/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.financialservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatasetName
implements ResourceName {
    private static final PathTemplate PROJECT_NUM_LOCATION_INSTANCE_DATASET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNum;
    private final String location;
    private final String instance;
    private final String dataset;

    @Deprecated
    protected DatasetName() {
        this.projectNum = null;
        this.location = null;
        this.instance = null;
        this.dataset = null;
    }

    private DatasetName(Builder builder) {
        this.projectNum = (String)Preconditions.checkNotNull((Object)builder.getProjectNum());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
    }

    public String getProjectNum() {
        return this.projectNum;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getDataset() {
        return this.dataset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DatasetName of(String projectNum, String location, String instance, String dataset) {
        return DatasetName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setDataset(dataset).build();
    }

    public static String format(String projectNum, String location, String instance, String dataset) {
        return DatasetName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setDataset(dataset).build().toString();
    }

    public static DatasetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUM_LOCATION_INSTANCE_DATASET.validatedMatch(formattedString, "DatasetName.parse: formattedString not in valid format");
        return DatasetName.of((String)matchMap.get("project_num"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("dataset"));
    }

    public static List<DatasetName> parseList(List<String> formattedStrings) {
        ArrayList<DatasetName> list = new ArrayList<DatasetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatasetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatasetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatasetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUM_LOCATION_INSTANCE_DATASET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatasetName datasetName = this;
            synchronized (datasetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNum != null) {
                        fieldMapBuilder.put((Object)"project_num", (Object)this.projectNum);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUM_LOCATION_INSTANCE_DATASET.instantiate(new String[]{"project_num", this.projectNum, "location", this.location, "instance", this.instance, "dataset", this.dataset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DatasetName that = (DatasetName)o;
            return Objects.equals(this.projectNum, that.projectNum) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.dataset, that.dataset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNum);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataset);
    }

    public static class Builder {
        private String projectNum;
        private String location;
        private String instance;
        private String dataset;

        protected Builder() {
        }

        public String getProjectNum() {
            return this.projectNum;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getDataset() {
            return this.dataset;
        }

        public Builder setProjectNum(String projectNum) {
            this.projectNum = projectNum;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        private Builder(DatasetName datasetName) {
            this.projectNum = datasetName.projectNum;
            this.location = datasetName.location;
            this.instance = datasetName.instance;
            this.dataset = datasetName.dataset;
        }

        public DatasetName build() {
            return new DatasetName(this);
        }
    }
}

