/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.financialservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PredictionResultName
implements ResourceName {
    private static final PathTemplate PROJECT_NUM_LOCATION_INSTANCE_PREDICTION_RESULT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_num}/locations/{location}/instances/{instance}/predictionResults/{prediction_result}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNum;
    private final String location;
    private final String instance;
    private final String predictionResult;

    @Deprecated
    protected PredictionResultName() {
        this.projectNum = null;
        this.location = null;
        this.instance = null;
        this.predictionResult = null;
    }

    private PredictionResultName(Builder builder) {
        this.projectNum = (String)Preconditions.checkNotNull((Object)builder.getProjectNum());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.predictionResult = (String)Preconditions.checkNotNull((Object)builder.getPredictionResult());
    }

    public String getProjectNum() {
        return this.projectNum;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getPredictionResult() {
        return this.predictionResult;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PredictionResultName of(String projectNum, String location, String instance, String predictionResult) {
        return PredictionResultName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setPredictionResult(predictionResult).build();
    }

    public static String format(String projectNum, String location, String instance, String predictionResult) {
        return PredictionResultName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setPredictionResult(predictionResult).build().toString();
    }

    public static PredictionResultName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUM_LOCATION_INSTANCE_PREDICTION_RESULT.validatedMatch(formattedString, "PredictionResultName.parse: formattedString not in valid format");
        return PredictionResultName.of((String)matchMap.get("project_num"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("prediction_result"));
    }

    public static List<PredictionResultName> parseList(List<String> formattedStrings) {
        ArrayList<PredictionResultName> list = new ArrayList<PredictionResultName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PredictionResultName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PredictionResultName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PredictionResultName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUM_LOCATION_INSTANCE_PREDICTION_RESULT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PredictionResultName predictionResultName = this;
            synchronized (predictionResultName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNum != null) {
                        fieldMapBuilder.put((Object)"project_num", (Object)this.projectNum);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.predictionResult != null) {
                        fieldMapBuilder.put((Object)"prediction_result", (Object)this.predictionResult);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUM_LOCATION_INSTANCE_PREDICTION_RESULT.instantiate(new String[]{"project_num", this.projectNum, "location", this.location, "instance", this.instance, "prediction_result", this.predictionResult});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PredictionResultName that = (PredictionResultName)o;
            return Objects.equals(this.projectNum, that.projectNum) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.predictionResult, that.predictionResult);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNum);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.predictionResult);
    }

    public static class Builder {
        private String projectNum;
        private String location;
        private String instance;
        private String predictionResult;

        protected Builder() {
        }

        public String getProjectNum() {
            return this.projectNum;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getPredictionResult() {
            return this.predictionResult;
        }

        public Builder setProjectNum(String projectNum) {
            this.projectNum = projectNum;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setPredictionResult(String predictionResult) {
            this.predictionResult = predictionResult;
            return this;
        }

        private Builder(PredictionResultName predictionResultName) {
            this.projectNum = predictionResultName.projectNum;
            this.location = predictionResultName.location;
            this.instance = predictionResultName.instance;
            this.predictionResult = predictionResultName.predictionResult;
        }

        public PredictionResultName build() {
            return new PredictionResultName(this);
        }
    }
}

