/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.financialservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelName
implements ResourceName {
    private static final PathTemplate PROJECT_NUM_LOCATION_INSTANCE_MODEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_num}/locations/{location}/instances/{instance}/models/{model}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNum;
    private final String location;
    private final String instance;
    private final String model;

    @Deprecated
    protected ModelName() {
        this.projectNum = null;
        this.location = null;
        this.instance = null;
        this.model = null;
    }

    private ModelName(Builder builder) {
        this.projectNum = (String)Preconditions.checkNotNull((Object)builder.getProjectNum());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.model = (String)Preconditions.checkNotNull((Object)builder.getModel());
    }

    public String getProjectNum() {
        return this.projectNum;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getModel() {
        return this.model;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ModelName of(String projectNum, String location, String instance, String model) {
        return ModelName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setModel(model).build();
    }

    public static String format(String projectNum, String location, String instance, String model) {
        return ModelName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setModel(model).build().toString();
    }

    public static ModelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUM_LOCATION_INSTANCE_MODEL.validatedMatch(formattedString, "ModelName.parse: formattedString not in valid format");
        return ModelName.of((String)matchMap.get("project_num"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("model"));
    }

    public static List<ModelName> parseList(List<String> formattedStrings) {
        ArrayList<ModelName> list = new ArrayList<ModelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ModelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ModelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ModelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUM_LOCATION_INSTANCE_MODEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ModelName modelName = this;
            synchronized (modelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNum != null) {
                        fieldMapBuilder.put((Object)"project_num", (Object)this.projectNum);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.model != null) {
                        fieldMapBuilder.put((Object)"model", (Object)this.model);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUM_LOCATION_INSTANCE_MODEL.instantiate(new String[]{"project_num", this.projectNum, "location", this.location, "instance", this.instance, "model", this.model});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ModelName that = (ModelName)o;
            return Objects.equals(this.projectNum, that.projectNum) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.model, that.model);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNum);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.model);
    }

    public static class Builder {
        private String projectNum;
        private String location;
        private String instance;
        private String model;

        protected Builder() {
        }

        public String getProjectNum() {
            return this.projectNum;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getModel() {
            return this.model;
        }

        public Builder setProjectNum(String projectNum) {
            this.projectNum = projectNum;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        private Builder(ModelName modelName) {
            this.projectNum = modelName.projectNum;
            this.location = modelName.location;
            this.instance = modelName.instance;
            this.model = modelName.model;
        }

        public ModelName build() {
            return new ModelName(this);
        }
    }
}

