/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.financialservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EngineConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_NUM_LOCATION_INSTANCE_ENGINE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engine_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNum;
    private final String location;
    private final String instance;
    private final String engineConfig;

    @Deprecated
    protected EngineConfigName() {
        this.projectNum = null;
        this.location = null;
        this.instance = null;
        this.engineConfig = null;
    }

    private EngineConfigName(Builder builder) {
        this.projectNum = (String)Preconditions.checkNotNull((Object)builder.getProjectNum());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.engineConfig = (String)Preconditions.checkNotNull((Object)builder.getEngineConfig());
    }

    public String getProjectNum() {
        return this.projectNum;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getEngineConfig() {
        return this.engineConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EngineConfigName of(String projectNum, String location, String instance, String engineConfig) {
        return EngineConfigName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setEngineConfig(engineConfig).build();
    }

    public static String format(String projectNum, String location, String instance, String engineConfig) {
        return EngineConfigName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setEngineConfig(engineConfig).build().toString();
    }

    public static EngineConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUM_LOCATION_INSTANCE_ENGINE_CONFIG.validatedMatch(formattedString, "EngineConfigName.parse: formattedString not in valid format");
        return EngineConfigName.of((String)matchMap.get("project_num"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("engine_config"));
    }

    public static List<EngineConfigName> parseList(List<String> formattedStrings) {
        ArrayList<EngineConfigName> list = new ArrayList<EngineConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EngineConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EngineConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EngineConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUM_LOCATION_INSTANCE_ENGINE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EngineConfigName engineConfigName = this;
            synchronized (engineConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNum != null) {
                        fieldMapBuilder.put((Object)"project_num", (Object)this.projectNum);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.engineConfig != null) {
                        fieldMapBuilder.put((Object)"engine_config", (Object)this.engineConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUM_LOCATION_INSTANCE_ENGINE_CONFIG.instantiate(new String[]{"project_num", this.projectNum, "location", this.location, "instance", this.instance, "engine_config", this.engineConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EngineConfigName that = (EngineConfigName)o;
            return Objects.equals(this.projectNum, that.projectNum) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.engineConfig, that.engineConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNum);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.engineConfig);
    }

    public static class Builder {
        private String projectNum;
        private String location;
        private String instance;
        private String engineConfig;

        protected Builder() {
        }

        public String getProjectNum() {
            return this.projectNum;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getEngineConfig() {
            return this.engineConfig;
        }

        public Builder setProjectNum(String projectNum) {
            this.projectNum = projectNum;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setEngineConfig(String engineConfig) {
            this.engineConfig = engineConfig;
            return this;
        }

        private Builder(EngineConfigName engineConfigName) {
            this.projectNum = engineConfigName.projectNum;
            this.location = engineConfigName.location;
            this.instance = engineConfigName.instance;
            this.engineConfig = engineConfigName.engineConfig;
        }

        public EngineConfigName build() {
            return new EngineConfigName(this);
        }
    }
}

