/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.filestore.v1;

import com.google.cloud.filestore.v1.CloudFilestoreServiceProto;
import com.google.cloud.filestore.v1.FileShareConfig;
import com.google.cloud.filestore.v1.FileShareConfigOrBuilder;
import com.google.cloud.filestore.v1.InstanceOrBuilder;
import com.google.cloud.filestore.v1.NetworkConfig;
import com.google.cloud.filestore.v1.NetworkConfigOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BoolValueOrBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Instance
extends GeneratedMessageV3
implements InstanceOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int DESCRIPTION_FIELD_NUMBER = 2;
    private volatile Object description_ = "";
    public static final int STATE_FIELD_NUMBER = 5;
    private int state_ = 0;
    public static final int STATUS_MESSAGE_FIELD_NUMBER = 6;
    private volatile Object statusMessage_ = "";
    public static final int CREATE_TIME_FIELD_NUMBER = 7;
    private Timestamp createTime_;
    public static final int TIER_FIELD_NUMBER = 8;
    private int tier_ = 0;
    public static final int LABELS_FIELD_NUMBER = 9;
    private MapField<String, String> labels_;
    public static final int FILE_SHARES_FIELD_NUMBER = 10;
    private List<FileShareConfig> fileShares_;
    public static final int NETWORKS_FIELD_NUMBER = 11;
    private List<NetworkConfig> networks_;
    public static final int ETAG_FIELD_NUMBER = 12;
    private volatile Object etag_ = "";
    public static final int SATISFIES_PZS_FIELD_NUMBER = 13;
    private BoolValue satisfiesPzs_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Instance DEFAULT_INSTANCE = new Instance();
    private static final Parser<Instance> PARSER = new AbstractParser<Instance>(){

        public Instance parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Instance.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Instance(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Instance() {
        this.name_ = "";
        this.description_ = "";
        this.state_ = 0;
        this.statusMessage_ = "";
        this.tier_ = 0;
        this.fileShares_ = Collections.emptyList();
        this.networks_ = Collections.emptyList();
        this.etag_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Instance();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_Instance_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 9: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_Instance_fieldAccessorTable.ensureFieldAccessorsInitialized(Instance.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public State getState() {
        State result = State.forNumber(this.state_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    @Override
    public String getStatusMessage() {
        Object ref = this.statusMessage_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.statusMessage_ = s;
        return s;
    }

    @Override
    public ByteString getStatusMessageBytes() {
        Object ref = this.statusMessage_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.statusMessage_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCreateTime() {
        return this.createTime_ != null;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public int getTierValue() {
        return this.tier_;
    }

    @Override
    public Tier getTier() {
        Tier result = Tier.forNumber(this.tier_);
        return result == null ? Tier.UNRECOGNIZED : result;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public List<FileShareConfig> getFileSharesList() {
        return this.fileShares_;
    }

    @Override
    public List<? extends FileShareConfigOrBuilder> getFileSharesOrBuilderList() {
        return this.fileShares_;
    }

    @Override
    public int getFileSharesCount() {
        return this.fileShares_.size();
    }

    @Override
    public FileShareConfig getFileShares(int index) {
        return this.fileShares_.get(index);
    }

    @Override
    public FileShareConfigOrBuilder getFileSharesOrBuilder(int index) {
        return this.fileShares_.get(index);
    }

    @Override
    public List<NetworkConfig> getNetworksList() {
        return this.networks_;
    }

    @Override
    public List<? extends NetworkConfigOrBuilder> getNetworksOrBuilderList() {
        return this.networks_;
    }

    @Override
    public int getNetworksCount() {
        return this.networks_.size();
    }

    @Override
    public NetworkConfig getNetworks(int index) {
        return this.networks_.get(index);
    }

    @Override
    public NetworkConfigOrBuilder getNetworksOrBuilder(int index) {
        return this.networks_.get(index);
    }

    @Override
    public String getEtag() {
        Object ref = this.etag_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.etag_ = s;
        return s;
    }

    @Override
    public ByteString getEtagBytes() {
        Object ref = this.etag_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.etag_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasSatisfiesPzs() {
        return this.satisfiesPzs_ != null;
    }

    @Override
    public BoolValue getSatisfiesPzs() {
        return this.satisfiesPzs_ == null ? BoolValue.getDefaultInstance() : this.satisfiesPzs_;
    }

    @Override
    public BoolValueOrBuilder getSatisfiesPzsOrBuilder() {
        return this.satisfiesPzs_ == null ? BoolValue.getDefaultInstance() : this.satisfiesPzs_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.description_);
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.state_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.statusMessage_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.statusMessage_);
        }
        if (this.createTime_ != null) {
            output.writeMessage(7, (MessageLite)this.getCreateTime());
        }
        if (this.tier_ != Tier.TIER_UNSPECIFIED.getNumber()) {
            output.writeEnum(8, this.tier_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)9);
        for (i = 0; i < this.fileShares_.size(); ++i) {
            output.writeMessage(10, (MessageLite)this.fileShares_.get(i));
        }
        for (i = 0; i < this.networks_.size(); ++i) {
            output.writeMessage(11, (MessageLite)this.networks_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.etag_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.etag_);
        }
        if (this.satisfiesPzs_ != null) {
            output.writeMessage(13, (MessageLite)this.getSatisfiesPzs());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.description_);
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.state_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.statusMessage_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.statusMessage_);
        }
        if (this.createTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getCreateTime());
        }
        if (this.tier_ != Tier.TIER_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)8, (int)this.tier_);
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)labels__);
        }
        for (i = 0; i < this.fileShares_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)((MessageLite)this.fileShares_.get(i)));
        }
        for (i = 0; i < this.networks_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)((MessageLite)this.networks_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.etag_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.etag_);
        }
        if (this.satisfiesPzs_ != null) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getSatisfiesPzs());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Instance)) {
            return super.equals(obj);
        }
        Instance other = (Instance)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        if (!this.getStatusMessage().equals(other.getStatusMessage())) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.tier_ != other.tier_) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.getFileSharesList().equals(other.getFileSharesList())) {
            return false;
        }
        if (!this.getNetworksList().equals(other.getNetworksList())) {
            return false;
        }
        if (!this.getEtag().equals(other.getEtag())) {
            return false;
        }
        if (this.hasSatisfiesPzs() != other.hasSatisfiesPzs()) {
            return false;
        }
        if (this.hasSatisfiesPzs() && !this.getSatisfiesPzs().equals((Object)other.getSatisfiesPzs())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Instance.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDescription().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.state_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getStatusMessage().hashCode();
        if (this.hasCreateTime()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        hash = 37 * hash + 8;
        hash = 53 * hash + this.tier_;
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        if (this.getFileSharesCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getFileSharesList().hashCode();
        }
        if (this.getNetworksCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getNetworksList().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getEtag().hashCode();
        if (this.hasSatisfiesPzs()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getSatisfiesPzs().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Instance parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data);
    }

    public static Instance parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Instance parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data);
    }

    public static Instance parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Instance parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data);
    }

    public static Instance parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Instance parseFrom(InputStream input) throws IOException {
        return (Instance)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Instance parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Instance)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Instance parseDelimitedFrom(InputStream input) throws IOException {
        return (Instance)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Instance parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Instance)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Instance parseFrom(CodedInputStream input) throws IOException {
        return (Instance)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Instance parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Instance)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Instance.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Instance prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Instance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Instance> parser() {
        return PARSER;
    }

    public Parser<Instance> getParserForType() {
        return PARSER;
    }

    public Instance getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements InstanceOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Object description_ = "";
        private int state_ = 0;
        private Object statusMessage_ = "";
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private int tier_ = 0;
        private MapField<String, String> labels_;
        private List<FileShareConfig> fileShares_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<FileShareConfig, FileShareConfig.Builder, FileShareConfigOrBuilder> fileSharesBuilder_;
        private List<NetworkConfig> networks_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<NetworkConfig, NetworkConfig.Builder, NetworkConfigOrBuilder> networksBuilder_;
        private Object etag_ = "";
        private BoolValue satisfiesPzs_;
        private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> satisfiesPzsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_Instance_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 9: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 9: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_Instance_fieldAccessorTable.ensureFieldAccessorsInitialized(Instance.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.description_ = "";
            this.state_ = 0;
            this.statusMessage_ = "";
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.tier_ = 0;
            this.internalGetMutableLabels().clear();
            if (this.fileSharesBuilder_ == null) {
                this.fileShares_ = Collections.emptyList();
            } else {
                this.fileShares_ = null;
                this.fileSharesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFF7F;
            if (this.networksBuilder_ == null) {
                this.networks_ = Collections.emptyList();
            } else {
                this.networks_ = null;
                this.networksBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFEFF;
            this.etag_ = "";
            this.satisfiesPzs_ = null;
            if (this.satisfiesPzsBuilder_ != null) {
                this.satisfiesPzsBuilder_.dispose();
                this.satisfiesPzsBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_Instance_descriptor;
        }

        public Instance getDefaultInstanceForType() {
            return Instance.getDefaultInstance();
        }

        public Instance build() {
            Instance result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Instance buildPartial() {
            Instance result = new Instance(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Instance result) {
            if (this.fileSharesBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0) {
                    this.fileShares_ = Collections.unmodifiableList(this.fileShares_);
                    this.bitField0_ &= 0xFFFFFF7F;
                }
                result.fileShares_ = this.fileShares_;
            } else {
                result.fileShares_ = this.fileSharesBuilder_.build();
            }
            if (this.networksBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0) {
                    this.networks_ = Collections.unmodifiableList(this.networks_);
                    this.bitField0_ &= 0xFFFFFEFF;
                }
                result.networks_ = this.networks_;
            } else {
                result.networks_ = this.networksBuilder_.build();
            }
        }

        private void buildPartial0(Instance result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.state_ = this.state_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.statusMessage_ = this.statusMessage_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.tier_ = this.tier_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.labels_ = this.internalGetLabels();
                result.labels_.makeImmutable();
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.etag_ = this.etag_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.satisfiesPzs_ = this.satisfiesPzsBuilder_ == null ? this.satisfiesPzs_ : (BoolValue)this.satisfiesPzsBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Instance) {
                return this.mergeFrom((Instance)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Instance other) {
            if (other == Instance.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            if (!other.getStatusMessage().isEmpty()) {
                this.statusMessage_ = other.statusMessage_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.tier_ != 0) {
                this.setTierValue(other.getTierValue());
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.bitField0_ |= 0x40;
            if (this.fileSharesBuilder_ == null) {
                if (!other.fileShares_.isEmpty()) {
                    if (this.fileShares_.isEmpty()) {
                        this.fileShares_ = other.fileShares_;
                        this.bitField0_ &= 0xFFFFFF7F;
                    } else {
                        this.ensureFileSharesIsMutable();
                        this.fileShares_.addAll(other.fileShares_);
                    }
                    this.onChanged();
                }
            } else if (!other.fileShares_.isEmpty()) {
                if (this.fileSharesBuilder_.isEmpty()) {
                    this.fileSharesBuilder_.dispose();
                    this.fileSharesBuilder_ = null;
                    this.fileShares_ = other.fileShares_;
                    this.bitField0_ &= 0xFFFFFF7F;
                    this.fileSharesBuilder_ = alwaysUseFieldBuilders ? this.getFileSharesFieldBuilder() : null;
                } else {
                    this.fileSharesBuilder_.addAllMessages((Iterable)other.fileShares_);
                }
            }
            if (this.networksBuilder_ == null) {
                if (!other.networks_.isEmpty()) {
                    if (this.networks_.isEmpty()) {
                        this.networks_ = other.networks_;
                        this.bitField0_ &= 0xFFFFFEFF;
                    } else {
                        this.ensureNetworksIsMutable();
                        this.networks_.addAll(other.networks_);
                    }
                    this.onChanged();
                }
            } else if (!other.networks_.isEmpty()) {
                if (this.networksBuilder_.isEmpty()) {
                    this.networksBuilder_.dispose();
                    this.networksBuilder_ = null;
                    this.networks_ = other.networks_;
                    this.bitField0_ &= 0xFFFFFEFF;
                    this.networksBuilder_ = alwaysUseFieldBuilders ? this.getNetworksFieldBuilder() : null;
                } else {
                    this.networksBuilder_.addAllMessages((Iterable)other.networks_);
                }
            }
            if (!other.getEtag().isEmpty()) {
                this.etag_ = other.etag_;
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            if (other.hasSatisfiesPzs()) {
                this.mergeSatisfiesPzs(other.getSatisfiesPzs());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block19: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block19;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block19;
                        }
                        case 18: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block19;
                        }
                        case 40: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block19;
                        }
                        case 50: {
                            this.statusMessage_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block19;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block19;
                        }
                        case 64: {
                            this.tier_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block19;
                        }
                        case 74: {
                            MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLabels().getMutableMap().put(labels__.getKey(), labels__.getValue());
                            this.bitField0_ |= 0x40;
                            continue block19;
                        }
                        case 82: {
                            GeneratedMessageV3 m = (FileShareConfig)input.readMessage(FileShareConfig.parser(), extensionRegistry);
                            if (this.fileSharesBuilder_ == null) {
                                this.ensureFileSharesIsMutable();
                                this.fileShares_.add((FileShareConfig)m);
                                continue block19;
                            }
                            this.fileSharesBuilder_.addMessage((AbstractMessage)m);
                            continue block19;
                        }
                        case 90: {
                            GeneratedMessageV3 m = (NetworkConfig)input.readMessage(NetworkConfig.parser(), extensionRegistry);
                            if (this.networksBuilder_ == null) {
                                this.ensureNetworksIsMutable();
                                this.networks_.add((NetworkConfig)m);
                                continue block19;
                            }
                            this.networksBuilder_.addMessage((AbstractMessage)m);
                            continue block19;
                        }
                        case 98: {
                            this.etag_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x200;
                            continue block19;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getSatisfiesPzsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block19;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Instance.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = Instance.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getStatusMessage() {
            Object ref = this.statusMessage_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.statusMessage_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getStatusMessageBytes() {
            Object ref = this.statusMessage_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.statusMessage_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setStatusMessage(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.statusMessage_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearStatusMessage() {
            this.statusMessage_ = Instance.getDefaultInstance().getStatusMessage();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setStatusMessageBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.statusMessage_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public int getTierValue() {
            return this.tier_;
        }

        public Builder setTierValue(int value) {
            this.tier_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public Tier getTier() {
            Tier result = Tier.forNumber(this.tier_);
            return result == null ? Tier.UNRECOGNIZED : result;
        }

        public Builder setTier(Tier value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.tier_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTier() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.tier_ = 0;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            this.bitField0_ |= 0x40;
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            this.bitField0_ |= 0x40;
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            this.bitField0_ |= 0x40;
            return this;
        }

        private void ensureFileSharesIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.fileShares_ = new ArrayList<FileShareConfig>(this.fileShares_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<FileShareConfig> getFileSharesList() {
            if (this.fileSharesBuilder_ == null) {
                return Collections.unmodifiableList(this.fileShares_);
            }
            return this.fileSharesBuilder_.getMessageList();
        }

        @Override
        public int getFileSharesCount() {
            if (this.fileSharesBuilder_ == null) {
                return this.fileShares_.size();
            }
            return this.fileSharesBuilder_.getCount();
        }

        @Override
        public FileShareConfig getFileShares(int index) {
            if (this.fileSharesBuilder_ == null) {
                return this.fileShares_.get(index);
            }
            return (FileShareConfig)this.fileSharesBuilder_.getMessage(index);
        }

        public Builder setFileShares(int index, FileShareConfig value) {
            if (this.fileSharesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureFileSharesIsMutable();
                this.fileShares_.set(index, value);
                this.onChanged();
            } else {
                this.fileSharesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setFileShares(int index, FileShareConfig.Builder builderForValue) {
            if (this.fileSharesBuilder_ == null) {
                this.ensureFileSharesIsMutable();
                this.fileShares_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.fileSharesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addFileShares(FileShareConfig value) {
            if (this.fileSharesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureFileSharesIsMutable();
                this.fileShares_.add(value);
                this.onChanged();
            } else {
                this.fileSharesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addFileShares(int index, FileShareConfig value) {
            if (this.fileSharesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureFileSharesIsMutable();
                this.fileShares_.add(index, value);
                this.onChanged();
            } else {
                this.fileSharesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addFileShares(FileShareConfig.Builder builderForValue) {
            if (this.fileSharesBuilder_ == null) {
                this.ensureFileSharesIsMutable();
                this.fileShares_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.fileSharesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addFileShares(int index, FileShareConfig.Builder builderForValue) {
            if (this.fileSharesBuilder_ == null) {
                this.ensureFileSharesIsMutable();
                this.fileShares_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.fileSharesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllFileShares(Iterable<? extends FileShareConfig> values) {
            if (this.fileSharesBuilder_ == null) {
                this.ensureFileSharesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.fileShares_);
                this.onChanged();
            } else {
                this.fileSharesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearFileShares() {
            if (this.fileSharesBuilder_ == null) {
                this.fileShares_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFF7F;
                this.onChanged();
            } else {
                this.fileSharesBuilder_.clear();
            }
            return this;
        }

        public Builder removeFileShares(int index) {
            if (this.fileSharesBuilder_ == null) {
                this.ensureFileSharesIsMutable();
                this.fileShares_.remove(index);
                this.onChanged();
            } else {
                this.fileSharesBuilder_.remove(index);
            }
            return this;
        }

        public FileShareConfig.Builder getFileSharesBuilder(int index) {
            return (FileShareConfig.Builder)this.getFileSharesFieldBuilder().getBuilder(index);
        }

        @Override
        public FileShareConfigOrBuilder getFileSharesOrBuilder(int index) {
            if (this.fileSharesBuilder_ == null) {
                return this.fileShares_.get(index);
            }
            return (FileShareConfigOrBuilder)this.fileSharesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends FileShareConfigOrBuilder> getFileSharesOrBuilderList() {
            if (this.fileSharesBuilder_ != null) {
                return this.fileSharesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.fileShares_);
        }

        public FileShareConfig.Builder addFileSharesBuilder() {
            return (FileShareConfig.Builder)this.getFileSharesFieldBuilder().addBuilder((AbstractMessage)FileShareConfig.getDefaultInstance());
        }

        public FileShareConfig.Builder addFileSharesBuilder(int index) {
            return (FileShareConfig.Builder)this.getFileSharesFieldBuilder().addBuilder(index, (AbstractMessage)FileShareConfig.getDefaultInstance());
        }

        public List<FileShareConfig.Builder> getFileSharesBuilderList() {
            return this.getFileSharesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<FileShareConfig, FileShareConfig.Builder, FileShareConfigOrBuilder> getFileSharesFieldBuilder() {
            if (this.fileSharesBuilder_ == null) {
                this.fileSharesBuilder_ = new RepeatedFieldBuilderV3(this.fileShares_, (this.bitField0_ & 0x80) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.fileShares_ = null;
            }
            return this.fileSharesBuilder_;
        }

        private void ensureNetworksIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.networks_ = new ArrayList<NetworkConfig>(this.networks_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<NetworkConfig> getNetworksList() {
            if (this.networksBuilder_ == null) {
                return Collections.unmodifiableList(this.networks_);
            }
            return this.networksBuilder_.getMessageList();
        }

        @Override
        public int getNetworksCount() {
            if (this.networksBuilder_ == null) {
                return this.networks_.size();
            }
            return this.networksBuilder_.getCount();
        }

        @Override
        public NetworkConfig getNetworks(int index) {
            if (this.networksBuilder_ == null) {
                return this.networks_.get(index);
            }
            return (NetworkConfig)this.networksBuilder_.getMessage(index);
        }

        public Builder setNetworks(int index, NetworkConfig value) {
            if (this.networksBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureNetworksIsMutable();
                this.networks_.set(index, value);
                this.onChanged();
            } else {
                this.networksBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setNetworks(int index, NetworkConfig.Builder builderForValue) {
            if (this.networksBuilder_ == null) {
                this.ensureNetworksIsMutable();
                this.networks_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.networksBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addNetworks(NetworkConfig value) {
            if (this.networksBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureNetworksIsMutable();
                this.networks_.add(value);
                this.onChanged();
            } else {
                this.networksBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addNetworks(int index, NetworkConfig value) {
            if (this.networksBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureNetworksIsMutable();
                this.networks_.add(index, value);
                this.onChanged();
            } else {
                this.networksBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addNetworks(NetworkConfig.Builder builderForValue) {
            if (this.networksBuilder_ == null) {
                this.ensureNetworksIsMutable();
                this.networks_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.networksBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addNetworks(int index, NetworkConfig.Builder builderForValue) {
            if (this.networksBuilder_ == null) {
                this.ensureNetworksIsMutable();
                this.networks_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.networksBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllNetworks(Iterable<? extends NetworkConfig> values) {
            if (this.networksBuilder_ == null) {
                this.ensureNetworksIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.networks_);
                this.onChanged();
            } else {
                this.networksBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearNetworks() {
            if (this.networksBuilder_ == null) {
                this.networks_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
            } else {
                this.networksBuilder_.clear();
            }
            return this;
        }

        public Builder removeNetworks(int index) {
            if (this.networksBuilder_ == null) {
                this.ensureNetworksIsMutable();
                this.networks_.remove(index);
                this.onChanged();
            } else {
                this.networksBuilder_.remove(index);
            }
            return this;
        }

        public NetworkConfig.Builder getNetworksBuilder(int index) {
            return (NetworkConfig.Builder)this.getNetworksFieldBuilder().getBuilder(index);
        }

        @Override
        public NetworkConfigOrBuilder getNetworksOrBuilder(int index) {
            if (this.networksBuilder_ == null) {
                return this.networks_.get(index);
            }
            return (NetworkConfigOrBuilder)this.networksBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends NetworkConfigOrBuilder> getNetworksOrBuilderList() {
            if (this.networksBuilder_ != null) {
                return this.networksBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.networks_);
        }

        public NetworkConfig.Builder addNetworksBuilder() {
            return (NetworkConfig.Builder)this.getNetworksFieldBuilder().addBuilder((AbstractMessage)NetworkConfig.getDefaultInstance());
        }

        public NetworkConfig.Builder addNetworksBuilder(int index) {
            return (NetworkConfig.Builder)this.getNetworksFieldBuilder().addBuilder(index, (AbstractMessage)NetworkConfig.getDefaultInstance());
        }

        public List<NetworkConfig.Builder> getNetworksBuilderList() {
            return this.getNetworksFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<NetworkConfig, NetworkConfig.Builder, NetworkConfigOrBuilder> getNetworksFieldBuilder() {
            if (this.networksBuilder_ == null) {
                this.networksBuilder_ = new RepeatedFieldBuilderV3(this.networks_, (this.bitField0_ & 0x100) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.networks_ = null;
            }
            return this.networksBuilder_;
        }

        @Override
        public String getEtag() {
            Object ref = this.etag_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.etag_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEtagBytes() {
            Object ref = this.etag_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.etag_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEtag(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.etag_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearEtag() {
            this.etag_ = Instance.getDefaultInstance().getEtag();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder setEtagBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.etag_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSatisfiesPzs() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public BoolValue getSatisfiesPzs() {
            if (this.satisfiesPzsBuilder_ == null) {
                return this.satisfiesPzs_ == null ? BoolValue.getDefaultInstance() : this.satisfiesPzs_;
            }
            return (BoolValue)this.satisfiesPzsBuilder_.getMessage();
        }

        public Builder setSatisfiesPzs(BoolValue value) {
            if (this.satisfiesPzsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.satisfiesPzs_ = value;
            } else {
                this.satisfiesPzsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setSatisfiesPzs(BoolValue.Builder builderForValue) {
            if (this.satisfiesPzsBuilder_ == null) {
                this.satisfiesPzs_ = builderForValue.build();
            } else {
                this.satisfiesPzsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeSatisfiesPzs(BoolValue value) {
            if (this.satisfiesPzsBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.satisfiesPzs_ != null && this.satisfiesPzs_ != BoolValue.getDefaultInstance()) {
                    this.getSatisfiesPzsBuilder().mergeFrom(value);
                } else {
                    this.satisfiesPzs_ = value;
                }
            } else {
                this.satisfiesPzsBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearSatisfiesPzs() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.satisfiesPzs_ = null;
            if (this.satisfiesPzsBuilder_ != null) {
                this.satisfiesPzsBuilder_.dispose();
                this.satisfiesPzsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public BoolValue.Builder getSatisfiesPzsBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (BoolValue.Builder)this.getSatisfiesPzsFieldBuilder().getBuilder();
        }

        @Override
        public BoolValueOrBuilder getSatisfiesPzsOrBuilder() {
            if (this.satisfiesPzsBuilder_ != null) {
                return (BoolValueOrBuilder)this.satisfiesPzsBuilder_.getMessageOrBuilder();
            }
            return this.satisfiesPzs_ == null ? BoolValue.getDefaultInstance() : this.satisfiesPzs_;
        }

        private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> getSatisfiesPzsFieldBuilder() {
            if (this.satisfiesPzsBuilder_ == null) {
                this.satisfiesPzsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSatisfiesPzs(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.satisfiesPzs_ = null;
            }
            return this.satisfiesPzsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_Instance_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static enum Tier implements ProtocolMessageEnum
    {
        TIER_UNSPECIFIED(0),
        STANDARD(1),
        PREMIUM(2),
        BASIC_HDD(3),
        BASIC_SSD(4),
        HIGH_SCALE_SSD(5),
        UNRECOGNIZED(-1);

        public static final int TIER_UNSPECIFIED_VALUE = 0;
        public static final int STANDARD_VALUE = 1;
        public static final int PREMIUM_VALUE = 2;
        public static final int BASIC_HDD_VALUE = 3;
        public static final int BASIC_SSD_VALUE = 4;
        public static final int HIGH_SCALE_SSD_VALUE = 5;
        private static final Internal.EnumLiteMap<Tier> internalValueMap;
        private static final Tier[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Tier valueOf(int value) {
            return Tier.forNumber(value);
        }

        public static Tier forNumber(int value) {
            switch (value) {
                case 0: {
                    return TIER_UNSPECIFIED;
                }
                case 1: {
                    return STANDARD;
                }
                case 2: {
                    return PREMIUM;
                }
                case 3: {
                    return BASIC_HDD;
                }
                case 4: {
                    return BASIC_SSD;
                }
                case 5: {
                    return HIGH_SCALE_SSD;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Tier> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Tier.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Tier.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Instance.getDescriptor().getEnumTypes().get(1);
        }

        public static Tier valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Tier.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Tier(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Tier>(){

                public Tier findValueByNumber(int number) {
                    return Tier.forNumber(number);
                }
            };
            VALUES = Tier.values();
        }
    }

    public static enum State implements ProtocolMessageEnum
    {
        STATE_UNSPECIFIED(0),
        CREATING(1),
        READY(2),
        REPAIRING(3),
        DELETING(4),
        ERROR(6),
        RESTORING(7),
        UNRECOGNIZED(-1);

        public static final int STATE_UNSPECIFIED_VALUE = 0;
        public static final int CREATING_VALUE = 1;
        public static final int READY_VALUE = 2;
        public static final int REPAIRING_VALUE = 3;
        public static final int DELETING_VALUE = 4;
        public static final int ERROR_VALUE = 6;
        public static final int RESTORING_VALUE = 7;
        private static final Internal.EnumLiteMap<State> internalValueMap;
        private static final State[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static State valueOf(int value) {
            return State.forNumber(value);
        }

        public static State forNumber(int value) {
            switch (value) {
                case 0: {
                    return STATE_UNSPECIFIED;
                }
                case 1: {
                    return CREATING;
                }
                case 2: {
                    return READY;
                }
                case 3: {
                    return REPAIRING;
                }
                case 4: {
                    return DELETING;
                }
                case 6: {
                    return ERROR;
                }
                case 7: {
                    return RESTORING;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<State> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return State.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Instance.getDescriptor().getEnumTypes().get(0);
        }

        public static State valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != State.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private State(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<State>(){

                public State findValueByNumber(int number) {
                    return State.forNumber(number);
                }
            };
            VALUES = State.values();
        }
    }
}

