/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GoogleChannelConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/googleChannelConfig");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;

    @Deprecated
    protected GoogleChannelConfigName() {
        this.project = null;
        this.location = null;
    }

    private GoogleChannelConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GoogleChannelConfigName of(String project, String location) {
        return GoogleChannelConfigName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String project, String location) {
        return GoogleChannelConfigName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static GoogleChannelConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION.validatedMatch(formattedString, "GoogleChannelConfigName.parse: formattedString not in valid format");
        return GoogleChannelConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"));
    }

    public static List<GoogleChannelConfigName> parseList(List<String> formattedStrings) {
        ArrayList<GoogleChannelConfigName> list = new ArrayList<GoogleChannelConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GoogleChannelConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GoogleChannelConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GoogleChannelConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GoogleChannelConfigName googleChannelConfigName = this;
            synchronized (googleChannelConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION.instantiate(new String[]{"project", this.project, "location", this.location});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GoogleChannelConfigName that = (GoogleChannelConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class Builder {
        private String project;
        private String location;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(GoogleChannelConfigName googleChannelConfigName) {
            this.project = googleChannelConfigName.project;
            this.location = googleChannelConfigName.location;
        }

        public GoogleChannelConfigName build() {
            return new GoogleChannelConfigName(this);
        }
    }
}

