/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EnrollmentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENROLLMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/enrollments/{enrollment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String enrollment;

    @Deprecated
    protected EnrollmentName() {
        this.project = null;
        this.location = null;
        this.enrollment = null;
    }

    private EnrollmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.enrollment = (String)Preconditions.checkNotNull((Object)builder.getEnrollment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEnrollment() {
        return this.enrollment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EnrollmentName of(String project, String location, String enrollment) {
        return EnrollmentName.newBuilder().setProject(project).setLocation(location).setEnrollment(enrollment).build();
    }

    public static String format(String project, String location, String enrollment) {
        return EnrollmentName.newBuilder().setProject(project).setLocation(location).setEnrollment(enrollment).build().toString();
    }

    public static EnrollmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENROLLMENT.validatedMatch(formattedString, "EnrollmentName.parse: formattedString not in valid format");
        return EnrollmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("enrollment"));
    }

    public static List<EnrollmentName> parseList(List<String> formattedStrings) {
        ArrayList<EnrollmentName> list = new ArrayList<EnrollmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EnrollmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EnrollmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EnrollmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENROLLMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EnrollmentName enrollmentName = this;
            synchronized (enrollmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.enrollment != null) {
                        fieldMapBuilder.put((Object)"enrollment", (Object)this.enrollment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENROLLMENT.instantiate(new String[]{"project", this.project, "location", this.location, "enrollment", this.enrollment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EnrollmentName that = (EnrollmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.enrollment, that.enrollment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.enrollment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String enrollment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEnrollment() {
            return this.enrollment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEnrollment(String enrollment) {
            this.enrollment = enrollment;
            return this;
        }

        private Builder(EnrollmentName enrollmentName) {
            this.project = enrollmentName.project;
            this.location = enrollmentName.location;
            this.enrollment = enrollmentName.enrollment;
        }

        public EnrollmentName build() {
            return new EnrollmentName(this);
        }
    }
}

