/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChannelConnectionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CHANNEL_CONNECTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/channelConnections/{channel_connection}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String channelConnection;

    @Deprecated
    protected ChannelConnectionName() {
        this.project = null;
        this.location = null;
        this.channelConnection = null;
    }

    private ChannelConnectionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.channelConnection = (String)Preconditions.checkNotNull((Object)builder.getChannelConnection());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getChannelConnection() {
        return this.channelConnection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChannelConnectionName of(String project, String location, String channelConnection) {
        return ChannelConnectionName.newBuilder().setProject(project).setLocation(location).setChannelConnection(channelConnection).build();
    }

    public static String format(String project, String location, String channelConnection) {
        return ChannelConnectionName.newBuilder().setProject(project).setLocation(location).setChannelConnection(channelConnection).build().toString();
    }

    public static ChannelConnectionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CHANNEL_CONNECTION.validatedMatch(formattedString, "ChannelConnectionName.parse: formattedString not in valid format");
        return ChannelConnectionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("channel_connection"));
    }

    public static List<ChannelConnectionName> parseList(List<String> formattedStrings) {
        ArrayList<ChannelConnectionName> list = new ArrayList<ChannelConnectionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChannelConnectionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChannelConnectionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChannelConnectionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CHANNEL_CONNECTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChannelConnectionName channelConnectionName = this;
            synchronized (channelConnectionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.channelConnection != null) {
                        fieldMapBuilder.put((Object)"channel_connection", (Object)this.channelConnection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CHANNEL_CONNECTION.instantiate(new String[]{"project", this.project, "location", this.location, "channel_connection", this.channelConnection});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ChannelConnectionName that = (ChannelConnectionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.channelConnection, that.channelConnection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.channelConnection);
    }

    public static class Builder {
        private String project;
        private String location;
        private String channelConnection;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getChannelConnection() {
            return this.channelConnection;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setChannelConnection(String channelConnection) {
            this.channelConnection = channelConnection;
            return this;
        }

        private Builder(ChannelConnectionName channelConnectionName) {
            this.project = channelConnectionName.project;
            this.location = channelConnectionName.location;
            this.channelConnection = channelConnectionName.channelConnection;
        }

        public ChannelConnectionName build() {
            return new ChannelConnectionName(this);
        }
    }
}

