/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MessageBusName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MESSAGE_BUS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/messageBuses/{message_bus}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String messageBus;

    @Deprecated
    protected MessageBusName() {
        this.project = null;
        this.location = null;
        this.messageBus = null;
    }

    private MessageBusName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.messageBus = (String)Preconditions.checkNotNull((Object)builder.getMessageBus());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessageBus() {
        return this.messageBus;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MessageBusName of(String project, String location, String messageBus) {
        return MessageBusName.newBuilder().setProject(project).setLocation(location).setMessageBus(messageBus).build();
    }

    public static String format(String project, String location, String messageBus) {
        return MessageBusName.newBuilder().setProject(project).setLocation(location).setMessageBus(messageBus).build().toString();
    }

    public static MessageBusName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MESSAGE_BUS.validatedMatch(formattedString, "MessageBusName.parse: formattedString not in valid format");
        return MessageBusName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("message_bus"));
    }

    public static List<MessageBusName> parseList(List<String> formattedStrings) {
        ArrayList<MessageBusName> list = new ArrayList<MessageBusName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MessageBusName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MessageBusName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MessageBusName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MESSAGE_BUS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MessageBusName messageBusName = this;
            synchronized (messageBusName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.messageBus != null) {
                        fieldMapBuilder.put((Object)"message_bus", (Object)this.messageBus);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MESSAGE_BUS.instantiate(new String[]{"project", this.project, "location", this.location, "message_bus", this.messageBus});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MessageBusName that = (MessageBusName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.messageBus, that.messageBus);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.messageBus);
    }

    public static class Builder {
        private String project;
        private String location;
        private String messageBus;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMessageBus() {
            return this.messageBus;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMessageBus(String messageBus) {
            this.messageBus = messageBus;
            return this;
        }

        private Builder(MessageBusName messageBusName) {
            this.project = messageBusName.project;
            this.location = messageBusName.location;
            this.messageBus = messageBusName.messageBus;
        }

        public MessageBusName build() {
            return new MessageBusName(this);
        }
    }
}

