/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.essentialcontacts.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContactName
implements ResourceName {
    private static final PathTemplate PROJECT_CONTACT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/contacts/{contact}");
    private static final PathTemplate FOLDER_CONTACT = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/contacts/{contact}");
    private static final PathTemplate ORGANIZATION_CONTACT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/contacts/{contact}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String contact;
    private final String folder;
    private final String organization;

    @Deprecated
    protected ContactName() {
        this.project = null;
        this.contact = null;
        this.folder = null;
        this.organization = null;
    }

    private ContactName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.contact = (String)Preconditions.checkNotNull((Object)builder.getContact());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_CONTACT;
    }

    private ContactName(FolderContactBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.contact = (String)Preconditions.checkNotNull((Object)builder.getContact());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_CONTACT;
    }

    private ContactName(OrganizationContactBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.contact = (String)Preconditions.checkNotNull((Object)builder.getContact());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_CONTACT;
    }

    public String getProject() {
        return this.project;
    }

    public String getContact() {
        return this.contact;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectContactBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderContactBuilder newFolderContactBuilder() {
        return new FolderContactBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationContactBuilder newOrganizationContactBuilder() {
        return new OrganizationContactBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ContactName of(String project, String contact) {
        return ContactName.newBuilder().setProject(project).setContact(contact).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ContactName ofProjectContactName(String project, String contact) {
        return ContactName.newBuilder().setProject(project).setContact(contact).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ContactName ofFolderContactName(String folder, String contact) {
        return ContactName.newFolderContactBuilder().setFolder(folder).setContact(contact).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ContactName ofOrganizationContactName(String organization, String contact) {
        return ContactName.newOrganizationContactBuilder().setOrganization(organization).setContact(contact).build();
    }

    public static String format(String project, String contact) {
        return ContactName.newBuilder().setProject(project).setContact(contact).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectContactName(String project, String contact) {
        return ContactName.newBuilder().setProject(project).setContact(contact).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderContactName(String folder, String contact) {
        return ContactName.newFolderContactBuilder().setFolder(folder).setContact(contact).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationContactName(String organization, String contact) {
        return ContactName.newOrganizationContactBuilder().setOrganization(organization).setContact(contact).build().toString();
    }

    public static ContactName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CONTACT.matches(formattedString)) {
            Map matchMap = PROJECT_CONTACT.match(formattedString);
            return ContactName.ofProjectContactName((String)matchMap.get("project"), (String)matchMap.get("contact"));
        }
        if (FOLDER_CONTACT.matches(formattedString)) {
            Map matchMap = FOLDER_CONTACT.match(formattedString);
            return ContactName.ofFolderContactName((String)matchMap.get("folder"), (String)matchMap.get("contact"));
        }
        if (ORGANIZATION_CONTACT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_CONTACT.match(formattedString);
            return ContactName.ofOrganizationContactName((String)matchMap.get("organization"), (String)matchMap.get("contact"));
        }
        throw new ValidationException("ContactName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ContactName> parseList(List<String> formattedStrings) {
        ArrayList<ContactName> list = new ArrayList<ContactName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContactName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContactName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContactName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CONTACT.matches(formattedString) || FOLDER_CONTACT.matches(formattedString) || ORGANIZATION_CONTACT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContactName contactName = this;
            synchronized (contactName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.contact != null) {
                        fieldMapBuilder.put((Object)"contact", (Object)this.contact);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ContactName that = (ContactName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.contact, that.contact) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.contact);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationContactBuilder {
        private String organization;
        private String contact;

        protected OrganizationContactBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getContact() {
            return this.contact;
        }

        public OrganizationContactBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationContactBuilder setContact(String contact) {
            this.contact = contact;
            return this;
        }

        public ContactName build() {
            return new ContactName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderContactBuilder {
        private String folder;
        private String contact;

        protected FolderContactBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getContact() {
            return this.contact;
        }

        public FolderContactBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderContactBuilder setContact(String contact) {
            this.contact = contact;
            return this;
        }

        public ContactName build() {
            return new ContactName(this);
        }
    }

    public static class Builder {
        private String project;
        private String contact;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getContact() {
            return this.contact;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setContact(String contact) {
            this.contact = contact;
            return this;
        }

        private Builder(ContactName contactName) {
            Preconditions.checkArgument((boolean)Objects.equals(contactName.pathTemplate, PROJECT_CONTACT), (Object)"toBuilder is only supported when ContactName has the pattern of projects/{project}/contacts/{contact}");
            this.project = contactName.project;
            this.contact = contactName.contact;
        }

        public ContactName build() {
            return new ContactName(this);
        }
    }
}

