/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.domains.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RegistrationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REGISTRATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/registrations/{registration}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String registration;

    @Deprecated
    protected RegistrationName() {
        this.project = null;
        this.location = null;
        this.registration = null;
    }

    private RegistrationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.registration = (String)Preconditions.checkNotNull((Object)builder.getRegistration());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRegistration() {
        return this.registration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RegistrationName of(String project, String location, String registration) {
        return RegistrationName.newBuilder().setProject(project).setLocation(location).setRegistration(registration).build();
    }

    public static String format(String project, String location, String registration) {
        return RegistrationName.newBuilder().setProject(project).setLocation(location).setRegistration(registration).build().toString();
    }

    public static RegistrationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REGISTRATION.validatedMatch(formattedString, "RegistrationName.parse: formattedString not in valid format");
        return RegistrationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("registration"));
    }

    public static List<RegistrationName> parseList(List<String> formattedStrings) {
        ArrayList<RegistrationName> list = new ArrayList<RegistrationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RegistrationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RegistrationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RegistrationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REGISTRATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RegistrationName registrationName = this;
            synchronized (registrationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.registration != null) {
                        fieldMapBuilder.put((Object)"registration", (Object)this.registration);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REGISTRATION.instantiate(new String[]{"project", this.project, "location", this.location, "registration", this.registration});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RegistrationName that = (RegistrationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.registration, that.registration);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.registration);
    }

    public static class Builder {
        private String project;
        private String location;
        private String registration;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRegistration() {
            return this.registration;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRegistration(String registration) {
            this.registration = registration;
            return this;
        }

        private Builder(RegistrationName registrationName) {
            this.project = registrationName.project;
            this.location = registrationName.location;
            this.registration = registrationName.registration;
        }

        public RegistrationName build() {
            return new RegistrationName(this);
        }
    }
}

