/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.clouddms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MappingRuleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONVERSION_WORKSPACE_MAPPING_RULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}/mappingRules/{mapping_rule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String conversionWorkspace;
    private final String mappingRule;

    @Deprecated
    protected MappingRuleName() {
        this.project = null;
        this.location = null;
        this.conversionWorkspace = null;
        this.mappingRule = null;
    }

    private MappingRuleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversionWorkspace = (String)Preconditions.checkNotNull((Object)builder.getConversionWorkspace());
        this.mappingRule = (String)Preconditions.checkNotNull((Object)builder.getMappingRule());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConversionWorkspace() {
        return this.conversionWorkspace;
    }

    public String getMappingRule() {
        return this.mappingRule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MappingRuleName of(String project, String location, String conversionWorkspace, String mappingRule) {
        return MappingRuleName.newBuilder().setProject(project).setLocation(location).setConversionWorkspace(conversionWorkspace).setMappingRule(mappingRule).build();
    }

    public static String format(String project, String location, String conversionWorkspace, String mappingRule) {
        return MappingRuleName.newBuilder().setProject(project).setLocation(location).setConversionWorkspace(conversionWorkspace).setMappingRule(mappingRule).build().toString();
    }

    public static MappingRuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONVERSION_WORKSPACE_MAPPING_RULE.validatedMatch(formattedString, "MappingRuleName.parse: formattedString not in valid format");
        return MappingRuleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversion_workspace"), (String)matchMap.get("mapping_rule"));
    }

    public static List<MappingRuleName> parseList(List<String> formattedStrings) {
        ArrayList<MappingRuleName> list = new ArrayList<MappingRuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MappingRuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MappingRuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MappingRuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONVERSION_WORKSPACE_MAPPING_RULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MappingRuleName mappingRuleName = this;
            synchronized (mappingRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.conversionWorkspace != null) {
                        fieldMapBuilder.put((Object)"conversion_workspace", (Object)this.conversionWorkspace);
                    }
                    if (this.mappingRule != null) {
                        fieldMapBuilder.put((Object)"mapping_rule", (Object)this.mappingRule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONVERSION_WORKSPACE_MAPPING_RULE.instantiate(new String[]{"project", this.project, "location", this.location, "conversion_workspace", this.conversionWorkspace, "mapping_rule", this.mappingRule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MappingRuleName that = (MappingRuleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.conversionWorkspace, that.conversionWorkspace) && Objects.equals(this.mappingRule, that.mappingRule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversionWorkspace);
        h *= 1000003;
        return h ^= Objects.hashCode(this.mappingRule);
    }

    public static class Builder {
        private String project;
        private String location;
        private String conversionWorkspace;
        private String mappingRule;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversionWorkspace() {
            return this.conversionWorkspace;
        }

        public String getMappingRule() {
            return this.mappingRule;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConversionWorkspace(String conversionWorkspace) {
            this.conversionWorkspace = conversionWorkspace;
            return this;
        }

        public Builder setMappingRule(String mappingRule) {
            this.mappingRule = mappingRule;
            return this;
        }

        private Builder(MappingRuleName mappingRuleName) {
            this.project = mappingRuleName.project;
            this.location = mappingRuleName.location;
            this.conversionWorkspace = mappingRuleName.conversionWorkspace;
            this.mappingRule = mappingRuleName.mappingRule;
        }

        public MappingRuleName build() {
            return new MappingRuleName(this);
        }
    }
}

