/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.clouddms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MigrationJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MIGRATION_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/migrationJobs/{migration_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String migrationJob;

    @Deprecated
    protected MigrationJobName() {
        this.project = null;
        this.location = null;
        this.migrationJob = null;
    }

    private MigrationJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.migrationJob = (String)Preconditions.checkNotNull((Object)builder.getMigrationJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMigrationJob() {
        return this.migrationJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MigrationJobName of(String project, String location, String migrationJob) {
        return MigrationJobName.newBuilder().setProject(project).setLocation(location).setMigrationJob(migrationJob).build();
    }

    public static String format(String project, String location, String migrationJob) {
        return MigrationJobName.newBuilder().setProject(project).setLocation(location).setMigrationJob(migrationJob).build().toString();
    }

    public static MigrationJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MIGRATION_JOB.validatedMatch(formattedString, "MigrationJobName.parse: formattedString not in valid format");
        return MigrationJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("migration_job"));
    }

    public static List<MigrationJobName> parseList(List<String> formattedStrings) {
        ArrayList<MigrationJobName> list = new ArrayList<MigrationJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MigrationJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MigrationJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MigrationJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MIGRATION_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MigrationJobName migrationJobName = this;
            synchronized (migrationJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.migrationJob != null) {
                        fieldMapBuilder.put((Object)"migration_job", (Object)this.migrationJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MIGRATION_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "migration_job", this.migrationJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MigrationJobName that = (MigrationJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.migrationJob, that.migrationJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.migrationJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String migrationJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMigrationJob() {
            return this.migrationJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMigrationJob(String migrationJob) {
            this.migrationJob = migrationJob;
            return this;
        }

        private Builder(MigrationJobName migrationJobName) {
            this.project = migrationJobName.project;
            this.location = migrationJobName.location;
            this.migrationJob = migrationJobName.migrationJob;
        }

        public MigrationJobName build() {
            return new MigrationJobName(this);
        }
    }
}

