/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.privacy.dlp.v2.CloudStorageOptionsOrBuilder;
import com.google.privacy.dlp.v2.CloudStorageRegexFileSet;
import com.google.privacy.dlp.v2.CloudStorageRegexFileSetOrBuilder;
import com.google.privacy.dlp.v2.DlpStorage;
import com.google.privacy.dlp.v2.FileType;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CloudStorageOptions
extends GeneratedMessageV3
implements CloudStorageOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int FILE_SET_FIELD_NUMBER = 1;
    private FileSet fileSet_;
    public static final int BYTES_LIMIT_PER_FILE_FIELD_NUMBER = 4;
    private long bytesLimitPerFile_;
    public static final int BYTES_LIMIT_PER_FILE_PERCENT_FIELD_NUMBER = 8;
    private int bytesLimitPerFilePercent_;
    public static final int FILE_TYPES_FIELD_NUMBER = 5;
    private List<Integer> fileTypes_;
    private static final Internal.ListAdapter.Converter<Integer, FileType> fileTypes_converter_ = new Internal.ListAdapter.Converter<Integer, FileType>(){

        public FileType convert(Integer from) {
            FileType result = FileType.valueOf(from);
            return result == null ? FileType.UNRECOGNIZED : result;
        }
    };
    private int fileTypesMemoizedSerializedSize;
    public static final int SAMPLE_METHOD_FIELD_NUMBER = 6;
    private int sampleMethod_;
    public static final int FILES_LIMIT_PERCENT_FIELD_NUMBER = 7;
    private int filesLimitPercent_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CloudStorageOptions DEFAULT_INSTANCE = new CloudStorageOptions();
    private static final Parser<CloudStorageOptions> PARSER = new AbstractParser<CloudStorageOptions>(){

        public CloudStorageOptions parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new CloudStorageOptions(input, extensionRegistry);
        }
    };

    private CloudStorageOptions(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CloudStorageOptions() {
        this.fileTypes_ = Collections.emptyList();
        this.sampleMethod_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new CloudStorageOptions();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private CloudStorageOptions(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block16: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block16;
                    }
                    case 10: {
                        FileSet.Builder subBuilder = null;
                        if (this.fileSet_ != null) {
                            subBuilder = this.fileSet_.toBuilder();
                        }
                        this.fileSet_ = (FileSet)input.readMessage(FileSet.parser(), extensionRegistry);
                        if (subBuilder == null) continue block16;
                        subBuilder.mergeFrom(this.fileSet_);
                        this.fileSet_ = subBuilder.buildPartial();
                        continue block16;
                    }
                    case 32: {
                        this.bytesLimitPerFile_ = input.readInt64();
                        continue block16;
                    }
                    case 40: {
                        int rawValue = input.readEnum();
                        if (!(mutable_bitField0_ & true)) {
                            this.fileTypes_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= true;
                        }
                        this.fileTypes_.add(rawValue);
                        continue block16;
                    }
                    case 42: {
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            int rawValue = input.readEnum();
                            if (!(mutable_bitField0_ & true)) {
                                this.fileTypes_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= true;
                            }
                            this.fileTypes_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block16;
                    }
                    case 48: {
                        int rawValue;
                        this.sampleMethod_ = rawValue = input.readEnum();
                        continue block16;
                    }
                    case 56: {
                        this.filesLimitPercent_ = input.readInt32();
                        continue block16;
                    }
                    case 64: {
                        this.bytesLimitPerFilePercent_ = input.readInt32();
                        continue block16;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.fileTypes_ = Collections.unmodifiableList(this.fileTypes_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_fieldAccessorTable.ensureFieldAccessorsInitialized(CloudStorageOptions.class, Builder.class);
    }

    @Override
    public boolean hasFileSet() {
        return this.fileSet_ != null;
    }

    @Override
    public FileSet getFileSet() {
        return this.fileSet_ == null ? FileSet.getDefaultInstance() : this.fileSet_;
    }

    @Override
    public FileSetOrBuilder getFileSetOrBuilder() {
        return this.getFileSet();
    }

    @Override
    public long getBytesLimitPerFile() {
        return this.bytesLimitPerFile_;
    }

    @Override
    public int getBytesLimitPerFilePercent() {
        return this.bytesLimitPerFilePercent_;
    }

    @Override
    public List<FileType> getFileTypesList() {
        return new Internal.ListAdapter(this.fileTypes_, fileTypes_converter_);
    }

    @Override
    public int getFileTypesCount() {
        return this.fileTypes_.size();
    }

    @Override
    public FileType getFileTypes(int index) {
        return (FileType)((Object)fileTypes_converter_.convert((Object)this.fileTypes_.get(index)));
    }

    @Override
    public List<Integer> getFileTypesValueList() {
        return this.fileTypes_;
    }

    @Override
    public int getFileTypesValue(int index) {
        return this.fileTypes_.get(index);
    }

    @Override
    public int getSampleMethodValue() {
        return this.sampleMethod_;
    }

    @Override
    public SampleMethod getSampleMethod() {
        SampleMethod result = SampleMethod.valueOf(this.sampleMethod_);
        return result == null ? SampleMethod.UNRECOGNIZED : result;
    }

    @Override
    public int getFilesLimitPercent() {
        return this.filesLimitPercent_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (this.fileSet_ != null) {
            output.writeMessage(1, (MessageLite)this.getFileSet());
        }
        if (this.bytesLimitPerFile_ != 0L) {
            output.writeInt64(4, this.bytesLimitPerFile_);
        }
        if (this.getFileTypesList().size() > 0) {
            output.writeUInt32NoTag(42);
            output.writeUInt32NoTag(this.fileTypesMemoizedSerializedSize);
        }
        for (int i = 0; i < this.fileTypes_.size(); ++i) {
            output.writeEnumNoTag(this.fileTypes_.get(i).intValue());
        }
        if (this.sampleMethod_ != SampleMethod.SAMPLE_METHOD_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.sampleMethod_);
        }
        if (this.filesLimitPercent_ != 0) {
            output.writeInt32(7, this.filesLimitPercent_);
        }
        if (this.bytesLimitPerFilePercent_ != 0) {
            output.writeInt32(8, this.bytesLimitPerFilePercent_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.fileSet_ != null) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getFileSet());
        }
        if (this.bytesLimitPerFile_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)4, (long)this.bytesLimitPerFile_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.fileTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.fileTypes_.get(i));
        }
        size += dataSize;
        if (!this.getFileTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.fileTypesMemoizedSerializedSize = dataSize;
        if (this.sampleMethod_ != SampleMethod.SAMPLE_METHOD_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.sampleMethod_);
        }
        if (this.filesLimitPercent_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)7, (int)this.filesLimitPercent_);
        }
        if (this.bytesLimitPerFilePercent_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)8, (int)this.bytesLimitPerFilePercent_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CloudStorageOptions)) {
            return super.equals(obj);
        }
        CloudStorageOptions other = (CloudStorageOptions)obj;
        if (this.hasFileSet() != other.hasFileSet()) {
            return false;
        }
        if (this.hasFileSet() && !this.getFileSet().equals(other.getFileSet())) {
            return false;
        }
        if (this.getBytesLimitPerFile() != other.getBytesLimitPerFile()) {
            return false;
        }
        if (this.getBytesLimitPerFilePercent() != other.getBytesLimitPerFilePercent()) {
            return false;
        }
        if (!this.fileTypes_.equals(other.fileTypes_)) {
            return false;
        }
        if (this.sampleMethod_ != other.sampleMethod_) {
            return false;
        }
        if (this.getFilesLimitPercent() != other.getFilesLimitPercent()) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + CloudStorageOptions.getDescriptor().hashCode();
        if (this.hasFileSet()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getFileSet().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashLong((long)this.getBytesLimitPerFile());
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getBytesLimitPerFilePercent();
        if (this.getFileTypesCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.fileTypes_.hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.sampleMethod_;
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getFilesLimitPercent();
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static CloudStorageOptions parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (CloudStorageOptions)PARSER.parseFrom(data);
    }

    public static CloudStorageOptions parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CloudStorageOptions)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CloudStorageOptions parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (CloudStorageOptions)PARSER.parseFrom(data);
    }

    public static CloudStorageOptions parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CloudStorageOptions)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CloudStorageOptions parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (CloudStorageOptions)PARSER.parseFrom(data);
    }

    public static CloudStorageOptions parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CloudStorageOptions)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CloudStorageOptions parseFrom(InputStream input) throws IOException {
        return (CloudStorageOptions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static CloudStorageOptions parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CloudStorageOptions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CloudStorageOptions parseDelimitedFrom(InputStream input) throws IOException {
        return (CloudStorageOptions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static CloudStorageOptions parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CloudStorageOptions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CloudStorageOptions parseFrom(CodedInputStream input) throws IOException {
        return (CloudStorageOptions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static CloudStorageOptions parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CloudStorageOptions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return CloudStorageOptions.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CloudStorageOptions prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static CloudStorageOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CloudStorageOptions> parser() {
        return PARSER;
    }

    public Parser<CloudStorageOptions> getParserForType() {
        return PARSER;
    }

    public CloudStorageOptions getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CloudStorageOptionsOrBuilder {
        private int bitField0_;
        private FileSet fileSet_;
        private SingleFieldBuilderV3<FileSet, FileSet.Builder, FileSetOrBuilder> fileSetBuilder_;
        private long bytesLimitPerFile_;
        private int bytesLimitPerFilePercent_;
        private List<Integer> fileTypes_ = Collections.emptyList();
        private int sampleMethod_ = 0;
        private int filesLimitPercent_;

        public static final Descriptors.Descriptor getDescriptor() {
            return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_fieldAccessorTable.ensureFieldAccessorsInitialized(CloudStorageOptions.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            if (this.fileSetBuilder_ == null) {
                this.fileSet_ = null;
            } else {
                this.fileSet_ = null;
                this.fileSetBuilder_ = null;
            }
            this.bytesLimitPerFile_ = 0L;
            this.bytesLimitPerFilePercent_ = 0;
            this.fileTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.sampleMethod_ = 0;
            this.filesLimitPercent_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_descriptor;
        }

        public CloudStorageOptions getDefaultInstanceForType() {
            return CloudStorageOptions.getDefaultInstance();
        }

        public CloudStorageOptions build() {
            CloudStorageOptions result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public CloudStorageOptions buildPartial() {
            CloudStorageOptions result = new CloudStorageOptions(this);
            int from_bitField0_ = this.bitField0_;
            if (this.fileSetBuilder_ == null) {
                result.fileSet_ = this.fileSet_;
            } else {
                result.fileSet_ = (FileSet)this.fileSetBuilder_.build();
            }
            result.bytesLimitPerFile_ = this.bytesLimitPerFile_;
            result.bytesLimitPerFilePercent_ = this.bytesLimitPerFilePercent_;
            if ((this.bitField0_ & 1) != 0) {
                this.fileTypes_ = Collections.unmodifiableList(this.fileTypes_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.fileTypes_ = this.fileTypes_;
            result.sampleMethod_ = this.sampleMethod_;
            result.filesLimitPercent_ = this.filesLimitPercent_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof CloudStorageOptions) {
                return this.mergeFrom((CloudStorageOptions)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(CloudStorageOptions other) {
            if (other == CloudStorageOptions.getDefaultInstance()) {
                return this;
            }
            if (other.hasFileSet()) {
                this.mergeFileSet(other.getFileSet());
            }
            if (other.getBytesLimitPerFile() != 0L) {
                this.setBytesLimitPerFile(other.getBytesLimitPerFile());
            }
            if (other.getBytesLimitPerFilePercent() != 0) {
                this.setBytesLimitPerFilePercent(other.getBytesLimitPerFilePercent());
            }
            if (!other.fileTypes_.isEmpty()) {
                if (this.fileTypes_.isEmpty()) {
                    this.fileTypes_ = other.fileTypes_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureFileTypesIsMutable();
                    this.fileTypes_.addAll(other.fileTypes_);
                }
                this.onChanged();
            }
            if (other.sampleMethod_ != 0) {
                this.setSampleMethodValue(other.getSampleMethodValue());
            }
            if (other.getFilesLimitPercent() != 0) {
                this.setFilesLimitPercent(other.getFilesLimitPercent());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            CloudStorageOptions parsedMessage = null;
            try {
                parsedMessage = (CloudStorageOptions)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (CloudStorageOptions)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public boolean hasFileSet() {
            return this.fileSetBuilder_ != null || this.fileSet_ != null;
        }

        @Override
        public FileSet getFileSet() {
            if (this.fileSetBuilder_ == null) {
                return this.fileSet_ == null ? FileSet.getDefaultInstance() : this.fileSet_;
            }
            return (FileSet)this.fileSetBuilder_.getMessage();
        }

        public Builder setFileSet(FileSet value) {
            if (this.fileSetBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.fileSet_ = value;
                this.onChanged();
            } else {
                this.fileSetBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setFileSet(FileSet.Builder builderForValue) {
            if (this.fileSetBuilder_ == null) {
                this.fileSet_ = builderForValue.build();
                this.onChanged();
            } else {
                this.fileSetBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeFileSet(FileSet value) {
            if (this.fileSetBuilder_ == null) {
                this.fileSet_ = this.fileSet_ != null ? FileSet.newBuilder(this.fileSet_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.fileSetBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearFileSet() {
            if (this.fileSetBuilder_ == null) {
                this.fileSet_ = null;
                this.onChanged();
            } else {
                this.fileSet_ = null;
                this.fileSetBuilder_ = null;
            }
            return this;
        }

        public FileSet.Builder getFileSetBuilder() {
            this.onChanged();
            return (FileSet.Builder)this.getFileSetFieldBuilder().getBuilder();
        }

        @Override
        public FileSetOrBuilder getFileSetOrBuilder() {
            if (this.fileSetBuilder_ != null) {
                return (FileSetOrBuilder)this.fileSetBuilder_.getMessageOrBuilder();
            }
            return this.fileSet_ == null ? FileSet.getDefaultInstance() : this.fileSet_;
        }

        private SingleFieldBuilderV3<FileSet, FileSet.Builder, FileSetOrBuilder> getFileSetFieldBuilder() {
            if (this.fileSetBuilder_ == null) {
                this.fileSetBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getFileSet(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.fileSet_ = null;
            }
            return this.fileSetBuilder_;
        }

        @Override
        public long getBytesLimitPerFile() {
            return this.bytesLimitPerFile_;
        }

        public Builder setBytesLimitPerFile(long value) {
            this.bytesLimitPerFile_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBytesLimitPerFile() {
            this.bytesLimitPerFile_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getBytesLimitPerFilePercent() {
            return this.bytesLimitPerFilePercent_;
        }

        public Builder setBytesLimitPerFilePercent(int value) {
            this.bytesLimitPerFilePercent_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBytesLimitPerFilePercent() {
            this.bytesLimitPerFilePercent_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureFileTypesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.fileTypes_ = new ArrayList<Integer>(this.fileTypes_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<FileType> getFileTypesList() {
            return new Internal.ListAdapter(this.fileTypes_, fileTypes_converter_);
        }

        @Override
        public int getFileTypesCount() {
            return this.fileTypes_.size();
        }

        @Override
        public FileType getFileTypes(int index) {
            return (FileType)((Object)fileTypes_converter_.convert((Object)this.fileTypes_.get(index)));
        }

        public Builder setFileTypes(int index, FileType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFileTypesIsMutable();
            this.fileTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addFileTypes(FileType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFileTypesIsMutable();
            this.fileTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllFileTypes(Iterable<? extends FileType> values) {
            this.ensureFileTypesIsMutable();
            for (FileType fileType : values) {
                this.fileTypes_.add(fileType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearFileTypes() {
            this.fileTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getFileTypesValueList() {
            return Collections.unmodifiableList(this.fileTypes_);
        }

        @Override
        public int getFileTypesValue(int index) {
            return this.fileTypes_.get(index);
        }

        public Builder setFileTypesValue(int index, int value) {
            this.ensureFileTypesIsMutable();
            this.fileTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addFileTypesValue(int value) {
            this.ensureFileTypesIsMutable();
            this.fileTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllFileTypesValue(Iterable<Integer> values) {
            this.ensureFileTypesIsMutable();
            for (int value : values) {
                this.fileTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public int getSampleMethodValue() {
            return this.sampleMethod_;
        }

        public Builder setSampleMethodValue(int value) {
            this.sampleMethod_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public SampleMethod getSampleMethod() {
            SampleMethod result = SampleMethod.valueOf(this.sampleMethod_);
            return result == null ? SampleMethod.UNRECOGNIZED : result;
        }

        public Builder setSampleMethod(SampleMethod value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.sampleMethod_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearSampleMethod() {
            this.sampleMethod_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getFilesLimitPercent() {
            return this.filesLimitPercent_;
        }

        public Builder setFilesLimitPercent(int value) {
            this.filesLimitPercent_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearFilesLimitPercent() {
            this.filesLimitPercent_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class FileSet
    extends GeneratedMessageV3
    implements FileSetOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int URL_FIELD_NUMBER = 1;
        private volatile Object url_;
        public static final int REGEX_FILE_SET_FIELD_NUMBER = 2;
        private CloudStorageRegexFileSet regexFileSet_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final FileSet DEFAULT_INSTANCE = new FileSet();
        private static final Parser<FileSet> PARSER = new AbstractParser<FileSet>(){

            public FileSet parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return new FileSet(input, extensionRegistry);
            }
        };

        private FileSet(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private FileSet() {
            this.url_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new FileSet();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private FileSet(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            String s = input.readStringRequireUtf8();
                            this.url_ = s;
                            continue block11;
                        }
                        case 18: {
                            CloudStorageRegexFileSet.Builder subBuilder = null;
                            if (this.regexFileSet_ != null) {
                                subBuilder = this.regexFileSet_.toBuilder();
                            }
                            this.regexFileSet_ = (CloudStorageRegexFileSet)input.readMessage(CloudStorageRegexFileSet.parser(), extensionRegistry);
                            if (subBuilder == null) continue block11;
                            subBuilder.mergeFrom(this.regexFileSet_);
                            this.regexFileSet_ = subBuilder.buildPartial();
                            continue block11;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
            }
            finally {
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_fieldAccessorTable.ensureFieldAccessorsInitialized(FileSet.class, Builder.class);
        }

        @Override
        public String getUrl() {
            Object ref = this.url_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.url_ = s;
            return s;
        }

        @Override
        public ByteString getUrlBytes() {
            Object ref = this.url_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.url_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasRegexFileSet() {
            return this.regexFileSet_ != null;
        }

        @Override
        public CloudStorageRegexFileSet getRegexFileSet() {
            return this.regexFileSet_ == null ? CloudStorageRegexFileSet.getDefaultInstance() : this.regexFileSet_;
        }

        @Override
        public CloudStorageRegexFileSetOrBuilder getRegexFileSetOrBuilder() {
            return this.getRegexFileSet();
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!this.getUrlBytes().isEmpty()) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.url_);
            }
            if (this.regexFileSet_ != null) {
                output.writeMessage(2, (MessageLite)this.getRegexFileSet());
            }
            this.unknownFields.writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!this.getUrlBytes().isEmpty()) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.url_);
            }
            if (this.regexFileSet_ != null) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getRegexFileSet());
            }
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FileSet)) {
                return super.equals(obj);
            }
            FileSet other = (FileSet)obj;
            if (!this.getUrl().equals(other.getUrl())) {
                return false;
            }
            if (this.hasRegexFileSet() != other.hasRegexFileSet()) {
                return false;
            }
            if (this.hasRegexFileSet() && !this.getRegexFileSet().equals(other.getRegexFileSet())) {
                return false;
            }
            return this.unknownFields.equals((Object)other.unknownFields);
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + FileSet.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getUrl().hashCode();
            if (this.hasRegexFileSet()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getRegexFileSet().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        public static FileSet parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (FileSet)PARSER.parseFrom(data);
        }

        public static FileSet parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (FileSet)PARSER.parseFrom(data, extensionRegistry);
        }

        public static FileSet parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (FileSet)PARSER.parseFrom(data);
        }

        public static FileSet parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (FileSet)PARSER.parseFrom(data, extensionRegistry);
        }

        public static FileSet parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (FileSet)PARSER.parseFrom(data);
        }

        public static FileSet parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (FileSet)PARSER.parseFrom(data, extensionRegistry);
        }

        public static FileSet parseFrom(InputStream input) throws IOException {
            return (FileSet)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static FileSet parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (FileSet)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static FileSet parseDelimitedFrom(InputStream input) throws IOException {
            return (FileSet)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static FileSet parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (FileSet)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static FileSet parseFrom(CodedInputStream input) throws IOException {
            return (FileSet)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static FileSet parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (FileSet)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return FileSet.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(FileSet prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static FileSet getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<FileSet> parser() {
            return PARSER;
        }

        public Parser<FileSet> getParserForType() {
            return PARSER;
        }

        public FileSet getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements FileSetOrBuilder {
            private Object url_ = "";
            private CloudStorageRegexFileSet regexFileSet_;
            private SingleFieldBuilderV3<CloudStorageRegexFileSet, CloudStorageRegexFileSet.Builder, CloudStorageRegexFileSetOrBuilder> regexFileSetBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_fieldAccessorTable.ensureFieldAccessorsInitialized(FileSet.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    // empty if block
                }
            }

            public Builder clear() {
                super.clear();
                this.url_ = "";
                if (this.regexFileSetBuilder_ == null) {
                    this.regexFileSet_ = null;
                } else {
                    this.regexFileSet_ = null;
                    this.regexFileSetBuilder_ = null;
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return DlpStorage.internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_descriptor;
            }

            public FileSet getDefaultInstanceForType() {
                return FileSet.getDefaultInstance();
            }

            public FileSet build() {
                FileSet result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public FileSet buildPartial() {
                FileSet result = new FileSet(this);
                result.url_ = this.url_;
                if (this.regexFileSetBuilder_ == null) {
                    result.regexFileSet_ = this.regexFileSet_;
                } else {
                    result.regexFileSet_ = (CloudStorageRegexFileSet)this.regexFileSetBuilder_.build();
                }
                this.onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof FileSet) {
                    return this.mergeFrom((FileSet)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(FileSet other) {
                if (other == FileSet.getDefaultInstance()) {
                    return this;
                }
                if (!other.getUrl().isEmpty()) {
                    this.url_ = other.url_;
                    this.onChanged();
                }
                if (other.hasRegexFileSet()) {
                    this.mergeRegexFileSet(other.getRegexFileSet());
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                FileSet parsedMessage = null;
                try {
                    parsedMessage = (FileSet)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (FileSet)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public String getUrl() {
                Object ref = this.url_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.url_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getUrlBytes() {
                Object ref = this.url_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.url_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setUrl(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.url_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearUrl() {
                this.url_ = FileSet.getDefaultInstance().getUrl();
                this.onChanged();
                return this;
            }

            public Builder setUrlBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                FileSet.checkByteStringIsUtf8((ByteString)value);
                this.url_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasRegexFileSet() {
                return this.regexFileSetBuilder_ != null || this.regexFileSet_ != null;
            }

            @Override
            public CloudStorageRegexFileSet getRegexFileSet() {
                if (this.regexFileSetBuilder_ == null) {
                    return this.regexFileSet_ == null ? CloudStorageRegexFileSet.getDefaultInstance() : this.regexFileSet_;
                }
                return (CloudStorageRegexFileSet)this.regexFileSetBuilder_.getMessage();
            }

            public Builder setRegexFileSet(CloudStorageRegexFileSet value) {
                if (this.regexFileSetBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.regexFileSet_ = value;
                    this.onChanged();
                } else {
                    this.regexFileSetBuilder_.setMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder setRegexFileSet(CloudStorageRegexFileSet.Builder builderForValue) {
                if (this.regexFileSetBuilder_ == null) {
                    this.regexFileSet_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.regexFileSetBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder mergeRegexFileSet(CloudStorageRegexFileSet value) {
                if (this.regexFileSetBuilder_ == null) {
                    this.regexFileSet_ = this.regexFileSet_ != null ? CloudStorageRegexFileSet.newBuilder(this.regexFileSet_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else {
                    this.regexFileSetBuilder_.mergeFrom((AbstractMessage)value);
                }
                return this;
            }

            public Builder clearRegexFileSet() {
                if (this.regexFileSetBuilder_ == null) {
                    this.regexFileSet_ = null;
                    this.onChanged();
                } else {
                    this.regexFileSet_ = null;
                    this.regexFileSetBuilder_ = null;
                }
                return this;
            }

            public CloudStorageRegexFileSet.Builder getRegexFileSetBuilder() {
                this.onChanged();
                return (CloudStorageRegexFileSet.Builder)this.getRegexFileSetFieldBuilder().getBuilder();
            }

            @Override
            public CloudStorageRegexFileSetOrBuilder getRegexFileSetOrBuilder() {
                if (this.regexFileSetBuilder_ != null) {
                    return (CloudStorageRegexFileSetOrBuilder)this.regexFileSetBuilder_.getMessageOrBuilder();
                }
                return this.regexFileSet_ == null ? CloudStorageRegexFileSet.getDefaultInstance() : this.regexFileSet_;
            }

            private SingleFieldBuilderV3<CloudStorageRegexFileSet, CloudStorageRegexFileSet.Builder, CloudStorageRegexFileSetOrBuilder> getRegexFileSetFieldBuilder() {
                if (this.regexFileSetBuilder_ == null) {
                    this.regexFileSetBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRegexFileSet(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.regexFileSet_ = null;
                }
                return this.regexFileSetBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface FileSetOrBuilder
    extends MessageOrBuilder {
        public String getUrl();

        public ByteString getUrlBytes();

        public boolean hasRegexFileSet();

        public CloudStorageRegexFileSet getRegexFileSet();

        public CloudStorageRegexFileSetOrBuilder getRegexFileSetOrBuilder();
    }

    public static enum SampleMethod implements ProtocolMessageEnum
    {
        SAMPLE_METHOD_UNSPECIFIED(0),
        TOP(1),
        RANDOM_START(2),
        UNRECOGNIZED(-1);

        public static final int SAMPLE_METHOD_UNSPECIFIED_VALUE = 0;
        public static final int TOP_VALUE = 1;
        public static final int RANDOM_START_VALUE = 2;
        private static final Internal.EnumLiteMap<SampleMethod> internalValueMap;
        private static final SampleMethod[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static SampleMethod valueOf(int value) {
            return SampleMethod.forNumber(value);
        }

        public static SampleMethod forNumber(int value) {
            switch (value) {
                case 0: {
                    return SAMPLE_METHOD_UNSPECIFIED;
                }
                case 1: {
                    return TOP;
                }
                case 2: {
                    return RANDOM_START;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<SampleMethod> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)SampleMethod.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return SampleMethod.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)CloudStorageOptions.getDescriptor().getEnumTypes().get(0);
        }

        public static SampleMethod valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != SampleMethod.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private SampleMethod(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<SampleMethod>(){

                public SampleMethod findValueByNumber(int number) {
                    return SampleMethod.forNumber(number);
                }
            };
            VALUES = SampleMethod.values();
        }
    }
}

