/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.privacy.dlp.v2.DeidentifyTemplateName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UntypedDeidentifyTemplateName
extends DeidentifyTemplateName {
    private final String rawValue;
    private Map<String, String> valueMap;

    private UntypedDeidentifyTemplateName(String rawValue) {
        this.rawValue = (String)Preconditions.checkNotNull((Object)rawValue);
        this.valueMap = ImmutableMap.of((Object)"", (Object)rawValue);
    }

    public static UntypedDeidentifyTemplateName from(ResourceName resourceName) {
        return new UntypedDeidentifyTemplateName(resourceName.toString());
    }

    public static UntypedDeidentifyTemplateName parse(String formattedString) {
        return new UntypedDeidentifyTemplateName(formattedString);
    }

    public static List<UntypedDeidentifyTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<UntypedDeidentifyTemplateName> list = new ArrayList<UntypedDeidentifyTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UntypedDeidentifyTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UntypedDeidentifyTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UntypedDeidentifyTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return true;
    }

    public Map<String, String> getFieldValuesMap() {
        return this.valueMap;
    }

    public String getFieldValue(String fieldName) {
        return this.valueMap.get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("UntypedDeidentifyTemplateName.getType() not supported");
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UntypedDeidentifyTemplateName) {
            UntypedDeidentifyTemplateName that = (UntypedDeidentifyTemplateName)o;
            return this.rawValue.equals(that.rawValue);
        }
        return false;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }
}

