/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectJobTriggerName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/jobTriggers/{job_trigger}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String jobTrigger;

    public String getProject() {
        return this.project;
    }

    public String getJobTrigger() {
        return this.jobTrigger;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectJobTriggerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.jobTrigger = (String)Preconditions.checkNotNull((Object)builder.getJobTrigger());
    }

    public static ProjectJobTriggerName of(String project, String jobTrigger) {
        return ProjectJobTriggerName.newBuilder().setProject(project).setJobTrigger(jobTrigger).build();
    }

    public static String format(String project, String jobTrigger) {
        return ProjectJobTriggerName.newBuilder().setProject(project).setJobTrigger(jobTrigger).build().toString();
    }

    public static ProjectJobTriggerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectJobTriggerName.parse: formattedString not in valid format");
        return ProjectJobTriggerName.of((String)matchMap.get("project"), (String)matchMap.get("job_trigger"));
    }

    public static List<ProjectJobTriggerName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectJobTriggerName> list = new ArrayList<ProjectJobTriggerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectJobTriggerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectJobTriggerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectJobTriggerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectJobTriggerName projectJobTriggerName = this;
            synchronized (projectJobTriggerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"jobTrigger", (Object)this.jobTrigger);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("ProjectJobTriggerName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "job_trigger", this.jobTrigger});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectJobTriggerName) {
            ProjectJobTriggerName that = (ProjectJobTriggerName)o;
            return this.project.equals(that.project) && this.jobTrigger.equals(that.jobTrigger);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.jobTrigger.hashCode();
    }

    public static class Builder {
        private String project;
        private String jobTrigger;

        public String getProject() {
            return this.project;
        }

        public String getJobTrigger() {
            return this.jobTrigger;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setJobTrigger(String jobTrigger) {
            this.jobTrigger = jobTrigger;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectJobTriggerName projectJobTriggerName) {
            this.project = projectJobTriggerName.project;
            this.jobTrigger = projectJobTriggerName.jobTrigger;
        }

        public ProjectJobTriggerName build() {
            return new ProjectJobTriggerName(this);
        }
    }
}

