/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DlpJobName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/dlpJobs/{dlp_job}");
    private final String project;
    private final String dlpJob;

    public String getProject() {
        return this.project;
    }

    public String getDlpJob() {
        return this.dlpJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DlpJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dlpJob = (String)Preconditions.checkNotNull((Object)builder.getDlpJob());
    }

    public static DlpJobName of(String project, String dlpJob) {
        return DlpJobName.newBuilder().setProject(project).setDlpJob(dlpJob).build();
    }

    public static String format(String project, String dlpJob) {
        return DlpJobName.newBuilder().setProject(project).setDlpJob(dlpJob).build().toString();
    }

    public static DlpJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DlpJobName.parse: formattedString not in valid format");
        return DlpJobName.of((String)matchMap.get("project"), (String)matchMap.get("dlp_job"));
    }

    public static List<DlpJobName> parseList(List<String> formattedStrings) {
        ArrayList<DlpJobName> list = new ArrayList<DlpJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DlpJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DlpJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DlpJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("DlpJobName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "dlp_job", this.dlpJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DlpJobName) {
            DlpJobName that = (DlpJobName)o;
            return this.project.equals(that.project) && this.dlpJob.equals(that.dlpJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.dlpJob.hashCode();
    }

    public static class Builder {
        private String project;
        private String dlpJob;

        public String getProject() {
            return this.project;
        }

        public String getDlpJob() {
            return this.dlpJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDlpJob(String dlpJob) {
            this.dlpJob = dlpJob;
            return this;
        }

        private Builder() {
        }

        private Builder(DlpJobName dlpJobName) {
            this.project = dlpJobName.project;
            this.dlpJob = dlpJobName.dlpJob;
        }

        public DlpJobName build() {
            return new DlpJobName(this);
        }
    }
}

