/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgecontainer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NodePoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_NODE_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cluster;
    private final String nodePool;

    @Deprecated
    protected NodePoolName() {
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.nodePool = null;
    }

    private NodePoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.nodePool = (String)Preconditions.checkNotNull((Object)builder.getNodePool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getNodePool() {
        return this.nodePool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NodePoolName of(String project, String location, String cluster, String nodePool) {
        return NodePoolName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setNodePool(nodePool).build();
    }

    public static String format(String project, String location, String cluster, String nodePool) {
        return NodePoolName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setNodePool(nodePool).build().toString();
    }

    public static NodePoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLUSTER_NODE_POOL.validatedMatch(formattedString, "NodePoolName.parse: formattedString not in valid format");
        return NodePoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"), (String)matchMap.get("node_pool"));
    }

    public static List<NodePoolName> parseList(List<String> formattedStrings) {
        ArrayList<NodePoolName> list = new ArrayList<NodePoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NodePoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NodePoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NodePoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLUSTER_NODE_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NodePoolName nodePoolName = this;
            synchronized (nodePoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.nodePool != null) {
                        fieldMapBuilder.put((Object)"node_pool", (Object)this.nodePool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLUSTER_NODE_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "cluster", this.cluster, "node_pool", this.nodePool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NodePoolName that = (NodePoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.nodePool, that.nodePool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.nodePool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cluster;
        private String nodePool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getNodePool() {
            return this.nodePool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setNodePool(String nodePool) {
            this.nodePool = nodePool;
            return this;
        }

        private Builder(NodePoolName nodePoolName) {
            this.project = nodePoolName.project;
            this.location = nodePoolName.location;
            this.cluster = nodePoolName.cluster;
            this.nodePool = nodePoolName.nodePool;
        }

        public NodePoolName build() {
            return new NodePoolName(this);
        }
    }
}

