/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GroundingConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GROUNDING_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/groundingConfigs/{grounding_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String groundingConfig;

    @Deprecated
    protected GroundingConfigName() {
        this.project = null;
        this.location = null;
        this.groundingConfig = null;
    }

    private GroundingConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.groundingConfig = (String)Preconditions.checkNotNull((Object)builder.getGroundingConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGroundingConfig() {
        return this.groundingConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GroundingConfigName of(String project, String location, String groundingConfig) {
        return GroundingConfigName.newBuilder().setProject(project).setLocation(location).setGroundingConfig(groundingConfig).build();
    }

    public static String format(String project, String location, String groundingConfig) {
        return GroundingConfigName.newBuilder().setProject(project).setLocation(location).setGroundingConfig(groundingConfig).build().toString();
    }

    public static GroundingConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GROUNDING_CONFIG.validatedMatch(formattedString, "GroundingConfigName.parse: formattedString not in valid format");
        return GroundingConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("grounding_config"));
    }

    public static List<GroundingConfigName> parseList(List<String> formattedStrings) {
        ArrayList<GroundingConfigName> list = new ArrayList<GroundingConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GroundingConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GroundingConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GroundingConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GROUNDING_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GroundingConfigName groundingConfigName = this;
            synchronized (groundingConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.groundingConfig != null) {
                        fieldMapBuilder.put((Object)"grounding_config", (Object)this.groundingConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GROUNDING_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "grounding_config", this.groundingConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GroundingConfigName that = (GroundingConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.groundingConfig, that.groundingConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.groundingConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String groundingConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGroundingConfig() {
            return this.groundingConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGroundingConfig(String groundingConfig) {
            this.groundingConfig = groundingConfig;
            return this;
        }

        private Builder(GroundingConfigName groundingConfigName) {
            this.project = groundingConfigName.project;
            this.location = groundingConfigName.location;
            this.groundingConfig = groundingConfigName.groundingConfig;
        }

        public GroundingConfigName build() {
            return new GroundingConfigName(this);
        }
    }
}

