/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CompletionConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/completionConfig");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/completionConfig");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_ENGINE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/completionConfig");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String collection;
    private final String engine;

    @Deprecated
    protected CompletionConfigName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.collection = null;
        this.engine = null;
    }

    private CompletionConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.collection = null;
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE;
    }

    private CompletionConfigName(ProjectLocationCollectionDataStoreBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE;
    }

    private CompletionConfigName(ProjectLocationCollectionEngineBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.engine = (String)Preconditions.checkNotNull((Object)builder.getEngine());
        this.dataStore = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_ENGINE;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getEngine() {
        return this.engine;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreBuilder newProjectLocationCollectionDataStoreBuilder() {
        return new ProjectLocationCollectionDataStoreBuilder();
    }

    public static ProjectLocationCollectionEngineBuilder newProjectLocationCollectionEngineBuilder() {
        return new ProjectLocationCollectionEngineBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CompletionConfigName of(String project, String location, String dataStore) {
        return CompletionConfigName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build();
    }

    public static CompletionConfigName ofProjectLocationDataStoreName(String project, String location, String dataStore) {
        return CompletionConfigName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build();
    }

    public static CompletionConfigName ofProjectLocationCollectionDataStoreName(String project, String location, String collection, String dataStore) {
        return CompletionConfigName.newProjectLocationCollectionDataStoreBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).build();
    }

    public static CompletionConfigName ofProjectLocationCollectionEngineName(String project, String location, String collection, String engine) {
        return CompletionConfigName.newProjectLocationCollectionEngineBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).build();
    }

    public static String format(String project, String location, String dataStore) {
        return CompletionConfigName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build().toString();
    }

    public static String formatProjectLocationDataStoreName(String project, String location, String dataStore) {
        return CompletionConfigName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreName(String project, String location, String collection, String dataStore) {
        return CompletionConfigName.newProjectLocationCollectionDataStoreBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).build().toString();
    }

    public static String formatProjectLocationCollectionEngineName(String project, String location, String collection, String engine) {
        return CompletionConfigName.newProjectLocationCollectionEngineBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).build().toString();
    }

    public static CompletionConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE.match(formattedString);
            return CompletionConfigName.ofProjectLocationDataStoreName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE.match(formattedString);
            return CompletionConfigName.ofProjectLocationCollectionDataStoreName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"));
        }
        if (PROJECT_LOCATION_COLLECTION_ENGINE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_ENGINE.match(formattedString);
            return CompletionConfigName.ofProjectLocationCollectionEngineName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("engine"));
        }
        throw new ValidationException("CompletionConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<CompletionConfigName> parseList(List<String> formattedStrings) {
        ArrayList<CompletionConfigName> list = new ArrayList<CompletionConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CompletionConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CompletionConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CompletionConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE.matches(formattedString) || PROJECT_LOCATION_COLLECTION_ENGINE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CompletionConfigName completionConfigName = this;
            synchronized (completionConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.engine != null) {
                        fieldMapBuilder.put((Object)"engine", (Object)this.engine);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CompletionConfigName that = (CompletionConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.collection, that.collection) && Objects.equals(this.engine, that.engine);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.engine);
    }

    public static class ProjectLocationCollectionEngineBuilder {
        private String project;
        private String location;
        private String collection;
        private String engine;

        protected ProjectLocationCollectionEngineBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getEngine() {
            return this.engine;
        }

        public ProjectLocationCollectionEngineBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionEngineBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionEngineBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionEngineBuilder setEngine(String engine) {
            this.engine = engine;
            return this;
        }

        public CompletionConfigName build() {
            return new CompletionConfigName(this);
        }
    }

    public static class ProjectLocationCollectionDataStoreBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;

        protected ProjectLocationCollectionDataStoreBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public ProjectLocationCollectionDataStoreBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public CompletionConfigName build() {
            return new CompletionConfigName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        private Builder(CompletionConfigName completionConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(completionConfigName.pathTemplate, PROJECT_LOCATION_DATA_STORE), (Object)"toBuilder is only supported when CompletionConfigName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/completionConfig");
            this.project = completionConfigName.project;
            this.location = completionConfigName.location;
            this.dataStore = completionConfigName.dataStore;
        }

        public CompletionConfigName build() {
            return new CompletionConfigName(this);
        }
    }
}

