/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SampleQuerySetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SAMPLE_QUERY_SET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String sampleQuerySet;

    @Deprecated
    protected SampleQuerySetName() {
        this.project = null;
        this.location = null;
        this.sampleQuerySet = null;
    }

    private SampleQuerySetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.sampleQuerySet = (String)Preconditions.checkNotNull((Object)builder.getSampleQuerySet());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSampleQuerySet() {
        return this.sampleQuerySet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SampleQuerySetName of(String project, String location, String sampleQuerySet) {
        return SampleQuerySetName.newBuilder().setProject(project).setLocation(location).setSampleQuerySet(sampleQuerySet).build();
    }

    public static String format(String project, String location, String sampleQuerySet) {
        return SampleQuerySetName.newBuilder().setProject(project).setLocation(location).setSampleQuerySet(sampleQuerySet).build().toString();
    }

    public static SampleQuerySetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SAMPLE_QUERY_SET.validatedMatch(formattedString, "SampleQuerySetName.parse: formattedString not in valid format");
        return SampleQuerySetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("sample_query_set"));
    }

    public static List<SampleQuerySetName> parseList(List<String> formattedStrings) {
        ArrayList<SampleQuerySetName> list = new ArrayList<SampleQuerySetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SampleQuerySetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SampleQuerySetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SampleQuerySetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SAMPLE_QUERY_SET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SampleQuerySetName sampleQuerySetName = this;
            synchronized (sampleQuerySetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.sampleQuerySet != null) {
                        fieldMapBuilder.put((Object)"sample_query_set", (Object)this.sampleQuerySet);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SAMPLE_QUERY_SET.instantiate(new String[]{"project", this.project, "location", this.location, "sample_query_set", this.sampleQuerySet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SampleQuerySetName that = (SampleQuerySetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.sampleQuerySet, that.sampleQuerySet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.sampleQuerySet);
    }

    public static class Builder {
        private String project;
        private String location;
        private String sampleQuerySet;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSampleQuerySet() {
            return this.sampleQuerySet;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSampleQuerySet(String sampleQuerySet) {
            this.sampleQuerySet = sampleQuerySet;
            return this;
        }

        private Builder(SampleQuerySetName sampleQuerySetName) {
            this.project = sampleQuerySetName.project;
            this.location = sampleQuerySetName.location;
            this.sampleQuerySet = sampleQuerySetName.sampleQuerySet;
        }

        public SampleQuerySetName build() {
            return new SampleQuerySetName(this);
        }
    }
}

