/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DocumentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String branch;
    private final String document;

    @Deprecated
    protected DocumentName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.branch = null;
        this.document = null;
    }

    private DocumentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.branch = (String)Preconditions.checkNotNull((Object)builder.getBranch());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getDocument() {
        return this.document;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DocumentName of(String project, String location, String dataStore, String branch, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).build();
    }

    public static String format(String project, String location, String dataStore, String branch, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).build().toString();
    }

    public static DocumentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT.validatedMatch(formattedString, "DocumentName.parse: formattedString not in valid format");
        return DocumentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("branch"), (String)matchMap.get("document"));
    }

    public static List<DocumentName> parseList(List<String> formattedStrings) {
        ArrayList<DocumentName> list = new ArrayList<DocumentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DocumentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DocumentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DocumentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DocumentName documentName = this;
            synchronized (documentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.branch != null) {
                        fieldMapBuilder.put((Object)"branch", (Object)this.branch);
                    }
                    if (this.document != null) {
                        fieldMapBuilder.put((Object)"document", (Object)this.document);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT.instantiate(new String[]{"project", this.project, "location", this.location, "data_store", this.dataStore, "branch", this.branch, "document", this.document});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DocumentName that = (DocumentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.branch, that.branch) && Objects.equals(this.document, that.document);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.branch);
        h *= 1000003;
        return h ^= Objects.hashCode(this.document);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String branch;
        private String document;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getDocument() {
            return this.document;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder setDocument(String document) {
            this.document = document;
            return this;
        }

        private Builder(DocumentName documentName) {
            this.project = documentName.project;
            this.location = documentName.location;
            this.dataStore = documentName.dataStore;
            this.branch = documentName.branch;
            this.document = documentName.document;
        }

        public DocumentName build() {
            return new DocumentName(this);
        }
    }
}

