/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SampleQueryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SAMPLE_QUERY_SET_SAMPLE_QUERY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String sampleQuerySet;
    private final String sampleQuery;

    @Deprecated
    protected SampleQueryName() {
        this.project = null;
        this.location = null;
        this.sampleQuerySet = null;
        this.sampleQuery = null;
    }

    private SampleQueryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.sampleQuerySet = (String)Preconditions.checkNotNull((Object)builder.getSampleQuerySet());
        this.sampleQuery = (String)Preconditions.checkNotNull((Object)builder.getSampleQuery());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSampleQuerySet() {
        return this.sampleQuerySet;
    }

    public String getSampleQuery() {
        return this.sampleQuery;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SampleQueryName of(String project, String location, String sampleQuerySet, String sampleQuery) {
        return SampleQueryName.newBuilder().setProject(project).setLocation(location).setSampleQuerySet(sampleQuerySet).setSampleQuery(sampleQuery).build();
    }

    public static String format(String project, String location, String sampleQuerySet, String sampleQuery) {
        return SampleQueryName.newBuilder().setProject(project).setLocation(location).setSampleQuerySet(sampleQuerySet).setSampleQuery(sampleQuery).build().toString();
    }

    public static SampleQueryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SAMPLE_QUERY_SET_SAMPLE_QUERY.validatedMatch(formattedString, "SampleQueryName.parse: formattedString not in valid format");
        return SampleQueryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("sample_query_set"), (String)matchMap.get("sample_query"));
    }

    public static List<SampleQueryName> parseList(List<String> formattedStrings) {
        ArrayList<SampleQueryName> list = new ArrayList<SampleQueryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SampleQueryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SampleQueryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SampleQueryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SAMPLE_QUERY_SET_SAMPLE_QUERY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SampleQueryName sampleQueryName = this;
            synchronized (sampleQueryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.sampleQuerySet != null) {
                        fieldMapBuilder.put((Object)"sample_query_set", (Object)this.sampleQuerySet);
                    }
                    if (this.sampleQuery != null) {
                        fieldMapBuilder.put((Object)"sample_query", (Object)this.sampleQuery);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SAMPLE_QUERY_SET_SAMPLE_QUERY.instantiate(new String[]{"project", this.project, "location", this.location, "sample_query_set", this.sampleQuerySet, "sample_query", this.sampleQuery});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SampleQueryName that = (SampleQueryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.sampleQuerySet, that.sampleQuerySet) && Objects.equals(this.sampleQuery, that.sampleQuery);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.sampleQuerySet);
        h *= 1000003;
        return h ^= Objects.hashCode(this.sampleQuery);
    }

    public static class Builder {
        private String project;
        private String location;
        private String sampleQuerySet;
        private String sampleQuery;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSampleQuerySet() {
            return this.sampleQuerySet;
        }

        public String getSampleQuery() {
            return this.sampleQuery;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSampleQuerySet(String sampleQuerySet) {
            this.sampleQuerySet = sampleQuerySet;
            return this;
        }

        public Builder setSampleQuery(String sampleQuery) {
            this.sampleQuery = sampleQuery;
            return this;
        }

        private Builder(SampleQueryName sampleQueryName) {
            this.project = sampleQueryName.project;
            this.location = sampleQueryName.location;
            this.sampleQuerySet = sampleQueryName.sampleQuerySet;
            this.sampleQuery = sampleQueryName.sampleQuery;
        }

        public SampleQueryName build() {
            return new SampleQueryName(this);
        }
    }
}

