/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/common.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Identity Provider Config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.IdpConfig}
 */
public final class IdpConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.IdpConfig)
    IdpConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IdpConfig.newBuilder() to construct.
  private IdpConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IdpConfig() {
    idpType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IdpConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.CommonProto
        .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.CommonProto
        .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.IdpConfig.class,
            com.google.cloud.discoveryengine.v1alpha.IdpConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Identity Provider Type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType}
   */
  public enum IdpType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. ACL search not enabled.
     * </pre>
     *
     * <code>IDP_TYPE_UNSPECIFIED = 0;</code>
     */
    IDP_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Google 1P provider.
     * </pre>
     *
     * <code>GSUITE = 1;</code>
     */
    GSUITE(1),
    /**
     *
     *
     * <pre>
     * Third party provider.
     * </pre>
     *
     * <code>THIRD_PARTY = 2;</code>
     */
    THIRD_PARTY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. ACL search not enabled.
     * </pre>
     *
     * <code>IDP_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int IDP_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Google 1P provider.
     * </pre>
     *
     * <code>GSUITE = 1;</code>
     */
    public static final int GSUITE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Third party provider.
     * </pre>
     *
     * <code>THIRD_PARTY = 2;</code>
     */
    public static final int THIRD_PARTY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IdpType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IdpType forNumber(int value) {
      switch (value) {
        case 0:
          return IDP_TYPE_UNSPECIFIED;
        case 1:
          return GSUITE;
        case 2:
          return THIRD_PARTY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IdpType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IdpType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IdpType>() {
          public IdpType findValueByNumber(int number) {
            return IdpType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.IdpConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final IdpType[] VALUES = values();

    public static IdpType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IdpType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType)
  }

  public interface ExternalIdpConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Workforce pool name.
     * Example: "locations/global/workforcePools/pool_id"
     * </pre>
     *
     * <code>string workforce_pool_name = 1;</code>
     *
     * @return The workforcePoolName.
     */
    java.lang.String getWorkforcePoolName();
    /**
     *
     *
     * <pre>
     * Workforce pool name.
     * Example: "locations/global/workforcePools/pool_id"
     * </pre>
     *
     * <code>string workforce_pool_name = 1;</code>
     *
     * @return The bytes for workforcePoolName.
     */
    com.google.protobuf.ByteString getWorkforcePoolNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Third party IDP Config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig}
   */
  public static final class ExternalIdpConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig)
      ExternalIdpConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExternalIdpConfig.newBuilder() to construct.
    private ExternalIdpConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExternalIdpConfig() {
      workforcePoolName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExternalIdpConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.CommonProto
          .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_ExternalIdpConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.CommonProto
          .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_ExternalIdpConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.class,
              com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.Builder.class);
    }

    public static final int WORKFORCE_POOL_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object workforcePoolName_ = "";
    /**
     *
     *
     * <pre>
     * Workforce pool name.
     * Example: "locations/global/workforcePools/pool_id"
     * </pre>
     *
     * <code>string workforce_pool_name = 1;</code>
     *
     * @return The workforcePoolName.
     */
    @java.lang.Override
    public java.lang.String getWorkforcePoolName() {
      java.lang.Object ref = workforcePoolName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workforcePoolName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Workforce pool name.
     * Example: "locations/global/workforcePools/pool_id"
     * </pre>
     *
     * <code>string workforce_pool_name = 1;</code>
     *
     * @return The bytes for workforcePoolName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getWorkforcePoolNameBytes() {
      java.lang.Object ref = workforcePoolName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workforcePoolName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workforcePoolName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, workforcePoolName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workforcePoolName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, workforcePoolName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig other =
          (com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig) obj;

      if (!getWorkforcePoolName().equals(other.getWorkforcePoolName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WORKFORCE_POOL_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getWorkforcePoolName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Third party IDP Config.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig)
        com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.CommonProto
            .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_ExternalIdpConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.CommonProto
            .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_ExternalIdpConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.class,
                com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        workforcePoolName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1alpha.CommonProto
            .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_ExternalIdpConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig build() {
        com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig buildPartial() {
        com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig result =
            new com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.workforcePoolName_ = workforcePoolName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
                .getDefaultInstance()) return this;
        if (!other.getWorkforcePoolName().isEmpty()) {
          workforcePoolName_ = other.workforcePoolName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  workforcePoolName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object workforcePoolName_ = "";
      /**
       *
       *
       * <pre>
       * Workforce pool name.
       * Example: "locations/global/workforcePools/pool_id"
       * </pre>
       *
       * <code>string workforce_pool_name = 1;</code>
       *
       * @return The workforcePoolName.
       */
      public java.lang.String getWorkforcePoolName() {
        java.lang.Object ref = workforcePoolName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          workforcePoolName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Workforce pool name.
       * Example: "locations/global/workforcePools/pool_id"
       * </pre>
       *
       * <code>string workforce_pool_name = 1;</code>
       *
       * @return The bytes for workforcePoolName.
       */
      public com.google.protobuf.ByteString getWorkforcePoolNameBytes() {
        java.lang.Object ref = workforcePoolName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          workforcePoolName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Workforce pool name.
       * Example: "locations/global/workforcePools/pool_id"
       * </pre>
       *
       * <code>string workforce_pool_name = 1;</code>
       *
       * @param value The workforcePoolName to set.
       * @return This builder for chaining.
       */
      public Builder setWorkforcePoolName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        workforcePoolName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Workforce pool name.
       * Example: "locations/global/workforcePools/pool_id"
       * </pre>
       *
       * <code>string workforce_pool_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWorkforcePoolName() {
        workforcePoolName_ = getDefaultInstance().getWorkforcePoolName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Workforce pool name.
       * Example: "locations/global/workforcePools/pool_id"
       * </pre>
       *
       * <code>string workforce_pool_name = 1;</code>
       *
       * @param value The bytes for workforcePoolName to set.
       * @return This builder for chaining.
       */
      public Builder setWorkforcePoolNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        workforcePoolName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig)
    private static final com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig();
    }

    public static com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExternalIdpConfig> PARSER =
        new com.google.protobuf.AbstractParser<ExternalIdpConfig>() {
          @java.lang.Override
          public ExternalIdpConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExternalIdpConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExternalIdpConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int IDP_TYPE_FIELD_NUMBER = 1;
  private int idpType_ = 0;
  /**
   *
   *
   * <pre>
   * Identity provider type configured.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType idp_type = 1;</code>
   *
   * @return The enum numeric value on the wire for idpType.
   */
  @java.lang.Override
  public int getIdpTypeValue() {
    return idpType_;
  }
  /**
   *
   *
   * <pre>
   * Identity provider type configured.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType idp_type = 1;</code>
   *
   * @return The idpType.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType getIdpType() {
    com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType result =
        com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType.forNumber(idpType_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType.UNRECOGNIZED
        : result;
  }

  public static final int EXTERNAL_IDP_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig externalIdpConfig_;
  /**
   *
   *
   * <pre>
   * External Identity provider config.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
   * </code>
   *
   * @return Whether the externalIdpConfig field is set.
   */
  @java.lang.Override
  public boolean hasExternalIdpConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * External Identity provider config.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
   * </code>
   *
   * @return The externalIdpConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
      getExternalIdpConfig() {
    return externalIdpConfig_ == null
        ? com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.getDefaultInstance()
        : externalIdpConfig_;
  }
  /**
   *
   *
   * <pre>
   * External Identity provider config.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfigOrBuilder
      getExternalIdpConfigOrBuilder() {
    return externalIdpConfig_ == null
        ? com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.getDefaultInstance()
        : externalIdpConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (idpType_
        != com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType.IDP_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, idpType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getExternalIdpConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (idpType_
        != com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType.IDP_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, idpType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExternalIdpConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.IdpConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.IdpConfig other =
        (com.google.cloud.discoveryengine.v1alpha.IdpConfig) obj;

    if (idpType_ != other.idpType_) return false;
    if (hasExternalIdpConfig() != other.hasExternalIdpConfig()) return false;
    if (hasExternalIdpConfig()) {
      if (!getExternalIdpConfig().equals(other.getExternalIdpConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IDP_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + idpType_;
    if (hasExternalIdpConfig()) {
      hash = (37 * hash) + EXTERNAL_IDP_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getExternalIdpConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1alpha.IdpConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Identity Provider Config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.IdpConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.IdpConfig)
      com.google.cloud.discoveryengine.v1alpha.IdpConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.CommonProto
          .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.CommonProto
          .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.IdpConfig.class,
              com.google.cloud.discoveryengine.v1alpha.IdpConfig.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1alpha.IdpConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExternalIdpConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      idpType_ = 0;
      externalIdpConfig_ = null;
      if (externalIdpConfigBuilder_ != null) {
        externalIdpConfigBuilder_.dispose();
        externalIdpConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.CommonProto
          .internal_static_google_cloud_discoveryengine_v1alpha_IdpConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.IdpConfig getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.IdpConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.IdpConfig build() {
      com.google.cloud.discoveryengine.v1alpha.IdpConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.IdpConfig buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.IdpConfig result =
          new com.google.cloud.discoveryengine.v1alpha.IdpConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1alpha.IdpConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.idpType_ = idpType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.externalIdpConfig_ =
            externalIdpConfigBuilder_ == null
                ? externalIdpConfig_
                : externalIdpConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.IdpConfig) {
        return mergeFrom((com.google.cloud.discoveryengine.v1alpha.IdpConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1alpha.IdpConfig other) {
      if (other == com.google.cloud.discoveryengine.v1alpha.IdpConfig.getDefaultInstance())
        return this;
      if (other.idpType_ != 0) {
        setIdpTypeValue(other.getIdpTypeValue());
      }
      if (other.hasExternalIdpConfig()) {
        mergeExternalIdpConfig(other.getExternalIdpConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                idpType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getExternalIdpConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int idpType_ = 0;
    /**
     *
     *
     * <pre>
     * Identity provider type configured.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType idp_type = 1;</code>
     *
     * @return The enum numeric value on the wire for idpType.
     */
    @java.lang.Override
    public int getIdpTypeValue() {
      return idpType_;
    }
    /**
     *
     *
     * <pre>
     * Identity provider type configured.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType idp_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for idpType to set.
     * @return This builder for chaining.
     */
    public Builder setIdpTypeValue(int value) {
      idpType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity provider type configured.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType idp_type = 1;</code>
     *
     * @return The idpType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType getIdpType() {
      com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType result =
          com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType.forNumber(idpType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Identity provider type configured.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType idp_type = 1;</code>
     *
     * @param value The idpType to set.
     * @return This builder for chaining.
     */
    public Builder setIdpType(com.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      idpType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity provider type configured.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType idp_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIdpType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      idpType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig externalIdpConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig,
            com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.Builder,
            com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfigOrBuilder>
        externalIdpConfigBuilder_;
    /**
     *
     *
     * <pre>
     * External Identity provider config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
     * </code>
     *
     * @return Whether the externalIdpConfig field is set.
     */
    public boolean hasExternalIdpConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * External Identity provider config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
     * </code>
     *
     * @return The externalIdpConfig.
     */
    public com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
        getExternalIdpConfig() {
      if (externalIdpConfigBuilder_ == null) {
        return externalIdpConfig_ == null
            ? com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
                .getDefaultInstance()
            : externalIdpConfig_;
      } else {
        return externalIdpConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * External Identity provider config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
     * </code>
     */
    public Builder setExternalIdpConfig(
        com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig value) {
      if (externalIdpConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        externalIdpConfig_ = value;
      } else {
        externalIdpConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * External Identity provider config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
     * </code>
     */
    public Builder setExternalIdpConfig(
        com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.Builder
            builderForValue) {
      if (externalIdpConfigBuilder_ == null) {
        externalIdpConfig_ = builderForValue.build();
      } else {
        externalIdpConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * External Identity provider config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
     * </code>
     */
    public Builder mergeExternalIdpConfig(
        com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig value) {
      if (externalIdpConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && externalIdpConfig_ != null
            && externalIdpConfig_
                != com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
                    .getDefaultInstance()) {
          getExternalIdpConfigBuilder().mergeFrom(value);
        } else {
          externalIdpConfig_ = value;
        }
      } else {
        externalIdpConfigBuilder_.mergeFrom(value);
      }
      if (externalIdpConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * External Identity provider config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
     * </code>
     */
    public Builder clearExternalIdpConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      externalIdpConfig_ = null;
      if (externalIdpConfigBuilder_ != null) {
        externalIdpConfigBuilder_.dispose();
        externalIdpConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * External Identity provider config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.Builder
        getExternalIdpConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getExternalIdpConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * External Identity provider config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfigOrBuilder
        getExternalIdpConfigOrBuilder() {
      if (externalIdpConfigBuilder_ != null) {
        return externalIdpConfigBuilder_.getMessageOrBuilder();
      } else {
        return externalIdpConfig_ == null
            ? com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
                .getDefaultInstance()
            : externalIdpConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * External Identity provider config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig external_idp_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig,
            com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.Builder,
            com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfigOrBuilder>
        getExternalIdpConfigFieldBuilder() {
      if (externalIdpConfigBuilder_ == null) {
        externalIdpConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig,
                com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig.Builder,
                com.google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfigOrBuilder>(
                getExternalIdpConfig(), getParentForChildren(), isClean());
        externalIdpConfig_ = null;
      }
      return externalIdpConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.IdpConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.IdpConfig)
  private static final com.google.cloud.discoveryengine.v1alpha.IdpConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.IdpConfig();
  }

  public static com.google.cloud.discoveryengine.v1alpha.IdpConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IdpConfig> PARSER =
      new com.google.protobuf.AbstractParser<IdpConfig>() {
        @java.lang.Override
        public IdpConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IdpConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IdpConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.IdpConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
