/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SchemaName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_SCHEMA = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/schemas/{schema}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_SCHEMA = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/schemas/{schema}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String schema;
    private final String collection;

    @Deprecated
    protected SchemaName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.schema = null;
        this.collection = null;
    }

    private SchemaName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.schema = (String)Preconditions.checkNotNull((Object)builder.getSchema());
        this.collection = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_SCHEMA;
    }

    private SchemaName(ProjectLocationCollectionDataStoreSchemaBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.schema = (String)Preconditions.checkNotNull((Object)builder.getSchema());
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_SCHEMA;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreSchemaBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreSchemaBuilder newProjectLocationCollectionDataStoreSchemaBuilder() {
        return new ProjectLocationCollectionDataStoreSchemaBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SchemaName of(String project, String location, String dataStore, String schema) {
        return SchemaName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSchema(schema).build();
    }

    public static SchemaName ofProjectLocationDataStoreSchemaName(String project, String location, String dataStore, String schema) {
        return SchemaName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSchema(schema).build();
    }

    public static SchemaName ofProjectLocationCollectionDataStoreSchemaName(String project, String location, String collection, String dataStore, String schema) {
        return SchemaName.newProjectLocationCollectionDataStoreSchemaBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setSchema(schema).build();
    }

    public static String format(String project, String location, String dataStore, String schema) {
        return SchemaName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSchema(schema).build().toString();
    }

    public static String formatProjectLocationDataStoreSchemaName(String project, String location, String dataStore, String schema) {
        return SchemaName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSchema(schema).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreSchemaName(String project, String location, String collection, String dataStore, String schema) {
        return SchemaName.newProjectLocationCollectionDataStoreSchemaBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setSchema(schema).build().toString();
    }

    public static SchemaName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_SCHEMA.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_SCHEMA.match(formattedString);
            return SchemaName.ofProjectLocationDataStoreSchemaName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("schema"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_SCHEMA.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_SCHEMA.match(formattedString);
            return SchemaName.ofProjectLocationCollectionDataStoreSchemaName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("schema"));
        }
        throw new ValidationException("SchemaName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SchemaName> parseList(List<String> formattedStrings) {
        ArrayList<SchemaName> list = new ArrayList<SchemaName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SchemaName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SchemaName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SchemaName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_SCHEMA.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_SCHEMA.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SchemaName schemaName = this;
            synchronized (schemaName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.schema != null) {
                        fieldMapBuilder.put((Object)"schema", (Object)this.schema);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SchemaName that = (SchemaName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.schema, that.schema) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.schema);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    public static class ProjectLocationCollectionDataStoreSchemaBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String schema;

        protected ProjectLocationCollectionDataStoreSchemaBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getSchema() {
            return this.schema;
        }

        public ProjectLocationCollectionDataStoreSchemaBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreSchemaBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreSchemaBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreSchemaBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreSchemaBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public SchemaName build() {
            return new SchemaName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String schema;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getSchema() {
            return this.schema;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        private Builder(SchemaName schemaName) {
            Preconditions.checkArgument((boolean)Objects.equals(schemaName.pathTemplate, PROJECT_LOCATION_DATA_STORE_SCHEMA), (Object)"toBuilder is only supported when SchemaName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/schemas/{schema}");
            this.project = schemaName.project;
            this.location = schemaName.location;
            this.dataStore = schemaName.dataStore;
            this.schema = schemaName.schema;
        }

        public SchemaName build() {
            return new SchemaName(this);
        }
    }
}

