/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CmekConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cmekConfig");
    private static final PathTemplate PROJECT_LOCATION_CMEK_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cmekConfigs/{cmek_config}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String cmekConfig;

    @Deprecated
    protected CmekConfigName() {
        this.project = null;
        this.location = null;
        this.cmekConfig = null;
    }

    private CmekConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cmekConfig = null;
        this.pathTemplate = PROJECT_LOCATION;
    }

    private CmekConfigName(ProjectLocationCmekConfigBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cmekConfig = (String)Preconditions.checkNotNull((Object)builder.getCmekConfig());
        this.pathTemplate = PROJECT_LOCATION_CMEK_CONFIG;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCmekConfig() {
        return this.cmekConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationBuilder() {
        return new Builder();
    }

    public static ProjectLocationCmekConfigBuilder newProjectLocationCmekConfigBuilder() {
        return new ProjectLocationCmekConfigBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CmekConfigName of(String project, String location) {
        return CmekConfigName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static CmekConfigName ofProjectLocationName(String project, String location) {
        return CmekConfigName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static CmekConfigName ofProjectLocationCmekConfigName(String project, String location, String cmekConfig) {
        return CmekConfigName.newProjectLocationCmekConfigBuilder().setProject(project).setLocation(location).setCmekConfig(cmekConfig).build();
    }

    public static String format(String project, String location) {
        return CmekConfigName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static String formatProjectLocationName(String project, String location) {
        return CmekConfigName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static String formatProjectLocationCmekConfigName(String project, String location, String cmekConfig) {
        return CmekConfigName.newProjectLocationCmekConfigBuilder().setProject(project).setLocation(location).setCmekConfig(cmekConfig).build().toString();
    }

    public static CmekConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION.match(formattedString);
            return CmekConfigName.ofProjectLocationName((String)matchMap.get("project"), (String)matchMap.get("location"));
        }
        if (PROJECT_LOCATION_CMEK_CONFIG.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CMEK_CONFIG.match(formattedString);
            return CmekConfigName.ofProjectLocationCmekConfigName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cmek_config"));
        }
        throw new ValidationException("CmekConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<CmekConfigName> parseList(List<String> formattedStrings) {
        ArrayList<CmekConfigName> list = new ArrayList<CmekConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CmekConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CmekConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CmekConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION.matches(formattedString) || PROJECT_LOCATION_CMEK_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CmekConfigName cmekConfigName = this;
            synchronized (cmekConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cmekConfig != null) {
                        fieldMapBuilder.put((Object)"cmek_config", (Object)this.cmekConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CmekConfigName that = (CmekConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cmekConfig, that.cmekConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cmekConfig);
    }

    public static class ProjectLocationCmekConfigBuilder {
        private String project;
        private String location;
        private String cmekConfig;

        protected ProjectLocationCmekConfigBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCmekConfig() {
            return this.cmekConfig;
        }

        public ProjectLocationCmekConfigBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCmekConfigBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCmekConfigBuilder setCmekConfig(String cmekConfig) {
            this.cmekConfig = cmekConfig;
            return this;
        }

        public CmekConfigName build() {
            return new CmekConfigName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(CmekConfigName cmekConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(cmekConfigName.pathTemplate, PROJECT_LOCATION), (Object)"toBuilder is only supported when CmekConfigName has the pattern of projects/{project}/locations/{location}/cmekConfig");
            this.project = cmekConfigName.project;
            this.location = cmekConfigName.location;
        }

        public CmekConfigName build() {
            return new CmekConfigName(this);
        }
    }
}

