/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ControlName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_CONTROL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/controls/{control}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_CONTROL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/controls/{control}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_ENGINE_CONTROL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/controls/{control}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String control;
    private final String collection;
    private final String engine;

    @Deprecated
    protected ControlName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.control = null;
        this.collection = null;
        this.engine = null;
    }

    private ControlName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.control = (String)Preconditions.checkNotNull((Object)builder.getControl());
        this.collection = null;
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_CONTROL;
    }

    private ControlName(ProjectLocationCollectionDataStoreControlBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.control = (String)Preconditions.checkNotNull((Object)builder.getControl());
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_CONTROL;
    }

    private ControlName(ProjectLocationCollectionEngineControlBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.engine = (String)Preconditions.checkNotNull((Object)builder.getEngine());
        this.control = (String)Preconditions.checkNotNull((Object)builder.getControl());
        this.dataStore = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_ENGINE_CONTROL;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getControl() {
        return this.control;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getEngine() {
        return this.engine;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreControlBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreControlBuilder newProjectLocationCollectionDataStoreControlBuilder() {
        return new ProjectLocationCollectionDataStoreControlBuilder();
    }

    public static ProjectLocationCollectionEngineControlBuilder newProjectLocationCollectionEngineControlBuilder() {
        return new ProjectLocationCollectionEngineControlBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ControlName of(String project, String location, String dataStore, String control) {
        return ControlName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setControl(control).build();
    }

    public static ControlName ofProjectLocationDataStoreControlName(String project, String location, String dataStore, String control) {
        return ControlName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setControl(control).build();
    }

    public static ControlName ofProjectLocationCollectionDataStoreControlName(String project, String location, String collection, String dataStore, String control) {
        return ControlName.newProjectLocationCollectionDataStoreControlBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setControl(control).build();
    }

    public static ControlName ofProjectLocationCollectionEngineControlName(String project, String location, String collection, String engine, String control) {
        return ControlName.newProjectLocationCollectionEngineControlBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setControl(control).build();
    }

    public static String format(String project, String location, String dataStore, String control) {
        return ControlName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setControl(control).build().toString();
    }

    public static String formatProjectLocationDataStoreControlName(String project, String location, String dataStore, String control) {
        return ControlName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setControl(control).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreControlName(String project, String location, String collection, String dataStore, String control) {
        return ControlName.newProjectLocationCollectionDataStoreControlBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setControl(control).build().toString();
    }

    public static String formatProjectLocationCollectionEngineControlName(String project, String location, String collection, String engine, String control) {
        return ControlName.newProjectLocationCollectionEngineControlBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setControl(control).build().toString();
    }

    public static ControlName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_CONTROL.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_CONTROL.match(formattedString);
            return ControlName.ofProjectLocationDataStoreControlName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("control"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_CONTROL.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_CONTROL.match(formattedString);
            return ControlName.ofProjectLocationCollectionDataStoreControlName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("control"));
        }
        if (PROJECT_LOCATION_COLLECTION_ENGINE_CONTROL.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_ENGINE_CONTROL.match(formattedString);
            return ControlName.ofProjectLocationCollectionEngineControlName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("engine"), (String)matchMap.get("control"));
        }
        throw new ValidationException("ControlName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ControlName> parseList(List<String> formattedStrings) {
        ArrayList<ControlName> list = new ArrayList<ControlName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ControlName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ControlName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ControlName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_CONTROL.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_CONTROL.matches(formattedString) || PROJECT_LOCATION_COLLECTION_ENGINE_CONTROL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ControlName controlName = this;
            synchronized (controlName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.control != null) {
                        fieldMapBuilder.put((Object)"control", (Object)this.control);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.engine != null) {
                        fieldMapBuilder.put((Object)"engine", (Object)this.engine);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ControlName that = (ControlName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.control, that.control) && Objects.equals(this.collection, that.collection) && Objects.equals(this.engine, that.engine);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.control);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.engine);
    }

    public static class ProjectLocationCollectionEngineControlBuilder {
        private String project;
        private String location;
        private String collection;
        private String engine;
        private String control;

        protected ProjectLocationCollectionEngineControlBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getEngine() {
            return this.engine;
        }

        public String getControl() {
            return this.control;
        }

        public ProjectLocationCollectionEngineControlBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionEngineControlBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionEngineControlBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionEngineControlBuilder setEngine(String engine) {
            this.engine = engine;
            return this;
        }

        public ProjectLocationCollectionEngineControlBuilder setControl(String control) {
            this.control = control;
            return this;
        }

        public ControlName build() {
            return new ControlName(this);
        }
    }

    public static class ProjectLocationCollectionDataStoreControlBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String control;

        protected ProjectLocationCollectionDataStoreControlBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getControl() {
            return this.control;
        }

        public ProjectLocationCollectionDataStoreControlBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreControlBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreControlBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreControlBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreControlBuilder setControl(String control) {
            this.control = control;
            return this;
        }

        public ControlName build() {
            return new ControlName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String control;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getControl() {
            return this.control;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setControl(String control) {
            this.control = control;
            return this;
        }

        private Builder(ControlName controlName) {
            Preconditions.checkArgument((boolean)Objects.equals(controlName.pathTemplate, PROJECT_LOCATION_DATA_STORE_CONTROL), (Object)"toBuilder is only supported when ControlName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/controls/{control}");
            this.project = controlName.project;
            this.location = controlName.location;
            this.dataStore = controlName.dataStore;
            this.control = controlName.control;
        }

        public ControlName build() {
            return new ControlName(this);
        }
    }
}

