/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataStoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String collection;

    @Deprecated
    protected DataStoreName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.collection = null;
    }

    private DataStoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.collection = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE;
    }

    private DataStoreName(ProjectLocationCollectionDataStoreBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreBuilder newProjectLocationCollectionDataStoreBuilder() {
        return new ProjectLocationCollectionDataStoreBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataStoreName of(String project, String location, String dataStore) {
        return DataStoreName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build();
    }

    public static DataStoreName ofProjectLocationDataStoreName(String project, String location, String dataStore) {
        return DataStoreName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build();
    }

    public static DataStoreName ofProjectLocationCollectionDataStoreName(String project, String location, String collection, String dataStore) {
        return DataStoreName.newProjectLocationCollectionDataStoreBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).build();
    }

    public static String format(String project, String location, String dataStore) {
        return DataStoreName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build().toString();
    }

    public static String formatProjectLocationDataStoreName(String project, String location, String dataStore) {
        return DataStoreName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreName(String project, String location, String collection, String dataStore) {
        return DataStoreName.newProjectLocationCollectionDataStoreBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).build().toString();
    }

    public static DataStoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE.match(formattedString);
            return DataStoreName.ofProjectLocationDataStoreName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE.match(formattedString);
            return DataStoreName.ofProjectLocationCollectionDataStoreName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"));
        }
        throw new ValidationException("DataStoreName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<DataStoreName> parseList(List<String> formattedStrings) {
        ArrayList<DataStoreName> list = new ArrayList<DataStoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataStoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataStoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataStoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataStoreName dataStoreName = this;
            synchronized (dataStoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataStoreName that = (DataStoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    public static class ProjectLocationCollectionDataStoreBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;

        protected ProjectLocationCollectionDataStoreBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public ProjectLocationCollectionDataStoreBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public DataStoreName build() {
            return new DataStoreName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        private Builder(DataStoreName dataStoreName) {
            Preconditions.checkArgument((boolean)Objects.equals(dataStoreName.pathTemplate, PROJECT_LOCATION_DATA_STORE), (Object)"toBuilder is only supported when DataStoreName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}");
            this.project = dataStoreName.project;
            this.location = dataStoreName.location;
            this.dataStore = dataStoreName.dataStore;
        }

        public DataStoreName build() {
            return new DataStoreName(this);
        }
    }
}

