/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_CONVERSATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/conversations/{conversation}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_CONVERSATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/conversations/{conversation}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String conversation;
    private final String collection;

    @Deprecated
    protected ConversationName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.conversation = null;
        this.collection = null;
    }

    private ConversationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.collection = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_CONVERSATION;
    }

    private ConversationName(ProjectLocationCollectionDataStoreConversationBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_CONVERSATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getConversation() {
        return this.conversation;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationDataStoreConversationBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationCollectionDataStoreConversationBuilder newProjectLocationCollectionDataStoreConversationBuilder() {
        return new ProjectLocationCollectionDataStoreConversationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversationName of(String project, String location, String dataStore, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setConversation(conversation).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConversationName ofProjectLocationDataStoreConversationName(String project, String location, String dataStore, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setConversation(conversation).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConversationName ofProjectLocationCollectionDataStoreConversationName(String project, String location, String collection, String dataStore, String conversation) {
        return ConversationName.newProjectLocationCollectionDataStoreConversationBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setConversation(conversation).build();
    }

    public static String format(String project, String location, String dataStore, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setConversation(conversation).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationDataStoreConversationName(String project, String location, String dataStore, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setConversation(conversation).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationCollectionDataStoreConversationName(String project, String location, String collection, String dataStore, String conversation) {
        return ConversationName.newProjectLocationCollectionDataStoreConversationBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setConversation(conversation).build().toString();
    }

    public static ConversationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_CONVERSATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_CONVERSATION.match(formattedString);
            return ConversationName.ofProjectLocationDataStoreConversationName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("conversation"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_CONVERSATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_CONVERSATION.match(formattedString);
            return ConversationName.ofProjectLocationCollectionDataStoreConversationName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("conversation"));
        }
        throw new ValidationException("ConversationName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ConversationName> parseList(List<String> formattedStrings) {
        ArrayList<ConversationName> list = new ArrayList<ConversationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_CONVERSATION.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_CONVERSATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversationName conversationName = this;
            synchronized (conversationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversationName that = (ConversationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.conversation, that.conversation) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversation);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationCollectionDataStoreConversationBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String conversation;

        protected ProjectLocationCollectionDataStoreConversationBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getConversation() {
            return this.conversation;
        }

        public ProjectLocationCollectionDataStoreConversationBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreConversationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreConversationBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreConversationBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreConversationBuilder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public ConversationName build() {
            return new ConversationName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String conversation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getConversation() {
            return this.conversation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        private Builder(ConversationName conversationName) {
            Preconditions.checkArgument((boolean)Objects.equals(conversationName.pathTemplate, PROJECT_LOCATION_DATA_STORE_CONVERSATION), (Object)"toBuilder is only supported when ConversationName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/conversations/{conversation}");
            this.project = conversationName.project;
            this.location = conversationName.location;
            this.dataStore = conversationName.dataStore;
            this.conversation = conversationName.conversation;
        }

        public ConversationName build() {
            return new ConversationName(this);
        }
    }
}

