/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BranchName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_BRANCH = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String branch;
    private final String collection;

    @Deprecated
    protected BranchName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.branch = null;
        this.collection = null;
    }

    private BranchName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.branch = (String)Preconditions.checkNotNull((Object)builder.getBranch());
        this.collection = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_BRANCH;
    }

    private BranchName(ProjectLocationCollectionDataStoreBranchBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.branch = (String)Preconditions.checkNotNull((Object)builder.getBranch());
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationDataStoreBranchBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationCollectionDataStoreBranchBuilder newProjectLocationCollectionDataStoreBranchBuilder() {
        return new ProjectLocationCollectionDataStoreBranchBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BranchName of(String project, String location, String dataStore, String branch) {
        return BranchName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static BranchName ofProjectLocationDataStoreBranchName(String project, String location, String dataStore, String branch) {
        return BranchName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static BranchName ofProjectLocationCollectionDataStoreBranchName(String project, String location, String collection, String dataStore, String branch) {
        return BranchName.newProjectLocationCollectionDataStoreBranchBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setBranch(branch).build();
    }

    public static String format(String project, String location, String dataStore, String branch) {
        return BranchName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationDataStoreBranchName(String project, String location, String dataStore, String branch) {
        return BranchName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationCollectionDataStoreBranchName(String project, String location, String collection, String dataStore, String branch) {
        return BranchName.newProjectLocationCollectionDataStoreBranchBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setBranch(branch).build().toString();
    }

    public static BranchName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_BRANCH.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_BRANCH.match(formattedString);
            return BranchName.ofProjectLocationDataStoreBranchName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("branch"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH.match(formattedString);
            return BranchName.ofProjectLocationCollectionDataStoreBranchName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("branch"));
        }
        throw new ValidationException("BranchName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<BranchName> parseList(List<String> formattedStrings) {
        ArrayList<BranchName> list = new ArrayList<BranchName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BranchName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BranchName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BranchName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_BRANCH.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BranchName branchName = this;
            synchronized (branchName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.branch != null) {
                        fieldMapBuilder.put((Object)"branch", (Object)this.branch);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BranchName that = (BranchName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.branch, that.branch) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.branch);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationCollectionDataStoreBranchBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String branch;

        protected ProjectLocationCollectionDataStoreBranchBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getBranch() {
            return this.branch;
        }

        public ProjectLocationCollectionDataStoreBranchBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchBuilder setBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public BranchName build() {
            return new BranchName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String branch;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getBranch() {
            return this.branch;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setBranch(String branch) {
            this.branch = branch;
            return this;
        }

        private Builder(BranchName branchName) {
            Preconditions.checkArgument((boolean)Objects.equals(branchName.pathTemplate, PROJECT_LOCATION_DATA_STORE_BRANCH), (Object)"toBuilder is only supported when BranchName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}");
            this.project = branchName.project;
            this.location = branchName.location;
            this.dataStore = branchName.dataStore;
            this.branch = branchName.branch;
        }

        public BranchName build() {
            return new BranchName(this);
        }
    }
}

