/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PhoneNumberName
implements ResourceName {
    private static final PathTemplate PROJECT_PHONE_NUMBER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/phoneNumbers/{phone_number}");
    private static final PathTemplate PROJECT_LOCATION_PHONE_NUMBER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/phoneNumbers/{phone_number}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String phoneNumber;
    private final String location;

    @Deprecated
    protected PhoneNumberName() {
        this.project = null;
        this.phoneNumber = null;
        this.location = null;
    }

    private PhoneNumberName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.phoneNumber = (String)Preconditions.checkNotNull((Object)builder.getPhoneNumber());
        this.location = null;
        this.pathTemplate = PROJECT_PHONE_NUMBER;
    }

    private PhoneNumberName(ProjectLocationPhoneNumberBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.phoneNumber = (String)Preconditions.checkNotNull((Object)builder.getPhoneNumber());
        this.pathTemplate = PROJECT_LOCATION_PHONE_NUMBER;
    }

    public String getProject() {
        return this.project;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectPhoneNumberBuilder() {
        return new Builder();
    }

    public static ProjectLocationPhoneNumberBuilder newProjectLocationPhoneNumberBuilder() {
        return new ProjectLocationPhoneNumberBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PhoneNumberName of(String project, String phoneNumber) {
        return PhoneNumberName.newBuilder().setProject(project).setPhoneNumber(phoneNumber).build();
    }

    public static PhoneNumberName ofProjectPhoneNumberName(String project, String phoneNumber) {
        return PhoneNumberName.newBuilder().setProject(project).setPhoneNumber(phoneNumber).build();
    }

    public static PhoneNumberName ofProjectLocationPhoneNumberName(String project, String location, String phoneNumber) {
        return PhoneNumberName.newProjectLocationPhoneNumberBuilder().setProject(project).setLocation(location).setPhoneNumber(phoneNumber).build();
    }

    public static String format(String project, String phoneNumber) {
        return PhoneNumberName.newBuilder().setProject(project).setPhoneNumber(phoneNumber).build().toString();
    }

    public static String formatProjectPhoneNumberName(String project, String phoneNumber) {
        return PhoneNumberName.newBuilder().setProject(project).setPhoneNumber(phoneNumber).build().toString();
    }

    public static String formatProjectLocationPhoneNumberName(String project, String location, String phoneNumber) {
        return PhoneNumberName.newProjectLocationPhoneNumberBuilder().setProject(project).setLocation(location).setPhoneNumber(phoneNumber).build().toString();
    }

    public static PhoneNumberName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_PHONE_NUMBER.matches(formattedString)) {
            Map matchMap = PROJECT_PHONE_NUMBER.match(formattedString);
            return PhoneNumberName.ofProjectPhoneNumberName((String)matchMap.get("project"), (String)matchMap.get("phone_number"));
        }
        if (PROJECT_LOCATION_PHONE_NUMBER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_PHONE_NUMBER.match(formattedString);
            return PhoneNumberName.ofProjectLocationPhoneNumberName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("phone_number"));
        }
        throw new ValidationException("PhoneNumberName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<PhoneNumberName> parseList(List<String> formattedStrings) {
        ArrayList<PhoneNumberName> list = new ArrayList<PhoneNumberName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PhoneNumberName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PhoneNumberName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PhoneNumberName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_PHONE_NUMBER.matches(formattedString) || PROJECT_LOCATION_PHONE_NUMBER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PhoneNumberName phoneNumberName = this;
            synchronized (phoneNumberName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.phoneNumber != null) {
                        fieldMapBuilder.put((Object)"phone_number", (Object)this.phoneNumber);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PhoneNumberName that = (PhoneNumberName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.phoneNumber, that.phoneNumber) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.phoneNumber);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationPhoneNumberBuilder {
        private String project;
        private String location;
        private String phoneNumber;

        protected ProjectLocationPhoneNumberBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public ProjectLocationPhoneNumberBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationPhoneNumberBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationPhoneNumberBuilder setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public PhoneNumberName build() {
            return new PhoneNumberName(this);
        }
    }

    public static class Builder {
        private String project;
        private String phoneNumber;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        private Builder(PhoneNumberName phoneNumberName) {
            Preconditions.checkArgument((boolean)Objects.equals(phoneNumberName.pathTemplate, PROJECT_PHONE_NUMBER), (Object)"toBuilder is only supported when PhoneNumberName has the pattern of projects/{project}/phoneNumbers/{phone_number}");
            this.project = phoneNumberName.project;
            this.phoneNumber = phoneNumberName.phoneNumber;
        }

        public PhoneNumberName build() {
            return new PhoneNumberName(this);
        }
    }
}

