/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnvironmentSessionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String environment;
    private final String user;
    private final String session;

    public String getProject() {
        return this.project;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getUser() {
        return this.user;
    }

    public String getSession() {
        return this.session;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private EnvironmentSessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
    }

    public static EnvironmentSessionName of(String project, String environment, String user, String session) {
        return EnvironmentSessionName.newBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).build();
    }

    public static String format(String project, String environment, String user, String session) {
        return EnvironmentSessionName.newBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).build().toString();
    }

    public static EnvironmentSessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "EnvironmentSessionName.parse: formattedString not in valid format");
        return EnvironmentSessionName.of((String)matchMap.get("project"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"));
    }

    public static List<EnvironmentSessionName> parseList(List<String> formattedStrings) {
        ArrayList<EnvironmentSessionName> list = new ArrayList<EnvironmentSessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EnvironmentSessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EnvironmentSessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EnvironmentSessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EnvironmentSessionName environmentSessionName = this;
            synchronized (environmentSessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    fieldMapBuilder.put((Object)"user", (Object)this.user);
                    fieldMapBuilder.put((Object)"session", (Object)this.session);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "environment", this.environment, "user", this.user, "session", this.session});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EnvironmentSessionName) {
            EnvironmentSessionName that = (EnvironmentSessionName)o;
            return this.project.equals(that.project) && this.environment.equals(that.environment) && this.user.equals(that.user) && this.session.equals(that.session);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.environment.hashCode();
        h *= 1000003;
        h ^= this.user.hashCode();
        h *= 1000003;
        return h ^= this.session.hashCode();
    }

    public static class Builder {
        private String project;
        private String environment;
        private String user;
        private String session;

        public String getProject() {
            return this.project;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        private Builder() {
        }

        private Builder(EnvironmentSessionName environmentSessionName) {
            this.project = environmentSessionName.project;
            this.environment = environmentSessionName.environment;
            this.user = environmentSessionName.user;
            this.session = environmentSessionName.session;
        }

        public EnvironmentSessionName build() {
            return new EnvironmentSessionName(this);
        }
    }
}

