/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntityTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_ENTITY_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/entityTypes/{entity_type}");
    private static final PathTemplate PROJECT_LOCATION_ENTITY_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/entityTypes/{entity_type}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String entityType;
    private final String location;

    @Deprecated
    protected EntityTypeName() {
        this.project = null;
        this.entityType = null;
        this.location = null;
    }

    private EntityTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
        this.location = null;
        this.pathTemplate = PROJECT_ENTITY_TYPE;
    }

    private EntityTypeName(ProjectLocationEntityTypeBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
        this.pathTemplate = PROJECT_LOCATION_ENTITY_TYPE;
    }

    public String getProject() {
        return this.project;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectEntityTypeBuilder() {
        return new Builder();
    }

    public static ProjectLocationEntityTypeBuilder newProjectLocationEntityTypeBuilder() {
        return new ProjectLocationEntityTypeBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntityTypeName of(String project, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setEntityType(entityType).build();
    }

    public static EntityTypeName ofProjectEntityTypeName(String project, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setEntityType(entityType).build();
    }

    public static EntityTypeName ofProjectLocationEntityTypeName(String project, String location, String entityType) {
        return EntityTypeName.newProjectLocationEntityTypeBuilder().setProject(project).setLocation(location).setEntityType(entityType).build();
    }

    public static String format(String project, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setEntityType(entityType).build().toString();
    }

    public static String formatProjectEntityTypeName(String project, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setEntityType(entityType).build().toString();
    }

    public static String formatProjectLocationEntityTypeName(String project, String location, String entityType) {
        return EntityTypeName.newProjectLocationEntityTypeBuilder().setProject(project).setLocation(location).setEntityType(entityType).build().toString();
    }

    public static EntityTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_ENTITY_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_ENTITY_TYPE.match(formattedString);
            return EntityTypeName.ofProjectEntityTypeName((String)matchMap.get("project"), (String)matchMap.get("entity_type"));
        }
        if (PROJECT_LOCATION_ENTITY_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ENTITY_TYPE.match(formattedString);
            return EntityTypeName.ofProjectLocationEntityTypeName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entity_type"));
        }
        throw new ValidationException("EntityTypeName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<EntityTypeName> parseList(List<String> formattedStrings) {
        ArrayList<EntityTypeName> list = new ArrayList<EntityTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntityTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntityTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntityTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ENTITY_TYPE.matches(formattedString) || PROJECT_LOCATION_ENTITY_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntityTypeName entityTypeName = this;
            synchronized (entityTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.entityType != null) {
                        fieldMapBuilder.put((Object)"entity_type", (Object)this.entityType);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntityTypeName that = (EntityTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.entityType, that.entityType) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.entityType);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationEntityTypeBuilder {
        private String project;
        private String location;
        private String entityType;

        protected ProjectLocationEntityTypeBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public ProjectLocationEntityTypeBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationEntityTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationEntityTypeBuilder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public EntityTypeName build() {
            return new EntityTypeName(this);
        }
    }

    public static class Builder {
        private String project;
        private String entityType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        private Builder(EntityTypeName entityTypeName) {
            Preconditions.checkArgument((boolean)Objects.equals(entityTypeName.pathTemplate, PROJECT_ENTITY_TYPE), (Object)"toBuilder is only supported when EntityTypeName has the pattern of projects/{project}/agent/entityTypes/{entity_type}");
            this.project = entityTypeName.project;
            this.entityType = entityTypeName.entityType;
        }

        public EntityTypeName build() {
            return new EntityTypeName(this);
        }
    }
}

