/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MessageName
implements ResourceName {
    private static final PathTemplate PROJECT_CONVERSATION_MESSAGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/conversations/{conversation}/messages/{message}");
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_MESSAGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversations/{conversation}/messages/{message}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String conversation;
    private final String message;
    private final String location;

    @Deprecated
    protected MessageName() {
        this.project = null;
        this.conversation = null;
        this.message = null;
        this.location = null;
    }

    private MessageName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.message = (String)Preconditions.checkNotNull((Object)builder.getMessage());
        this.location = null;
        this.pathTemplate = PROJECT_CONVERSATION_MESSAGE;
    }

    private MessageName(ProjectLocationConversationMessageBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.message = (String)Preconditions.checkNotNull((Object)builder.getMessage());
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION_MESSAGE;
    }

    public String getProject() {
        return this.project;
    }

    public String getConversation() {
        return this.conversation;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectConversationMessageBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationConversationMessageBuilder newProjectLocationConversationMessageBuilder() {
        return new ProjectLocationConversationMessageBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MessageName of(String project, String conversation, String message) {
        return MessageName.newBuilder().setProject(project).setConversation(conversation).setMessage(message).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static MessageName ofProjectConversationMessageName(String project, String conversation, String message) {
        return MessageName.newBuilder().setProject(project).setConversation(conversation).setMessage(message).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static MessageName ofProjectLocationConversationMessageName(String project, String location, String conversation, String message) {
        return MessageName.newProjectLocationConversationMessageBuilder().setProject(project).setLocation(location).setConversation(conversation).setMessage(message).build();
    }

    public static String format(String project, String conversation, String message) {
        return MessageName.newBuilder().setProject(project).setConversation(conversation).setMessage(message).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectConversationMessageName(String project, String conversation, String message) {
        return MessageName.newBuilder().setProject(project).setConversation(conversation).setMessage(message).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationConversationMessageName(String project, String location, String conversation, String message) {
        return MessageName.newProjectLocationConversationMessageBuilder().setProject(project).setLocation(location).setConversation(conversation).setMessage(message).build().toString();
    }

    public static MessageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CONVERSATION_MESSAGE.matches(formattedString)) {
            Map matchMap = PROJECT_CONVERSATION_MESSAGE.match(formattedString);
            return MessageName.ofProjectConversationMessageName((String)matchMap.get("project"), (String)matchMap.get("conversation"), (String)matchMap.get("message"));
        }
        if (PROJECT_LOCATION_CONVERSATION_MESSAGE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION_MESSAGE.match(formattedString);
            return MessageName.ofProjectLocationConversationMessageName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation"), (String)matchMap.get("message"));
        }
        throw new ValidationException("MessageName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<MessageName> parseList(List<String> formattedStrings) {
        ArrayList<MessageName> list = new ArrayList<MessageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MessageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MessageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MessageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CONVERSATION_MESSAGE.matches(formattedString) || PROJECT_LOCATION_CONVERSATION_MESSAGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MessageName messageName = this;
            synchronized (messageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    if (this.message != null) {
                        fieldMapBuilder.put((Object)"message", (Object)this.message);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MessageName that = (MessageName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.conversation, that.conversation) && Objects.equals(this.message, that.message) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversation);
        h *= 1000003;
        h ^= Objects.hashCode(this.message);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationConversationMessageBuilder {
        private String project;
        private String location;
        private String conversation;
        private String message;

        protected ProjectLocationConversationMessageBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getMessage() {
            return this.message;
        }

        public ProjectLocationConversationMessageBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationConversationMessageBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationConversationMessageBuilder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public ProjectLocationConversationMessageBuilder setMessage(String message) {
            this.message = message;
            return this;
        }

        public MessageName build() {
            return new MessageName(this);
        }
    }

    public static class Builder {
        private String project;
        private String conversation;
        private String message;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getMessage() {
            return this.message;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        private Builder(MessageName messageName) {
            Preconditions.checkArgument((boolean)Objects.equals(messageName.pathTemplate, PROJECT_CONVERSATION_MESSAGE), (Object)"toBuilder is only supported when MessageName has the pattern of projects/{project}/conversations/{conversation}/messages/{message}");
            this.project = messageName.project;
            this.conversation = messageName.conversation;
            this.message = messageName.message;
        }

        public MessageName build() {
            return new MessageName(this);
        }
    }
}

