/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ParticipantName
implements ResourceName {
    private static final PathTemplate PROJECT_CONVERSATION_PARTICIPANT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/conversations/{conversation}/participants/{participant}");
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_PARTICIPANT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String conversation;
    private final String participant;
    private final String location;

    @Deprecated
    protected ParticipantName() {
        this.project = null;
        this.conversation = null;
        this.participant = null;
        this.location = null;
    }

    private ParticipantName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.participant = (String)Preconditions.checkNotNull((Object)builder.getParticipant());
        this.location = null;
        this.pathTemplate = PROJECT_CONVERSATION_PARTICIPANT;
    }

    private ParticipantName(ProjectLocationConversationParticipantBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.participant = (String)Preconditions.checkNotNull((Object)builder.getParticipant());
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION_PARTICIPANT;
    }

    public String getProject() {
        return this.project;
    }

    public String getConversation() {
        return this.conversation;
    }

    public String getParticipant() {
        return this.participant;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectConversationParticipantBuilder() {
        return new Builder();
    }

    public static ProjectLocationConversationParticipantBuilder newProjectLocationConversationParticipantBuilder() {
        return new ProjectLocationConversationParticipantBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ParticipantName of(String project, String conversation, String participant) {
        return ParticipantName.newBuilder().setProject(project).setConversation(conversation).setParticipant(participant).build();
    }

    public static ParticipantName ofProjectConversationParticipantName(String project, String conversation, String participant) {
        return ParticipantName.newBuilder().setProject(project).setConversation(conversation).setParticipant(participant).build();
    }

    public static ParticipantName ofProjectLocationConversationParticipantName(String project, String location, String conversation, String participant) {
        return ParticipantName.newProjectLocationConversationParticipantBuilder().setProject(project).setLocation(location).setConversation(conversation).setParticipant(participant).build();
    }

    public static String format(String project, String conversation, String participant) {
        return ParticipantName.newBuilder().setProject(project).setConversation(conversation).setParticipant(participant).build().toString();
    }

    public static String formatProjectConversationParticipantName(String project, String conversation, String participant) {
        return ParticipantName.newBuilder().setProject(project).setConversation(conversation).setParticipant(participant).build().toString();
    }

    public static String formatProjectLocationConversationParticipantName(String project, String location, String conversation, String participant) {
        return ParticipantName.newProjectLocationConversationParticipantBuilder().setProject(project).setLocation(location).setConversation(conversation).setParticipant(participant).build().toString();
    }

    public static ParticipantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CONVERSATION_PARTICIPANT.matches(formattedString)) {
            Map matchMap = PROJECT_CONVERSATION_PARTICIPANT.match(formattedString);
            return ParticipantName.ofProjectConversationParticipantName((String)matchMap.get("project"), (String)matchMap.get("conversation"), (String)matchMap.get("participant"));
        }
        if (PROJECT_LOCATION_CONVERSATION_PARTICIPANT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION_PARTICIPANT.match(formattedString);
            return ParticipantName.ofProjectLocationConversationParticipantName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation"), (String)matchMap.get("participant"));
        }
        throw new ValidationException("ParticipantName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ParticipantName> parseList(List<String> formattedStrings) {
        ArrayList<ParticipantName> list = new ArrayList<ParticipantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ParticipantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ParticipantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ParticipantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CONVERSATION_PARTICIPANT.matches(formattedString) || PROJECT_LOCATION_CONVERSATION_PARTICIPANT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ParticipantName participantName = this;
            synchronized (participantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    if (this.participant != null) {
                        fieldMapBuilder.put((Object)"participant", (Object)this.participant);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ParticipantName that = (ParticipantName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.conversation, that.conversation) && Objects.equals(this.participant, that.participant) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversation);
        h *= 1000003;
        h ^= Objects.hashCode(this.participant);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationConversationParticipantBuilder {
        private String project;
        private String location;
        private String conversation;
        private String participant;

        protected ProjectLocationConversationParticipantBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getParticipant() {
            return this.participant;
        }

        public ProjectLocationConversationParticipantBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationConversationParticipantBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationConversationParticipantBuilder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public ProjectLocationConversationParticipantBuilder setParticipant(String participant) {
            this.participant = participant;
            return this;
        }

        public ParticipantName build() {
            return new ParticipantName(this);
        }
    }

    public static class Builder {
        private String project;
        private String conversation;
        private String participant;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getParticipant() {
            return this.participant;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public Builder setParticipant(String participant) {
            this.participant = participant;
            return this;
        }

        private Builder(ParticipantName participantName) {
            Preconditions.checkArgument((boolean)Objects.equals(participantName.pathTemplate, PROJECT_CONVERSATION_PARTICIPANT), (Object)"toBuilder is only supported when ParticipantName has the pattern of projects/{project}/conversations/{conversation}/participants/{participant}");
            this.project = participantName.project;
            this.conversation = participantName.conversation;
            this.participant = participantName.participant;
        }

        public ParticipantName build() {
            return new ParticipantName(this);
        }
    }
}

