/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ToolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_TOOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/tools/{tool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String tool;

    @Deprecated
    protected ToolName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.tool = null;
    }

    private ToolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.tool = (String)Preconditions.checkNotNull((Object)builder.getTool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getTool() {
        return this.tool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ToolName of(String project, String location, String agent, String tool) {
        return ToolName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setTool(tool).build();
    }

    public static String format(String project, String location, String agent, String tool) {
        return ToolName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setTool(tool).build().toString();
    }

    public static ToolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_TOOL.validatedMatch(formattedString, "ToolName.parse: formattedString not in valid format");
        return ToolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("tool"));
    }

    public static List<ToolName> parseList(List<String> formattedStrings) {
        ArrayList<ToolName> list = new ArrayList<ToolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ToolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ToolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ToolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_TOOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ToolName toolName = this;
            synchronized (toolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.tool != null) {
                        fieldMapBuilder.put((Object)"tool", (Object)this.tool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_TOOL.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "tool", this.tool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ToolName that = (ToolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.tool, that.tool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String tool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getTool() {
            return this.tool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setTool(String tool) {
            this.tool = tool;
            return this;
        }

        private Builder(ToolName toolName) {
            this.project = toolName.project;
            this.location = toolName.location;
            this.agent = toolName.agent;
            this.tool = toolName.tool;
        }

        public ToolName build() {
            return new ToolName(this);
        }
    }
}

