/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/webhook.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Represents session information communicated to and from the webhook.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.SessionInfo}
 */
public final class SessionInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.SessionInfo)
    SessionInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SessionInfo.newBuilder() to construct.
  private SessionInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SessionInfo() {
    session_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SessionInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_SessionInfo_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetParameters();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_SessionInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.SessionInfo.class,
            com.google.cloud.dialogflow.cx.v3beta1.SessionInfo.Builder.class);
  }

  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * Always present for
   * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
   * Ignored for
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
   * unique identifier of the
   * [session][google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.session].
   * This field can be used by the webhook to identify a session. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
   * or
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`
   * if environment is specified.
   * </pre>
   *
   * <code>string session = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Always present for
   * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
   * Ignored for
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
   * unique identifier of the
   * [session][google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.session].
   * This field can be used by the webhook to identify a session. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
   * or
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`
   * if environment is specified.
   * </pre>
   *
   * <code>string session = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 2;

  private static final class ParametersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
                        .internal_static_google_cloud_dialogflow_cx_v3beta1_SessionInfo_ParametersEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value> parameters_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetParameters() {
    if (parameters_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParametersDefaultEntryHolder.defaultEntry);
    }
    return parameters_;
  }

  public int getParametersCount() {
    return internalGetParameters().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional for
   * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
   * Optional for
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
   * parameters collected from forms and intents during the session. Parameters
   * can be created, updated, or removed by the webhook. To remove a parameter
   * from the session, the webhook should explicitly set the parameter value to
   * null in
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
   * map is keyed by parameters' display names.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
   */
  @java.lang.Override
  public boolean containsParameters(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParameters().getMap().containsKey(key);
  }
  /** Use {@link #getParametersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameters() {
    return getParametersMap();
  }
  /**
   *
   *
   * <pre>
   * Optional for
   * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
   * Optional for
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
   * parameters collected from forms and intents during the session. Parameters
   * can be created, updated, or removed by the webhook. To remove a parameter
   * from the session, the webhook should explicitly set the parameter value to
   * null in
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
   * map is keyed by parameters' display names.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getParametersMap() {
    return internalGetParameters().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional for
   * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
   * Optional for
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
   * parameters collected from forms and intents during the session. Parameters
   * can be created, updated, or removed by the webhook. To remove a parameter
   * from the session, the webhook should explicitly set the parameter value to
   * null in
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
   * map is keyed by parameters' display names.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Value getParametersOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetParameters().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional for
   * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
   * Optional for
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
   * parameters collected from forms and intents during the session. Parameters
   * can be created, updated, or removed by the webhook. To remove a parameter
   * from the session, the webhook should explicitly set the parameter value to
   * null in
   * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
   * map is keyed by parameters' display names.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getParametersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetParameters().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParameters(), ParametersDefaultEntryHolder.defaultEntry, 2);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetParameters().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> parameters__ =
          ParametersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parameters__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.SessionInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.SessionInfo other =
        (com.google.cloud.dialogflow.cx.v3beta1.SessionInfo) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (!internalGetParameters().equals(other.internalGetParameters())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (!internalGetParameters().getMap().isEmpty()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParameters().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.SessionInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents session information communicated to and from the webhook.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.SessionInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.SessionInfo)
      com.google.cloud.dialogflow.cx.v3beta1.SessionInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_SessionInfo_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_SessionInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.SessionInfo.class,
              com.google.cloud.dialogflow.cx.v3beta1.SessionInfo.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.SessionInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      internalGetMutableParameters().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_SessionInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.SessionInfo getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.SessionInfo build() {
      com.google.cloud.dialogflow.cx.v3beta1.SessionInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.SessionInfo buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.SessionInfo result =
          new com.google.cloud.dialogflow.cx.v3beta1.SessionInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.SessionInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parameters_ =
            internalGetParameters().build(ParametersDefaultEntryHolder.defaultEntry);
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.SessionInfo) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.SessionInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.SessionInfo other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.SessionInfo.getDefaultInstance())
        return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableParameters().mergeFrom(other.internalGetParameters());
      bitField0_ |= 0x00000002;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                    parameters__ =
                        input.readMessage(
                            ParametersDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableParameters()
                    .ensureBuilderMap()
                    .put(parameters__.getKey(), parameters__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Always present for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Ignored for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * unique identifier of the
     * [session][google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.session].
     * This field can be used by the webhook to identify a session. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`
     * if environment is specified.
     * </pre>
     *
     * <code>string session = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Ignored for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * unique identifier of the
     * [session][google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.session].
     * This field can be used by the webhook to identify a session. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`
     * if environment is specified.
     * </pre>
     *
     * <code>string session = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Ignored for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * unique identifier of the
     * [session][google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.session].
     * This field can be used by the webhook to identify a session. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`
     * if environment is specified.
     * </pre>
     *
     * <code>string session = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Ignored for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * unique identifier of the
     * [session][google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.session].
     * This field can be used by the webhook to identify a session. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`
     * if environment is specified.
     * </pre>
     *
     * <code>string session = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Ignored for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * unique identifier of the
     * [session][google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.session].
     * This field can be used by the webhook to identify a session. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`
     * if environment is specified.
     * </pre>
     *
     * <code>string session = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private static final class ParametersConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String, com.google.protobuf.ValueOrBuilder, com.google.protobuf.Value> {
      @java.lang.Override
      public com.google.protobuf.Value build(com.google.protobuf.ValueOrBuilder val) {
        if (val instanceof com.google.protobuf.Value) {
          return (com.google.protobuf.Value) val;
        }
        return ((com.google.protobuf.Value.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry() {
        return ParametersDefaultEntryHolder.defaultEntry;
      }
    };

    private static final ParametersConverter parametersConverter = new ParametersConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        parameters_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetParameters() {
      if (parameters_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(parametersConverter);
      }
      return parameters_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetMutableParameters() {
      if (parameters_ == null) {
        parameters_ = new com.google.protobuf.MapFieldBuilder<>(parametersConverter);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return parameters_;
    }

    public int getParametersCount() {
      return internalGetParameters().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Optional for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
     * parameters collected from forms and intents during the session. Parameters
     * can be created, updated, or removed by the webhook. To remove a parameter
     * from the session, the webhook should explicitly set the parameter value to
     * null in
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * map is keyed by parameters' display names.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
     */
    @java.lang.Override
    public boolean containsParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameters().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getParametersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameters() {
      return getParametersMap();
    }
    /**
     *
     *
     * <pre>
     * Optional for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Optional for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
     * parameters collected from forms and intents during the session. Parameters
     * can be created, updated, or removed by the webhook. To remove a parameter
     * from the session, the webhook should explicitly set the parameter value to
     * null in
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * map is keyed by parameters' display names.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParametersMap() {
      return internalGetParameters().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Optional for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
     * parameters collected from forms and intents during the session. Parameters
     * can be created, updated, or removed by the webhook. To remove a parameter
     * from the session, the webhook should explicitly set the parameter value to
     * null in
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * map is keyed by parameters' display names.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getParametersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableParameters().ensureBuilderMap();
      return map.containsKey(key) ? parametersConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Optional for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
     * parameters collected from forms and intents during the session. Parameters
     * can be created, updated, or removed by the webhook. To remove a parameter
     * from the session, the webhook should explicitly set the parameter value to
     * null in
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * map is keyed by parameters' display names.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getParametersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableParameters().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return parametersConverter.build(map.get(key));
    }

    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableParameters().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Optional for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
     * parameters collected from forms and intents during the session. Parameters
     * can be created, updated, or removed by the webhook. To remove a parameter
     * from the session, the webhook should explicitly set the parameter value to
     * null in
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * map is keyed by parameters' display names.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
     */
    public Builder removeParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableParameters().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMutableParameters() {
      bitField0_ |= 0x00000002;
      return internalGetMutableParameters().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Optional for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Optional for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
     * parameters collected from forms and intents during the session. Parameters
     * can be created, updated, or removed by the webhook. To remove a parameter
     * from the session, the webhook should explicitly set the parameter value to
     * null in
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * map is keyed by parameters' display names.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
     */
    public Builder putParameters(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableParameters().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Optional for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
     * parameters collected from forms and intents during the session. Parameters
     * can be created, updated, or removed by the webhook. To remove a parameter
     * from the session, the webhook should explicitly set the parameter value to
     * null in
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * map is keyed by parameters' display names.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
     */
    public Builder putAllParameters(
        java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableParameters().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional for
     * [WebhookRequest][google.cloud.dialogflow.cx.v3beta1.WebhookRequest].
     * Optional for
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. All
     * parameters collected from forms and intents during the session. Parameters
     * can be created, updated, or removed by the webhook. To remove a parameter
     * from the session, the webhook should explicitly set the parameter value to
     * null in
     * [WebhookResponse][google.cloud.dialogflow.cx.v3beta1.WebhookResponse]. The
     * map is keyed by parameters' display names.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameters = 2;</code>
     */
    public com.google.protobuf.Value.Builder putParametersBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> builderMap =
          internalGetMutableParameters().ensureBuilderMap();
      com.google.protobuf.ValueOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.protobuf.Value.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.protobuf.Value) {
        entry = ((com.google.protobuf.Value) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.protobuf.Value.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.SessionInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.SessionInfo)
  private static final com.google.cloud.dialogflow.cx.v3beta1.SessionInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.SessionInfo();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SessionInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SessionInfo> PARSER =
      new com.google.protobuf.AbstractParser<SessionInfo>() {
        @java.lang.Override
        public SessionInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SessionInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SessionInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.SessionInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
