/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/playbook.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

public interface PlaybookOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Playbook)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The unique identifier of the playbook.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The unique identifier of the playbook.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the playbook, unique within an agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the playbook, unique within an agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Required. High level description of the goal the playbook intend to
   * accomplish. A goal should be concise since it's visible to other playbooks
   * that may reference this playbook.
   * </pre>
   *
   * <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The goal.
   */
  java.lang.String getGoal();
  /**
   *
   *
   * <pre>
   * Required. High level description of the goal the playbook intend to
   * accomplish. A goal should be concise since it's visible to other playbooks
   * that may reference this playbook.
   * </pre>
   *
   * <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for goal.
   */
  com.google.protobuf.ByteString getGoalBytes();

  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
      getInputParameterDefinitionsList();
  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition getInputParameterDefinitions(
      int index);
  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getInputParameterDefinitionsCount();
  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
      getInputParameterDefinitionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder
      getInputParameterDefinitionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
      getOutputParameterDefinitionsList();
  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition getOutputParameterDefinitions(
      int index);
  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getOutputParameterDefinitionsCount();
  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
      getOutputParameterDefinitionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder
      getOutputParameterDefinitionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Instruction to accomplish target goal.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
   *
   * @return Whether the instruction field is set.
   */
  boolean hasInstruction();
  /**
   *
   *
   * <pre>
   * Instruction to accomplish target goal.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
   *
   * @return The instruction.
   */
  com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction getInstruction();
  /**
   *
   *
   * <pre>
   * Instruction to accomplish target goal.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.Playbook.InstructionOrBuilder getInstructionOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Estimated number of tokes current playbook takes when sent to
   * the LLM.
   * </pre>
   *
   * <code>int64 token_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tokenCount.
   */
  long getTokenCount();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of initial playbook creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of initial playbook creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of initial playbook creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Last time the playbook version was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Last time the playbook version was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Last time the playbook version was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of other playbooks referenced by the current
   * playbook in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencedPlaybooks.
   */
  java.util.List<java.lang.String> getReferencedPlaybooksList();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of other playbooks referenced by the current
   * playbook in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencedPlaybooks.
   */
  int getReferencedPlaybooksCount();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of other playbooks referenced by the current
   * playbook in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencedPlaybooks at the given index.
   */
  java.lang.String getReferencedPlaybooks(int index);
  /**
   *
   *
   * <pre>
   * Output only. The resource name of other playbooks referenced by the current
   * playbook in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencedPlaybooks at the given index.
   */
  com.google.protobuf.ByteString getReferencedPlaybooksBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The resource name of flows referenced by the current playbook
   * in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencedFlows.
   */
  java.util.List<java.lang.String> getReferencedFlowsList();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of flows referenced by the current playbook
   * in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencedFlows.
   */
  int getReferencedFlowsCount();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of flows referenced by the current playbook
   * in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencedFlows at the given index.
   */
  java.lang.String getReferencedFlows(int index);
  /**
   *
   *
   * <pre>
   * Output only. The resource name of flows referenced by the current playbook
   * in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencedFlows at the given index.
   */
  com.google.protobuf.ByteString getReferencedFlowsBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. The resource name of tools referenced by the current playbook in
   * the instructions. If not provided explicitly, they are will
   * be implied using the tool being referenced in goal and steps.
   * </pre>
   *
   * <code>
   * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencedTools.
   */
  java.util.List<java.lang.String> getReferencedToolsList();
  /**
   *
   *
   * <pre>
   * Optional. The resource name of tools referenced by the current playbook in
   * the instructions. If not provided explicitly, they are will
   * be implied using the tool being referenced in goal and steps.
   * </pre>
   *
   * <code>
   * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencedTools.
   */
  int getReferencedToolsCount();
  /**
   *
   *
   * <pre>
   * Optional. The resource name of tools referenced by the current playbook in
   * the instructions. If not provided explicitly, they are will
   * be implied using the tool being referenced in goal and steps.
   * </pre>
   *
   * <code>
   * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencedTools at the given index.
   */
  java.lang.String getReferencedTools(int index);
  /**
   *
   *
   * <pre>
   * Optional. The resource name of tools referenced by the current playbook in
   * the instructions. If not provided explicitly, they are will
   * be implied using the tool being referenced in goal and steps.
   * </pre>
   *
   * <code>
   * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencedTools at the given index.
   */
  com.google.protobuf.ByteString getReferencedToolsBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. Llm model settings for the playbook.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the llmModelSettings field is set.
   */
  boolean hasLlmModelSettings();
  /**
   *
   *
   * <pre>
   * Optional. Llm model settings for the playbook.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The llmModelSettings.
   */
  com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings getLlmModelSettings();
  /**
   *
   *
   * <pre>
   * Optional. Llm model settings for the playbook.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder getLlmModelSettingsOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Playbook level Settings for speech to text detection.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the speechSettings field is set.
   */
  boolean hasSpeechSettings();
  /**
   *
   *
   * <pre>
   * Optional. Playbook level Settings for speech to text detection.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The speechSettings.
   */
  com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings getSpeechSettings();
  /**
   *
   *
   * <pre>
   * Optional. Playbook level Settings for speech to text detection.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder
      getSpeechSettingsOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Handler> getHandlersList();
  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.Handler getHandlers(int index);
  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getHandlersCount();
  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder>
      getHandlersOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder getHandlersOrBuilder(int index);
}
