/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/example.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Stores metadata of the invocation of a child playbook.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation}
 */
public final class PlaybookInvocation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation)
    PlaybookInvocationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PlaybookInvocation.newBuilder() to construct.
  private PlaybookInvocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PlaybookInvocation() {
    playbook_ = "";
    displayName_ = "";
    playbookState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PlaybookInvocation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_PlaybookInvocation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_PlaybookInvocation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.class,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.Builder.class);
  }

  private int bitField0_;
  public static final int PLAYBOOK_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object playbook_ = "";
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the playbook.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
   * </pre>
   *
   * <code>
   * string playbook = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The playbook.
   */
  @java.lang.Override
  public java.lang.String getPlaybook() {
    java.lang.Object ref = playbook_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      playbook_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the playbook.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
   * </pre>
   *
   * <code>
   * string playbook = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for playbook.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlaybookBytes() {
    java.lang.Object ref = playbook_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      playbook_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The display name of the playbook.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The display name of the playbook.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PLAYBOOK_INPUT_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbookInput_;
  /**
   *
   *
   * <pre>
   * Optional. Input of the child playbook invocation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the playbookInput field is set.
   */
  @java.lang.Override
  public boolean hasPlaybookInput() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Input of the child playbook invocation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The playbookInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput getPlaybookInput() {
    return playbookInput_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()
        : playbookInput_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Input of the child playbook invocation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder getPlaybookInputOrBuilder() {
    return playbookInput_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()
        : playbookInput_;
  }

  public static final int PLAYBOOK_OUTPUT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbookOutput_;
  /**
   *
   *
   * <pre>
   * Optional. Output of the child playbook invocation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the playbookOutput field is set.
   */
  @java.lang.Override
  public boolean hasPlaybookOutput() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Output of the child playbook invocation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The playbookOutput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput getPlaybookOutput() {
    return playbookOutput_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()
        : playbookOutput_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Output of the child playbook invocation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder
      getPlaybookOutputOrBuilder() {
    return playbookOutput_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()
        : playbookOutput_;
  }

  public static final int PLAYBOOK_STATE_FIELD_NUMBER = 4;
  private int playbookState_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Playbook invocation's output state.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.OutputState playbook_state = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for playbookState.
   */
  @java.lang.Override
  public int getPlaybookStateValue() {
    return playbookState_;
  }
  /**
   *
   *
   * <pre>
   * Required. Playbook invocation's output state.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.OutputState playbook_state = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The playbookState.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.OutputState getPlaybookState() {
    com.google.cloud.dialogflow.cx.v3beta1.OutputState result =
        com.google.cloud.dialogflow.cx.v3beta1.OutputState.forNumber(playbookState_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.OutputState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(playbook_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, playbook_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getPlaybookInput());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getPlaybookOutput());
    }
    if (playbookState_
        != com.google.cloud.dialogflow.cx.v3beta1.OutputState.OUTPUT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, playbookState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(playbook_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, playbook_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPlaybookInput());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPlaybookOutput());
    }
    if (playbookState_
        != com.google.cloud.dialogflow.cx.v3beta1.OutputState.OUTPUT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, playbookState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation other =
        (com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) obj;

    if (!getPlaybook().equals(other.getPlaybook())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasPlaybookInput() != other.hasPlaybookInput()) return false;
    if (hasPlaybookInput()) {
      if (!getPlaybookInput().equals(other.getPlaybookInput())) return false;
    }
    if (hasPlaybookOutput() != other.hasPlaybookOutput()) return false;
    if (hasPlaybookOutput()) {
      if (!getPlaybookOutput().equals(other.getPlaybookOutput())) return false;
    }
    if (playbookState_ != other.playbookState_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PLAYBOOK_FIELD_NUMBER;
    hash = (53 * hash) + getPlaybook().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasPlaybookInput()) {
      hash = (37 * hash) + PLAYBOOK_INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getPlaybookInput().hashCode();
    }
    if (hasPlaybookOutput()) {
      hash = (37 * hash) + PLAYBOOK_OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + getPlaybookOutput().hashCode();
    }
    hash = (37 * hash) + PLAYBOOK_STATE_FIELD_NUMBER;
    hash = (53 * hash) + playbookState_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Stores metadata of the invocation of a child playbook.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation)
      com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_PlaybookInvocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_PlaybookInvocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.class,
              com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPlaybookInputFieldBuilder();
        getPlaybookOutputFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      playbook_ = "";
      displayName_ = "";
      playbookInput_ = null;
      if (playbookInputBuilder_ != null) {
        playbookInputBuilder_.dispose();
        playbookInputBuilder_ = null;
      }
      playbookOutput_ = null;
      if (playbookOutputBuilder_ != null) {
        playbookOutputBuilder_.dispose();
        playbookOutputBuilder_ = null;
      }
      playbookState_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_PlaybookInvocation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation build() {
      com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation result =
          new com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.playbook_ = playbook_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.playbookInput_ =
            playbookInputBuilder_ == null ? playbookInput_ : playbookInputBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.playbookOutput_ =
            playbookOutputBuilder_ == null ? playbookOutput_ : playbookOutputBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.playbookState_ = playbookState_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.getDefaultInstance())
        return this;
      if (!other.getPlaybook().isEmpty()) {
        playbook_ = other.playbook_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPlaybookInput()) {
        mergePlaybookInput(other.getPlaybookInput());
      }
      if (other.hasPlaybookOutput()) {
        mergePlaybookOutput(other.getPlaybookOutput());
      }
      if (other.playbookState_ != 0) {
        setPlaybookStateValue(other.getPlaybookStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                playbook_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPlaybookInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPlaybookOutputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 32:
              {
                playbookState_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object playbook_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>
     * string playbook = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The playbook.
     */
    public java.lang.String getPlaybook() {
      java.lang.Object ref = playbook_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        playbook_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>
     * string playbook = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for playbook.
     */
    public com.google.protobuf.ByteString getPlaybookBytes() {
      java.lang.Object ref = playbook_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        playbook_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>
     * string playbook = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The playbook to set.
     * @return This builder for chaining.
     */
    public Builder setPlaybook(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      playbook_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>
     * string playbook = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaybook() {
      playbook_ = getDefaultInstance().getPlaybook();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>
     * string playbook = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for playbook to set.
     * @return This builder for chaining.
     */
    public Builder setPlaybookBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      playbook_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The display name of the playbook.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the playbook.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the playbook.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the playbook.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the playbook.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbookInput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder>
        playbookInputBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Input of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the playbookInput field is set.
     */
    public boolean hasPlaybookInput() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Input of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The playbookInput.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput getPlaybookInput() {
      if (playbookInputBuilder_ == null) {
        return playbookInput_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()
            : playbookInput_;
      } else {
        return playbookInputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookInput(com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput value) {
      if (playbookInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        playbookInput_ = value;
      } else {
        playbookInputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookInput(
        com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder builderForValue) {
      if (playbookInputBuilder_ == null) {
        playbookInput_ = builderForValue.build();
      } else {
        playbookInputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePlaybookInput(com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput value) {
      if (playbookInputBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && playbookInput_ != null
            && playbookInput_
                != com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()) {
          getPlaybookInputBuilder().mergeFrom(value);
        } else {
          playbookInput_ = value;
        }
      } else {
        playbookInputBuilder_.mergeFrom(value);
      }
      if (playbookInput_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPlaybookInput() {
      bitField0_ = (bitField0_ & ~0x00000004);
      playbookInput_ = null;
      if (playbookInputBuilder_ != null) {
        playbookInputBuilder_.dispose();
        playbookInputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder getPlaybookInputBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPlaybookInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder
        getPlaybookInputOrBuilder() {
      if (playbookInputBuilder_ != null) {
        return playbookInputBuilder_.getMessageOrBuilder();
      } else {
        return playbookInput_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()
            : playbookInput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Input of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder>
        getPlaybookInputFieldBuilder() {
      if (playbookInputBuilder_ == null) {
        playbookInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder>(
                getPlaybookInput(), getParentForChildren(), isClean());
        playbookInput_ = null;
      }
      return playbookInputBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbookOutput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder>
        playbookOutputBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Output of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the playbookOutput field is set.
     */
    public boolean hasPlaybookOutput() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Output of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The playbookOutput.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput getPlaybookOutput() {
      if (playbookOutputBuilder_ == null) {
        return playbookOutput_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()
            : playbookOutput_;
      } else {
        return playbookOutputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookOutput(com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput value) {
      if (playbookOutputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        playbookOutput_ = value;
      } else {
        playbookOutputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookOutput(
        com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder builderForValue) {
      if (playbookOutputBuilder_ == null) {
        playbookOutput_ = builderForValue.build();
      } else {
        playbookOutputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePlaybookOutput(
        com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput value) {
      if (playbookOutputBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && playbookOutput_ != null
            && playbookOutput_
                != com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()) {
          getPlaybookOutputBuilder().mergeFrom(value);
        } else {
          playbookOutput_ = value;
        }
      } else {
        playbookOutputBuilder_.mergeFrom(value);
      }
      if (playbookOutput_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPlaybookOutput() {
      bitField0_ = (bitField0_ & ~0x00000008);
      playbookOutput_ = null;
      if (playbookOutputBuilder_ != null) {
        playbookOutputBuilder_.dispose();
        playbookOutputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder
        getPlaybookOutputBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPlaybookOutputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Output of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder
        getPlaybookOutputOrBuilder() {
      if (playbookOutputBuilder_ != null) {
        return playbookOutputBuilder_.getMessageOrBuilder();
      } else {
        return playbookOutput_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()
            : playbookOutput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output of the child playbook invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder>
        getPlaybookOutputFieldBuilder() {
      if (playbookOutputBuilder_ == null) {
        playbookOutputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder>(
                getPlaybookOutput(), getParentForChildren(), isClean());
        playbookOutput_ = null;
      }
      return playbookOutputBuilder_;
    }

    private int playbookState_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Playbook invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState playbook_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for playbookState.
     */
    @java.lang.Override
    public int getPlaybookStateValue() {
      return playbookState_;
    }
    /**
     *
     *
     * <pre>
     * Required. Playbook invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState playbook_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for playbookState to set.
     * @return This builder for chaining.
     */
    public Builder setPlaybookStateValue(int value) {
      playbookState_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Playbook invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState playbook_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The playbookState.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.OutputState getPlaybookState() {
      com.google.cloud.dialogflow.cx.v3beta1.OutputState result =
          com.google.cloud.dialogflow.cx.v3beta1.OutputState.forNumber(playbookState_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.OutputState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Playbook invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState playbook_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The playbookState to set.
     * @return This builder for chaining.
     */
    public Builder setPlaybookState(com.google.cloud.dialogflow.cx.v3beta1.OutputState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      playbookState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Playbook invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState playbook_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaybookState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      playbookState_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation)
  private static final com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PlaybookInvocation> PARSER =
      new com.google.protobuf.AbstractParser<PlaybookInvocation>() {
        @java.lang.Override
        public PlaybookInvocation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PlaybookInvocation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PlaybookInvocation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
