/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/page.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * The Knowledge Connector settings for this page or flow.
 * This includes information such as the attached Knowledge Bases, and the way
 * to execute fulfillment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings}
 */
public final class KnowledgeConnectorSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings)
    KnowledgeConnectorSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KnowledgeConnectorSettings.newBuilder() to construct.
  private KnowledgeConnectorSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KnowledgeConnectorSettings() {
    dataStoreConnections_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KnowledgeConnectorSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_KnowledgeConnectorSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_KnowledgeConnectorSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.class,
            com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.Builder.class);
  }

  private int bitField0_;
  private int targetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object target_;

  public enum TargetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TARGET_PAGE(4),
    TARGET_FLOW(5),
    TARGET_NOT_SET(0);
    private final int value;

    private TargetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetCase forNumber(int value) {
      switch (value) {
        case 4:
          return TARGET_PAGE;
        case 5:
          return TARGET_FLOW;
        case 0:
          return TARGET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetCase getTargetCase() {
    return TargetCase.forNumber(targetCase_);
  }

  public static final int ENABLED_FIELD_NUMBER = 1;
  private boolean enabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether Knowledge Connector is enabled or not.
   * </pre>
   *
   * <code>bool enabled = 1;</code>
   *
   * @return The enabled.
   */
  @java.lang.Override
  public boolean getEnabled() {
    return enabled_;
  }

  public static final int TRIGGER_FULFILLMENT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3beta1.Fulfillment triggerFulfillment_;
  /**
   *
   *
   * <pre>
   * The fulfillment to be triggered.
   *
   * When the answers from the Knowledge Connector are selected by Dialogflow,
   * you can utitlize the request scoped parameter `$request.knowledge.answers`
   * (contains up to the 5 highest confidence answers) and
   * `$request.knowledge.questions` (contains the corresponding questions) to
   * construct the fulfillment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
   *
   * @return Whether the triggerFulfillment field is set.
   */
  @java.lang.Override
  public boolean hasTriggerFulfillment() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The fulfillment to be triggered.
   *
   * When the answers from the Knowledge Connector are selected by Dialogflow,
   * you can utitlize the request scoped parameter `$request.knowledge.answers`
   * (contains up to the 5 highest confidence answers) and
   * `$request.knowledge.questions` (contains the corresponding questions) to
   * construct the fulfillment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
   *
   * @return The triggerFulfillment.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getTriggerFulfillment() {
    return triggerFulfillment_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
        : triggerFulfillment_;
  }
  /**
   *
   *
   * <pre>
   * The fulfillment to be triggered.
   *
   * When the answers from the Knowledge Connector are selected by Dialogflow,
   * you can utitlize the request scoped parameter `$request.knowledge.answers`
   * (contains up to the 5 highest confidence answers) and
   * `$request.knowledge.questions` (contains the corresponding questions) to
   * construct the fulfillment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder
      getTriggerFulfillmentOrBuilder() {
    return triggerFulfillment_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
        : triggerFulfillment_;
  }

  public static final int TARGET_PAGE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The target page to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
   * </pre>
   *
   * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the targetPage field is set.
   */
  public boolean hasTargetPage() {
    return targetCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The target page to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
   * </pre>
   *
   * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The targetPage.
   */
  public java.lang.String getTargetPage() {
    java.lang.Object ref = "";
    if (targetCase_ == 4) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (targetCase_ == 4) {
        target_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The target page to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
   * </pre>
   *
   * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for targetPage.
   */
  public com.google.protobuf.ByteString getTargetPageBytes() {
    java.lang.Object ref = "";
    if (targetCase_ == 4) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (targetCase_ == 4) {
        target_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_FLOW_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The target flow to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the targetFlow field is set.
   */
  public boolean hasTargetFlow() {
    return targetCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The target flow to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The targetFlow.
   */
  public java.lang.String getTargetFlow() {
    java.lang.Object ref = "";
    if (targetCase_ == 5) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (targetCase_ == 5) {
        target_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The target flow to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for targetFlow.
   */
  public com.google.protobuf.ByteString getTargetFlowBytes() {
    java.lang.Object ref = "";
    if (targetCase_ == 5) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (targetCase_ == 5) {
        target_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_STORE_CONNECTIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
      dataStoreConnections_;
  /**
   *
   *
   * <pre>
   * Optional. List of related data store connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
      getDataStoreConnectionsList() {
    return dataStoreConnections_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of related data store connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>
      getDataStoreConnectionsOrBuilderList() {
    return dataStoreConnections_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of related data store connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getDataStoreConnectionsCount() {
    return dataStoreConnections_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of related data store connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection getDataStoreConnections(
      int index) {
    return dataStoreConnections_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of related data store connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder
      getDataStoreConnectionsOrBuilder(int index) {
    return dataStoreConnections_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (enabled_ != false) {
      output.writeBool(1, enabled_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getTriggerFulfillment());
    }
    if (targetCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, target_);
    }
    if (targetCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, target_);
    }
    for (int i = 0; i < dataStoreConnections_.size(); i++) {
      output.writeMessage(6, dataStoreConnections_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (enabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTriggerFulfillment());
    }
    if (targetCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, target_);
    }
    if (targetCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, target_);
    }
    for (int i = 0; i < dataStoreConnections_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, dataStoreConnections_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings other =
        (com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings) obj;

    if (getEnabled() != other.getEnabled()) return false;
    if (hasTriggerFulfillment() != other.hasTriggerFulfillment()) return false;
    if (hasTriggerFulfillment()) {
      if (!getTriggerFulfillment().equals(other.getTriggerFulfillment())) return false;
    }
    if (!getDataStoreConnectionsList().equals(other.getDataStoreConnectionsList())) return false;
    if (!getTargetCase().equals(other.getTargetCase())) return false;
    switch (targetCase_) {
      case 4:
        if (!getTargetPage().equals(other.getTargetPage())) return false;
        break;
      case 5:
        if (!getTargetFlow().equals(other.getTargetFlow())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
    if (hasTriggerFulfillment()) {
      hash = (37 * hash) + TRIGGER_FULFILLMENT_FIELD_NUMBER;
      hash = (53 * hash) + getTriggerFulfillment().hashCode();
    }
    if (getDataStoreConnectionsCount() > 0) {
      hash = (37 * hash) + DATA_STORE_CONNECTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDataStoreConnectionsList().hashCode();
    }
    switch (targetCase_) {
      case 4:
        hash = (37 * hash) + TARGET_PAGE_FIELD_NUMBER;
        hash = (53 * hash) + getTargetPage().hashCode();
        break;
      case 5:
        hash = (37 * hash) + TARGET_FLOW_FIELD_NUMBER;
        hash = (53 * hash) + getTargetFlow().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The Knowledge Connector settings for this page or flow.
   * This includes information such as the attached Knowledge Bases, and the way
   * to execute fulfillment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings)
      com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_KnowledgeConnectorSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_KnowledgeConnectorSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.Builder.class);
    }

    // Construct using
    // com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTriggerFulfillmentFieldBuilder();
        getDataStoreConnectionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enabled_ = false;
      triggerFulfillment_ = null;
      if (triggerFulfillmentBuilder_ != null) {
        triggerFulfillmentBuilder_.dispose();
        triggerFulfillmentBuilder_ = null;
      }
      if (dataStoreConnectionsBuilder_ == null) {
        dataStoreConnections_ = java.util.Collections.emptyList();
      } else {
        dataStoreConnections_ = null;
        dataStoreConnectionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      targetCase_ = 0;
      target_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_KnowledgeConnectorSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings build() {
      com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings result =
          new com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings result) {
      if (dataStoreConnectionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          dataStoreConnections_ = java.util.Collections.unmodifiableList(dataStoreConnections_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.dataStoreConnections_ = dataStoreConnections_;
      } else {
        result.dataStoreConnections_ = dataStoreConnectionsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enabled_ = enabled_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.triggerFulfillment_ =
            triggerFulfillmentBuilder_ == null
                ? triggerFulfillment_
                : triggerFulfillmentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings result) {
      result.targetCase_ = targetCase_;
      result.target_ = this.target_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings other) {
      if (other
          == com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.getDefaultInstance())
        return this;
      if (other.getEnabled() != false) {
        setEnabled(other.getEnabled());
      }
      if (other.hasTriggerFulfillment()) {
        mergeTriggerFulfillment(other.getTriggerFulfillment());
      }
      if (dataStoreConnectionsBuilder_ == null) {
        if (!other.dataStoreConnections_.isEmpty()) {
          if (dataStoreConnections_.isEmpty()) {
            dataStoreConnections_ = other.dataStoreConnections_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureDataStoreConnectionsIsMutable();
            dataStoreConnections_.addAll(other.dataStoreConnections_);
          }
          onChanged();
        }
      } else {
        if (!other.dataStoreConnections_.isEmpty()) {
          if (dataStoreConnectionsBuilder_.isEmpty()) {
            dataStoreConnectionsBuilder_.dispose();
            dataStoreConnectionsBuilder_ = null;
            dataStoreConnections_ = other.dataStoreConnections_;
            bitField0_ = (bitField0_ & ~0x00000010);
            dataStoreConnectionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataStoreConnectionsFieldBuilder()
                    : null;
          } else {
            dataStoreConnectionsBuilder_.addAllMessages(other.dataStoreConnections_);
          }
        }
      }
      switch (other.getTargetCase()) {
        case TARGET_PAGE:
          {
            targetCase_ = 4;
            target_ = other.target_;
            onChanged();
            break;
          }
        case TARGET_FLOW:
          {
            targetCase_ = 5;
            target_ = other.target_;
            onChanged();
            break;
          }
        case TARGET_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                enabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 26:
              {
                input.readMessage(
                    getTriggerFulfillmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                targetCase_ = 4;
                target_ = s;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                targetCase_ = 5;
                target_ = s;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.parser(),
                        extensionRegistry);
                if (dataStoreConnectionsBuilder_ == null) {
                  ensureDataStoreConnectionsIsMutable();
                  dataStoreConnections_.add(m);
                } else {
                  dataStoreConnectionsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int targetCase_ = 0;
    private java.lang.Object target_;

    public TargetCase getTargetCase() {
      return TargetCase.forNumber(targetCase_);
    }

    public Builder clearTarget() {
      targetCase_ = 0;
      target_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private boolean enabled_;
    /**
     *
     *
     * <pre>
     * Whether Knowledge Connector is enabled or not.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether Knowledge Connector is enabled or not.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @param value The enabled to set.
     * @return This builder for chaining.
     */
    public Builder setEnabled(boolean value) {

      enabled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether Knowledge Connector is enabled or not.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnabled() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enabled_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.Fulfillment triggerFulfillment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
            com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>
        triggerFulfillmentBuilder_;
    /**
     *
     *
     * <pre>
     * The fulfillment to be triggered.
     *
     * When the answers from the Knowledge Connector are selected by Dialogflow,
     * you can utitlize the request scoped parameter `$request.knowledge.answers`
     * (contains up to the 5 highest confidence answers) and
     * `$request.knowledge.questions` (contains the corresponding questions) to
     * construct the fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
     *
     * @return Whether the triggerFulfillment field is set.
     */
    public boolean hasTriggerFulfillment() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to be triggered.
     *
     * When the answers from the Knowledge Connector are selected by Dialogflow,
     * you can utitlize the request scoped parameter `$request.knowledge.answers`
     * (contains up to the 5 highest confidence answers) and
     * `$request.knowledge.questions` (contains the corresponding questions) to
     * construct the fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
     *
     * @return The triggerFulfillment.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getTriggerFulfillment() {
      if (triggerFulfillmentBuilder_ == null) {
        return triggerFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
            : triggerFulfillment_;
      } else {
        return triggerFulfillmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to be triggered.
     *
     * When the answers from the Knowledge Connector are selected by Dialogflow,
     * you can utitlize the request scoped parameter `$request.knowledge.answers`
     * (contains up to the 5 highest confidence answers) and
     * `$request.knowledge.questions` (contains the corresponding questions) to
     * construct the fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
     */
    public Builder setTriggerFulfillment(com.google.cloud.dialogflow.cx.v3beta1.Fulfillment value) {
      if (triggerFulfillmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        triggerFulfillment_ = value;
      } else {
        triggerFulfillmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to be triggered.
     *
     * When the answers from the Knowledge Connector are selected by Dialogflow,
     * you can utitlize the request scoped parameter `$request.knowledge.answers`
     * (contains up to the 5 highest confidence answers) and
     * `$request.knowledge.questions` (contains the corresponding questions) to
     * construct the fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
     */
    public Builder setTriggerFulfillment(
        com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder builderForValue) {
      if (triggerFulfillmentBuilder_ == null) {
        triggerFulfillment_ = builderForValue.build();
      } else {
        triggerFulfillmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to be triggered.
     *
     * When the answers from the Knowledge Connector are selected by Dialogflow,
     * you can utitlize the request scoped parameter `$request.knowledge.answers`
     * (contains up to the 5 highest confidence answers) and
     * `$request.knowledge.questions` (contains the corresponding questions) to
     * construct the fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
     */
    public Builder mergeTriggerFulfillment(
        com.google.cloud.dialogflow.cx.v3beta1.Fulfillment value) {
      if (triggerFulfillmentBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && triggerFulfillment_ != null
            && triggerFulfillment_
                != com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()) {
          getTriggerFulfillmentBuilder().mergeFrom(value);
        } else {
          triggerFulfillment_ = value;
        }
      } else {
        triggerFulfillmentBuilder_.mergeFrom(value);
      }
      if (triggerFulfillment_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to be triggered.
     *
     * When the answers from the Knowledge Connector are selected by Dialogflow,
     * you can utitlize the request scoped parameter `$request.knowledge.answers`
     * (contains up to the 5 highest confidence answers) and
     * `$request.knowledge.questions` (contains the corresponding questions) to
     * construct the fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
     */
    public Builder clearTriggerFulfillment() {
      bitField0_ = (bitField0_ & ~0x00000002);
      triggerFulfillment_ = null;
      if (triggerFulfillmentBuilder_ != null) {
        triggerFulfillmentBuilder_.dispose();
        triggerFulfillmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to be triggered.
     *
     * When the answers from the Knowledge Connector are selected by Dialogflow,
     * you can utitlize the request scoped parameter `$request.knowledge.answers`
     * (contains up to the 5 highest confidence answers) and
     * `$request.knowledge.questions` (contains the corresponding questions) to
     * construct the fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder
        getTriggerFulfillmentBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTriggerFulfillmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to be triggered.
     *
     * When the answers from the Knowledge Connector are selected by Dialogflow,
     * you can utitlize the request scoped parameter `$request.knowledge.answers`
     * (contains up to the 5 highest confidence answers) and
     * `$request.knowledge.questions` (contains the corresponding questions) to
     * construct the fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder
        getTriggerFulfillmentOrBuilder() {
      if (triggerFulfillmentBuilder_ != null) {
        return triggerFulfillmentBuilder_.getMessageOrBuilder();
      } else {
        return triggerFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
            : triggerFulfillment_;
      }
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to be triggered.
     *
     * When the answers from the Knowledge Connector are selected by Dialogflow,
     * you can utitlize the request scoped parameter `$request.knowledge.answers`
     * (contains up to the 5 highest confidence answers) and
     * `$request.knowledge.questions` (contains the corresponding questions) to
     * construct the fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Fulfillment trigger_fulfillment = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
            com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>
        getTriggerFulfillmentFieldBuilder() {
      if (triggerFulfillmentBuilder_ == null) {
        triggerFulfillmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
                com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>(
                getTriggerFulfillment(), getParentForChildren(), isClean());
        triggerFulfillment_ = null;
      }
      return triggerFulfillmentBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the targetPage field is set.
     */
    @java.lang.Override
    public boolean hasTargetPage() {
      return targetCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The targetPage.
     */
    @java.lang.Override
    public java.lang.String getTargetPage() {
      java.lang.Object ref = "";
      if (targetCase_ == 4) {
        ref = target_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetCase_ == 4) {
          target_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for targetPage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetPageBytes() {
      java.lang.Object ref = "";
      if (targetCase_ == 4) {
        ref = target_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetCase_ == 4) {
          target_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The targetPage to set.
     * @return This builder for chaining.
     */
    public Builder setTargetPage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetCase_ = 4;
      target_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetPage() {
      if (targetCase_ == 4) {
        targetCase_ = 0;
        target_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for targetPage to set.
     * @return This builder for chaining.
     */
    public Builder setTargetPageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetCase_ = 4;
      target_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the targetFlow field is set.
     */
    @java.lang.Override
    public boolean hasTargetFlow() {
      return targetCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The targetFlow.
     */
    @java.lang.Override
    public java.lang.String getTargetFlow() {
      java.lang.Object ref = "";
      if (targetCase_ == 5) {
        ref = target_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetCase_ == 5) {
          target_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for targetFlow.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetFlowBytes() {
      java.lang.Object ref = "";
      if (targetCase_ == 5) {
        ref = target_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetCase_ == 5) {
          target_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The targetFlow to set.
     * @return This builder for chaining.
     */
    public Builder setTargetFlow(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetCase_ = 5;
      target_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetFlow() {
      if (targetCase_ == 5) {
        targetCase_ = 0;
        target_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for targetFlow to set.
     * @return This builder for chaining.
     */
    public Builder setTargetFlowBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetCase_ = 5;
      target_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
        dataStoreConnections_ = java.util.Collections.emptyList();

    private void ensureDataStoreConnectionsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        dataStoreConnections_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>(
                dataStoreConnections_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection,
            com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>
        dataStoreConnectionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
        getDataStoreConnectionsList() {
      if (dataStoreConnectionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dataStoreConnections_);
      } else {
        return dataStoreConnectionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getDataStoreConnectionsCount() {
      if (dataStoreConnectionsBuilder_ == null) {
        return dataStoreConnections_.size();
      } else {
        return dataStoreConnectionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection getDataStoreConnections(
        int index) {
      if (dataStoreConnectionsBuilder_ == null) {
        return dataStoreConnections_.get(index);
      } else {
        return dataStoreConnectionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataStoreConnections(
        int index, com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection value) {
      if (dataStoreConnectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataStoreConnectionsIsMutable();
        dataStoreConnections_.set(index, value);
        onChanged();
      } else {
        dataStoreConnectionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataStoreConnections(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder builderForValue) {
      if (dataStoreConnectionsBuilder_ == null) {
        ensureDataStoreConnectionsIsMutable();
        dataStoreConnections_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataStoreConnectionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDataStoreConnections(
        com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection value) {
      if (dataStoreConnectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataStoreConnectionsIsMutable();
        dataStoreConnections_.add(value);
        onChanged();
      } else {
        dataStoreConnectionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDataStoreConnections(
        int index, com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection value) {
      if (dataStoreConnectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataStoreConnectionsIsMutable();
        dataStoreConnections_.add(index, value);
        onChanged();
      } else {
        dataStoreConnectionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDataStoreConnections(
        com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder builderForValue) {
      if (dataStoreConnectionsBuilder_ == null) {
        ensureDataStoreConnectionsIsMutable();
        dataStoreConnections_.add(builderForValue.build());
        onChanged();
      } else {
        dataStoreConnectionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDataStoreConnections(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder builderForValue) {
      if (dataStoreConnectionsBuilder_ == null) {
        ensureDataStoreConnectionsIsMutable();
        dataStoreConnections_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataStoreConnectionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllDataStoreConnections(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
            values) {
      if (dataStoreConnectionsBuilder_ == null) {
        ensureDataStoreConnectionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataStoreConnections_);
        onChanged();
      } else {
        dataStoreConnectionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDataStoreConnections() {
      if (dataStoreConnectionsBuilder_ == null) {
        dataStoreConnections_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        dataStoreConnectionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeDataStoreConnections(int index) {
      if (dataStoreConnectionsBuilder_ == null) {
        ensureDataStoreConnectionsIsMutable();
        dataStoreConnections_.remove(index);
        onChanged();
      } else {
        dataStoreConnectionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder
        getDataStoreConnectionsBuilder(int index) {
      return getDataStoreConnectionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder
        getDataStoreConnectionsOrBuilder(int index) {
      if (dataStoreConnectionsBuilder_ == null) {
        return dataStoreConnections_.get(index);
      } else {
        return dataStoreConnectionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>
        getDataStoreConnectionsOrBuilderList() {
      if (dataStoreConnectionsBuilder_ != null) {
        return dataStoreConnectionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dataStoreConnections_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder
        addDataStoreConnectionsBuilder() {
      return getDataStoreConnectionsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder
        addDataStoreConnectionsBuilder(int index) {
      return getDataStoreConnectionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of related data store connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder>
        getDataStoreConnectionsBuilderList() {
      return getDataStoreConnectionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection,
            com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>
        getDataStoreConnectionsFieldBuilder() {
      if (dataStoreConnectionsBuilder_ == null) {
        dataStoreConnectionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection,
                com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>(
                dataStoreConnections_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        dataStoreConnections_ = null;
      }
      return dataStoreConnectionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings)
  private static final com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KnowledgeConnectorSettings> PARSER =
      new com.google.protobuf.AbstractParser<KnowledgeConnectorSettings>() {
        @java.lang.Override
        public KnowledgeConnectorSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KnowledgeConnectorSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KnowledgeConnectorSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
