/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/entity_type.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * The request message for
 * [EntityTypes.ImportEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ImportEntityTypes].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest}
 */
public final class ImportEntityTypesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest)
    ImportEntityTypesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportEntityTypesRequest.newBuilder() to construct.
  private ImportEntityTypesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportEntityTypesRequest() {
    parent_ = "";
    mergeOption_ = 0;
    targetEntityType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportEntityTypesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.EntityTypeProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportEntityTypesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.EntityTypeProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportEntityTypesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.class,
            com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Merge option when display name conflicts exist during import.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption}
   */
  public enum MergeOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. If used, system uses REPORT_CONFLICT as default.
     * </pre>
     *
     * <code>MERGE_OPTION_UNSPECIFIED = 0;</code>
     */
    MERGE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Replace the original entity type in the agent with the new entity type
     * when display name conflicts exist.
     * </pre>
     *
     * <code>REPLACE = 1;</code>
     */
    REPLACE(1),
    /**
     *
     *
     * <pre>
     * Merge the original entity type with the new entity type when display name
     * conflicts exist.
     * </pre>
     *
     * <code>MERGE = 2;</code>
     */
    MERGE(2),
    /**
     *
     *
     * <pre>
     * Create new entity types with new display names to differentiate them from
     * the existing entity types when display name conflicts exist.
     * </pre>
     *
     * <code>RENAME = 3;</code>
     */
    RENAME(3),
    /**
     *
     *
     * <pre>
     * Report conflict information if display names conflict is detected.
     * Otherwise, import entity types.
     * </pre>
     *
     * <code>REPORT_CONFLICT = 4;</code>
     */
    REPORT_CONFLICT(4),
    /**
     *
     *
     * <pre>
     * Keep the original entity type and discard the conflicting new entity type
     * when display name conflicts exist.
     * </pre>
     *
     * <code>KEEP = 5;</code>
     */
    KEEP(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. If used, system uses REPORT_CONFLICT as default.
     * </pre>
     *
     * <code>MERGE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int MERGE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Replace the original entity type in the agent with the new entity type
     * when display name conflicts exist.
     * </pre>
     *
     * <code>REPLACE = 1;</code>
     */
    public static final int REPLACE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Merge the original entity type with the new entity type when display name
     * conflicts exist.
     * </pre>
     *
     * <code>MERGE = 2;</code>
     */
    public static final int MERGE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Create new entity types with new display names to differentiate them from
     * the existing entity types when display name conflicts exist.
     * </pre>
     *
     * <code>RENAME = 3;</code>
     */
    public static final int RENAME_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Report conflict information if display names conflict is detected.
     * Otherwise, import entity types.
     * </pre>
     *
     * <code>REPORT_CONFLICT = 4;</code>
     */
    public static final int REPORT_CONFLICT_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Keep the original entity type and discard the conflicting new entity type
     * when display name conflicts exist.
     * </pre>
     *
     * <code>KEEP = 5;</code>
     */
    public static final int KEEP_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MergeOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MergeOption forNumber(int value) {
      switch (value) {
        case 0:
          return MERGE_OPTION_UNSPECIFIED;
        case 1:
          return REPLACE;
        case 2:
          return MERGE;
        case 3:
          return RENAME;
        case 4:
          return REPORT_CONFLICT;
        case 5:
          return KEEP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MergeOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MergeOption> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MergeOption>() {
          public MergeOption findValueByNumber(int number) {
            return MergeOption.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final MergeOption[] VALUES = values();

    public static MergeOption valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MergeOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption)
  }

  private int entityTypesCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object entityTypes_;

  public enum EntityTypesCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ENTITY_TYPES_URI(2),
    ENTITY_TYPES_CONTENT(3),
    ENTITYTYPES_NOT_SET(0);
    private final int value;

    private EntityTypesCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EntityTypesCase valueOf(int value) {
      return forNumber(value);
    }

    public static EntityTypesCase forNumber(int value) {
      switch (value) {
        case 2:
          return ENTITY_TYPES_URI;
        case 3:
          return ENTITY_TYPES_CONTENT;
        case 0:
          return ENTITYTYPES_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EntityTypesCase getEntityTypesCase() {
    return EntityTypesCase.forNumber(entityTypesCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The agent to import the entity types into.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The agent to import the entity types into.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_TYPES_URI_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import entity types from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string entity_types_uri = 2;</code>
   *
   * @return Whether the entityTypesUri field is set.
   */
  public boolean hasEntityTypesUri() {
    return entityTypesCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import entity types from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string entity_types_uri = 2;</code>
   *
   * @return The entityTypesUri.
   */
  public java.lang.String getEntityTypesUri() {
    java.lang.Object ref = "";
    if (entityTypesCase_ == 2) {
      ref = entityTypes_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (entityTypesCase_ == 2) {
        entityTypes_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import entity types from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string entity_types_uri = 2;</code>
   *
   * @return The bytes for entityTypesUri.
   */
  public com.google.protobuf.ByteString getEntityTypesUriBytes() {
    java.lang.Object ref = "";
    if (entityTypesCase_ == 2) {
      ref = entityTypes_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (entityTypesCase_ == 2) {
        entityTypes_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_TYPES_CONTENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Uncompressed byte content of entity types.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
   *
   * @return Whether the entityTypesContent field is set.
   */
  @java.lang.Override
  public boolean hasEntityTypesContent() {
    return entityTypesCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Uncompressed byte content of entity types.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
   *
   * @return The entityTypesContent.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.InlineSource getEntityTypesContent() {
    if (entityTypesCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) entityTypes_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Uncompressed byte content of entity types.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder
      getEntityTypesContentOrBuilder() {
    if (entityTypesCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) entityTypes_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
  }

  public static final int MERGE_OPTION_FIELD_NUMBER = 4;
  private int mergeOption_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Merge option for importing entity types.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption merge_option = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for mergeOption.
   */
  @java.lang.Override
  public int getMergeOptionValue() {
    return mergeOption_;
  }
  /**
   *
   *
   * <pre>
   * Required. Merge option for importing entity types.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption merge_option = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The mergeOption.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption
      getMergeOption() {
    com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption result =
        com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption.forNumber(
            mergeOption_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption.UNRECOGNIZED
        : result;
  }

  public static final int TARGET_ENTITY_TYPE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetEntityType_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The target entity type to import into.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entity_types/&lt;EntityTypeID&gt;`.
   *  If set, there should be only one entity type included in
   *  [entity_types][google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.entity_types],
   *  of which the type should match the type of the target entity type. All
   *  [entities][google.cloud.dialogflow.cx.v3beta1.EntityType.entities] in the
   *  imported entity type will be added to the target entity type.
   * </pre>
   *
   * <code>
   * string target_entity_type = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The targetEntityType.
   */
  @java.lang.Override
  public java.lang.String getTargetEntityType() {
    java.lang.Object ref = targetEntityType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetEntityType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The target entity type to import into.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entity_types/&lt;EntityTypeID&gt;`.
   *  If set, there should be only one entity type included in
   *  [entity_types][google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.entity_types],
   *  of which the type should match the type of the target entity type. All
   *  [entities][google.cloud.dialogflow.cx.v3beta1.EntityType.entities] in the
   *  imported entity type will be added to the target entity type.
   * </pre>
   *
   * <code>
   * string target_entity_type = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for targetEntityType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetEntityTypeBytes() {
    java.lang.Object ref = targetEntityType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetEntityType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (entityTypesCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, entityTypes_);
    }
    if (entityTypesCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) entityTypes_);
    }
    if (mergeOption_
        != com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption
            .MERGE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, mergeOption_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetEntityType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, targetEntityType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (entityTypesCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, entityTypes_);
    }
    if (entityTypesCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) entityTypes_);
    }
    if (mergeOption_
        != com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption
            .MERGE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, mergeOption_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetEntityType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, targetEntityType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest other =
        (com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (mergeOption_ != other.mergeOption_) return false;
    if (!getTargetEntityType().equals(other.getTargetEntityType())) return false;
    if (!getEntityTypesCase().equals(other.getEntityTypesCase())) return false;
    switch (entityTypesCase_) {
      case 2:
        if (!getEntityTypesUri().equals(other.getEntityTypesUri())) return false;
        break;
      case 3:
        if (!getEntityTypesContent().equals(other.getEntityTypesContent())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + MERGE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + mergeOption_;
    hash = (37 * hash) + TARGET_ENTITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getTargetEntityType().hashCode();
    switch (entityTypesCase_) {
      case 2:
        hash = (37 * hash) + ENTITY_TYPES_URI_FIELD_NUMBER;
        hash = (53 * hash) + getEntityTypesUri().hashCode();
        break;
      case 3:
        hash = (37 * hash) + ENTITY_TYPES_CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getEntityTypesContent().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [EntityTypes.ImportEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ImportEntityTypes].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest)
      com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.EntityTypeProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportEntityTypesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.EntityTypeProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportEntityTypesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.class,
              com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (entityTypesContentBuilder_ != null) {
        entityTypesContentBuilder_.clear();
      }
      mergeOption_ = 0;
      targetEntityType_ = "";
      entityTypesCase_ = 0;
      entityTypes_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.EntityTypeProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportEntityTypesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest build() {
      com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest result =
          new com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.mergeOption_ = mergeOption_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.targetEntityType_ = targetEntityType_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest result) {
      result.entityTypesCase_ = entityTypesCase_;
      result.entityTypes_ = this.entityTypes_;
      if (entityTypesCase_ == 3 && entityTypesContentBuilder_ != null) {
        result.entityTypes_ = entityTypesContentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest other) {
      if (other
          == com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.mergeOption_ != 0) {
        setMergeOptionValue(other.getMergeOptionValue());
      }
      if (!other.getTargetEntityType().isEmpty()) {
        targetEntityType_ = other.targetEntityType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getEntityTypesCase()) {
        case ENTITY_TYPES_URI:
          {
            entityTypesCase_ = 2;
            entityTypes_ = other.entityTypes_;
            onChanged();
            break;
          }
        case ENTITY_TYPES_CONTENT:
          {
            mergeEntityTypesContent(other.getEntityTypesContent());
            break;
          }
        case ENTITYTYPES_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                entityTypesCase_ = 2;
                entityTypes_ = s;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getEntityTypesContentFieldBuilder().getBuilder(), extensionRegistry);
                entityTypesCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                mergeOption_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                targetEntityType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int entityTypesCase_ = 0;
    private java.lang.Object entityTypes_;

    public EntityTypesCase getEntityTypesCase() {
      return EntityTypesCase.forNumber(entityTypesCase_);
    }

    public Builder clearEntityTypes() {
      entityTypesCase_ = 0;
      entityTypes_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The agent to import the entity types into.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the entity types into.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the entity types into.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the entity types into.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the entity types into.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import entity types from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string entity_types_uri = 2;</code>
     *
     * @return Whether the entityTypesUri field is set.
     */
    @java.lang.Override
    public boolean hasEntityTypesUri() {
      return entityTypesCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import entity types from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string entity_types_uri = 2;</code>
     *
     * @return The entityTypesUri.
     */
    @java.lang.Override
    public java.lang.String getEntityTypesUri() {
      java.lang.Object ref = "";
      if (entityTypesCase_ == 2) {
        ref = entityTypes_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (entityTypesCase_ == 2) {
          entityTypes_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import entity types from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string entity_types_uri = 2;</code>
     *
     * @return The bytes for entityTypesUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntityTypesUriBytes() {
      java.lang.Object ref = "";
      if (entityTypesCase_ == 2) {
        ref = entityTypes_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (entityTypesCase_ == 2) {
          entityTypes_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import entity types from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string entity_types_uri = 2;</code>
     *
     * @param value The entityTypesUri to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypesUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entityTypesCase_ = 2;
      entityTypes_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import entity types from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string entity_types_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityTypesUri() {
      if (entityTypesCase_ == 2) {
        entityTypesCase_ = 0;
        entityTypes_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import entity types from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string entity_types_uri = 2;</code>
     *
     * @param value The bytes for entityTypesUri to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypesUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entityTypesCase_ = 2;
      entityTypes_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.InlineSource,
            com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder>
        entityTypesContentBuilder_;
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of entity types.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
     *
     * @return Whether the entityTypesContent field is set.
     */
    @java.lang.Override
    public boolean hasEntityTypesContent() {
      return entityTypesCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of entity types.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
     *
     * @return The entityTypesContent.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.InlineSource getEntityTypesContent() {
      if (entityTypesContentBuilder_ == null) {
        if (entityTypesCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) entityTypes_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
      } else {
        if (entityTypesCase_ == 3) {
          return entityTypesContentBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of entity types.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
     */
    public Builder setEntityTypesContent(
        com.google.cloud.dialogflow.cx.v3beta1.InlineSource value) {
      if (entityTypesContentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityTypes_ = value;
        onChanged();
      } else {
        entityTypesContentBuilder_.setMessage(value);
      }
      entityTypesCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of entity types.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
     */
    public Builder setEntityTypesContent(
        com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder builderForValue) {
      if (entityTypesContentBuilder_ == null) {
        entityTypes_ = builderForValue.build();
        onChanged();
      } else {
        entityTypesContentBuilder_.setMessage(builderForValue.build());
      }
      entityTypesCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of entity types.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
     */
    public Builder mergeEntityTypesContent(
        com.google.cloud.dialogflow.cx.v3beta1.InlineSource value) {
      if (entityTypesContentBuilder_ == null) {
        if (entityTypesCase_ == 3
            && entityTypes_
                != com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance()) {
          entityTypes_ =
              com.google.cloud.dialogflow.cx.v3beta1.InlineSource.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) entityTypes_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityTypes_ = value;
        }
        onChanged();
      } else {
        if (entityTypesCase_ == 3) {
          entityTypesContentBuilder_.mergeFrom(value);
        } else {
          entityTypesContentBuilder_.setMessage(value);
        }
      }
      entityTypesCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of entity types.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
     */
    public Builder clearEntityTypesContent() {
      if (entityTypesContentBuilder_ == null) {
        if (entityTypesCase_ == 3) {
          entityTypesCase_ = 0;
          entityTypes_ = null;
          onChanged();
        }
      } else {
        if (entityTypesCase_ == 3) {
          entityTypesCase_ = 0;
          entityTypes_ = null;
        }
        entityTypesContentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of entity types.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder
        getEntityTypesContentBuilder() {
      return getEntityTypesContentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of entity types.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder
        getEntityTypesContentOrBuilder() {
      if ((entityTypesCase_ == 3) && (entityTypesContentBuilder_ != null)) {
        return entityTypesContentBuilder_.getMessageOrBuilder();
      } else {
        if (entityTypesCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) entityTypes_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of entity types.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource entity_types_content = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.InlineSource,
            com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder>
        getEntityTypesContentFieldBuilder() {
      if (entityTypesContentBuilder_ == null) {
        if (!(entityTypesCase_ == 3)) {
          entityTypes_ = com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
        }
        entityTypesContentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.InlineSource,
                com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) entityTypes_,
                getParentForChildren(),
                isClean());
        entityTypes_ = null;
      }
      entityTypesCase_ = 3;
      onChanged();
      return entityTypesContentBuilder_;
    }

    private int mergeOption_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Merge option for importing entity types.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption merge_option = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for mergeOption.
     */
    @java.lang.Override
    public int getMergeOptionValue() {
      return mergeOption_;
    }
    /**
     *
     *
     * <pre>
     * Required. Merge option for importing entity types.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption merge_option = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for mergeOption to set.
     * @return This builder for chaining.
     */
    public Builder setMergeOptionValue(int value) {
      mergeOption_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Merge option for importing entity types.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption merge_option = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The mergeOption.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption
        getMergeOption() {
      com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption result =
          com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption.forNumber(
              mergeOption_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Merge option for importing entity types.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption merge_option = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The mergeOption to set.
     * @return This builder for chaining.
     */
    public Builder setMergeOption(
        com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      mergeOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Merge option for importing entity types.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption merge_option = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMergeOption() {
      bitField0_ = (bitField0_ & ~0x00000008);
      mergeOption_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object targetEntityType_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The target entity type to import into.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entity_types/&lt;EntityTypeID&gt;`.
     *  If set, there should be only one entity type included in
     *  [entity_types][google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.entity_types],
     *  of which the type should match the type of the target entity type. All
     *  [entities][google.cloud.dialogflow.cx.v3beta1.EntityType.entities] in the
     *  imported entity type will be added to the target entity type.
     * </pre>
     *
     * <code>
     * string target_entity_type = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The targetEntityType.
     */
    public java.lang.String getTargetEntityType() {
      java.lang.Object ref = targetEntityType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetEntityType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The target entity type to import into.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entity_types/&lt;EntityTypeID&gt;`.
     *  If set, there should be only one entity type included in
     *  [entity_types][google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.entity_types],
     *  of which the type should match the type of the target entity type. All
     *  [entities][google.cloud.dialogflow.cx.v3beta1.EntityType.entities] in the
     *  imported entity type will be added to the target entity type.
     * </pre>
     *
     * <code>
     * string target_entity_type = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for targetEntityType.
     */
    public com.google.protobuf.ByteString getTargetEntityTypeBytes() {
      java.lang.Object ref = targetEntityType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetEntityType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The target entity type to import into.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entity_types/&lt;EntityTypeID&gt;`.
     *  If set, there should be only one entity type included in
     *  [entity_types][google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.entity_types],
     *  of which the type should match the type of the target entity type. All
     *  [entities][google.cloud.dialogflow.cx.v3beta1.EntityType.entities] in the
     *  imported entity type will be added to the target entity type.
     * </pre>
     *
     * <code>
     * string target_entity_type = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The targetEntityType to set.
     * @return This builder for chaining.
     */
    public Builder setTargetEntityType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetEntityType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The target entity type to import into.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entity_types/&lt;EntityTypeID&gt;`.
     *  If set, there should be only one entity type included in
     *  [entity_types][google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.entity_types],
     *  of which the type should match the type of the target entity type. All
     *  [entities][google.cloud.dialogflow.cx.v3beta1.EntityType.entities] in the
     *  imported entity type will be added to the target entity type.
     * </pre>
     *
     * <code>
     * string target_entity_type = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetEntityType() {
      targetEntityType_ = getDefaultInstance().getTargetEntityType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The target entity type to import into.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entity_types/&lt;EntityTypeID&gt;`.
     *  If set, there should be only one entity type included in
     *  [entity_types][google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.entity_types],
     *  of which the type should match the type of the target entity type. All
     *  [entities][google.cloud.dialogflow.cx.v3beta1.EntityType.entities] in the
     *  imported entity type will be added to the target entity type.
     * </pre>
     *
     * <code>
     * string target_entity_type = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for targetEntityType to set.
     * @return This builder for chaining.
     */
    public Builder setTargetEntityTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetEntityType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest)
  private static final com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportEntityTypesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportEntityTypesRequest>() {
        @java.lang.Override
        public ImportEntityTypesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportEntityTypesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportEntityTypesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
