/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/generator.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Generators contain prompt to be sent to the LLM model to generate text. The
 * prompt can contain parameters which will be resolved before calling the
 * model. It can optionally contain banned phrases to ensure the model responses
 * are safe.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Generator}
 */
public final class Generator extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Generator)
    GeneratorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Generator.newBuilder() to construct.
  private Generator(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Generator() {
    name_ = "";
    displayName_ = "";
    placeholders_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Generator();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Generator.class,
            com.google.cloud.dialogflow.cx.v3beta1.Generator.Builder.class);
  }

  public interface PlaceholderOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Unique ID used to map custom placeholder to parameters in fulfillment.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * Unique ID used to map custom placeholder to parameters in fulfillment.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * Custom placeholder value in the prompt text.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Custom placeholder value in the prompt text.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents a custom placeholder in the prompt text.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder}
   */
  public static final class Placeholder extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder)
      PlaceholderOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Placeholder.newBuilder() to construct.
    private Placeholder(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Placeholder() {
      id_ = "";
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Placeholder();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_Placeholder_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_Placeholder_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.class,
              com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Unique ID used to map custom placeholder to parameters in fulfillment.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique ID used to map custom placeholder to parameters in fulfillment.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Custom placeholder value in the prompt text.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom placeholder value in the prompt text.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder other =
          (com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a custom placeholder in the prompt text.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder)
        com.google.cloud.dialogflow.cx.v3beta1.Generator.PlaceholderOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_Placeholder_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_Placeholder_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.class,
                com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_Placeholder_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder build() {
        com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder result =
            new com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * Unique ID used to map custom placeholder to parameters in fulfillment.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique ID used to map custom placeholder to parameters in fulfillment.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique ID used to map custom placeholder to parameters in fulfillment.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique ID used to map custom placeholder to parameters in fulfillment.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique ID used to map custom placeholder to parameters in fulfillment.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Custom placeholder value in the prompt text.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Custom placeholder value in the prompt text.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Custom placeholder value in the prompt text.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom placeholder value in the prompt text.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom placeholder value in the prompt text.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Placeholder> PARSER =
        new com.google.protobuf.AbstractParser<Placeholder>() {
          @java.lang.Override
          public Placeholder parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Placeholder> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Placeholder> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ModelParameterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The temperature used for sampling. Temperature sampling occurs after both
     * topP and topK have been applied.
     * Valid range: [0.0, 1.0]
     * Low temperature = less random. High temperature = more random.
     * </pre>
     *
     * <code>optional float temperature = 1;</code>
     *
     * @return Whether the temperature field is set.
     */
    boolean hasTemperature();
    /**
     *
     *
     * <pre>
     * The temperature used for sampling. Temperature sampling occurs after both
     * topP and topK have been applied.
     * Valid range: [0.0, 1.0]
     * Low temperature = less random. High temperature = more random.
     * </pre>
     *
     * <code>optional float temperature = 1;</code>
     *
     * @return The temperature.
     */
    float getTemperature();

    /**
     *
     *
     * <pre>
     * The maximum number of tokens to generate.
     * </pre>
     *
     * <code>optional int32 max_decode_steps = 2;</code>
     *
     * @return Whether the maxDecodeSteps field is set.
     */
    boolean hasMaxDecodeSteps();
    /**
     *
     *
     * <pre>
     * The maximum number of tokens to generate.
     * </pre>
     *
     * <code>optional int32 max_decode_steps = 2;</code>
     *
     * @return The maxDecodeSteps.
     */
    int getMaxDecodeSteps();

    /**
     *
     *
     * <pre>
     * If set, only the tokens comprising the top top_p probability mass are
     * considered. If both top_p and top_k are
     * set, top_p will be used for further refining candidates selected with
     * top_k.
     * Valid range: (0.0, 1.0].
     * Small topP = less random. Large topP = more random.
     * </pre>
     *
     * <code>optional float top_p = 3;</code>
     *
     * @return Whether the topP field is set.
     */
    boolean hasTopP();
    /**
     *
     *
     * <pre>
     * If set, only the tokens comprising the top top_p probability mass are
     * considered. If both top_p and top_k are
     * set, top_p will be used for further refining candidates selected with
     * top_k.
     * Valid range: (0.0, 1.0].
     * Small topP = less random. Large topP = more random.
     * </pre>
     *
     * <code>optional float top_p = 3;</code>
     *
     * @return The topP.
     */
    float getTopP();

    /**
     *
     *
     * <pre>
     * If set, the sampling process in each step is limited to the top_k tokens
     * with highest probabilities.
     * Valid range: [1, 40] or 1000+.
     * Small topK = less random. Large topK = more random.
     * </pre>
     *
     * <code>optional int32 top_k = 4;</code>
     *
     * @return Whether the topK field is set.
     */
    boolean hasTopK();
    /**
     *
     *
     * <pre>
     * If set, the sampling process in each step is limited to the top_k tokens
     * with highest probabilities.
     * Valid range: [1, 40] or 1000+.
     * Small topK = less random. Large topK = more random.
     * </pre>
     *
     * <code>optional int32 top_k = 4;</code>
     *
     * @return The topK.
     */
    int getTopK();
  }
  /**
   *
   *
   * <pre>
   * Parameters to be passed to the LLM. If not set, default values will be
   * used.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter}
   */
  public static final class ModelParameter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter)
      ModelParameterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ModelParameter.newBuilder() to construct.
    private ModelParameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ModelParameter() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ModelParameter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_ModelParameter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_ModelParameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.class,
              com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.Builder.class);
    }

    private int bitField0_;
    public static final int TEMPERATURE_FIELD_NUMBER = 1;
    private float temperature_ = 0F;
    /**
     *
     *
     * <pre>
     * The temperature used for sampling. Temperature sampling occurs after both
     * topP and topK have been applied.
     * Valid range: [0.0, 1.0]
     * Low temperature = less random. High temperature = more random.
     * </pre>
     *
     * <code>optional float temperature = 1;</code>
     *
     * @return Whether the temperature field is set.
     */
    @java.lang.Override
    public boolean hasTemperature() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The temperature used for sampling. Temperature sampling occurs after both
     * topP and topK have been applied.
     * Valid range: [0.0, 1.0]
     * Low temperature = less random. High temperature = more random.
     * </pre>
     *
     * <code>optional float temperature = 1;</code>
     *
     * @return The temperature.
     */
    @java.lang.Override
    public float getTemperature() {
      return temperature_;
    }

    public static final int MAX_DECODE_STEPS_FIELD_NUMBER = 2;
    private int maxDecodeSteps_ = 0;
    /**
     *
     *
     * <pre>
     * The maximum number of tokens to generate.
     * </pre>
     *
     * <code>optional int32 max_decode_steps = 2;</code>
     *
     * @return Whether the maxDecodeSteps field is set.
     */
    @java.lang.Override
    public boolean hasMaxDecodeSteps() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum number of tokens to generate.
     * </pre>
     *
     * <code>optional int32 max_decode_steps = 2;</code>
     *
     * @return The maxDecodeSteps.
     */
    @java.lang.Override
    public int getMaxDecodeSteps() {
      return maxDecodeSteps_;
    }

    public static final int TOP_P_FIELD_NUMBER = 3;
    private float topP_ = 0F;
    /**
     *
     *
     * <pre>
     * If set, only the tokens comprising the top top_p probability mass are
     * considered. If both top_p and top_k are
     * set, top_p will be used for further refining candidates selected with
     * top_k.
     * Valid range: (0.0, 1.0].
     * Small topP = less random. Large topP = more random.
     * </pre>
     *
     * <code>optional float top_p = 3;</code>
     *
     * @return Whether the topP field is set.
     */
    @java.lang.Override
    public boolean hasTopP() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, only the tokens comprising the top top_p probability mass are
     * considered. If both top_p and top_k are
     * set, top_p will be used for further refining candidates selected with
     * top_k.
     * Valid range: (0.0, 1.0].
     * Small topP = less random. Large topP = more random.
     * </pre>
     *
     * <code>optional float top_p = 3;</code>
     *
     * @return The topP.
     */
    @java.lang.Override
    public float getTopP() {
      return topP_;
    }

    public static final int TOP_K_FIELD_NUMBER = 4;
    private int topK_ = 0;
    /**
     *
     *
     * <pre>
     * If set, the sampling process in each step is limited to the top_k tokens
     * with highest probabilities.
     * Valid range: [1, 40] or 1000+.
     * Small topK = less random. Large topK = more random.
     * </pre>
     *
     * <code>optional int32 top_k = 4;</code>
     *
     * @return Whether the topK field is set.
     */
    @java.lang.Override
    public boolean hasTopK() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, the sampling process in each step is limited to the top_k tokens
     * with highest probabilities.
     * Valid range: [1, 40] or 1000+.
     * Small topK = less random. Large topK = more random.
     * </pre>
     *
     * <code>optional int32 top_k = 4;</code>
     *
     * @return The topK.
     */
    @java.lang.Override
    public int getTopK() {
      return topK_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeFloat(1, temperature_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(2, maxDecodeSteps_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeFloat(3, topP_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeInt32(4, topK_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, temperature_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxDecodeSteps_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, topP_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, topK_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter other =
          (com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter) obj;

      if (hasTemperature() != other.hasTemperature()) return false;
      if (hasTemperature()) {
        if (java.lang.Float.floatToIntBits(getTemperature())
            != java.lang.Float.floatToIntBits(other.getTemperature())) return false;
      }
      if (hasMaxDecodeSteps() != other.hasMaxDecodeSteps()) return false;
      if (hasMaxDecodeSteps()) {
        if (getMaxDecodeSteps() != other.getMaxDecodeSteps()) return false;
      }
      if (hasTopP() != other.hasTopP()) return false;
      if (hasTopP()) {
        if (java.lang.Float.floatToIntBits(getTopP())
            != java.lang.Float.floatToIntBits(other.getTopP())) return false;
      }
      if (hasTopK() != other.hasTopK()) return false;
      if (hasTopK()) {
        if (getTopK() != other.getTopK()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTemperature()) {
        hash = (37 * hash) + TEMPERATURE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getTemperature());
      }
      if (hasMaxDecodeSteps()) {
        hash = (37 * hash) + MAX_DECODE_STEPS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxDecodeSteps();
      }
      if (hasTopP()) {
        hash = (37 * hash) + TOP_P_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getTopP());
      }
      if (hasTopK()) {
        hash = (37 * hash) + TOP_K_FIELD_NUMBER;
        hash = (53 * hash) + getTopK();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Parameters to be passed to the LLM. If not set, default values will be
     * used.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter)
        com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_ModelParameter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_ModelParameter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.class,
                com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        temperature_ = 0F;
        maxDecodeSteps_ = 0;
        topP_ = 0F;
        topK_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_ModelParameter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter build() {
        com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter result =
            new com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.temperature_ = temperature_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxDecodeSteps_ = maxDecodeSteps_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.topP_ = topP_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.topK_ = topK_;
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.getDefaultInstance())
          return this;
        if (other.hasTemperature()) {
          setTemperature(other.getTemperature());
        }
        if (other.hasMaxDecodeSteps()) {
          setMaxDecodeSteps(other.getMaxDecodeSteps());
        }
        if (other.hasTopP()) {
          setTopP(other.getTopP());
        }
        if (other.hasTopK()) {
          setTopK(other.getTopK());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  temperature_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 16:
                {
                  maxDecodeSteps_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 29:
                {
                  topP_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              case 32:
                {
                  topK_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float temperature_;
      /**
       *
       *
       * <pre>
       * The temperature used for sampling. Temperature sampling occurs after both
       * topP and topK have been applied.
       * Valid range: [0.0, 1.0]
       * Low temperature = less random. High temperature = more random.
       * </pre>
       *
       * <code>optional float temperature = 1;</code>
       *
       * @return Whether the temperature field is set.
       */
      @java.lang.Override
      public boolean hasTemperature() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The temperature used for sampling. Temperature sampling occurs after both
       * topP and topK have been applied.
       * Valid range: [0.0, 1.0]
       * Low temperature = less random. High temperature = more random.
       * </pre>
       *
       * <code>optional float temperature = 1;</code>
       *
       * @return The temperature.
       */
      @java.lang.Override
      public float getTemperature() {
        return temperature_;
      }
      /**
       *
       *
       * <pre>
       * The temperature used for sampling. Temperature sampling occurs after both
       * topP and topK have been applied.
       * Valid range: [0.0, 1.0]
       * Low temperature = less random. High temperature = more random.
       * </pre>
       *
       * <code>optional float temperature = 1;</code>
       *
       * @param value The temperature to set.
       * @return This builder for chaining.
       */
      public Builder setTemperature(float value) {

        temperature_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The temperature used for sampling. Temperature sampling occurs after both
       * topP and topK have been applied.
       * Valid range: [0.0, 1.0]
       * Low temperature = less random. High temperature = more random.
       * </pre>
       *
       * <code>optional float temperature = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTemperature() {
        bitField0_ = (bitField0_ & ~0x00000001);
        temperature_ = 0F;
        onChanged();
        return this;
      }

      private int maxDecodeSteps_;
      /**
       *
       *
       * <pre>
       * The maximum number of tokens to generate.
       * </pre>
       *
       * <code>optional int32 max_decode_steps = 2;</code>
       *
       * @return Whether the maxDecodeSteps field is set.
       */
      @java.lang.Override
      public boolean hasMaxDecodeSteps() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The maximum number of tokens to generate.
       * </pre>
       *
       * <code>optional int32 max_decode_steps = 2;</code>
       *
       * @return The maxDecodeSteps.
       */
      @java.lang.Override
      public int getMaxDecodeSteps() {
        return maxDecodeSteps_;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of tokens to generate.
       * </pre>
       *
       * <code>optional int32 max_decode_steps = 2;</code>
       *
       * @param value The maxDecodeSteps to set.
       * @return This builder for chaining.
       */
      public Builder setMaxDecodeSteps(int value) {

        maxDecodeSteps_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of tokens to generate.
       * </pre>
       *
       * <code>optional int32 max_decode_steps = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxDecodeSteps() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxDecodeSteps_ = 0;
        onChanged();
        return this;
      }

      private float topP_;
      /**
       *
       *
       * <pre>
       * If set, only the tokens comprising the top top_p probability mass are
       * considered. If both top_p and top_k are
       * set, top_p will be used for further refining candidates selected with
       * top_k.
       * Valid range: (0.0, 1.0].
       * Small topP = less random. Large topP = more random.
       * </pre>
       *
       * <code>optional float top_p = 3;</code>
       *
       * @return Whether the topP field is set.
       */
      @java.lang.Override
      public boolean hasTopP() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * If set, only the tokens comprising the top top_p probability mass are
       * considered. If both top_p and top_k are
       * set, top_p will be used for further refining candidates selected with
       * top_k.
       * Valid range: (0.0, 1.0].
       * Small topP = less random. Large topP = more random.
       * </pre>
       *
       * <code>optional float top_p = 3;</code>
       *
       * @return The topP.
       */
      @java.lang.Override
      public float getTopP() {
        return topP_;
      }
      /**
       *
       *
       * <pre>
       * If set, only the tokens comprising the top top_p probability mass are
       * considered. If both top_p and top_k are
       * set, top_p will be used for further refining candidates selected with
       * top_k.
       * Valid range: (0.0, 1.0].
       * Small topP = less random. Large topP = more random.
       * </pre>
       *
       * <code>optional float top_p = 3;</code>
       *
       * @param value The topP to set.
       * @return This builder for chaining.
       */
      public Builder setTopP(float value) {

        topP_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, only the tokens comprising the top top_p probability mass are
       * considered. If both top_p and top_k are
       * set, top_p will be used for further refining candidates selected with
       * top_k.
       * Valid range: (0.0, 1.0].
       * Small topP = less random. Large topP = more random.
       * </pre>
       *
       * <code>optional float top_p = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopP() {
        bitField0_ = (bitField0_ & ~0x00000004);
        topP_ = 0F;
        onChanged();
        return this;
      }

      private int topK_;
      /**
       *
       *
       * <pre>
       * If set, the sampling process in each step is limited to the top_k tokens
       * with highest probabilities.
       * Valid range: [1, 40] or 1000+.
       * Small topK = less random. Large topK = more random.
       * </pre>
       *
       * <code>optional int32 top_k = 4;</code>
       *
       * @return Whether the topK field is set.
       */
      @java.lang.Override
      public boolean hasTopK() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * If set, the sampling process in each step is limited to the top_k tokens
       * with highest probabilities.
       * Valid range: [1, 40] or 1000+.
       * Small topK = less random. Large topK = more random.
       * </pre>
       *
       * <code>optional int32 top_k = 4;</code>
       *
       * @return The topK.
       */
      @java.lang.Override
      public int getTopK() {
        return topK_;
      }
      /**
       *
       *
       * <pre>
       * If set, the sampling process in each step is limited to the top_k tokens
       * with highest probabilities.
       * Valid range: [1, 40] or 1000+.
       * Small topK = less random. Large topK = more random.
       * </pre>
       *
       * <code>optional int32 top_k = 4;</code>
       *
       * @param value The topK to set.
       * @return This builder for chaining.
       */
      public Builder setTopK(int value) {

        topK_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, the sampling process in each step is limited to the top_k tokens
       * with highest probabilities.
       * Valid range: [1, 40] or 1000+.
       * Small topK = less random. Large topK = more random.
       * </pre>
       *
       * <code>optional int32 top_k = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopK() {
        bitField0_ = (bitField0_ & ~0x00000008);
        topK_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelParameter> PARSER =
        new com.google.protobuf.AbstractParser<ModelParameter>() {
          @java.lang.Override
          public ModelParameter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ModelParameter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelParameter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the generator.
   * Must be set for the
   * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3beta1.Generators.UpdateGenerator]
   * method. [Generators.CreateGenerate][] populates the name automatically.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/generators/&lt;GeneratorID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the generator.
   * Must be set for the
   * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3beta1.Generators.UpdateGenerator]
   * method. [Generators.CreateGenerate][] populates the name automatically.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/generators/&lt;GeneratorID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the generator, unique within the
   * agent. The prompt contains pre-defined parameters such as $conversation,
   * $last-user-utterance, etc. populated by Dialogflow. It can also contain
   * custom placeholders which will be resolved during fulfillment.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the generator, unique within the
   * agent. The prompt contains pre-defined parameters such as $conversation,
   * $last-user-utterance, etc. populated by Dialogflow. It can also contain
   * custom placeholders which will be resolved during fulfillment.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROMPT_TEXT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3beta1.Phrase promptText_;
  /**
   *
   *
   * <pre>
   * Required. Prompt for the LLM model.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the promptText field is set.
   */
  @java.lang.Override
  public boolean hasPromptText() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Prompt for the LLM model.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The promptText.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Phrase getPromptText() {
    return promptText_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Phrase.getDefaultInstance()
        : promptText_;
  }
  /**
   *
   *
   * <pre>
   * Required. Prompt for the LLM model.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PhraseOrBuilder getPromptTextOrBuilder() {
    return promptText_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Phrase.getDefaultInstance()
        : promptText_;
  }

  public static final int PLACEHOLDERS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder>
      placeholders_;
  /**
   *
   *
   * <pre>
   * Optional. List of custom placeholders in the prompt text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder>
      getPlaceholdersList() {
    return placeholders_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of custom placeholders in the prompt text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3beta1.Generator.PlaceholderOrBuilder>
      getPlaceholdersOrBuilderList() {
    return placeholders_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of custom placeholders in the prompt text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getPlaceholdersCount() {
    return placeholders_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of custom placeholders in the prompt text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder getPlaceholders(int index) {
    return placeholders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of custom placeholders in the prompt text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Generator.PlaceholderOrBuilder
      getPlaceholdersOrBuilder(int index) {
    return placeholders_.get(index);
  }

  public static final int LLM_MODEL_SETTINGS_FIELD_NUMBER = 9;
  private com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llmModelSettings_;
  /**
   *
   *
   * <pre>
   * The LLM model settings.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
   *
   * @return Whether the llmModelSettings field is set.
   */
  @java.lang.Override
  public boolean hasLlmModelSettings() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The LLM model settings.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
   *
   * @return The llmModelSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings getLlmModelSettings() {
    return llmModelSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()
        : llmModelSettings_;
  }
  /**
   *
   *
   * <pre>
   * The LLM model settings.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder
      getLlmModelSettingsOrBuilder() {
    return llmModelSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()
        : llmModelSettings_;
  }

  public static final int MODEL_PARAMETER_FIELD_NUMBER = 8;
  private com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter modelParameter_;
  /**
   *
   *
   * <pre>
   * Parameters passed to the LLM to configure its behavior.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;</code>
   *
   * @return Whether the modelParameter field is set.
   */
  @java.lang.Override
  public boolean hasModelParameter() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters passed to the LLM to configure its behavior.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;</code>
   *
   * @return The modelParameter.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter getModelParameter() {
    return modelParameter_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.getDefaultInstance()
        : modelParameter_;
  }
  /**
   *
   *
   * <pre>
   * Parameters passed to the LLM to configure its behavior.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameterOrBuilder
      getModelParameterOrBuilder() {
    return modelParameter_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.getDefaultInstance()
        : modelParameter_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getPromptText());
    }
    for (int i = 0; i < placeholders_.size(); i++) {
      output.writeMessage(5, placeholders_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getModelParameter());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getLlmModelSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPromptText());
    }
    for (int i = 0; i < placeholders_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, placeholders_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getModelParameter());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getLlmModelSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Generator)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Generator other =
        (com.google.cloud.dialogflow.cx.v3beta1.Generator) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasPromptText() != other.hasPromptText()) return false;
    if (hasPromptText()) {
      if (!getPromptText().equals(other.getPromptText())) return false;
    }
    if (!getPlaceholdersList().equals(other.getPlaceholdersList())) return false;
    if (hasLlmModelSettings() != other.hasLlmModelSettings()) return false;
    if (hasLlmModelSettings()) {
      if (!getLlmModelSettings().equals(other.getLlmModelSettings())) return false;
    }
    if (hasModelParameter() != other.hasModelParameter()) return false;
    if (hasModelParameter()) {
      if (!getModelParameter().equals(other.getModelParameter())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasPromptText()) {
      hash = (37 * hash) + PROMPT_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getPromptText().hashCode();
    }
    if (getPlaceholdersCount() > 0) {
      hash = (37 * hash) + PLACEHOLDERS_FIELD_NUMBER;
      hash = (53 * hash) + getPlaceholdersList().hashCode();
    }
    if (hasLlmModelSettings()) {
      hash = (37 * hash) + LLM_MODEL_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getLlmModelSettings().hashCode();
    }
    if (hasModelParameter()) {
      hash = (37 * hash) + MODEL_PARAMETER_FIELD_NUMBER;
      hash = (53 * hash) + getModelParameter().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Generator prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Generators contain prompt to be sent to the LLM model to generate text. The
   * prompt can contain parameters which will be resolved before calling the
   * model. It can optionally contain banned phrases to ensure the model responses
   * are safe.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Generator}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Generator)
      com.google.cloud.dialogflow.cx.v3beta1.GeneratorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Generator.class,
              com.google.cloud.dialogflow.cx.v3beta1.Generator.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Generator.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPromptTextFieldBuilder();
        getPlaceholdersFieldBuilder();
        getLlmModelSettingsFieldBuilder();
        getModelParameterFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      promptText_ = null;
      if (promptTextBuilder_ != null) {
        promptTextBuilder_.dispose();
        promptTextBuilder_ = null;
      }
      if (placeholdersBuilder_ == null) {
        placeholders_ = java.util.Collections.emptyList();
      } else {
        placeholders_ = null;
        placeholdersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      llmModelSettings_ = null;
      if (llmModelSettingsBuilder_ != null) {
        llmModelSettingsBuilder_.dispose();
        llmModelSettingsBuilder_ = null;
      }
      modelParameter_ = null;
      if (modelParameterBuilder_ != null) {
        modelParameterBuilder_.dispose();
        modelParameterBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Generator_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Generator getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Generator.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Generator build() {
      com.google.cloud.dialogflow.cx.v3beta1.Generator result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Generator buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Generator result =
          new com.google.cloud.dialogflow.cx.v3beta1.Generator(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.Generator result) {
      if (placeholdersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          placeholders_ = java.util.Collections.unmodifiableList(placeholders_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.placeholders_ = placeholders_;
      } else {
        result.placeholders_ = placeholdersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Generator result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.promptText_ = promptTextBuilder_ == null ? promptText_ : promptTextBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.llmModelSettings_ =
            llmModelSettingsBuilder_ == null ? llmModelSettings_ : llmModelSettingsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.modelParameter_ =
            modelParameterBuilder_ == null ? modelParameter_ : modelParameterBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Generator) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Generator) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Generator other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Generator.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPromptText()) {
        mergePromptText(other.getPromptText());
      }
      if (placeholdersBuilder_ == null) {
        if (!other.placeholders_.isEmpty()) {
          if (placeholders_.isEmpty()) {
            placeholders_ = other.placeholders_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensurePlaceholdersIsMutable();
            placeholders_.addAll(other.placeholders_);
          }
          onChanged();
        }
      } else {
        if (!other.placeholders_.isEmpty()) {
          if (placeholdersBuilder_.isEmpty()) {
            placeholdersBuilder_.dispose();
            placeholdersBuilder_ = null;
            placeholders_ = other.placeholders_;
            bitField0_ = (bitField0_ & ~0x00000008);
            placeholdersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPlaceholdersFieldBuilder()
                    : null;
          } else {
            placeholdersBuilder_.addAllMessages(other.placeholders_);
          }
        }
      }
      if (other.hasLlmModelSettings()) {
        mergeLlmModelSettings(other.getLlmModelSettings());
      }
      if (other.hasModelParameter()) {
        mergeModelParameter(other.getModelParameter());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPromptTextFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.parser(),
                        extensionRegistry);
                if (placeholdersBuilder_ == null) {
                  ensurePlaceholdersIsMutable();
                  placeholders_.add(m);
                } else {
                  placeholdersBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 66:
              {
                input.readMessage(getModelParameterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getLlmModelSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the generator.
     * Must be set for the
     * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3beta1.Generators.UpdateGenerator]
     * method. [Generators.CreateGenerate][] populates the name automatically.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/generators/&lt;GeneratorID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the generator.
     * Must be set for the
     * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3beta1.Generators.UpdateGenerator]
     * method. [Generators.CreateGenerate][] populates the name automatically.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/generators/&lt;GeneratorID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the generator.
     * Must be set for the
     * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3beta1.Generators.UpdateGenerator]
     * method. [Generators.CreateGenerate][] populates the name automatically.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/generators/&lt;GeneratorID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the generator.
     * Must be set for the
     * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3beta1.Generators.UpdateGenerator]
     * method. [Generators.CreateGenerate][] populates the name automatically.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/generators/&lt;GeneratorID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the generator.
     * Must be set for the
     * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3beta1.Generators.UpdateGenerator]
     * method. [Generators.CreateGenerate][] populates the name automatically.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/generators/&lt;GeneratorID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the generator, unique within the
     * agent. The prompt contains pre-defined parameters such as $conversation,
     * $last-user-utterance, etc. populated by Dialogflow. It can also contain
     * custom placeholders which will be resolved during fulfillment.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the generator, unique within the
     * agent. The prompt contains pre-defined parameters such as $conversation,
     * $last-user-utterance, etc. populated by Dialogflow. It can also contain
     * custom placeholders which will be resolved during fulfillment.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the generator, unique within the
     * agent. The prompt contains pre-defined parameters such as $conversation,
     * $last-user-utterance, etc. populated by Dialogflow. It can also contain
     * custom placeholders which will be resolved during fulfillment.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the generator, unique within the
     * agent. The prompt contains pre-defined parameters such as $conversation,
     * $last-user-utterance, etc. populated by Dialogflow. It can also contain
     * custom placeholders which will be resolved during fulfillment.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the generator, unique within the
     * agent. The prompt contains pre-defined parameters such as $conversation,
     * $last-user-utterance, etc. populated by Dialogflow. It can also contain
     * custom placeholders which will be resolved during fulfillment.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.Phrase promptText_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Phrase,
            com.google.cloud.dialogflow.cx.v3beta1.Phrase.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PhraseOrBuilder>
        promptTextBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Prompt for the LLM model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the promptText field is set.
     */
    public boolean hasPromptText() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Prompt for the LLM model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The promptText.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Phrase getPromptText() {
      if (promptTextBuilder_ == null) {
        return promptText_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Phrase.getDefaultInstance()
            : promptText_;
      } else {
        return promptTextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Prompt for the LLM model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPromptText(com.google.cloud.dialogflow.cx.v3beta1.Phrase value) {
      if (promptTextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        promptText_ = value;
      } else {
        promptTextBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Prompt for the LLM model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPromptText(
        com.google.cloud.dialogflow.cx.v3beta1.Phrase.Builder builderForValue) {
      if (promptTextBuilder_ == null) {
        promptText_ = builderForValue.build();
      } else {
        promptTextBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Prompt for the LLM model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergePromptText(com.google.cloud.dialogflow.cx.v3beta1.Phrase value) {
      if (promptTextBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && promptText_ != null
            && promptText_ != com.google.cloud.dialogflow.cx.v3beta1.Phrase.getDefaultInstance()) {
          getPromptTextBuilder().mergeFrom(value);
        } else {
          promptText_ = value;
        }
      } else {
        promptTextBuilder_.mergeFrom(value);
      }
      if (promptText_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Prompt for the LLM model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPromptText() {
      bitField0_ = (bitField0_ & ~0x00000004);
      promptText_ = null;
      if (promptTextBuilder_ != null) {
        promptTextBuilder_.dispose();
        promptTextBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Prompt for the LLM model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Phrase.Builder getPromptTextBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPromptTextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Prompt for the LLM model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PhraseOrBuilder getPromptTextOrBuilder() {
      if (promptTextBuilder_ != null) {
        return promptTextBuilder_.getMessageOrBuilder();
      } else {
        return promptText_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Phrase.getDefaultInstance()
            : promptText_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Prompt for the LLM model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Phrase,
            com.google.cloud.dialogflow.cx.v3beta1.Phrase.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PhraseOrBuilder>
        getPromptTextFieldBuilder() {
      if (promptTextBuilder_ == null) {
        promptTextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Phrase,
                com.google.cloud.dialogflow.cx.v3beta1.Phrase.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.PhraseOrBuilder>(
                getPromptText(), getParentForChildren(), isClean());
        promptText_ = null;
      }
      return promptTextBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder>
        placeholders_ = java.util.Collections.emptyList();

    private void ensurePlaceholdersIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        placeholders_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder>(
                placeholders_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder,
            com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Generator.PlaceholderOrBuilder>
        placeholdersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder>
        getPlaceholdersList() {
      if (placeholdersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(placeholders_);
      } else {
        return placeholdersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getPlaceholdersCount() {
      if (placeholdersBuilder_ == null) {
        return placeholders_.size();
      } else {
        return placeholdersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder getPlaceholders(int index) {
      if (placeholdersBuilder_ == null) {
        return placeholders_.get(index);
      } else {
        return placeholdersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaceholders(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder value) {
      if (placeholdersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePlaceholdersIsMutable();
        placeholders_.set(index, value);
        onChanged();
      } else {
        placeholdersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaceholders(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder builderForValue) {
      if (placeholdersBuilder_ == null) {
        ensurePlaceholdersIsMutable();
        placeholders_.set(index, builderForValue.build());
        onChanged();
      } else {
        placeholdersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPlaceholders(
        com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder value) {
      if (placeholdersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePlaceholdersIsMutable();
        placeholders_.add(value);
        onChanged();
      } else {
        placeholdersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPlaceholders(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder value) {
      if (placeholdersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePlaceholdersIsMutable();
        placeholders_.add(index, value);
        onChanged();
      } else {
        placeholdersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPlaceholders(
        com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder builderForValue) {
      if (placeholdersBuilder_ == null) {
        ensurePlaceholdersIsMutable();
        placeholders_.add(builderForValue.build());
        onChanged();
      } else {
        placeholdersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPlaceholders(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder builderForValue) {
      if (placeholdersBuilder_ == null) {
        ensurePlaceholdersIsMutable();
        placeholders_.add(index, builderForValue.build());
        onChanged();
      } else {
        placeholdersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllPlaceholders(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder>
            values) {
      if (placeholdersBuilder_ == null) {
        ensurePlaceholdersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, placeholders_);
        onChanged();
      } else {
        placeholdersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPlaceholders() {
      if (placeholdersBuilder_ == null) {
        placeholders_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        placeholdersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removePlaceholders(int index) {
      if (placeholdersBuilder_ == null) {
        ensurePlaceholdersIsMutable();
        placeholders_.remove(index);
        onChanged();
      } else {
        placeholdersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder
        getPlaceholdersBuilder(int index) {
      return getPlaceholdersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.PlaceholderOrBuilder
        getPlaceholdersOrBuilder(int index) {
      if (placeholdersBuilder_ == null) {
        return placeholders_.get(index);
      } else {
        return placeholdersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Generator.PlaceholderOrBuilder>
        getPlaceholdersOrBuilderList() {
      if (placeholdersBuilder_ != null) {
        return placeholdersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(placeholders_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder
        addPlaceholdersBuilder() {
      return getPlaceholdersFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder
        addPlaceholdersBuilder(int index) {
      return getPlaceholdersFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of custom placeholders in the prompt text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder>
        getPlaceholdersBuilderList() {
      return getPlaceholdersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder,
            com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Generator.PlaceholderOrBuilder>
        getPlaceholdersFieldBuilder() {
      if (placeholdersBuilder_ == null) {
        placeholdersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder,
                com.google.cloud.dialogflow.cx.v3beta1.Generator.Placeholder.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Generator.PlaceholderOrBuilder>(
                placeholders_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        placeholders_ = null;
      }
      return placeholdersBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llmModelSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings,
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder>
        llmModelSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * The LLM model settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
     *
     * @return Whether the llmModelSettings field is set.
     */
    public boolean hasLlmModelSettings() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The LLM model settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
     *
     * @return The llmModelSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings getLlmModelSettings() {
      if (llmModelSettingsBuilder_ == null) {
        return llmModelSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()
            : llmModelSettings_;
      } else {
        return llmModelSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The LLM model settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
     */
    public Builder setLlmModelSettings(
        com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings value) {
      if (llmModelSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        llmModelSettings_ = value;
      } else {
        llmModelSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The LLM model settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
     */
    public Builder setLlmModelSettings(
        com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder builderForValue) {
      if (llmModelSettingsBuilder_ == null) {
        llmModelSettings_ = builderForValue.build();
      } else {
        llmModelSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The LLM model settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
     */
    public Builder mergeLlmModelSettings(
        com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings value) {
      if (llmModelSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && llmModelSettings_ != null
            && llmModelSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()) {
          getLlmModelSettingsBuilder().mergeFrom(value);
        } else {
          llmModelSettings_ = value;
        }
      } else {
        llmModelSettingsBuilder_.mergeFrom(value);
      }
      if (llmModelSettings_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The LLM model settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
     */
    public Builder clearLlmModelSettings() {
      bitField0_ = (bitField0_ & ~0x00000010);
      llmModelSettings_ = null;
      if (llmModelSettingsBuilder_ != null) {
        llmModelSettingsBuilder_.dispose();
        llmModelSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The LLM model settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder
        getLlmModelSettingsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getLlmModelSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The LLM model settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder
        getLlmModelSettingsOrBuilder() {
      if (llmModelSettingsBuilder_ != null) {
        return llmModelSettingsBuilder_.getMessageOrBuilder();
      } else {
        return llmModelSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()
            : llmModelSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * The LLM model settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings,
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder>
        getLlmModelSettingsFieldBuilder() {
      if (llmModelSettingsBuilder_ == null) {
        llmModelSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings,
                com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder>(
                getLlmModelSettings(), getParentForChildren(), isClean());
        llmModelSettings_ = null;
      }
      return llmModelSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter modelParameter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter,
            com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameterOrBuilder>
        modelParameterBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters passed to the LLM to configure its behavior.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;
     * </code>
     *
     * @return Whether the modelParameter field is set.
     */
    public boolean hasModelParameter() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters passed to the LLM to configure its behavior.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;
     * </code>
     *
     * @return The modelParameter.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter getModelParameter() {
      if (modelParameterBuilder_ == null) {
        return modelParameter_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.getDefaultInstance()
            : modelParameter_;
      } else {
        return modelParameterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters passed to the LLM to configure its behavior.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;
     * </code>
     */
    public Builder setModelParameter(
        com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter value) {
      if (modelParameterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelParameter_ = value;
      } else {
        modelParameterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters passed to the LLM to configure its behavior.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;
     * </code>
     */
    public Builder setModelParameter(
        com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.Builder builderForValue) {
      if (modelParameterBuilder_ == null) {
        modelParameter_ = builderForValue.build();
      } else {
        modelParameterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters passed to the LLM to configure its behavior.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;
     * </code>
     */
    public Builder mergeModelParameter(
        com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter value) {
      if (modelParameterBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && modelParameter_ != null
            && modelParameter_
                != com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter
                    .getDefaultInstance()) {
          getModelParameterBuilder().mergeFrom(value);
        } else {
          modelParameter_ = value;
        }
      } else {
        modelParameterBuilder_.mergeFrom(value);
      }
      if (modelParameter_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters passed to the LLM to configure its behavior.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;
     * </code>
     */
    public Builder clearModelParameter() {
      bitField0_ = (bitField0_ & ~0x00000020);
      modelParameter_ = null;
      if (modelParameterBuilder_ != null) {
        modelParameterBuilder_.dispose();
        modelParameterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters passed to the LLM to configure its behavior.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.Builder
        getModelParameterBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getModelParameterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters passed to the LLM to configure its behavior.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameterOrBuilder
        getModelParameterOrBuilder() {
      if (modelParameterBuilder_ != null) {
        return modelParameterBuilder_.getMessageOrBuilder();
      } else {
        return modelParameter_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.getDefaultInstance()
            : modelParameter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters passed to the LLM to configure its behavior.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter model_parameter = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter,
            com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameterOrBuilder>
        getModelParameterFieldBuilder() {
      if (modelParameterBuilder_ == null) {
        modelParameterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter,
                com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameter.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Generator.ModelParameterOrBuilder>(
                getModelParameter(), getParentForChildren(), isClean());
        modelParameter_ = null;
      }
      return modelParameterBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Generator)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Generator)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Generator DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Generator();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Generator getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Generator> PARSER =
      new com.google.protobuf.AbstractParser<Generator>() {
        @java.lang.Override
        public Generator parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Generator> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Generator> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Generator getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
