/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/page.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * A form is a data model that groups related parameters that can be collected
 * from the user. The process in which the agent prompts the user and collects
 * parameter values from the user is called form filling. A form can be added to
 * a [page][google.cloud.dialogflow.cx.v3beta1.Page]. When form filling is done,
 * the filled parameters will be written to the
 * [session][google.cloud.dialogflow.cx.v3beta1.SessionInfo.parameters].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Form}
 */
public final class Form extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Form)
    FormOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Form.newBuilder() to construct.
  private Form(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Form() {
    parameters_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Form();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Form.class,
            com.google.cloud.dialogflow.cx.v3beta1.Form.Builder.class);
  }

  public interface ParameterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Form.Parameter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the parameter, unique within the
     * form.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the parameter, unique within the
     * form.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Indicates whether the parameter is required. Optional parameters will not
     * trigger prompts; however, they are filled if the user specifies them.
     * Required parameters must be filled before form filling concludes.
     * </pre>
     *
     * <code>bool required = 2;</code>
     *
     * @return The required.
     */
    boolean getRequired();

    /**
     *
     *
     * <pre>
     * Required. The entity type of the parameter.
     * Format:
     * `projects/-/locations/-/agents/-/entityTypes/&lt;SystemEntityTypeID&gt;` for
     * system entity types (for example,
     * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entityTypes/&lt;EntityTypeID&gt;`
     * for developer entity types.
     * </pre>
     *
     * <code>
     * string entity_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The entityType.
     */
    java.lang.String getEntityType();
    /**
     *
     *
     * <pre>
     * Required. The entity type of the parameter.
     * Format:
     * `projects/-/locations/-/agents/-/entityTypes/&lt;SystemEntityTypeID&gt;` for
     * system entity types (for example,
     * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entityTypes/&lt;EntityTypeID&gt;`
     * for developer entity types.
     * </pre>
     *
     * <code>
     * string entity_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for entityType.
     */
    com.google.protobuf.ByteString getEntityTypeBytes();

    /**
     *
     *
     * <pre>
     * Indicates whether the parameter represents a list of values.
     * </pre>
     *
     * <code>bool is_list = 4;</code>
     *
     * @return The isList.
     */
    boolean getIsList();

    /**
     *
     *
     * <pre>
     * Required. Defines fill behavior for the parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the fillBehavior field is set.
     */
    boolean hasFillBehavior();
    /**
     *
     *
     * <pre>
     * Required. Defines fill behavior for the parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fillBehavior.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior getFillBehavior();
    /**
     *
     *
     * <pre>
     * Required. Defines fill behavior for the parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehaviorOrBuilder
        getFillBehaviorOrBuilder();

    /**
     *
     *
     * <pre>
     * The default value of an optional parameter. If the parameter is required,
     * the default value will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Value default_value = 9;</code>
     *
     * @return Whether the defaultValue field is set.
     */
    boolean hasDefaultValue();
    /**
     *
     *
     * <pre>
     * The default value of an optional parameter. If the parameter is required,
     * the default value will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Value default_value = 9;</code>
     *
     * @return The defaultValue.
     */
    com.google.protobuf.Value getDefaultValue();
    /**
     *
     *
     * <pre>
     * The default value of an optional parameter. If the parameter is required,
     * the default value will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Value default_value = 9;</code>
     */
    com.google.protobuf.ValueOrBuilder getDefaultValueOrBuilder();

    /**
     *
     *
     * <pre>
     * Indicates whether the parameter content should be redacted in log.  If
     * redaction is enabled, the parameter content will be replaced by parameter
     * name during logging.
     * Note: the parameter content is subject to redaction if either parameter
     * level redaction or [entity type level
     * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
     * enabled.
     * </pre>
     *
     * <code>bool redact = 11;</code>
     *
     * @return The redact.
     */
    boolean getRedact();

    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this parameter. The settings exposed
     * at the lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
     *
     * @return Whether the advancedSettings field is set.
     */
    boolean hasAdvancedSettings();
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this parameter. The settings exposed
     * at the lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
     *
     * @return The advancedSettings.
     */
    com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getAdvancedSettings();
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this parameter. The settings exposed
     * at the lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder getAdvancedSettingsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Represents a form parameter.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Form.Parameter}
   */
  public static final class Parameter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Form.Parameter)
      ParameterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Parameter.newBuilder() to construct.
    private Parameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Parameter() {
      displayName_ = "";
      entityType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Parameter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.class,
              com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder.class);
    }

    public interface FillBehaviorOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The fulfillment to provide the initial prompt that the agent
       * can present to the user in order to fill the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the initialPromptFulfillment field is set.
       */
      boolean hasInitialPromptFulfillment();
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to provide the initial prompt that the agent
       * can present to the user in order to fill the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The initialPromptFulfillment.
       */
      com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getInitialPromptFulfillment();
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to provide the initial prompt that the agent
       * can present to the user in order to fill the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder
          getInitialPromptFulfillmentOrBuilder();

      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler>
          getRepromptEventHandlersList();
      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      com.google.cloud.dialogflow.cx.v3beta1.EventHandler getRepromptEventHandlers(int index);
      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      int getRepromptEventHandlersCount();
      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>
          getRepromptEventHandlersOrBuilderList();
      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder
          getRepromptEventHandlersOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Configuration for how the filling of a parameter should be handled.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior}
     */
    public static final class FillBehavior extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior)
        FillBehaviorOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FillBehavior.newBuilder() to construct.
      private FillBehavior(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FillBehavior() {
        repromptEventHandlers_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FillBehavior();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.PageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_FillBehavior_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.PageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_FillBehavior_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.class,
                com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.Builder.class);
      }

      private int bitField0_;
      public static final int INITIAL_PROMPT_FULFILLMENT_FIELD_NUMBER = 3;
      private com.google.cloud.dialogflow.cx.v3beta1.Fulfillment initialPromptFulfillment_;
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to provide the initial prompt that the agent
       * can present to the user in order to fill the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the initialPromptFulfillment field is set.
       */
      @java.lang.Override
      public boolean hasInitialPromptFulfillment() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to provide the initial prompt that the agent
       * can present to the user in order to fill the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The initialPromptFulfillment.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getInitialPromptFulfillment() {
        return initialPromptFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
            : initialPromptFulfillment_;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to provide the initial prompt that the agent
       * can present to the user in order to fill the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder
          getInitialPromptFulfillmentOrBuilder() {
        return initialPromptFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
            : initialPromptFulfillment_;
      }

      public static final int REPROMPT_EVENT_HANDLERS_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler>
          repromptEventHandlers_;
      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler>
          getRepromptEventHandlersList() {
        return repromptEventHandlers_;
      }
      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>
          getRepromptEventHandlersOrBuilderList() {
        return repromptEventHandlers_;
      }
      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      @java.lang.Override
      public int getRepromptEventHandlersCount() {
        return repromptEventHandlers_.size();
      }
      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.EventHandler getRepromptEventHandlers(
          int index) {
        return repromptEventHandlers_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The handlers for parameter-level events, used to provide reprompt for
       * the parameter or transition to a different page/flow. The supported
       * events are:
       * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-match-default`
       * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
       * *   `sys.no-input-default`
       * *   `sys.invalid-parameter`
       *
       * `initial_prompt_fulfillment` provides the first prompt for the
       * parameter.
       *
       * If the user's response does not fill the parameter, a
       * no-match/no-input event will be triggered, and the fulfillment
       * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
       * defined) will be called to provide a prompt. The
       * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
       * the next no-match/no-input event, and so on.
       *
       * A `sys.no-match-default` or `sys.no-input-default` handler will be used
       * to handle all following no-match/no-input events after all numbered
       * no-match/no-input handlers for the parameter are consumed.
       *
       * A `sys.invalid-parameter` handler can be defined to handle the case
       * where the parameter values have been `invalidated` by webhook. For
       * example, if the user's response fill the parameter, however the
       * parameter was invalidated by webhook, the fulfillment associated with
       * the `sys.invalid-parameter` handler (if defined) will be called to
       * provide a prompt.
       *
       * If the event handler for the corresponding event can't be found on the
       * parameter, `initial_prompt_fulfillment` will be re-prompted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder
          getRepromptEventHandlersOrBuilder(int index) {
        return repromptEventHandlers_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(3, getInitialPromptFulfillment());
        }
        for (int i = 0; i < repromptEventHandlers_.size(); i++) {
          output.writeMessage(5, repromptEventHandlers_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, getInitialPromptFulfillment());
        }
        for (int i = 0; i < repromptEventHandlers_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  5, repromptEventHandlers_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior other =
            (com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior) obj;

        if (hasInitialPromptFulfillment() != other.hasInitialPromptFulfillment()) return false;
        if (hasInitialPromptFulfillment()) {
          if (!getInitialPromptFulfillment().equals(other.getInitialPromptFulfillment()))
            return false;
        }
        if (!getRepromptEventHandlersList().equals(other.getRepromptEventHandlersList()))
          return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasInitialPromptFulfillment()) {
          hash = (37 * hash) + INITIAL_PROMPT_FULFILLMENT_FIELD_NUMBER;
          hash = (53 * hash) + getInitialPromptFulfillment().hashCode();
        }
        if (getRepromptEventHandlersCount() > 0) {
          hash = (37 * hash) + REPROMPT_EVENT_HANDLERS_FIELD_NUMBER;
          hash = (53 * hash) + getRepromptEventHandlersList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Configuration for how the filling of a parameter should be handled.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior)
          com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehaviorOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.PageProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_FillBehavior_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.PageProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_FillBehavior_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getInitialPromptFulfillmentFieldBuilder();
            getRepromptEventHandlersFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          initialPromptFulfillment_ = null;
          if (initialPromptFulfillmentBuilder_ != null) {
            initialPromptFulfillmentBuilder_.dispose();
            initialPromptFulfillmentBuilder_ = null;
          }
          if (repromptEventHandlersBuilder_ == null) {
            repromptEventHandlers_ = java.util.Collections.emptyList();
          } else {
            repromptEventHandlers_ = null;
            repromptEventHandlersBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.PageProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_FillBehavior_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior build() {
          com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior result =
              new com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior result) {
          if (repromptEventHandlersBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              repromptEventHandlers_ =
                  java.util.Collections.unmodifiableList(repromptEventHandlers_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.repromptEventHandlers_ = repromptEventHandlers_;
          } else {
            result.repromptEventHandlers_ = repromptEventHandlersBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.initialPromptFulfillment_ =
                initialPromptFulfillmentBuilder_ == null
                    ? initialPromptFulfillment_
                    : initialPromptFulfillmentBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
                  .getDefaultInstance()) return this;
          if (other.hasInitialPromptFulfillment()) {
            mergeInitialPromptFulfillment(other.getInitialPromptFulfillment());
          }
          if (repromptEventHandlersBuilder_ == null) {
            if (!other.repromptEventHandlers_.isEmpty()) {
              if (repromptEventHandlers_.isEmpty()) {
                repromptEventHandlers_ = other.repromptEventHandlers_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureRepromptEventHandlersIsMutable();
                repromptEventHandlers_.addAll(other.repromptEventHandlers_);
              }
              onChanged();
            }
          } else {
            if (!other.repromptEventHandlers_.isEmpty()) {
              if (repromptEventHandlersBuilder_.isEmpty()) {
                repromptEventHandlersBuilder_.dispose();
                repromptEventHandlersBuilder_ = null;
                repromptEventHandlers_ = other.repromptEventHandlers_;
                bitField0_ = (bitField0_ & ~0x00000002);
                repromptEventHandlersBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getRepromptEventHandlersFieldBuilder()
                        : null;
              } else {
                repromptEventHandlersBuilder_.addAllMessages(other.repromptEventHandlers_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 26:
                  {
                    input.readMessage(
                        getInitialPromptFulfillmentFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 26
                case 42:
                  {
                    com.google.cloud.dialogflow.cx.v3beta1.EventHandler m =
                        input.readMessage(
                            com.google.cloud.dialogflow.cx.v3beta1.EventHandler.parser(),
                            extensionRegistry);
                    if (repromptEventHandlersBuilder_ == null) {
                      ensureRepromptEventHandlersIsMutable();
                      repromptEventHandlers_.add(m);
                    } else {
                      repromptEventHandlersBuilder_.addMessage(m);
                    }
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.dialogflow.cx.v3beta1.Fulfillment initialPromptFulfillment_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
                com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>
            initialPromptFulfillmentBuilder_;
        /**
         *
         *
         * <pre>
         * Required. The fulfillment to provide the initial prompt that the agent
         * can present to the user in order to fill the parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the initialPromptFulfillment field is set.
         */
        public boolean hasInitialPromptFulfillment() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Required. The fulfillment to provide the initial prompt that the agent
         * can present to the user in order to fill the parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The initialPromptFulfillment.
         */
        public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getInitialPromptFulfillment() {
          if (initialPromptFulfillmentBuilder_ == null) {
            return initialPromptFulfillment_ == null
                ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
                : initialPromptFulfillment_;
          } else {
            return initialPromptFulfillmentBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The fulfillment to provide the initial prompt that the agent
         * can present to the user in order to fill the parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setInitialPromptFulfillment(
            com.google.cloud.dialogflow.cx.v3beta1.Fulfillment value) {
          if (initialPromptFulfillmentBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            initialPromptFulfillment_ = value;
          } else {
            initialPromptFulfillmentBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The fulfillment to provide the initial prompt that the agent
         * can present to the user in order to fill the parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setInitialPromptFulfillment(
            com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder builderForValue) {
          if (initialPromptFulfillmentBuilder_ == null) {
            initialPromptFulfillment_ = builderForValue.build();
          } else {
            initialPromptFulfillmentBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The fulfillment to provide the initial prompt that the agent
         * can present to the user in order to fill the parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeInitialPromptFulfillment(
            com.google.cloud.dialogflow.cx.v3beta1.Fulfillment value) {
          if (initialPromptFulfillmentBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && initialPromptFulfillment_ != null
                && initialPromptFulfillment_
                    != com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()) {
              getInitialPromptFulfillmentBuilder().mergeFrom(value);
            } else {
              initialPromptFulfillment_ = value;
            }
          } else {
            initialPromptFulfillmentBuilder_.mergeFrom(value);
          }
          if (initialPromptFulfillment_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The fulfillment to provide the initial prompt that the agent
         * can present to the user in order to fill the parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearInitialPromptFulfillment() {
          bitField0_ = (bitField0_ & ~0x00000001);
          initialPromptFulfillment_ = null;
          if (initialPromptFulfillmentBuilder_ != null) {
            initialPromptFulfillmentBuilder_.dispose();
            initialPromptFulfillmentBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The fulfillment to provide the initial prompt that the agent
         * can present to the user in order to fill the parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder
            getInitialPromptFulfillmentBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getInitialPromptFulfillmentFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. The fulfillment to provide the initial prompt that the agent
         * can present to the user in order to fill the parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder
            getInitialPromptFulfillmentOrBuilder() {
          if (initialPromptFulfillmentBuilder_ != null) {
            return initialPromptFulfillmentBuilder_.getMessageOrBuilder();
          } else {
            return initialPromptFulfillment_ == null
                ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
                : initialPromptFulfillment_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The fulfillment to provide the initial prompt that the agent
         * can present to the user in order to fill the parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Fulfillment initial_prompt_fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
                com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>
            getInitialPromptFulfillmentFieldBuilder() {
          if (initialPromptFulfillmentBuilder_ == null) {
            initialPromptFulfillmentBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
                    com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
                    com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>(
                    getInitialPromptFulfillment(), getParentForChildren(), isClean());
            initialPromptFulfillment_ = null;
          }
          return initialPromptFulfillmentBuilder_;
        }

        private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler>
            repromptEventHandlers_ = java.util.Collections.emptyList();

        private void ensureRepromptEventHandlersIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            repromptEventHandlers_ =
                new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.EventHandler>(
                    repromptEventHandlers_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.EventHandler,
                com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>
            repromptEventHandlersBuilder_;

        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler>
            getRepromptEventHandlersList() {
          if (repromptEventHandlersBuilder_ == null) {
            return java.util.Collections.unmodifiableList(repromptEventHandlers_);
          } else {
            return repromptEventHandlersBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public int getRepromptEventHandlersCount() {
          if (repromptEventHandlersBuilder_ == null) {
            return repromptEventHandlers_.size();
          } else {
            return repromptEventHandlersBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.EventHandler getRepromptEventHandlers(
            int index) {
          if (repromptEventHandlersBuilder_ == null) {
            return repromptEventHandlers_.get(index);
          } else {
            return repromptEventHandlersBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public Builder setRepromptEventHandlers(
            int index, com.google.cloud.dialogflow.cx.v3beta1.EventHandler value) {
          if (repromptEventHandlersBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRepromptEventHandlersIsMutable();
            repromptEventHandlers_.set(index, value);
            onChanged();
          } else {
            repromptEventHandlersBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public Builder setRepromptEventHandlers(
            int index,
            com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder builderForValue) {
          if (repromptEventHandlersBuilder_ == null) {
            ensureRepromptEventHandlersIsMutable();
            repromptEventHandlers_.set(index, builderForValue.build());
            onChanged();
          } else {
            repromptEventHandlersBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public Builder addRepromptEventHandlers(
            com.google.cloud.dialogflow.cx.v3beta1.EventHandler value) {
          if (repromptEventHandlersBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRepromptEventHandlersIsMutable();
            repromptEventHandlers_.add(value);
            onChanged();
          } else {
            repromptEventHandlersBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public Builder addRepromptEventHandlers(
            int index, com.google.cloud.dialogflow.cx.v3beta1.EventHandler value) {
          if (repromptEventHandlersBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRepromptEventHandlersIsMutable();
            repromptEventHandlers_.add(index, value);
            onChanged();
          } else {
            repromptEventHandlersBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public Builder addRepromptEventHandlers(
            com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder builderForValue) {
          if (repromptEventHandlersBuilder_ == null) {
            ensureRepromptEventHandlersIsMutable();
            repromptEventHandlers_.add(builderForValue.build());
            onChanged();
          } else {
            repromptEventHandlersBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public Builder addRepromptEventHandlers(
            int index,
            com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder builderForValue) {
          if (repromptEventHandlersBuilder_ == null) {
            ensureRepromptEventHandlersIsMutable();
            repromptEventHandlers_.add(index, builderForValue.build());
            onChanged();
          } else {
            repromptEventHandlersBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public Builder addAllRepromptEventHandlers(
            java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.EventHandler>
                values) {
          if (repromptEventHandlersBuilder_ == null) {
            ensureRepromptEventHandlersIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, repromptEventHandlers_);
            onChanged();
          } else {
            repromptEventHandlersBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public Builder clearRepromptEventHandlers() {
          if (repromptEventHandlersBuilder_ == null) {
            repromptEventHandlers_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            repromptEventHandlersBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public Builder removeRepromptEventHandlers(int index) {
          if (repromptEventHandlersBuilder_ == null) {
            ensureRepromptEventHandlersIsMutable();
            repromptEventHandlers_.remove(index);
            onChanged();
          } else {
            repromptEventHandlersBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder
            getRepromptEventHandlersBuilder(int index) {
          return getRepromptEventHandlersFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder
            getRepromptEventHandlersOrBuilder(int index) {
          if (repromptEventHandlersBuilder_ == null) {
            return repromptEventHandlers_.get(index);
          } else {
            return repromptEventHandlersBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>
            getRepromptEventHandlersOrBuilderList() {
          if (repromptEventHandlersBuilder_ != null) {
            return repromptEventHandlersBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(repromptEventHandlers_);
          }
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder
            addRepromptEventHandlersBuilder() {
          return getRepromptEventHandlersFieldBuilder()
              .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.EventHandler.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder
            addRepromptEventHandlersBuilder(int index) {
          return getRepromptEventHandlersFieldBuilder()
              .addBuilder(
                  index, com.google.cloud.dialogflow.cx.v3beta1.EventHandler.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * The handlers for parameter-level events, used to provide reprompt for
         * the parameter or transition to a different page/flow. The supported
         * events are:
         * *   `sys.no-match-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-match-default`
         * *   `sys.no-input-&lt;N&gt;`, where N can be from 1 to 6
         * *   `sys.no-input-default`
         * *   `sys.invalid-parameter`
         *
         * `initial_prompt_fulfillment` provides the first prompt for the
         * parameter.
         *
         * If the user's response does not fill the parameter, a
         * no-match/no-input event will be triggered, and the fulfillment
         * associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
         * defined) will be called to provide a prompt. The
         * `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
         * the next no-match/no-input event, and so on.
         *
         * A `sys.no-match-default` or `sys.no-input-default` handler will be used
         * to handle all following no-match/no-input events after all numbered
         * no-match/no-input handlers for the parameter are consumed.
         *
         * A `sys.invalid-parameter` handler can be defined to handle the case
         * where the parameter values have been `invalidated` by webhook. For
         * example, if the user's response fill the parameter, however the
         * parameter was invalidated by webhook, the fulfillment associated with
         * the `sys.invalid-parameter` handler (if defined) will be called to
         * provide a prompt.
         *
         * If the event handler for the corresponding event can't be found on the
         * parameter, `initial_prompt_fulfillment` will be re-prompted.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler reprompt_event_handlers = 5;
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder>
            getRepromptEventHandlersBuilderList() {
          return getRepromptEventHandlersFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.EventHandler,
                com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>
            getRepromptEventHandlersFieldBuilder() {
          if (repromptEventHandlersBuilder_ == null) {
            repromptEventHandlersBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.cx.v3beta1.EventHandler,
                    com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder,
                    com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>(
                    repromptEventHandlers_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            repromptEventHandlers_ = null;
          }
          return repromptEventHandlersBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FillBehavior> PARSER =
          new com.google.protobuf.AbstractParser<FillBehavior>() {
            @java.lang.Override
            public FillBehavior parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FillBehavior> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FillBehavior> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the parameter, unique within the
     * form.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the parameter, unique within the
     * form.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REQUIRED_FIELD_NUMBER = 2;
    private boolean required_ = false;
    /**
     *
     *
     * <pre>
     * Indicates whether the parameter is required. Optional parameters will not
     * trigger prompts; however, they are filled if the user specifies them.
     * Required parameters must be filled before form filling concludes.
     * </pre>
     *
     * <code>bool required = 2;</code>
     *
     * @return The required.
     */
    @java.lang.Override
    public boolean getRequired() {
      return required_;
    }

    public static final int ENTITY_TYPE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object entityType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The entity type of the parameter.
     * Format:
     * `projects/-/locations/-/agents/-/entityTypes/&lt;SystemEntityTypeID&gt;` for
     * system entity types (for example,
     * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entityTypes/&lt;EntityTypeID&gt;`
     * for developer entity types.
     * </pre>
     *
     * <code>
     * string entity_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The entityType.
     */
    @java.lang.Override
    public java.lang.String getEntityType() {
      java.lang.Object ref = entityType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The entity type of the parameter.
     * Format:
     * `projects/-/locations/-/agents/-/entityTypes/&lt;SystemEntityTypeID&gt;` for
     * system entity types (for example,
     * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entityTypes/&lt;EntityTypeID&gt;`
     * for developer entity types.
     * </pre>
     *
     * <code>
     * string entity_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for entityType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntityTypeBytes() {
      java.lang.Object ref = entityType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IS_LIST_FIELD_NUMBER = 4;
    private boolean isList_ = false;
    /**
     *
     *
     * <pre>
     * Indicates whether the parameter represents a list of values.
     * </pre>
     *
     * <code>bool is_list = 4;</code>
     *
     * @return The isList.
     */
    @java.lang.Override
    public boolean getIsList() {
      return isList_;
    }

    public static final int FILL_BEHAVIOR_FIELD_NUMBER = 7;
    private com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fillBehavior_;
    /**
     *
     *
     * <pre>
     * Required. Defines fill behavior for the parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the fillBehavior field is set.
     */
    @java.lang.Override
    public boolean hasFillBehavior() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Defines fill behavior for the parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fillBehavior.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior getFillBehavior() {
      return fillBehavior_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.getDefaultInstance()
          : fillBehavior_;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines fill behavior for the parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehaviorOrBuilder
        getFillBehaviorOrBuilder() {
      return fillBehavior_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.getDefaultInstance()
          : fillBehavior_;
    }

    public static final int DEFAULT_VALUE_FIELD_NUMBER = 9;
    private com.google.protobuf.Value defaultValue_;
    /**
     *
     *
     * <pre>
     * The default value of an optional parameter. If the parameter is required,
     * the default value will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Value default_value = 9;</code>
     *
     * @return Whether the defaultValue field is set.
     */
    @java.lang.Override
    public boolean hasDefaultValue() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The default value of an optional parameter. If the parameter is required,
     * the default value will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Value default_value = 9;</code>
     *
     * @return The defaultValue.
     */
    @java.lang.Override
    public com.google.protobuf.Value getDefaultValue() {
      return defaultValue_ == null ? com.google.protobuf.Value.getDefaultInstance() : defaultValue_;
    }
    /**
     *
     *
     * <pre>
     * The default value of an optional parameter. If the parameter is required,
     * the default value will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Value default_value = 9;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ValueOrBuilder getDefaultValueOrBuilder() {
      return defaultValue_ == null ? com.google.protobuf.Value.getDefaultInstance() : defaultValue_;
    }

    public static final int REDACT_FIELD_NUMBER = 11;
    private boolean redact_ = false;
    /**
     *
     *
     * <pre>
     * Indicates whether the parameter content should be redacted in log.  If
     * redaction is enabled, the parameter content will be replaced by parameter
     * name during logging.
     * Note: the parameter content is subject to redaction if either parameter
     * level redaction or [entity type level
     * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
     * enabled.
     * </pre>
     *
     * <code>bool redact = 11;</code>
     *
     * @return The redact.
     */
    @java.lang.Override
    public boolean getRedact() {
      return redact_;
    }

    public static final int ADVANCED_SETTINGS_FIELD_NUMBER = 12;
    private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advancedSettings_;
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this parameter. The settings exposed
     * at the lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
     *
     * @return Whether the advancedSettings field is set.
     */
    @java.lang.Override
    public boolean hasAdvancedSettings() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this parameter. The settings exposed
     * at the lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
     *
     * @return The advancedSettings.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getAdvancedSettings() {
      return advancedSettings_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()
          : advancedSettings_;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this parameter. The settings exposed
     * at the lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder
        getAdvancedSettingsOrBuilder() {
      return advancedSettings_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()
          : advancedSettings_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      if (required_ != false) {
        output.writeBool(2, required_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, entityType_);
      }
      if (isList_ != false) {
        output.writeBool(4, isList_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(7, getFillBehavior());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(9, getDefaultValue());
      }
      if (redact_ != false) {
        output.writeBool(11, redact_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(12, getAdvancedSettings());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      if (required_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, required_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, entityType_);
      }
      if (isList_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, isList_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getFillBehavior());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getDefaultValue());
      }
      if (redact_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, redact_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getAdvancedSettings());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter other =
          (com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (getRequired() != other.getRequired()) return false;
      if (!getEntityType().equals(other.getEntityType())) return false;
      if (getIsList() != other.getIsList()) return false;
      if (hasFillBehavior() != other.hasFillBehavior()) return false;
      if (hasFillBehavior()) {
        if (!getFillBehavior().equals(other.getFillBehavior())) return false;
      }
      if (hasDefaultValue() != other.hasDefaultValue()) return false;
      if (hasDefaultValue()) {
        if (!getDefaultValue().equals(other.getDefaultValue())) return false;
      }
      if (getRedact() != other.getRedact()) return false;
      if (hasAdvancedSettings() != other.hasAdvancedSettings()) return false;
      if (hasAdvancedSettings()) {
        if (!getAdvancedSettings().equals(other.getAdvancedSettings())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + REQUIRED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequired());
      hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getEntityType().hashCode();
      hash = (37 * hash) + IS_LIST_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsList());
      if (hasFillBehavior()) {
        hash = (37 * hash) + FILL_BEHAVIOR_FIELD_NUMBER;
        hash = (53 * hash) + getFillBehavior().hashCode();
      }
      if (hasDefaultValue()) {
        hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultValue().hashCode();
      }
      hash = (37 * hash) + REDACT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRedact());
      if (hasAdvancedSettings()) {
        hash = (37 * hash) + ADVANCED_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getAdvancedSettings().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a form parameter.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Form.Parameter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Form.Parameter)
        com.google.cloud.dialogflow.cx.v3beta1.Form.ParameterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.PageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.PageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.class,
                com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFillBehaviorFieldBuilder();
          getDefaultValueFieldBuilder();
          getAdvancedSettingsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        displayName_ = "";
        required_ = false;
        entityType_ = "";
        isList_ = false;
        fillBehavior_ = null;
        if (fillBehaviorBuilder_ != null) {
          fillBehaviorBuilder_.dispose();
          fillBehaviorBuilder_ = null;
        }
        defaultValue_ = null;
        if (defaultValueBuilder_ != null) {
          defaultValueBuilder_.dispose();
          defaultValueBuilder_ = null;
        }
        redact_ = false;
        advancedSettings_ = null;
        if (advancedSettingsBuilder_ != null) {
          advancedSettingsBuilder_.dispose();
          advancedSettingsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.PageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_Parameter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter build() {
        com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter result =
            new com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.required_ = required_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.entityType_ = entityType_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.isList_ = isList_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.fillBehavior_ =
              fillBehaviorBuilder_ == null ? fillBehavior_ : fillBehaviorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.defaultValue_ =
              defaultValueBuilder_ == null ? defaultValue_ : defaultValueBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.redact_ = redact_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.advancedSettings_ =
              advancedSettingsBuilder_ == null
                  ? advancedSettings_
                  : advancedSettingsBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter other) {
        if (other == com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.getDefaultInstance())
          return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getRequired() != false) {
          setRequired(other.getRequired());
        }
        if (!other.getEntityType().isEmpty()) {
          entityType_ = other.entityType_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.getIsList() != false) {
          setIsList(other.getIsList());
        }
        if (other.hasFillBehavior()) {
          mergeFillBehavior(other.getFillBehavior());
        }
        if (other.hasDefaultValue()) {
          mergeDefaultValue(other.getDefaultValue());
        }
        if (other.getRedact() != false) {
          setRedact(other.getRedact());
        }
        if (other.hasAdvancedSettings()) {
          mergeAdvancedSettings(other.getAdvancedSettings());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  required_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  entityType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  isList_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 58:
                {
                  input.readMessage(getFillBehaviorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 58
              case 74:
                {
                  input.readMessage(getDefaultValueFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 74
              case 88:
                {
                  redact_ = input.readBool();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 88
              case 98:
                {
                  input.readMessage(
                      getAdvancedSettingsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 98
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The human-readable name of the parameter, unique within the
       * form.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The human-readable name of the parameter, unique within the
       * form.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The human-readable name of the parameter, unique within the
       * form.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The human-readable name of the parameter, unique within the
       * form.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The human-readable name of the parameter, unique within the
       * form.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean required_;
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter is required. Optional parameters will not
       * trigger prompts; however, they are filled if the user specifies them.
       * Required parameters must be filled before form filling concludes.
       * </pre>
       *
       * <code>bool required = 2;</code>
       *
       * @return The required.
       */
      @java.lang.Override
      public boolean getRequired() {
        return required_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter is required. Optional parameters will not
       * trigger prompts; however, they are filled if the user specifies them.
       * Required parameters must be filled before form filling concludes.
       * </pre>
       *
       * <code>bool required = 2;</code>
       *
       * @param value The required to set.
       * @return This builder for chaining.
       */
      public Builder setRequired(boolean value) {

        required_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter is required. Optional parameters will not
       * trigger prompts; however, they are filled if the user specifies them.
       * Required parameters must be filled before form filling concludes.
       * </pre>
       *
       * <code>bool required = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequired() {
        bitField0_ = (bitField0_ & ~0x00000002);
        required_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object entityType_ = "";
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format:
       * `projects/-/locations/-/agents/-/entityTypes/&lt;SystemEntityTypeID&gt;` for
       * system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entityTypes/&lt;EntityTypeID&gt;`
       * for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The entityType.
       */
      public java.lang.String getEntityType() {
        java.lang.Object ref = entityType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entityType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format:
       * `projects/-/locations/-/agents/-/entityTypes/&lt;SystemEntityTypeID&gt;` for
       * system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entityTypes/&lt;EntityTypeID&gt;`
       * for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for entityType.
       */
      public com.google.protobuf.ByteString getEntityTypeBytes() {
        java.lang.Object ref = entityType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entityType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format:
       * `projects/-/locations/-/agents/-/entityTypes/&lt;SystemEntityTypeID&gt;` for
       * system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entityTypes/&lt;EntityTypeID&gt;`
       * for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The entityType to set.
       * @return This builder for chaining.
       */
      public Builder setEntityType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format:
       * `projects/-/locations/-/agents/-/entityTypes/&lt;SystemEntityTypeID&gt;` for
       * system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entityTypes/&lt;EntityTypeID&gt;`
       * for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntityType() {
        entityType_ = getDefaultInstance().getEntityType();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format:
       * `projects/-/locations/-/agents/-/entityTypes/&lt;SystemEntityTypeID&gt;` for
       * system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/entityTypes/&lt;EntityTypeID&gt;`
       * for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for entityType to set.
       * @return This builder for chaining.
       */
      public Builder setEntityTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        entityType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private boolean isList_;
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter represents a list of values.
       * </pre>
       *
       * <code>bool is_list = 4;</code>
       *
       * @return The isList.
       */
      @java.lang.Override
      public boolean getIsList() {
        return isList_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter represents a list of values.
       * </pre>
       *
       * <code>bool is_list = 4;</code>
       *
       * @param value The isList to set.
       * @return This builder for chaining.
       */
      public Builder setIsList(boolean value) {

        isList_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter represents a list of values.
       * </pre>
       *
       * <code>bool is_list = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsList() {
        bitField0_ = (bitField0_ & ~0x00000008);
        isList_ = false;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fillBehavior_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior,
              com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehaviorOrBuilder>
          fillBehaviorBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Defines fill behavior for the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the fillBehavior field is set.
       */
      public boolean hasFillBehavior() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Defines fill behavior for the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The fillBehavior.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior getFillBehavior() {
        if (fillBehaviorBuilder_ == null) {
          return fillBehavior_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
                  .getDefaultInstance()
              : fillBehavior_;
        } else {
          return fillBehaviorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Defines fill behavior for the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFillBehavior(
          com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior value) {
        if (fillBehaviorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fillBehavior_ = value;
        } else {
          fillBehaviorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Defines fill behavior for the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFillBehavior(
          com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.Builder
              builderForValue) {
        if (fillBehaviorBuilder_ == null) {
          fillBehavior_ = builderForValue.build();
        } else {
          fillBehaviorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Defines fill behavior for the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeFillBehavior(
          com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior value) {
        if (fillBehaviorBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && fillBehavior_ != null
              && fillBehavior_
                  != com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
                      .getDefaultInstance()) {
            getFillBehaviorBuilder().mergeFrom(value);
          } else {
            fillBehavior_ = value;
          }
        } else {
          fillBehaviorBuilder_.mergeFrom(value);
        }
        if (fillBehavior_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Defines fill behavior for the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearFillBehavior() {
        bitField0_ = (bitField0_ & ~0x00000010);
        fillBehavior_ = null;
        if (fillBehaviorBuilder_ != null) {
          fillBehaviorBuilder_.dispose();
          fillBehaviorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Defines fill behavior for the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.Builder
          getFillBehaviorBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getFillBehaviorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Defines fill behavior for the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehaviorOrBuilder
          getFillBehaviorOrBuilder() {
        if (fillBehaviorBuilder_ != null) {
          return fillBehaviorBuilder_.getMessageOrBuilder();
        } else {
          return fillBehavior_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
                  .getDefaultInstance()
              : fillBehavior_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Defines fill behavior for the parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior fill_behavior = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior,
              com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehaviorOrBuilder>
          getFillBehaviorFieldBuilder() {
        if (fillBehaviorBuilder_ == null) {
          fillBehaviorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior,
                  com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehaviorOrBuilder>(
                  getFillBehavior(), getParentForChildren(), isClean());
          fillBehavior_ = null;
        }
        return fillBehaviorBuilder_;
      }

      private com.google.protobuf.Value defaultValue_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          defaultValueBuilder_;
      /**
       *
       *
       * <pre>
       * The default value of an optional parameter. If the parameter is required,
       * the default value will be ignored.
       * </pre>
       *
       * <code>.google.protobuf.Value default_value = 9;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * The default value of an optional parameter. If the parameter is required,
       * the default value will be ignored.
       * </pre>
       *
       * <code>.google.protobuf.Value default_value = 9;</code>
       *
       * @return The defaultValue.
       */
      public com.google.protobuf.Value getDefaultValue() {
        if (defaultValueBuilder_ == null) {
          return defaultValue_ == null
              ? com.google.protobuf.Value.getDefaultInstance()
              : defaultValue_;
        } else {
          return defaultValueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The default value of an optional parameter. If the parameter is required,
       * the default value will be ignored.
       * </pre>
       *
       * <code>.google.protobuf.Value default_value = 9;</code>
       */
      public Builder setDefaultValue(com.google.protobuf.Value value) {
        if (defaultValueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultValue_ = value;
        } else {
          defaultValueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The default value of an optional parameter. If the parameter is required,
       * the default value will be ignored.
       * </pre>
       *
       * <code>.google.protobuf.Value default_value = 9;</code>
       */
      public Builder setDefaultValue(com.google.protobuf.Value.Builder builderForValue) {
        if (defaultValueBuilder_ == null) {
          defaultValue_ = builderForValue.build();
        } else {
          defaultValueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The default value of an optional parameter. If the parameter is required,
       * the default value will be ignored.
       * </pre>
       *
       * <code>.google.protobuf.Value default_value = 9;</code>
       */
      public Builder mergeDefaultValue(com.google.protobuf.Value value) {
        if (defaultValueBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && defaultValue_ != null
              && defaultValue_ != com.google.protobuf.Value.getDefaultInstance()) {
            getDefaultValueBuilder().mergeFrom(value);
          } else {
            defaultValue_ = value;
          }
        } else {
          defaultValueBuilder_.mergeFrom(value);
        }
        if (defaultValue_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The default value of an optional parameter. If the parameter is required,
       * the default value will be ignored.
       * </pre>
       *
       * <code>.google.protobuf.Value default_value = 9;</code>
       */
      public Builder clearDefaultValue() {
        bitField0_ = (bitField0_ & ~0x00000020);
        defaultValue_ = null;
        if (defaultValueBuilder_ != null) {
          defaultValueBuilder_.dispose();
          defaultValueBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The default value of an optional parameter. If the parameter is required,
       * the default value will be ignored.
       * </pre>
       *
       * <code>.google.protobuf.Value default_value = 9;</code>
       */
      public com.google.protobuf.Value.Builder getDefaultValueBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getDefaultValueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The default value of an optional parameter. If the parameter is required,
       * the default value will be ignored.
       * </pre>
       *
       * <code>.google.protobuf.Value default_value = 9;</code>
       */
      public com.google.protobuf.ValueOrBuilder getDefaultValueOrBuilder() {
        if (defaultValueBuilder_ != null) {
          return defaultValueBuilder_.getMessageOrBuilder();
        } else {
          return defaultValue_ == null
              ? com.google.protobuf.Value.getDefaultInstance()
              : defaultValue_;
        }
      }
      /**
       *
       *
       * <pre>
       * The default value of an optional parameter. If the parameter is required,
       * the default value will be ignored.
       * </pre>
       *
       * <code>.google.protobuf.Value default_value = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          getDefaultValueFieldBuilder() {
        if (defaultValueBuilder_ == null) {
          defaultValueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Value,
                  com.google.protobuf.Value.Builder,
                  com.google.protobuf.ValueOrBuilder>(
                  getDefaultValue(), getParentForChildren(), isClean());
          defaultValue_ = null;
        }
        return defaultValueBuilder_;
      }

      private boolean redact_;
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter content should be redacted in log.  If
       * redaction is enabled, the parameter content will be replaced by parameter
       * name during logging.
       * Note: the parameter content is subject to redaction if either parameter
       * level redaction or [entity type level
       * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
       * enabled.
       * </pre>
       *
       * <code>bool redact = 11;</code>
       *
       * @return The redact.
       */
      @java.lang.Override
      public boolean getRedact() {
        return redact_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter content should be redacted in log.  If
       * redaction is enabled, the parameter content will be replaced by parameter
       * name during logging.
       * Note: the parameter content is subject to redaction if either parameter
       * level redaction or [entity type level
       * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
       * enabled.
       * </pre>
       *
       * <code>bool redact = 11;</code>
       *
       * @param value The redact to set.
       * @return This builder for chaining.
       */
      public Builder setRedact(boolean value) {

        redact_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter content should be redacted in log.  If
       * redaction is enabled, the parameter content will be replaced by parameter
       * name during logging.
       * Note: the parameter content is subject to redaction if either parameter
       * level redaction or [entity type level
       * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
       * enabled.
       * </pre>
       *
       * <code>bool redact = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRedact() {
        bitField0_ = (bitField0_ & ~0x00000040);
        redact_ = false;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advancedSettings_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder>
          advancedSettingsBuilder_;
      /**
       *
       *
       * <pre>
       * Hierarchical advanced settings for this parameter. The settings exposed
       * at the lower level overrides the settings exposed at the higher level.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
       *
       * @return Whether the advancedSettings field is set.
       */
      public boolean hasAdvancedSettings() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Hierarchical advanced settings for this parameter. The settings exposed
       * at the lower level overrides the settings exposed at the higher level.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
       *
       * @return The advancedSettings.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getAdvancedSettings() {
        if (advancedSettingsBuilder_ == null) {
          return advancedSettings_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()
              : advancedSettings_;
        } else {
          return advancedSettingsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Hierarchical advanced settings for this parameter. The settings exposed
       * at the lower level overrides the settings exposed at the higher level.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
       */
      public Builder setAdvancedSettings(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings value) {
        if (advancedSettingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          advancedSettings_ = value;
        } else {
          advancedSettingsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hierarchical advanced settings for this parameter. The settings exposed
       * at the lower level overrides the settings exposed at the higher level.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
       */
      public Builder setAdvancedSettings(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder builderForValue) {
        if (advancedSettingsBuilder_ == null) {
          advancedSettings_ = builderForValue.build();
        } else {
          advancedSettingsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hierarchical advanced settings for this parameter. The settings exposed
       * at the lower level overrides the settings exposed at the higher level.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
       */
      public Builder mergeAdvancedSettings(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings value) {
        if (advancedSettingsBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && advancedSettings_ != null
              && advancedSettings_
                  != com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()) {
            getAdvancedSettingsBuilder().mergeFrom(value);
          } else {
            advancedSettings_ = value;
          }
        } else {
          advancedSettingsBuilder_.mergeFrom(value);
        }
        if (advancedSettings_ != null) {
          bitField0_ |= 0x00000080;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hierarchical advanced settings for this parameter. The settings exposed
       * at the lower level overrides the settings exposed at the higher level.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
       */
      public Builder clearAdvancedSettings() {
        bitField0_ = (bitField0_ & ~0x00000080);
        advancedSettings_ = null;
        if (advancedSettingsBuilder_ != null) {
          advancedSettingsBuilder_.dispose();
          advancedSettingsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hierarchical advanced settings for this parameter. The settings exposed
       * at the lower level overrides the settings exposed at the higher level.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder
          getAdvancedSettingsBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getAdvancedSettingsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Hierarchical advanced settings for this parameter. The settings exposed
       * at the lower level overrides the settings exposed at the higher level.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder
          getAdvancedSettingsOrBuilder() {
        if (advancedSettingsBuilder_ != null) {
          return advancedSettingsBuilder_.getMessageOrBuilder();
        } else {
          return advancedSettings_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()
              : advancedSettings_;
        }
      }
      /**
       *
       *
       * <pre>
       * Hierarchical advanced settings for this parameter. The settings exposed
       * at the lower level overrides the settings exposed at the higher level.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 12;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder>
          getAdvancedSettingsFieldBuilder() {
        if (advancedSettingsBuilder_ == null) {
          advancedSettingsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings,
                  com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder>(
                  getAdvancedSettings(), getParentForChildren(), isClean());
          advancedSettings_ = null;
        }
        return advancedSettingsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Form.Parameter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Form.Parameter)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Parameter> PARSER =
        new com.google.protobuf.AbstractParser<Parameter>() {
          @java.lang.Override
          public Parameter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Parameter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Parameter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter> parameters_;
  /**
   *
   *
   * <pre>
   * Parameters to collect from the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter> getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Parameters to collect from the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Form.ParameterOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Parameters to collect from the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Parameters to collect from the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Parameters to collect from the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Form.ParameterOrBuilder getParametersOrBuilder(
      int index) {
    return parameters_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(1, parameters_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, parameters_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Form)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Form other =
        (com.google.cloud.dialogflow.cx.v3beta1.Form) obj;

    if (!getParametersList().equals(other.getParametersList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Form prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A form is a data model that groups related parameters that can be collected
   * from the user. The process in which the agent prompts the user and collects
   * parameter values from the user is called form filling. A form can be added to
   * a [page][google.cloud.dialogflow.cx.v3beta1.Page]. When form filling is done,
   * the filled parameters will be written to the
   * [session][google.cloud.dialogflow.cx.v3beta1.SessionInfo.parameters].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Form}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Form)
      com.google.cloud.dialogflow.cx.v3beta1.FormOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Form.class,
              com.google.cloud.dialogflow.cx.v3beta1.Form.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Form.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Form_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Form getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Form.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Form build() {
      com.google.cloud.dialogflow.cx.v3beta1.Form result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Form buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Form result =
          new com.google.cloud.dialogflow.cx.v3beta1.Form(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dialogflow.cx.v3beta1.Form result) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Form result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Form) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Form) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Form other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Form.getDefaultInstance()) return this;
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000001);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.parser(),
                        extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter> parameters_ =
        java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        parameters_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter>(
                parameters_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter,
            com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Form.ParameterOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter>
        getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public Builder setParameters(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public Builder setParameters(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public Builder addParameters(com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public Builder addParameters(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public Builder addParameters(
        com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public Builder addParameters(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter>
            values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder getParametersBuilder(
        int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Form.ParameterOrBuilder getParametersOrBuilder(
        int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Form.ParameterOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder addParametersBuilder(
        int index) {
      return getParametersFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Parameters to collect from the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Form.Parameter parameters = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter,
            com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Form.ParameterOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter,
                com.google.cloud.dialogflow.cx.v3beta1.Form.Parameter.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Form.ParameterOrBuilder>(
                parameters_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Form)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Form)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Form DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Form();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Form getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Form> PARSER =
      new com.google.protobuf.AbstractParser<Form>() {
        @java.lang.Override
        public Form parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Form> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Form> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Form getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
