/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/environment.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Represents an environment for an agent. You can create multiple versions
 * of your agent and publish them to separate environments. When you edit an
 * agent, you are editing the draft agent. At any point, you can save the draft
 * agent as an agent version, which is an immutable snapshot of your agent. When
 * you save the draft agent, it is published to the default environment. When
 * you create agent versions, you can publish them to custom environments. You
 * can create a variety of custom environments for testing, development,
 * production, etc.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Environment}
 */
public final class Environment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Environment)
    EnvironmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Environment.newBuilder() to construct.
  private Environment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Environment() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    versionConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Environment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Environment.class,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.Builder.class);
  }

  public interface VersionConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Both flow and playbook versions are supported.
     * Format for flow version:
     * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;.
     * Format for playbook version:
     * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/versions/&lt;VersionID&gt;.
     * </pre>
     *
     * <code>
     * string version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * Required. Both flow and playbook versions are supported.
     * Format for flow version:
     * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;.
     * Format for playbook version:
     * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/versions/&lt;VersionID&gt;.
     * </pre>
     *
     * <code>
     * string version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration for the version.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig}
   */
  public static final class VersionConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig)
      VersionConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VersionConfig.newBuilder() to construct.
    private VersionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VersionConfig() {
      version_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VersionConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_VersionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_VersionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.class,
              com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder.class);
    }

    public static final int VERSION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Required. Both flow and playbook versions are supported.
     * Format for flow version:
     * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;.
     * Format for playbook version:
     * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/versions/&lt;VersionID&gt;.
     * </pre>
     *
     * <code>
     * string version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Both flow and playbook versions are supported.
     * Format for flow version:
     * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;.
     * Format for playbook version:
     * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/versions/&lt;VersionID&gt;.
     * </pre>
     *
     * <code>
     * string version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig other =
          (com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig) obj;

      if (!getVersion().equals(other.getVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the version.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig)
        com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_VersionConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_VersionConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        version_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_VersionConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig build() {
        com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig result =
            new com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.version_ = version_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
                .getDefaultInstance()) return this;
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * Required. Both flow and playbook versions are supported.
       * Format for flow version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;.
       * Format for playbook version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/versions/&lt;VersionID&gt;.
       * </pre>
       *
       * <code>
       * string version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Both flow and playbook versions are supported.
       * Format for flow version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;.
       * Format for playbook version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/versions/&lt;VersionID&gt;.
       * </pre>
       *
       * <code>
       * string version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Both flow and playbook versions are supported.
       * Format for flow version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;.
       * Format for playbook version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/versions/&lt;VersionID&gt;.
       * </pre>
       *
       * <code>
       * string version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Both flow and playbook versions are supported.
       * Format for flow version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;.
       * Format for playbook version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/versions/&lt;VersionID&gt;.
       * </pre>
       *
       * <code>
       * string version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Both flow and playbook versions are supported.
       * Format for flow version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;.
       * Format for playbook version:
       * projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/versions/&lt;VersionID&gt;.
       * </pre>
       *
       * <code>
       * string version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VersionConfig> PARSER =
        new com.google.protobuf.AbstractParser<VersionConfig>() {
          @java.lang.Override
          public VersionConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VersionConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VersionConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TestCasesConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of test case names to run. They should be under the same agent.
     * Format of each test case name:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
     * </pre>
     *
     * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the testCases.
     */
    java.util.List<java.lang.String> getTestCasesList();
    /**
     *
     *
     * <pre>
     * A list of test case names to run. They should be under the same agent.
     * Format of each test case name:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
     * </pre>
     *
     * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of testCases.
     */
    int getTestCasesCount();
    /**
     *
     *
     * <pre>
     * A list of test case names to run. They should be under the same agent.
     * Format of each test case name:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
     * </pre>
     *
     * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The testCases at the given index.
     */
    java.lang.String getTestCases(int index);
    /**
     *
     *
     * <pre>
     * A list of test case names to run. They should be under the same agent.
     * Format of each test case name:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
     * </pre>
     *
     * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the testCases at the given index.
     */
    com.google.protobuf.ByteString getTestCasesBytes(int index);

    /**
     *
     *
     * <pre>
     * Whether to run test cases in
     * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
     * periodically. Default false. If set to true, run once a day.
     * </pre>
     *
     * <code>bool enable_continuous_run = 2;</code>
     *
     * @return The enableContinuousRun.
     */
    boolean getEnableContinuousRun();

    /**
     *
     *
     * <pre>
     * Whether to run test cases in
     * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
     * before deploying a flow version to the environment. Default false.
     * </pre>
     *
     * <code>bool enable_predeployment_run = 3;</code>
     *
     * @return The enablePredeploymentRun.
     */
    boolean getEnablePredeploymentRun();
  }
  /**
   *
   *
   * <pre>
   * The configuration for continuous tests.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig}
   */
  public static final class TestCasesConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig)
      TestCasesConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TestCasesConfig.newBuilder() to construct.
    private TestCasesConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TestCasesConfig() {
      testCases_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TestCasesConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_TestCasesConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_TestCasesConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.class,
              com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.Builder.class);
    }

    public static final int TEST_CASES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList testCases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * A list of test case names to run. They should be under the same agent.
     * Format of each test case name:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
     * </pre>
     *
     * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the testCases.
     */
    public com.google.protobuf.ProtocolStringList getTestCasesList() {
      return testCases_;
    }
    /**
     *
     *
     * <pre>
     * A list of test case names to run. They should be under the same agent.
     * Format of each test case name:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
     * </pre>
     *
     * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of testCases.
     */
    public int getTestCasesCount() {
      return testCases_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of test case names to run. They should be under the same agent.
     * Format of each test case name:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
     * </pre>
     *
     * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The testCases at the given index.
     */
    public java.lang.String getTestCases(int index) {
      return testCases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of test case names to run. They should be under the same agent.
     * Format of each test case name:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
     * </pre>
     *
     * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the testCases at the given index.
     */
    public com.google.protobuf.ByteString getTestCasesBytes(int index) {
      return testCases_.getByteString(index);
    }

    public static final int ENABLE_CONTINUOUS_RUN_FIELD_NUMBER = 2;
    private boolean enableContinuousRun_ = false;
    /**
     *
     *
     * <pre>
     * Whether to run test cases in
     * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
     * periodically. Default false. If set to true, run once a day.
     * </pre>
     *
     * <code>bool enable_continuous_run = 2;</code>
     *
     * @return The enableContinuousRun.
     */
    @java.lang.Override
    public boolean getEnableContinuousRun() {
      return enableContinuousRun_;
    }

    public static final int ENABLE_PREDEPLOYMENT_RUN_FIELD_NUMBER = 3;
    private boolean enablePredeploymentRun_ = false;
    /**
     *
     *
     * <pre>
     * Whether to run test cases in
     * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
     * before deploying a flow version to the environment. Default false.
     * </pre>
     *
     * <code>bool enable_predeployment_run = 3;</code>
     *
     * @return The enablePredeploymentRun.
     */
    @java.lang.Override
    public boolean getEnablePredeploymentRun() {
      return enablePredeploymentRun_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < testCases_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, testCases_.getRaw(i));
      }
      if (enableContinuousRun_ != false) {
        output.writeBool(2, enableContinuousRun_);
      }
      if (enablePredeploymentRun_ != false) {
        output.writeBool(3, enablePredeploymentRun_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < testCases_.size(); i++) {
          dataSize += computeStringSizeNoTag(testCases_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTestCasesList().size();
      }
      if (enableContinuousRun_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableContinuousRun_);
      }
      if (enablePredeploymentRun_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enablePredeploymentRun_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig other =
          (com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig) obj;

      if (!getTestCasesList().equals(other.getTestCasesList())) return false;
      if (getEnableContinuousRun() != other.getEnableContinuousRun()) return false;
      if (getEnablePredeploymentRun() != other.getEnablePredeploymentRun()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getTestCasesCount() > 0) {
        hash = (37 * hash) + TEST_CASES_FIELD_NUMBER;
        hash = (53 * hash) + getTestCasesList().hashCode();
      }
      hash = (37 * hash) + ENABLE_CONTINUOUS_RUN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableContinuousRun());
      hash = (37 * hash) + ENABLE_PREDEPLOYMENT_RUN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePredeploymentRun());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The configuration for continuous tests.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig)
        com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_TestCasesConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_TestCasesConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        testCases_ = com.google.protobuf.LazyStringArrayList.emptyList();
        enableContinuousRun_ = false;
        enablePredeploymentRun_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_TestCasesConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig build() {
        com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig result =
            new com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          testCases_.makeImmutable();
          result.testCases_ = testCases_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.enableContinuousRun_ = enableContinuousRun_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.enablePredeploymentRun_ = enablePredeploymentRun_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
                .getDefaultInstance()) return this;
        if (!other.testCases_.isEmpty()) {
          if (testCases_.isEmpty()) {
            testCases_ = other.testCases_;
            bitField0_ |= 0x00000001;
          } else {
            ensureTestCasesIsMutable();
            testCases_.addAll(other.testCases_);
          }
          onChanged();
        }
        if (other.getEnableContinuousRun() != false) {
          setEnableContinuousRun(other.getEnableContinuousRun());
        }
        if (other.getEnablePredeploymentRun() != false) {
          setEnablePredeploymentRun(other.getEnablePredeploymentRun());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTestCasesIsMutable();
                  testCases_.add(s);
                  break;
                } // case 10
              case 16:
                {
                  enableContinuousRun_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  enablePredeploymentRun_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList testCases_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTestCasesIsMutable() {
        if (!testCases_.isModifiable()) {
          testCases_ = new com.google.protobuf.LazyStringArrayList(testCases_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * A list of test case names to run. They should be under the same agent.
       * Format of each test case name:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
       * </pre>
       *
       * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return A list containing the testCases.
       */
      public com.google.protobuf.ProtocolStringList getTestCasesList() {
        testCases_.makeImmutable();
        return testCases_;
      }
      /**
       *
       *
       * <pre>
       * A list of test case names to run. They should be under the same agent.
       * Format of each test case name:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
       * </pre>
       *
       * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The count of testCases.
       */
      public int getTestCasesCount() {
        return testCases_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of test case names to run. They should be under the same agent.
       * Format of each test case name:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
       * </pre>
       *
       * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param index The index of the element to return.
       * @return The testCases at the given index.
       */
      public java.lang.String getTestCases(int index) {
        return testCases_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of test case names to run. They should be under the same agent.
       * Format of each test case name:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
       * </pre>
       *
       * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the testCases at the given index.
       */
      public com.google.protobuf.ByteString getTestCasesBytes(int index) {
        return testCases_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * A list of test case names to run. They should be under the same agent.
       * Format of each test case name:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
       * </pre>
       *
       * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param index The index to set the value at.
       * @param value The testCases to set.
       * @return This builder for chaining.
       */
      public Builder setTestCases(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestCasesIsMutable();
        testCases_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of test case names to run. They should be under the same agent.
       * Format of each test case name:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
       * </pre>
       *
       * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The testCases to add.
       * @return This builder for chaining.
       */
      public Builder addTestCases(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestCasesIsMutable();
        testCases_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of test case names to run. They should be under the same agent.
       * Format of each test case name:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
       * </pre>
       *
       * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param values The testCases to add.
       * @return This builder for chaining.
       */
      public Builder addAllTestCases(java.lang.Iterable<java.lang.String> values) {
        ensureTestCasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, testCases_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of test case names to run. They should be under the same agent.
       * Format of each test case name:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
       * </pre>
       *
       * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTestCases() {
        testCases_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of test case names to run. They should be under the same agent.
       * Format of each test case name:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`
       * </pre>
       *
       * <code>repeated string test_cases = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes of the testCases to add.
       * @return This builder for chaining.
       */
      public Builder addTestCasesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTestCasesIsMutable();
        testCases_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean enableContinuousRun_;
      /**
       *
       *
       * <pre>
       * Whether to run test cases in
       * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
       * periodically. Default false. If set to true, run once a day.
       * </pre>
       *
       * <code>bool enable_continuous_run = 2;</code>
       *
       * @return The enableContinuousRun.
       */
      @java.lang.Override
      public boolean getEnableContinuousRun() {
        return enableContinuousRun_;
      }
      /**
       *
       *
       * <pre>
       * Whether to run test cases in
       * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
       * periodically. Default false. If set to true, run once a day.
       * </pre>
       *
       * <code>bool enable_continuous_run = 2;</code>
       *
       * @param value The enableContinuousRun to set.
       * @return This builder for chaining.
       */
      public Builder setEnableContinuousRun(boolean value) {

        enableContinuousRun_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to run test cases in
       * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
       * periodically. Default false. If set to true, run once a day.
       * </pre>
       *
       * <code>bool enable_continuous_run = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableContinuousRun() {
        bitField0_ = (bitField0_ & ~0x00000002);
        enableContinuousRun_ = false;
        onChanged();
        return this;
      }

      private boolean enablePredeploymentRun_;
      /**
       *
       *
       * <pre>
       * Whether to run test cases in
       * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
       * before deploying a flow version to the environment. Default false.
       * </pre>
       *
       * <code>bool enable_predeployment_run = 3;</code>
       *
       * @return The enablePredeploymentRun.
       */
      @java.lang.Override
      public boolean getEnablePredeploymentRun() {
        return enablePredeploymentRun_;
      }
      /**
       *
       *
       * <pre>
       * Whether to run test cases in
       * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
       * before deploying a flow version to the environment. Default false.
       * </pre>
       *
       * <code>bool enable_predeployment_run = 3;</code>
       *
       * @param value The enablePredeploymentRun to set.
       * @return This builder for chaining.
       */
      public Builder setEnablePredeploymentRun(boolean value) {

        enablePredeploymentRun_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to run test cases in
       * [TestCasesConfig.test_cases][google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.test_cases]
       * before deploying a flow version to the environment. Default false.
       * </pre>
       *
       * <code>bool enable_predeployment_run = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnablePredeploymentRun() {
        bitField0_ = (bitField0_ & ~0x00000004);
        enablePredeploymentRun_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TestCasesConfig> PARSER =
        new com.google.protobuf.AbstractParser<TestCasesConfig>() {
          @java.lang.Override
          public TestCasesConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TestCasesConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TestCasesConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WebhookConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Webhook> getWebhookOverridesList();
    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Webhook getWebhookOverrides(int index);
    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    int getWebhookOverridesCount();
    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder>
        getWebhookOverridesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder getWebhookOverridesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration for webhooks.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig}
   */
  public static final class WebhookConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig)
      WebhookConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WebhookConfig.newBuilder() to construct.
    private WebhookConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WebhookConfig() {
      webhookOverrides_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WebhookConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_WebhookConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_WebhookConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.class,
              com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.Builder.class);
    }

    public static final int WEBHOOK_OVERRIDES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Webhook> webhookOverrides_;
    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Webhook>
        getWebhookOverridesList() {
      return webhookOverrides_;
    }
    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder>
        getWebhookOverridesOrBuilderList() {
      return webhookOverrides_;
    }
    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    @java.lang.Override
    public int getWebhookOverridesCount() {
      return webhookOverrides_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook getWebhookOverrides(int index) {
      return webhookOverrides_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhooks to override for the agent environment. The webhook
     * must exist in the agent. You can override fields in
     * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
     * and
     * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder getWebhookOverridesOrBuilder(
        int index) {
      return webhookOverrides_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < webhookOverrides_.size(); i++) {
        output.writeMessage(1, webhookOverrides_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < webhookOverrides_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, webhookOverrides_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig other =
          (com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig) obj;

      if (!getWebhookOverridesList().equals(other.getWebhookOverridesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getWebhookOverridesCount() > 0) {
        hash = (37 * hash) + WEBHOOK_OVERRIDES_FIELD_NUMBER;
        hash = (53 * hash) + getWebhookOverridesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for webhooks.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig)
        com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_WebhookConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_WebhookConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (webhookOverridesBuilder_ == null) {
          webhookOverrides_ = java.util.Collections.emptyList();
        } else {
          webhookOverrides_ = null;
          webhookOverridesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_WebhookConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig build() {
        com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig result =
            new com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig result) {
        if (webhookOverridesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            webhookOverrides_ = java.util.Collections.unmodifiableList(webhookOverrides_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.webhookOverrides_ = webhookOverrides_;
        } else {
          result.webhookOverrides_ = webhookOverridesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig
                .getDefaultInstance()) return this;
        if (webhookOverridesBuilder_ == null) {
          if (!other.webhookOverrides_.isEmpty()) {
            if (webhookOverrides_.isEmpty()) {
              webhookOverrides_ = other.webhookOverrides_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureWebhookOverridesIsMutable();
              webhookOverrides_.addAll(other.webhookOverrides_);
            }
            onChanged();
          }
        } else {
          if (!other.webhookOverrides_.isEmpty()) {
            if (webhookOverridesBuilder_.isEmpty()) {
              webhookOverridesBuilder_.dispose();
              webhookOverridesBuilder_ = null;
              webhookOverrides_ = other.webhookOverrides_;
              bitField0_ = (bitField0_ & ~0x00000001);
              webhookOverridesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getWebhookOverridesFieldBuilder()
                      : null;
            } else {
              webhookOverridesBuilder_.addAllMessages(other.webhookOverrides_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.Webhook m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.Webhook.parser(),
                          extensionRegistry);
                  if (webhookOverridesBuilder_ == null) {
                    ensureWebhookOverridesIsMutable();
                    webhookOverrides_.add(m);
                  } else {
                    webhookOverridesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Webhook> webhookOverrides_ =
          java.util.Collections.emptyList();

      private void ensureWebhookOverridesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          webhookOverrides_ =
              new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Webhook>(
                  webhookOverrides_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Webhook,
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder>
          webhookOverridesBuilder_;

      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Webhook>
          getWebhookOverridesList() {
        if (webhookOverridesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(webhookOverrides_);
        } else {
          return webhookOverridesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public int getWebhookOverridesCount() {
        if (webhookOverridesBuilder_ == null) {
          return webhookOverrides_.size();
        } else {
          return webhookOverridesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook getWebhookOverrides(int index) {
        if (webhookOverridesBuilder_ == null) {
          return webhookOverrides_.get(index);
        } else {
          return webhookOverridesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public Builder setWebhookOverrides(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Webhook value) {
        if (webhookOverridesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWebhookOverridesIsMutable();
          webhookOverrides_.set(index, value);
          onChanged();
        } else {
          webhookOverridesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public Builder setWebhookOverrides(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder builderForValue) {
        if (webhookOverridesBuilder_ == null) {
          ensureWebhookOverridesIsMutable();
          webhookOverrides_.set(index, builderForValue.build());
          onChanged();
        } else {
          webhookOverridesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public Builder addWebhookOverrides(com.google.cloud.dialogflow.cx.v3beta1.Webhook value) {
        if (webhookOverridesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWebhookOverridesIsMutable();
          webhookOverrides_.add(value);
          onChanged();
        } else {
          webhookOverridesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public Builder addWebhookOverrides(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Webhook value) {
        if (webhookOverridesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWebhookOverridesIsMutable();
          webhookOverrides_.add(index, value);
          onChanged();
        } else {
          webhookOverridesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public Builder addWebhookOverrides(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder builderForValue) {
        if (webhookOverridesBuilder_ == null) {
          ensureWebhookOverridesIsMutable();
          webhookOverrides_.add(builderForValue.build());
          onChanged();
        } else {
          webhookOverridesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public Builder addWebhookOverrides(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder builderForValue) {
        if (webhookOverridesBuilder_ == null) {
          ensureWebhookOverridesIsMutable();
          webhookOverrides_.add(index, builderForValue.build());
          onChanged();
        } else {
          webhookOverridesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public Builder addAllWebhookOverrides(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Webhook> values) {
        if (webhookOverridesBuilder_ == null) {
          ensureWebhookOverridesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webhookOverrides_);
          onChanged();
        } else {
          webhookOverridesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public Builder clearWebhookOverrides() {
        if (webhookOverridesBuilder_ == null) {
          webhookOverrides_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          webhookOverridesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public Builder removeWebhookOverrides(int index) {
        if (webhookOverridesBuilder_ == null) {
          ensureWebhookOverridesIsMutable();
          webhookOverrides_.remove(index);
          onChanged();
        } else {
          webhookOverridesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder getWebhookOverridesBuilder(
          int index) {
        return getWebhookOverridesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder getWebhookOverridesOrBuilder(
          int index) {
        if (webhookOverridesBuilder_ == null) {
          return webhookOverrides_.get(index);
        } else {
          return webhookOverridesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder>
          getWebhookOverridesOrBuilderList() {
        if (webhookOverridesBuilder_ != null) {
          return webhookOverridesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(webhookOverrides_);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder addWebhookOverridesBuilder() {
        return getWebhookOverridesFieldBuilder()
            .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Webhook.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder addWebhookOverridesBuilder(
          int index) {
        return getWebhookOverridesFieldBuilder()
            .addBuilder(index, com.google.cloud.dialogflow.cx.v3beta1.Webhook.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of webhooks to override for the agent environment. The webhook
       * must exist in the agent. You can override fields in
       * [`generic_web_service`][google.cloud.dialogflow.cx.v3beta1.Webhook.generic_web_service]
       * and
       * [`service_directory`][google.cloud.dialogflow.cx.v3beta1.Webhook.service_directory].
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Webhook webhook_overrides = 1;</code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder>
          getWebhookOverridesBuilderList() {
        return getWebhookOverridesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Webhook,
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder>
          getWebhookOverridesFieldBuilder() {
        if (webhookOverridesBuilder_ == null) {
          webhookOverridesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Webhook,
                  com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder>(
                  webhookOverrides_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          webhookOverrides_ = null;
        }
        return webhookOverridesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WebhookConfig> PARSER =
        new com.google.protobuf.AbstractParser<WebhookConfig>() {
          @java.lang.Override
          public WebhookConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WebhookConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WebhookConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the environment.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the environment.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the environment (unique in an agent).
   * Limit of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the environment (unique in an agent).
   * Limit of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The human-readable description of the environment. The maximum length is
   * 500 characters. If exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human-readable description of the environment. The maximum length is
   * 500 characters. If exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_CONFIGS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig>
      versionConfigs_;
  /**
   *
   *
   * <pre>
   * A list of configurations for flow versions. You should include version
   * configs for all flows that are reachable from [`Start
   * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
   * returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig>
      getVersionConfigsList() {
    return versionConfigs_;
  }
  /**
   *
   *
   * <pre>
   * A list of configurations for flow versions. You should include version
   * configs for all flows that are reachable from [`Start
   * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
   * returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfigOrBuilder>
      getVersionConfigsOrBuilderList() {
    return versionConfigs_;
  }
  /**
   *
   *
   * <pre>
   * A list of configurations for flow versions. You should include version
   * configs for all flows that are reachable from [`Start
   * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
   * returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
   * </code>
   */
  @java.lang.Override
  public int getVersionConfigsCount() {
    return versionConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of configurations for flow versions. You should include version
   * configs for all flows that are reachable from [`Start
   * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
   * returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig getVersionConfigs(
      int index) {
    return versionConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of configurations for flow versions. You should include version
   * configs for all flows that are reachable from [`Start
   * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
   * returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfigOrBuilder
      getVersionConfigsOrBuilder(int index) {
    return versionConfigs_.get(index);
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Update time of this environment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time of this environment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time of this environment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int TEST_CASES_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig testCasesConfig_;
  /**
   *
   *
   * <pre>
   * The test cases config for continuous tests of this environment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
   * </code>
   *
   * @return Whether the testCasesConfig field is set.
   */
  @java.lang.Override
  public boolean hasTestCasesConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The test cases config for continuous tests of this environment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
   * </code>
   *
   * @return The testCasesConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig getTestCasesConfig() {
    return testCasesConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.getDefaultInstance()
        : testCasesConfig_;
  }
  /**
   *
   *
   * <pre>
   * The test cases config for continuous tests of this environment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfigOrBuilder
      getTestCasesConfigOrBuilder() {
    return testCasesConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.getDefaultInstance()
        : testCasesConfig_;
  }

  public static final int WEBHOOK_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhookConfig_;
  /**
   *
   *
   * <pre>
   * The webhook configuration for this environment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;</code>
   *
   * @return Whether the webhookConfig field is set.
   */
  @java.lang.Override
  public boolean hasWebhookConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The webhook configuration for this environment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;</code>
   *
   * @return The webhookConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig getWebhookConfig() {
    return webhookConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.getDefaultInstance()
        : webhookConfig_;
  }
  /**
   *
   *
   * <pre>
   * The webhook configuration for this environment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfigOrBuilder
      getWebhookConfigOrBuilder() {
    return webhookConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.getDefaultInstance()
        : webhookConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getUpdateTime());
    }
    for (int i = 0; i < versionConfigs_.size(); i++) {
      output.writeMessage(6, versionConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getTestCasesConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getWebhookConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    for (int i = 0; i < versionConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, versionConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTestCasesConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getWebhookConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Environment)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Environment other =
        (com.google.cloud.dialogflow.cx.v3beta1.Environment) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getVersionConfigsList().equals(other.getVersionConfigsList())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasTestCasesConfig() != other.hasTestCasesConfig()) return false;
    if (hasTestCasesConfig()) {
      if (!getTestCasesConfig().equals(other.getTestCasesConfig())) return false;
    }
    if (hasWebhookConfig() != other.hasWebhookConfig()) return false;
    if (hasWebhookConfig()) {
      if (!getWebhookConfig().equals(other.getWebhookConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getVersionConfigsCount() > 0) {
      hash = (37 * hash) + VERSION_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getVersionConfigsList().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasTestCasesConfig()) {
      hash = (37 * hash) + TEST_CASES_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getTestCasesConfig().hashCode();
    }
    if (hasWebhookConfig()) {
      hash = (37 * hash) + WEBHOOK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Environment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an environment for an agent. You can create multiple versions
   * of your agent and publish them to separate environments. When you edit an
   * agent, you are editing the draft agent. At any point, you can save the draft
   * agent as an agent version, which is an immutable snapshot of your agent. When
   * you save the draft agent, it is published to the default environment. When
   * you create agent versions, you can publish them to custom environments. You
   * can create a variety of custom environments for testing, development,
   * production, etc.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Environment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Environment)
      com.google.cloud.dialogflow.cx.v3beta1.EnvironmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Environment.class,
              com.google.cloud.dialogflow.cx.v3beta1.Environment.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Environment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVersionConfigsFieldBuilder();
        getUpdateTimeFieldBuilder();
        getTestCasesConfigFieldBuilder();
        getWebhookConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      if (versionConfigsBuilder_ == null) {
        versionConfigs_ = java.util.Collections.emptyList();
      } else {
        versionConfigs_ = null;
        versionConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      testCasesConfig_ = null;
      if (testCasesConfigBuilder_ != null) {
        testCasesConfigBuilder_.dispose();
        testCasesConfigBuilder_ = null;
      }
      webhookConfig_ = null;
      if (webhookConfigBuilder_ != null) {
        webhookConfigBuilder_.dispose();
        webhookConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Environment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Environment getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Environment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Environment build() {
      com.google.cloud.dialogflow.cx.v3beta1.Environment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Environment buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Environment result =
          new com.google.cloud.dialogflow.cx.v3beta1.Environment(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.Environment result) {
      if (versionConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          versionConfigs_ = java.util.Collections.unmodifiableList(versionConfigs_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.versionConfigs_ = versionConfigs_;
      } else {
        result.versionConfigs_ = versionConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Environment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.testCasesConfig_ =
            testCasesConfigBuilder_ == null ? testCasesConfig_ : testCasesConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.webhookConfig_ =
            webhookConfigBuilder_ == null ? webhookConfig_ : webhookConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Environment) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Environment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Environment other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Environment.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (versionConfigsBuilder_ == null) {
        if (!other.versionConfigs_.isEmpty()) {
          if (versionConfigs_.isEmpty()) {
            versionConfigs_ = other.versionConfigs_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureVersionConfigsIsMutable();
            versionConfigs_.addAll(other.versionConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.versionConfigs_.isEmpty()) {
          if (versionConfigsBuilder_.isEmpty()) {
            versionConfigsBuilder_.dispose();
            versionConfigsBuilder_ = null;
            versionConfigs_ = other.versionConfigs_;
            bitField0_ = (bitField0_ & ~0x00000008);
            versionConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVersionConfigsFieldBuilder()
                    : null;
          } else {
            versionConfigsBuilder_.addAllMessages(other.versionConfigs_);
          }
        }
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasTestCasesConfig()) {
        mergeTestCasesConfig(other.getTestCasesConfig());
      }
      if (other.hasWebhookConfig()) {
        mergeWebhookConfig(other.getWebhookConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.parser(),
                        extensionRegistry);
                if (versionConfigsBuilder_ == null) {
                  ensureVersionConfigsIsMutable();
                  versionConfigs_.add(m);
                } else {
                  versionConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getTestCasesConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 82:
              {
                input.readMessage(getWebhookConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the environment.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the environment.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the environment.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the environment.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the environment.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the environment (unique in an agent).
     * Limit of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the environment (unique in an agent).
     * Limit of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the environment (unique in an agent).
     * Limit of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the environment (unique in an agent).
     * Limit of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the environment (unique in an agent).
     * Limit of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The human-readable description of the environment. The maximum length is
     * 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable description of the environment. The maximum length is
     * 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable description of the environment. The maximum length is
     * 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable description of the environment. The maximum length is
     * 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable description of the environment. The maximum length is
     * 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig>
        versionConfigs_ = java.util.Collections.emptyList();

    private void ensureVersionConfigsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        versionConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig>(versionConfigs_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfigOrBuilder>
        versionConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig>
        getVersionConfigsList() {
      if (versionConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(versionConfigs_);
      } else {
        return versionConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public int getVersionConfigsCount() {
      if (versionConfigsBuilder_ == null) {
        return versionConfigs_.size();
      } else {
        return versionConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig getVersionConfigs(
        int index) {
      if (versionConfigsBuilder_ == null) {
        return versionConfigs_.get(index);
      } else {
        return versionConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public Builder setVersionConfigs(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig value) {
      if (versionConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionConfigsIsMutable();
        versionConfigs_.set(index, value);
        onChanged();
      } else {
        versionConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public Builder setVersionConfigs(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder builderForValue) {
      if (versionConfigsBuilder_ == null) {
        ensureVersionConfigsIsMutable();
        versionConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        versionConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public Builder addVersionConfigs(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig value) {
      if (versionConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionConfigsIsMutable();
        versionConfigs_.add(value);
        onChanged();
      } else {
        versionConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public Builder addVersionConfigs(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig value) {
      if (versionConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionConfigsIsMutable();
        versionConfigs_.add(index, value);
        onChanged();
      } else {
        versionConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public Builder addVersionConfigs(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder builderForValue) {
      if (versionConfigsBuilder_ == null) {
        ensureVersionConfigsIsMutable();
        versionConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        versionConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public Builder addVersionConfigs(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder builderForValue) {
      if (versionConfigsBuilder_ == null) {
        ensureVersionConfigsIsMutable();
        versionConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        versionConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public Builder addAllVersionConfigs(
        java.lang.Iterable<
                ? extends com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig>
            values) {
      if (versionConfigsBuilder_ == null) {
        ensureVersionConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, versionConfigs_);
        onChanged();
      } else {
        versionConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public Builder clearVersionConfigs() {
      if (versionConfigsBuilder_ == null) {
        versionConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        versionConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public Builder removeVersionConfigs(int index) {
      if (versionConfigsBuilder_ == null) {
        ensureVersionConfigsIsMutable();
        versionConfigs_.remove(index);
        onChanged();
      } else {
        versionConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder
        getVersionConfigsBuilder(int index) {
      return getVersionConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfigOrBuilder
        getVersionConfigsOrBuilder(int index) {
      if (versionConfigsBuilder_ == null) {
        return versionConfigs_.get(index);
      } else {
        return versionConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfigOrBuilder>
        getVersionConfigsOrBuilderList() {
      if (versionConfigsBuilder_ != null) {
        return versionConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(versionConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder
        addVersionConfigsBuilder() {
      return getVersionConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder
        addVersionConfigsBuilder(int index) {
      return getVersionConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of configurations for flow versions. You should include version
     * configs for all flows that are reachable from [`Start
     * Flow`][Agent.start_flow] in the agent. Otherwise, an error will be
     * returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig version_configs = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder>
        getVersionConfigsBuilderList() {
      return getVersionConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfigOrBuilder>
        getVersionConfigsFieldBuilder() {
      if (versionConfigsBuilder_ == null) {
        versionConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfig.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.VersionConfigOrBuilder>(
                versionConfigs_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        versionConfigs_ = null;
      }
      return versionConfigsBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Update time of this environment.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this environment.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this environment.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this environment.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this environment.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this environment.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this environment.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this environment.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this environment.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig testCasesConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfigOrBuilder>
        testCasesConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The test cases config for continuous tests of this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
     * </code>
     *
     * @return Whether the testCasesConfig field is set.
     */
    public boolean hasTestCasesConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The test cases config for continuous tests of this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
     * </code>
     *
     * @return The testCasesConfig.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig getTestCasesConfig() {
      if (testCasesConfigBuilder_ == null) {
        return testCasesConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
                .getDefaultInstance()
            : testCasesConfig_;
      } else {
        return testCasesConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The test cases config for continuous tests of this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
     * </code>
     */
    public Builder setTestCasesConfig(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig value) {
      if (testCasesConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        testCasesConfig_ = value;
      } else {
        testCasesConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The test cases config for continuous tests of this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
     * </code>
     */
    public Builder setTestCasesConfig(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.Builder
            builderForValue) {
      if (testCasesConfigBuilder_ == null) {
        testCasesConfig_ = builderForValue.build();
      } else {
        testCasesConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The test cases config for continuous tests of this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
     * </code>
     */
    public Builder mergeTestCasesConfig(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig value) {
      if (testCasesConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && testCasesConfig_ != null
            && testCasesConfig_
                != com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
                    .getDefaultInstance()) {
          getTestCasesConfigBuilder().mergeFrom(value);
        } else {
          testCasesConfig_ = value;
        }
      } else {
        testCasesConfigBuilder_.mergeFrom(value);
      }
      if (testCasesConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The test cases config for continuous tests of this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
     * </code>
     */
    public Builder clearTestCasesConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      testCasesConfig_ = null;
      if (testCasesConfigBuilder_ != null) {
        testCasesConfigBuilder_.dispose();
        testCasesConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The test cases config for continuous tests of this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.Builder
        getTestCasesConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTestCasesConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The test cases config for continuous tests of this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfigOrBuilder
        getTestCasesConfigOrBuilder() {
      if (testCasesConfigBuilder_ != null) {
        return testCasesConfigBuilder_.getMessageOrBuilder();
      } else {
        return testCasesConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig
                .getDefaultInstance()
            : testCasesConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The test cases config for continuous tests of this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig test_cases_config = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfigOrBuilder>
        getTestCasesConfigFieldBuilder() {
      if (testCasesConfigBuilder_ == null) {
        testCasesConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfig.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.TestCasesConfigOrBuilder>(
                getTestCasesConfig(), getParentForChildren(), isClean());
        testCasesConfig_ = null;
      }
      return testCasesConfigBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhookConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfigOrBuilder>
        webhookConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The webhook configuration for this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;
     * </code>
     *
     * @return Whether the webhookConfig field is set.
     */
    public boolean hasWebhookConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The webhook configuration for this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;
     * </code>
     *
     * @return The webhookConfig.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig getWebhookConfig() {
      if (webhookConfigBuilder_ == null) {
        return webhookConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.getDefaultInstance()
            : webhookConfig_;
      } else {
        return webhookConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The webhook configuration for this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;
     * </code>
     */
    public Builder setWebhookConfig(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig value) {
      if (webhookConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhookConfig_ = value;
      } else {
        webhookConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The webhook configuration for this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;
     * </code>
     */
    public Builder setWebhookConfig(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.Builder builderForValue) {
      if (webhookConfigBuilder_ == null) {
        webhookConfig_ = builderForValue.build();
      } else {
        webhookConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The webhook configuration for this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;
     * </code>
     */
    public Builder mergeWebhookConfig(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig value) {
      if (webhookConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && webhookConfig_ != null
            && webhookConfig_
                != com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig
                    .getDefaultInstance()) {
          getWebhookConfigBuilder().mergeFrom(value);
        } else {
          webhookConfig_ = value;
        }
      } else {
        webhookConfigBuilder_.mergeFrom(value);
      }
      if (webhookConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The webhook configuration for this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;
     * </code>
     */
    public Builder clearWebhookConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      webhookConfig_ = null;
      if (webhookConfigBuilder_ != null) {
        webhookConfigBuilder_.dispose();
        webhookConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The webhook configuration for this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.Builder
        getWebhookConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getWebhookConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The webhook configuration for this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfigOrBuilder
        getWebhookConfigOrBuilder() {
      if (webhookConfigBuilder_ != null) {
        return webhookConfigBuilder_.getMessageOrBuilder();
      } else {
        return webhookConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.getDefaultInstance()
            : webhookConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The webhook configuration for this environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig webhook_config = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfigOrBuilder>
        getWebhookConfigFieldBuilder() {
      if (webhookConfigBuilder_ == null) {
        webhookConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfig.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.WebhookConfigOrBuilder>(
                getWebhookConfig(), getParentForChildren(), isClean());
        webhookConfig_ = null;
      }
      return webhookConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Environment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Environment)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Environment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Environment();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Environment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Environment> PARSER =
      new com.google.protobuf.AbstractParser<Environment>() {
        @java.lang.Override
        public Environment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Environment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Environment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Environment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
