/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/conversation_history.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

public interface ConversationOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Conversation)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Identifier. The identifier of the conversation.
   * If conversation ID is reused, interactions happened later than 48 hours of
   * the conversation's create time will be ignored. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/conversations/&lt;ConversationID&gt;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Identifier. The identifier of the conversation.
   * If conversation ID is reused, interactions happened later than 48 hours of
   * the conversation's create time will be ignored. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/conversations/&lt;ConversationID&gt;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The type of the conversation.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Type type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  int getTypeValue();
  /**
   *
   *
   * <pre>
   * The type of the conversation.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Type type = 2;</code>
   *
   * @return The type.
   */
  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type getType();

  /**
   *
   *
   * <pre>
   * The language of the conversation, which is the language of the first
   * request in the conversation.
   * </pre>
   *
   * <code>string language_code = 3;</code>
   *
   * @return The languageCode.
   */
  java.lang.String getLanguageCode();
  /**
   *
   *
   * <pre>
   * The language of the conversation, which is the language of the first
   * request in the conversation.
   * </pre>
   *
   * <code>string language_code = 3;</code>
   *
   * @return The bytes for languageCode.
   */
  com.google.protobuf.ByteString getLanguageCodeBytes();

  /**
   *
   *
   * <pre>
   * Start time of the conversation, which is the time of the first request of
   * the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return Whether the startTime field is set.
   */
  boolean hasStartTime();
  /**
   *
   *
   * <pre>
   * Start time of the conversation, which is the time of the first request of
   * the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return The startTime.
   */
  com.google.protobuf.Timestamp getStartTime();
  /**
   *
   *
   * <pre>
   * Start time of the conversation, which is the time of the first request of
   * the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   */
  com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Duration of the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 5;</code>
   *
   * @return Whether the duration field is set.
   */
  boolean hasDuration();
  /**
   *
   *
   * <pre>
   * Duration of the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 5;</code>
   *
   * @return The duration.
   */
  com.google.protobuf.Duration getDuration();
  /**
   *
   *
   * <pre>
   * Duration of the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 5;</code>
   */
  com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Conversation metrics.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
   *
   * @return Whether the metrics field is set.
   */
  boolean hasMetrics();
  /**
   *
   *
   * <pre>
   * Conversation metrics.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
   *
   * @return The metrics.
   */
  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics getMetrics();
  /**
   *
   *
   * <pre>
   * Conversation metrics.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.Conversation.MetricsOrBuilder getMetricsOrBuilder();

  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent> getIntentsList();
  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.Intent getIntents(int index);
  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  int getIntentsCount();
  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder>
      getIntentsOrBuilderList();
  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder getIntentsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Flow> getFlowsList();
  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.Flow getFlows(int index);
  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  int getFlowsCount();
  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder>
      getFlowsOrBuilderList();
  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder getFlowsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Page> getPagesList();
  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.Page getPages(int index);
  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  int getPagesCount();
  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder>
      getPagesOrBuilderList();
  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder getPagesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction>
      getInteractionsList();
  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction getInteractions(int index);
  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  int getInteractionsCount();
  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder>
      getInteractionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder getInteractionsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Environment of the conversation.
   * Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
   *
   * @return Whether the environment field is set.
   */
  boolean hasEnvironment();
  /**
   *
   *
   * <pre>
   * Environment of the conversation.
   * Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
   *
   * @return The environment.
   */
  com.google.cloud.dialogflow.cx.v3beta1.Environment getEnvironment();
  /**
   *
   *
   * <pre>
   * Environment of the conversation.
   * Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.EnvironmentOrBuilder getEnvironmentOrBuilder();

  /**
   *
   *
   * <pre>
   * Flow versions used in the conversation.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
   */
  int getFlowVersionsCount();
  /**
   *
   *
   * <pre>
   * Flow versions used in the conversation.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
   */
  boolean containsFlowVersions(java.lang.String key);
  /** Use {@link #getFlowVersionsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.Long> getFlowVersions();
  /**
   *
   *
   * <pre>
   * Flow versions used in the conversation.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
   */
  java.util.Map<java.lang.String, java.lang.Long> getFlowVersionsMap();
  /**
   *
   *
   * <pre>
   * Flow versions used in the conversation.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
   */
  long getFlowVersionsOrDefault(java.lang.String key, long defaultValue);
  /**
   *
   *
   * <pre>
   * Flow versions used in the conversation.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
   */
  long getFlowVersionsOrThrow(java.lang.String key);
}
