/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/test_case.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * The response message for
 * [TestCases.CalculateCoverage][google.cloud.dialogflow.cx.v3beta1.TestCases.CalculateCoverage].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse}
 */
public final class CalculateCoverageResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse)
    CalculateCoverageResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CalculateCoverageResponse.newBuilder() to construct.
  private CalculateCoverageResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CalculateCoverageResponse() {
    agent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CalculateCoverageResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_CalculateCoverageResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_CalculateCoverageResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.class,
            com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.Builder.class);
  }

  private int coverageTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object coverageType_;

  public enum CoverageTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INTENT_COVERAGE(2),
    TRANSITION_COVERAGE(4),
    ROUTE_GROUP_COVERAGE(6),
    COVERAGETYPE_NOT_SET(0);
    private final int value;

    private CoverageTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CoverageTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static CoverageTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return INTENT_COVERAGE;
        case 4:
          return TRANSITION_COVERAGE;
        case 6:
          return ROUTE_GROUP_COVERAGE;
        case 0:
          return COVERAGETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CoverageTypeCase getCoverageTypeCase() {
    return CoverageTypeCase.forNumber(coverageTypeCase_);
  }

  public static final int AGENT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object agent_ = "";
  /**
   *
   *
   * <pre>
   * The agent to calculate coverage for.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>string agent = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The agent.
   */
  @java.lang.Override
  public java.lang.String getAgent() {
    java.lang.Object ref = agent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The agent to calculate coverage for.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>string agent = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for agent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentBytes() {
    java.lang.Object ref = agent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTENT_COVERAGE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Intent coverage.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
   *
   * @return Whether the intentCoverage field is set.
   */
  @java.lang.Override
  public boolean hasIntentCoverage() {
    return coverageTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Intent coverage.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
   *
   * @return The intentCoverage.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage getIntentCoverage() {
    if (coverageTypeCase_ == 2) {
      return (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) coverageType_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Intent coverage.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverageOrBuilder
      getIntentCoverageOrBuilder() {
    if (coverageTypeCase_ == 2) {
      return (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) coverageType_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.getDefaultInstance();
  }

  public static final int TRANSITION_COVERAGE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Transition (excluding transition route groups) coverage.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
   *
   * @return Whether the transitionCoverage field is set.
   */
  @java.lang.Override
  public boolean hasTransitionCoverage() {
    return coverageTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Transition (excluding transition route groups) coverage.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
   *
   * @return The transitionCoverage.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage getTransitionCoverage() {
    if (coverageTypeCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage) coverageType_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Transition (excluding transition route groups) coverage.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverageOrBuilder
      getTransitionCoverageOrBuilder() {
    if (coverageTypeCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage) coverageType_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.getDefaultInstance();
  }

  public static final int ROUTE_GROUP_COVERAGE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Transition route group coverage.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
   * </code>
   *
   * @return Whether the routeGroupCoverage field is set.
   */
  @java.lang.Override
  public boolean hasRouteGroupCoverage() {
    return coverageTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Transition route group coverage.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
   * </code>
   *
   * @return The routeGroupCoverage.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
      getRouteGroupCoverage() {
    if (coverageTypeCase_ == 6) {
      return (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage) coverageType_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Transition route group coverage.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverageOrBuilder
      getRouteGroupCoverageOrBuilder() {
    if (coverageTypeCase_ == 6) {
      return (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage) coverageType_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (coverageTypeCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) coverageType_);
    }
    if (coverageTypeCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage) coverageType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, agent_);
    }
    if (coverageTypeCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage) coverageType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (coverageTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) coverageType_);
    }
    if (coverageTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage) coverageType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, agent_);
    }
    if (coverageTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6,
              (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage) coverageType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse other =
        (com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse) obj;

    if (!getAgent().equals(other.getAgent())) return false;
    if (!getCoverageTypeCase().equals(other.getCoverageTypeCase())) return false;
    switch (coverageTypeCase_) {
      case 2:
        if (!getIntentCoverage().equals(other.getIntentCoverage())) return false;
        break;
      case 4:
        if (!getTransitionCoverage().equals(other.getTransitionCoverage())) return false;
        break;
      case 6:
        if (!getRouteGroupCoverage().equals(other.getRouteGroupCoverage())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AGENT_FIELD_NUMBER;
    hash = (53 * hash) + getAgent().hashCode();
    switch (coverageTypeCase_) {
      case 2:
        hash = (37 * hash) + INTENT_COVERAGE_FIELD_NUMBER;
        hash = (53 * hash) + getIntentCoverage().hashCode();
        break;
      case 4:
        hash = (37 * hash) + TRANSITION_COVERAGE_FIELD_NUMBER;
        hash = (53 * hash) + getTransitionCoverage().hashCode();
        break;
      case 6:
        hash = (37 * hash) + ROUTE_GROUP_COVERAGE_FIELD_NUMBER;
        hash = (53 * hash) + getRouteGroupCoverage().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response message for
   * [TestCases.CalculateCoverage][google.cloud.dialogflow.cx.v3beta1.TestCases.CalculateCoverage].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse)
      com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_CalculateCoverageResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_CalculateCoverageResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.class,
              com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      agent_ = "";
      if (intentCoverageBuilder_ != null) {
        intentCoverageBuilder_.clear();
      }
      if (transitionCoverageBuilder_ != null) {
        transitionCoverageBuilder_.clear();
      }
      if (routeGroupCoverageBuilder_ != null) {
        routeGroupCoverageBuilder_.clear();
      }
      coverageTypeCase_ = 0;
      coverageType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_CalculateCoverageResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse build() {
      com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse result =
          new com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.agent_ = agent_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse result) {
      result.coverageTypeCase_ = coverageTypeCase_;
      result.coverageType_ = this.coverageType_;
      if (coverageTypeCase_ == 2 && intentCoverageBuilder_ != null) {
        result.coverageType_ = intentCoverageBuilder_.build();
      }
      if (coverageTypeCase_ == 4 && transitionCoverageBuilder_ != null) {
        result.coverageType_ = transitionCoverageBuilder_.build();
      }
      if (coverageTypeCase_ == 6 && routeGroupCoverageBuilder_ != null) {
        result.coverageType_ = routeGroupCoverageBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse other) {
      if (other
          == com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.getDefaultInstance())
        return this;
      if (!other.getAgent().isEmpty()) {
        agent_ = other.agent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getCoverageTypeCase()) {
        case INTENT_COVERAGE:
          {
            mergeIntentCoverage(other.getIntentCoverage());
            break;
          }
        case TRANSITION_COVERAGE:
          {
            mergeTransitionCoverage(other.getTransitionCoverage());
            break;
          }
        case ROUTE_GROUP_COVERAGE:
          {
            mergeRouteGroupCoverage(other.getRouteGroupCoverage());
            break;
          }
        case COVERAGETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getIntentCoverageFieldBuilder().getBuilder(), extensionRegistry);
                coverageTypeCase_ = 2;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(
                    getTransitionCoverageFieldBuilder().getBuilder(), extensionRegistry);
                coverageTypeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                agent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getRouteGroupCoverageFieldBuilder().getBuilder(), extensionRegistry);
                coverageTypeCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int coverageTypeCase_ = 0;
    private java.lang.Object coverageType_;

    public CoverageTypeCase getCoverageTypeCase() {
      return CoverageTypeCase.forNumber(coverageTypeCase_);
    }

    public Builder clearCoverageType() {
      coverageTypeCase_ = 0;
      coverageType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object agent_ = "";
    /**
     *
     *
     * <pre>
     * The agent to calculate coverage for.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string agent = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The agent.
     */
    public java.lang.String getAgent() {
      java.lang.Object ref = agent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The agent to calculate coverage for.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string agent = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for agent.
     */
    public com.google.protobuf.ByteString getAgentBytes() {
      java.lang.Object ref = agent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The agent to calculate coverage for.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string agent = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The agent to set.
     * @return This builder for chaining.
     */
    public Builder setAgent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The agent to calculate coverage for.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string agent = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgent() {
      agent_ = getDefaultInstance().getAgent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The agent to calculate coverage for.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string agent = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for agent to set.
     * @return This builder for chaining.
     */
    public Builder setAgentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage,
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverageOrBuilder>
        intentCoverageBuilder_;
    /**
     *
     *
     * <pre>
     * Intent coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
     *
     * @return Whether the intentCoverage field is set.
     */
    @java.lang.Override
    public boolean hasIntentCoverage() {
      return coverageTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Intent coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
     *
     * @return The intentCoverage.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage getIntentCoverage() {
      if (intentCoverageBuilder_ == null) {
        if (coverageTypeCase_ == 2) {
          return (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) coverageType_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.getDefaultInstance();
      } else {
        if (coverageTypeCase_ == 2) {
          return intentCoverageBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Intent coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
     */
    public Builder setIntentCoverage(com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage value) {
      if (intentCoverageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        coverageType_ = value;
        onChanged();
      } else {
        intentCoverageBuilder_.setMessage(value);
      }
      coverageTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intent coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
     */
    public Builder setIntentCoverage(
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Builder builderForValue) {
      if (intentCoverageBuilder_ == null) {
        coverageType_ = builderForValue.build();
        onChanged();
      } else {
        intentCoverageBuilder_.setMessage(builderForValue.build());
      }
      coverageTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intent coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
     */
    public Builder mergeIntentCoverage(
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage value) {
      if (intentCoverageBuilder_ == null) {
        if (coverageTypeCase_ == 2
            && coverageType_
                != com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.getDefaultInstance()) {
          coverageType_ =
              com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) coverageType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          coverageType_ = value;
        }
        onChanged();
      } else {
        if (coverageTypeCase_ == 2) {
          intentCoverageBuilder_.mergeFrom(value);
        } else {
          intentCoverageBuilder_.setMessage(value);
        }
      }
      coverageTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intent coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
     */
    public Builder clearIntentCoverage() {
      if (intentCoverageBuilder_ == null) {
        if (coverageTypeCase_ == 2) {
          coverageTypeCase_ = 0;
          coverageType_ = null;
          onChanged();
        }
      } else {
        if (coverageTypeCase_ == 2) {
          coverageTypeCase_ = 0;
          coverageType_ = null;
        }
        intentCoverageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intent coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Builder
        getIntentCoverageBuilder() {
      return getIntentCoverageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Intent coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverageOrBuilder
        getIntentCoverageOrBuilder() {
      if ((coverageTypeCase_ == 2) && (intentCoverageBuilder_ != null)) {
        return intentCoverageBuilder_.getMessageOrBuilder();
      } else {
        if (coverageTypeCase_ == 2) {
          return (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) coverageType_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Intent coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.IntentCoverage intent_coverage = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage,
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverageOrBuilder>
        getIntentCoverageFieldBuilder() {
      if (intentCoverageBuilder_ == null) {
        if (!(coverageTypeCase_ == 2)) {
          coverageType_ =
              com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.getDefaultInstance();
        }
        intentCoverageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage,
                com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.IntentCoverageOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) coverageType_,
                getParentForChildren(),
                isClean());
        coverageType_ = null;
      }
      coverageTypeCase_ = 2;
      onChanged();
      return intentCoverageBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverageOrBuilder>
        transitionCoverageBuilder_;
    /**
     *
     *
     * <pre>
     * Transition (excluding transition route groups) coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
     *
     * @return Whether the transitionCoverage field is set.
     */
    @java.lang.Override
    public boolean hasTransitionCoverage() {
      return coverageTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Transition (excluding transition route groups) coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
     *
     * @return The transitionCoverage.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage getTransitionCoverage() {
      if (transitionCoverageBuilder_ == null) {
        if (coverageTypeCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage) coverageType_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.getDefaultInstance();
      } else {
        if (coverageTypeCase_ == 4) {
          return transitionCoverageBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition (excluding transition route groups) coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
     */
    public Builder setTransitionCoverage(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage value) {
      if (transitionCoverageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        coverageType_ = value;
        onChanged();
      } else {
        transitionCoverageBuilder_.setMessage(value);
      }
      coverageTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition (excluding transition route groups) coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
     */
    public Builder setTransitionCoverage(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Builder builderForValue) {
      if (transitionCoverageBuilder_ == null) {
        coverageType_ = builderForValue.build();
        onChanged();
      } else {
        transitionCoverageBuilder_.setMessage(builderForValue.build());
      }
      coverageTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition (excluding transition route groups) coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
     */
    public Builder mergeTransitionCoverage(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage value) {
      if (transitionCoverageBuilder_ == null) {
        if (coverageTypeCase_ == 4
            && coverageType_
                != com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.getDefaultInstance()) {
          coverageType_ =
              com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage) coverageType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          coverageType_ = value;
        }
        onChanged();
      } else {
        if (coverageTypeCase_ == 4) {
          transitionCoverageBuilder_.mergeFrom(value);
        } else {
          transitionCoverageBuilder_.setMessage(value);
        }
      }
      coverageTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition (excluding transition route groups) coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
     */
    public Builder clearTransitionCoverage() {
      if (transitionCoverageBuilder_ == null) {
        if (coverageTypeCase_ == 4) {
          coverageTypeCase_ = 0;
          coverageType_ = null;
          onChanged();
        }
      } else {
        if (coverageTypeCase_ == 4) {
          coverageTypeCase_ = 0;
          coverageType_ = null;
        }
        transitionCoverageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition (excluding transition route groups) coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Builder
        getTransitionCoverageBuilder() {
      return getTransitionCoverageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Transition (excluding transition route groups) coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverageOrBuilder
        getTransitionCoverageOrBuilder() {
      if ((coverageTypeCase_ == 4) && (transitionCoverageBuilder_ != null)) {
        return transitionCoverageBuilder_.getMessageOrBuilder();
      } else {
        if (coverageTypeCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage) coverageType_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition (excluding transition route groups) coverage.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage transition_coverage = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverageOrBuilder>
        getTransitionCoverageFieldBuilder() {
      if (transitionCoverageBuilder_ == null) {
        if (!(coverageTypeCase_ == 4)) {
          coverageType_ =
              com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.getDefaultInstance();
        }
        transitionCoverageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverageOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.TransitionCoverage) coverageType_,
                getParentForChildren(),
                isClean());
        coverageType_ = null;
      }
      coverageTypeCase_ = 4;
      onChanged();
      return transitionCoverageBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverageOrBuilder>
        routeGroupCoverageBuilder_;
    /**
     *
     *
     * <pre>
     * Transition route group coverage.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
     * </code>
     *
     * @return Whether the routeGroupCoverage field is set.
     */
    @java.lang.Override
    public boolean hasRouteGroupCoverage() {
      return coverageTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverage.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
     * </code>
     *
     * @return The routeGroupCoverage.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
        getRouteGroupCoverage() {
      if (routeGroupCoverageBuilder_ == null) {
        if (coverageTypeCase_ == 6) {
          return (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage)
              coverageType_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
            .getDefaultInstance();
      } else {
        if (coverageTypeCase_ == 6) {
          return routeGroupCoverageBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverage.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
     * </code>
     */
    public Builder setRouteGroupCoverage(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage value) {
      if (routeGroupCoverageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        coverageType_ = value;
        onChanged();
      } else {
        routeGroupCoverageBuilder_.setMessage(value);
      }
      coverageTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverage.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
     * </code>
     */
    public Builder setRouteGroupCoverage(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Builder
            builderForValue) {
      if (routeGroupCoverageBuilder_ == null) {
        coverageType_ = builderForValue.build();
        onChanged();
      } else {
        routeGroupCoverageBuilder_.setMessage(builderForValue.build());
      }
      coverageTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverage.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
     * </code>
     */
    public Builder mergeRouteGroupCoverage(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage value) {
      if (routeGroupCoverageBuilder_ == null) {
        if (coverageTypeCase_ == 6
            && coverageType_
                != com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
                    .getDefaultInstance()) {
          coverageType_ =
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage)
                          coverageType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          coverageType_ = value;
        }
        onChanged();
      } else {
        if (coverageTypeCase_ == 6) {
          routeGroupCoverageBuilder_.mergeFrom(value);
        } else {
          routeGroupCoverageBuilder_.setMessage(value);
        }
      }
      coverageTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverage.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
     * </code>
     */
    public Builder clearRouteGroupCoverage() {
      if (routeGroupCoverageBuilder_ == null) {
        if (coverageTypeCase_ == 6) {
          coverageTypeCase_ = 0;
          coverageType_ = null;
          onChanged();
        }
      } else {
        if (coverageTypeCase_ == 6) {
          coverageTypeCase_ = 0;
          coverageType_ = null;
        }
        routeGroupCoverageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverage.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Builder
        getRouteGroupCoverageBuilder() {
      return getRouteGroupCoverageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverage.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverageOrBuilder
        getRouteGroupCoverageOrBuilder() {
      if ((coverageTypeCase_ == 6) && (routeGroupCoverageBuilder_ != null)) {
        return routeGroupCoverageBuilder_.getMessageOrBuilder();
      } else {
        if (coverageTypeCase_ == 6) {
          return (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage)
              coverageType_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverage.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage route_group_coverage = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverageOrBuilder>
        getRouteGroupCoverageFieldBuilder() {
      if (routeGroupCoverageBuilder_ == null) {
        if (!(coverageTypeCase_ == 6)) {
          coverageType_ =
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
                  .getDefaultInstance();
        }
        routeGroupCoverageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverageOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage) coverageType_,
                getParentForChildren(),
                isClean());
        coverageType_ = null;
      }
      coverageTypeCase_ = 6;
      onChanged();
      return routeGroupCoverageBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse)
  private static final com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CalculateCoverageResponse> PARSER =
      new com.google.protobuf.AbstractParser<CalculateCoverageResponse>() {
        @java.lang.Override
        public CalculateCoverageResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CalculateCoverageResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CalculateCoverageResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
