/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/session.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Stores information about feedback provided by users about a response.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AnswerFeedback}
 */
public final class AnswerFeedback extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback)
    AnswerFeedbackOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnswerFeedback.newBuilder() to construct.
  private AnswerFeedback(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnswerFeedback() {
    rating_ = 0;
    customRating_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnswerFeedback();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.class,
            com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents thumbs up/down rating provided by user about a response.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating}
   */
  public enum Rating implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Rating not specified.
     * </pre>
     *
     * <code>RATING_UNSPECIFIED = 0;</code>
     */
    RATING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Thumbs up feedback from user.
     * </pre>
     *
     * <code>THUMBS_UP = 1;</code>
     */
    THUMBS_UP(1),
    /**
     *
     *
     * <pre>
     * Thumbs down feedback from user.
     * </pre>
     *
     * <code>THUMBS_DOWN = 2;</code>
     */
    THUMBS_DOWN(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Rating not specified.
     * </pre>
     *
     * <code>RATING_UNSPECIFIED = 0;</code>
     */
    public static final int RATING_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Thumbs up feedback from user.
     * </pre>
     *
     * <code>THUMBS_UP = 1;</code>
     */
    public static final int THUMBS_UP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Thumbs down feedback from user.
     * </pre>
     *
     * <code>THUMBS_DOWN = 2;</code>
     */
    public static final int THUMBS_DOWN_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Rating valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Rating forNumber(int value) {
      switch (value) {
        case 0:
          return RATING_UNSPECIFIED;
        case 1:
          return THUMBS_UP;
        case 2:
          return THUMBS_DOWN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Rating> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Rating> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Rating>() {
          public Rating findValueByNumber(int number) {
            return Rating.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Rating[] VALUES = values();

    public static Rating valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Rating(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating)
  }

  public interface RatingReasonOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Custom reason labels for thumbs down rating provided by the
     * user. The maximum number of labels allowed is 10 and the maximum length
     * of a single label is 128 characters.
     * </pre>
     *
     * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the reasonLabels.
     */
    java.util.List<java.lang.String> getReasonLabelsList();
    /**
     *
     *
     * <pre>
     * Optional. Custom reason labels for thumbs down rating provided by the
     * user. The maximum number of labels allowed is 10 and the maximum length
     * of a single label is 128 characters.
     * </pre>
     *
     * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of reasonLabels.
     */
    int getReasonLabelsCount();
    /**
     *
     *
     * <pre>
     * Optional. Custom reason labels for thumbs down rating provided by the
     * user. The maximum number of labels allowed is 10 and the maximum length
     * of a single label is 128 characters.
     * </pre>
     *
     * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The reasonLabels at the given index.
     */
    java.lang.String getReasonLabels(int index);
    /**
     *
     *
     * <pre>
     * Optional. Custom reason labels for thumbs down rating provided by the
     * user. The maximum number of labels allowed is 10 and the maximum length
     * of a single label is 128 characters.
     * </pre>
     *
     * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the reasonLabels at the given index.
     */
    com.google.protobuf.ByteString getReasonLabelsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. Additional feedback about the rating.
     * This field can be populated without choosing a predefined `reason`.
     * </pre>
     *
     * <code>string feedback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The feedback.
     */
    java.lang.String getFeedback();
    /**
     *
     *
     * <pre>
     * Optional. Additional feedback about the rating.
     * This field can be populated without choosing a predefined `reason`.
     * </pre>
     *
     * <code>string feedback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for feedback.
     */
    com.google.protobuf.ByteString getFeedbackBytes();
  }
  /**
   *
   *
   * <pre>
   * Stores extra information about why users provided thumbs down rating.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason}
   */
  public static final class RatingReason extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason)
      RatingReasonOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RatingReason.newBuilder() to construct.
    private RatingReason(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RatingReason() {
      reasonLabels_ = com.google.protobuf.LazyStringArrayList.emptyList();
      feedback_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RatingReason();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_RatingReason_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_RatingReason_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.class,
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.Builder.class);
    }

    public static final int REASON_LABELS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList reasonLabels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. Custom reason labels for thumbs down rating provided by the
     * user. The maximum number of labels allowed is 10 and the maximum length
     * of a single label is 128 characters.
     * </pre>
     *
     * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the reasonLabels.
     */
    public com.google.protobuf.ProtocolStringList getReasonLabelsList() {
      return reasonLabels_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom reason labels for thumbs down rating provided by the
     * user. The maximum number of labels allowed is 10 and the maximum length
     * of a single label is 128 characters.
     * </pre>
     *
     * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of reasonLabels.
     */
    public int getReasonLabelsCount() {
      return reasonLabels_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom reason labels for thumbs down rating provided by the
     * user. The maximum number of labels allowed is 10 and the maximum length
     * of a single label is 128 characters.
     * </pre>
     *
     * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The reasonLabels at the given index.
     */
    public java.lang.String getReasonLabels(int index) {
      return reasonLabels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom reason labels for thumbs down rating provided by the
     * user. The maximum number of labels allowed is 10 and the maximum length
     * of a single label is 128 characters.
     * </pre>
     *
     * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the reasonLabels at the given index.
     */
    public com.google.protobuf.ByteString getReasonLabelsBytes(int index) {
      return reasonLabels_.getByteString(index);
    }

    public static final int FEEDBACK_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object feedback_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Additional feedback about the rating.
     * This field can be populated without choosing a predefined `reason`.
     * </pre>
     *
     * <code>string feedback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The feedback.
     */
    @java.lang.Override
    public java.lang.String getFeedback() {
      java.lang.Object ref = feedback_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        feedback_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional feedback about the rating.
     * This field can be populated without choosing a predefined `reason`.
     * </pre>
     *
     * <code>string feedback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for feedback.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFeedbackBytes() {
      java.lang.Object ref = feedback_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        feedback_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(feedback_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, feedback_);
      }
      for (int i = 0; i < reasonLabels_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, reasonLabels_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(feedback_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, feedback_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < reasonLabels_.size(); i++) {
          dataSize += computeStringSizeNoTag(reasonLabels_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getReasonLabelsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason other =
          (com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason) obj;

      if (!getReasonLabelsList().equals(other.getReasonLabelsList())) return false;
      if (!getFeedback().equals(other.getFeedback())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getReasonLabelsCount() > 0) {
        hash = (37 * hash) + REASON_LABELS_FIELD_NUMBER;
        hash = (53 * hash) + getReasonLabelsList().hashCode();
      }
      hash = (37 * hash) + FEEDBACK_FIELD_NUMBER;
      hash = (53 * hash) + getFeedback().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Stores extra information about why users provided thumbs down rating.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason)
        com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReasonOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_RatingReason_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_RatingReason_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.class,
                com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        reasonLabels_ = com.google.protobuf.LazyStringArrayList.emptyList();
        feedback_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_RatingReason_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason build() {
        com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason result =
            new com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          reasonLabels_.makeImmutable();
          result.reasonLabels_ = reasonLabels_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.feedback_ = feedback_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
                .getDefaultInstance()) return this;
        if (!other.reasonLabels_.isEmpty()) {
          if (reasonLabels_.isEmpty()) {
            reasonLabels_ = other.reasonLabels_;
            bitField0_ |= 0x00000001;
          } else {
            ensureReasonLabelsIsMutable();
            reasonLabels_.addAll(other.reasonLabels_);
          }
          onChanged();
        }
        if (!other.getFeedback().isEmpty()) {
          feedback_ = other.feedback_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  feedback_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureReasonLabelsIsMutable();
                  reasonLabels_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList reasonLabels_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureReasonLabelsIsMutable() {
        if (!reasonLabels_.isModifiable()) {
          reasonLabels_ = new com.google.protobuf.LazyStringArrayList(reasonLabels_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom reason labels for thumbs down rating provided by the
       * user. The maximum number of labels allowed is 10 and the maximum length
       * of a single label is 128 characters.
       * </pre>
       *
       * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the reasonLabels.
       */
      public com.google.protobuf.ProtocolStringList getReasonLabelsList() {
        reasonLabels_.makeImmutable();
        return reasonLabels_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom reason labels for thumbs down rating provided by the
       * user. The maximum number of labels allowed is 10 and the maximum length
       * of a single label is 128 characters.
       * </pre>
       *
       * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of reasonLabels.
       */
      public int getReasonLabelsCount() {
        return reasonLabels_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom reason labels for thumbs down rating provided by the
       * user. The maximum number of labels allowed is 10 and the maximum length
       * of a single label is 128 characters.
       * </pre>
       *
       * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The reasonLabels at the given index.
       */
      public java.lang.String getReasonLabels(int index) {
        return reasonLabels_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom reason labels for thumbs down rating provided by the
       * user. The maximum number of labels allowed is 10 and the maximum length
       * of a single label is 128 characters.
       * </pre>
       *
       * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the reasonLabels at the given index.
       */
      public com.google.protobuf.ByteString getReasonLabelsBytes(int index) {
        return reasonLabels_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom reason labels for thumbs down rating provided by the
       * user. The maximum number of labels allowed is 10 and the maximum length
       * of a single label is 128 characters.
       * </pre>
       *
       * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The reasonLabels to set.
       * @return This builder for chaining.
       */
      public Builder setReasonLabels(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReasonLabelsIsMutable();
        reasonLabels_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom reason labels for thumbs down rating provided by the
       * user. The maximum number of labels allowed is 10 and the maximum length
       * of a single label is 128 characters.
       * </pre>
       *
       * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The reasonLabels to add.
       * @return This builder for chaining.
       */
      public Builder addReasonLabels(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReasonLabelsIsMutable();
        reasonLabels_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom reason labels for thumbs down rating provided by the
       * user. The maximum number of labels allowed is 10 and the maximum length
       * of a single label is 128 characters.
       * </pre>
       *
       * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The reasonLabels to add.
       * @return This builder for chaining.
       */
      public Builder addAllReasonLabels(java.lang.Iterable<java.lang.String> values) {
        ensureReasonLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reasonLabels_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom reason labels for thumbs down rating provided by the
       * user. The maximum number of labels allowed is 10 and the maximum length
       * of a single label is 128 characters.
       * </pre>
       *
       * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReasonLabels() {
        reasonLabels_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom reason labels for thumbs down rating provided by the
       * user. The maximum number of labels allowed is 10 and the maximum length
       * of a single label is 128 characters.
       * </pre>
       *
       * <code>repeated string reason_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the reasonLabels to add.
       * @return This builder for chaining.
       */
      public Builder addReasonLabelsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureReasonLabelsIsMutable();
        reasonLabels_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object feedback_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Additional feedback about the rating.
       * This field can be populated without choosing a predefined `reason`.
       * </pre>
       *
       * <code>string feedback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The feedback.
       */
      public java.lang.String getFeedback() {
        java.lang.Object ref = feedback_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          feedback_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional feedback about the rating.
       * This field can be populated without choosing a predefined `reason`.
       * </pre>
       *
       * <code>string feedback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for feedback.
       */
      public com.google.protobuf.ByteString getFeedbackBytes() {
        java.lang.Object ref = feedback_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          feedback_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional feedback about the rating.
       * This field can be populated without choosing a predefined `reason`.
       * </pre>
       *
       * <code>string feedback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The feedback to set.
       * @return This builder for chaining.
       */
      public Builder setFeedback(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        feedback_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional feedback about the rating.
       * This field can be populated without choosing a predefined `reason`.
       * </pre>
       *
       * <code>string feedback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFeedback() {
        feedback_ = getDefaultInstance().getFeedback();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional feedback about the rating.
       * This field can be populated without choosing a predefined `reason`.
       * </pre>
       *
       * <code>string feedback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for feedback to set.
       * @return This builder for chaining.
       */
      public Builder setFeedbackBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        feedback_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason)
    private static final com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RatingReason> PARSER =
        new com.google.protobuf.AbstractParser<RatingReason>() {
          @java.lang.Override
          public RatingReason parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RatingReason> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RatingReason> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int RATING_FIELD_NUMBER = 1;
  private int rating_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Rating from user for the specific Dialogflow response.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating rating = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for rating.
   */
  @java.lang.Override
  public int getRatingValue() {
    return rating_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rating from user for the specific Dialogflow response.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating rating = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rating.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating getRating() {
    com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating result =
        com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating.forNumber(rating_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating.UNRECOGNIZED
        : result;
  }

  public static final int RATING_REASON_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason ratingReason_;
  /**
   *
   *
   * <pre>
   * Optional. In case of thumbs down rating provided, users can optionally
   * provide context about the rating.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ratingReason field is set.
   */
  @java.lang.Override
  public boolean hasRatingReason() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. In case of thumbs down rating provided, users can optionally
   * provide context about the rating.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ratingReason.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason getRatingReason() {
    return ratingReason_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.getDefaultInstance()
        : ratingReason_;
  }
  /**
   *
   *
   * <pre>
   * Optional. In case of thumbs down rating provided, users can optionally
   * provide context about the rating.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReasonOrBuilder
      getRatingReasonOrBuilder() {
    return ratingReason_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.getDefaultInstance()
        : ratingReason_;
  }

  public static final int CUSTOM_RATING_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customRating_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Custom rating from the user about the provided answer, with
   * maximum length of 1024 characters. For example, client could use a
   * customized JSON object to indicate the rating.
   * </pre>
   *
   * <code>string custom_rating = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The customRating.
   */
  @java.lang.Override
  public java.lang.String getCustomRating() {
    java.lang.Object ref = customRating_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customRating_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom rating from the user about the provided answer, with
   * maximum length of 1024 characters. For example, client could use a
   * customized JSON object to indicate the rating.
   * </pre>
   *
   * <code>string custom_rating = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for customRating.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomRatingBytes() {
    java.lang.Object ref = customRating_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customRating_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (rating_
        != com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating.RATING_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, rating_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getRatingReason());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customRating_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, customRating_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (rating_
        != com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating.RATING_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, rating_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRatingReason());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customRating_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, customRating_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback other =
        (com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback) obj;

    if (rating_ != other.rating_) return false;
    if (hasRatingReason() != other.hasRatingReason()) return false;
    if (hasRatingReason()) {
      if (!getRatingReason().equals(other.getRatingReason())) return false;
    }
    if (!getCustomRating().equals(other.getCustomRating())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RATING_FIELD_NUMBER;
    hash = (53 * hash) + rating_;
    if (hasRatingReason()) {
      hash = (37 * hash) + RATING_REASON_FIELD_NUMBER;
      hash = (53 * hash) + getRatingReason().hashCode();
    }
    hash = (37 * hash) + CUSTOM_RATING_FIELD_NUMBER;
    hash = (53 * hash) + getCustomRating().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Stores information about feedback provided by users about a response.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AnswerFeedback}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback)
      com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedbackOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.class,
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRatingReasonFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      rating_ = 0;
      ratingReason_ = null;
      if (ratingReasonBuilder_ != null) {
        ratingReasonBuilder_.dispose();
        ratingReasonBuilder_ = null;
      }
      customRating_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AnswerFeedback_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback build() {
      com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback result =
          new com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.rating_ = rating_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.ratingReason_ =
            ratingReasonBuilder_ == null ? ratingReason_ : ratingReasonBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.customRating_ = customRating_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.getDefaultInstance())
        return this;
      if (other.rating_ != 0) {
        setRatingValue(other.getRatingValue());
      }
      if (other.hasRatingReason()) {
        mergeRatingReason(other.getRatingReason());
      }
      if (!other.getCustomRating().isEmpty()) {
        customRating_ = other.customRating_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                rating_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getRatingReasonFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                customRating_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int rating_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Rating from user for the specific Dialogflow response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating rating = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for rating.
     */
    @java.lang.Override
    public int getRatingValue() {
      return rating_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rating from user for the specific Dialogflow response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating rating = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for rating to set.
     * @return This builder for chaining.
     */
    public Builder setRatingValue(int value) {
      rating_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rating from user for the specific Dialogflow response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating rating = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rating.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating getRating() {
      com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating result =
          com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating.forNumber(rating_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rating from user for the specific Dialogflow response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating rating = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The rating to set.
     * @return This builder for chaining.
     */
    public Builder setRating(com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      rating_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rating from user for the specific Dialogflow response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating rating = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRating() {
      bitField0_ = (bitField0_ & ~0x00000001);
      rating_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason ratingReason_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason,
            com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReasonOrBuilder>
        ratingReasonBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. In case of thumbs down rating provided, users can optionally
     * provide context about the rating.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ratingReason field is set.
     */
    public boolean hasRatingReason() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. In case of thumbs down rating provided, users can optionally
     * provide context about the rating.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ratingReason.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason getRatingReason() {
      if (ratingReasonBuilder_ == null) {
        return ratingReason_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
                .getDefaultInstance()
            : ratingReason_;
      } else {
        return ratingReasonBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. In case of thumbs down rating provided, users can optionally
     * provide context about the rating.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRatingReason(
        com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason value) {
      if (ratingReasonBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ratingReason_ = value;
      } else {
        ratingReasonBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. In case of thumbs down rating provided, users can optionally
     * provide context about the rating.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRatingReason(
        com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.Builder
            builderForValue) {
      if (ratingReasonBuilder_ == null) {
        ratingReason_ = builderForValue.build();
      } else {
        ratingReasonBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. In case of thumbs down rating provided, users can optionally
     * provide context about the rating.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRatingReason(
        com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason value) {
      if (ratingReasonBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && ratingReason_ != null
            && ratingReason_
                != com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
                    .getDefaultInstance()) {
          getRatingReasonBuilder().mergeFrom(value);
        } else {
          ratingReason_ = value;
        }
      } else {
        ratingReasonBuilder_.mergeFrom(value);
      }
      if (ratingReason_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. In case of thumbs down rating provided, users can optionally
     * provide context about the rating.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRatingReason() {
      bitField0_ = (bitField0_ & ~0x00000002);
      ratingReason_ = null;
      if (ratingReasonBuilder_ != null) {
        ratingReasonBuilder_.dispose();
        ratingReasonBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. In case of thumbs down rating provided, users can optionally
     * provide context about the rating.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.Builder
        getRatingReasonBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRatingReasonFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. In case of thumbs down rating provided, users can optionally
     * provide context about the rating.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReasonOrBuilder
        getRatingReasonOrBuilder() {
      if (ratingReasonBuilder_ != null) {
        return ratingReasonBuilder_.getMessageOrBuilder();
      } else {
        return ratingReason_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
                .getDefaultInstance()
            : ratingReason_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. In case of thumbs down rating provided, users can optionally
     * provide context about the rating.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason rating_reason = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason,
            com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReasonOrBuilder>
        getRatingReasonFieldBuilder() {
      if (ratingReasonBuilder_ == null) {
        ratingReasonBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason,
                com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReasonOrBuilder>(
                getRatingReason(), getParentForChildren(), isClean());
        ratingReason_ = null;
      }
      return ratingReasonBuilder_;
    }

    private java.lang.Object customRating_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Custom rating from the user about the provided answer, with
     * maximum length of 1024 characters. For example, client could use a
     * customized JSON object to indicate the rating.
     * </pre>
     *
     * <code>string custom_rating = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The customRating.
     */
    public java.lang.String getCustomRating() {
      java.lang.Object ref = customRating_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customRating_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom rating from the user about the provided answer, with
     * maximum length of 1024 characters. For example, client could use a
     * customized JSON object to indicate the rating.
     * </pre>
     *
     * <code>string custom_rating = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for customRating.
     */
    public com.google.protobuf.ByteString getCustomRatingBytes() {
      java.lang.Object ref = customRating_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customRating_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom rating from the user about the provided answer, with
     * maximum length of 1024 characters. For example, client could use a
     * customized JSON object to indicate the rating.
     * </pre>
     *
     * <code>string custom_rating = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The customRating to set.
     * @return This builder for chaining.
     */
    public Builder setCustomRating(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customRating_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom rating from the user about the provided answer, with
     * maximum length of 1024 characters. For example, client could use a
     * customized JSON object to indicate the rating.
     * </pre>
     *
     * <code>string custom_rating = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomRating() {
      customRating_ = getDefaultInstance().getCustomRating();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom rating from the user about the provided answer, with
     * maximum length of 1024 characters. For example, client could use a
     * customized JSON object to indicate the rating.
     * </pre>
     *
     * <code>string custom_rating = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for customRating to set.
     * @return This builder for chaining.
     */
    public Builder setCustomRatingBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customRating_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.AnswerFeedback)
  private static final com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnswerFeedback> PARSER =
      new com.google.protobuf.AbstractParser<AnswerFeedback>() {
        @java.lang.Override
        public AnswerFeedback parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnswerFeedback> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnswerFeedback> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
