/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/example.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Action performed by end user or Dialogflow agent in the conversation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Action}
 */
public final class Action extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Action)
    ActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Action.newBuilder() to construct.
  private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Action() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Action();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Action_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Action_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Action.class,
            com.google.cloud.dialogflow.cx.v3beta1.Action.Builder.class);
  }

  private int actionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    USER_UTTERANCE(1),
    AGENT_UTTERANCE(2),
    TOOL_USE(3),
    PLAYBOOK_INVOCATION(4),
    FLOW_INVOCATION(5),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 1:
          return USER_UTTERANCE;
        case 2:
          return AGENT_UTTERANCE;
        case 3:
          return TOOL_USE;
        case 4:
          return PLAYBOOK_INVOCATION;
        case 5:
          return FLOW_INVOCATION;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int USER_UTTERANCE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Optional. Agent obtained a message from the customer.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the userUtterance field is set.
   */
  @java.lang.Override
  public boolean hasUserUtterance() {
    return actionCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Optional. Agent obtained a message from the customer.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The userUtterance.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.UserUtterance getUserUtterance() {
    if (actionCase_ == 1) {
      return (com.google.cloud.dialogflow.cx.v3beta1.UserUtterance) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Agent obtained a message from the customer.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.UserUtteranceOrBuilder getUserUtteranceOrBuilder() {
    if (actionCase_ == 1) {
      return (com.google.cloud.dialogflow.cx.v3beta1.UserUtterance) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.getDefaultInstance();
  }

  public static final int AGENT_UTTERANCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. Action performed by the agent as a message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the agentUtterance field is set.
   */
  @java.lang.Override
  public boolean hasAgentUtterance() {
    return actionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. Action performed by the agent as a message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The agentUtterance.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance getAgentUtterance() {
    if (actionCase_ == 2) {
      return (com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Action performed by the agent as a message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AgentUtteranceOrBuilder
      getAgentUtteranceOrBuilder() {
    if (actionCase_ == 2) {
      return (com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.getDefaultInstance();
  }

  public static final int TOOL_USE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. Action performed on behalf of the agent by calling a plugin
   * tool.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the toolUse field is set.
   */
  @java.lang.Override
  public boolean hasToolUse() {
    return actionCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. Action performed on behalf of the agent by calling a plugin
   * tool.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The toolUse.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ToolUse getToolUse() {
    if (actionCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ToolUse) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ToolUse.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Action performed on behalf of the agent by calling a plugin
   * tool.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ToolUseOrBuilder getToolUseOrBuilder() {
    if (actionCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ToolUse) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ToolUse.getDefaultInstance();
  }

  public static final int PLAYBOOK_INVOCATION_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Action performed on behalf of the agent by invoking a child
   * playbook.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the playbookInvocation field is set.
   */
  @java.lang.Override
  public boolean hasPlaybookInvocation() {
    return actionCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Action performed on behalf of the agent by invoking a child
   * playbook.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The playbookInvocation.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation getPlaybookInvocation() {
    if (actionCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Action performed on behalf of the agent by invoking a child
   * playbook.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocationOrBuilder
      getPlaybookInvocationOrBuilder() {
    if (actionCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.getDefaultInstance();
  }

  public static final int FLOW_INVOCATION_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. Action performed on behalf of the agent by invoking a CX flow.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the flowInvocation field is set.
   */
  @java.lang.Override
  public boolean hasFlowInvocation() {
    return actionCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. Action performed on behalf of the agent by invoking a CX flow.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The flowInvocation.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation getFlowInvocation() {
    if (actionCase_ == 5) {
      return (com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Action performed on behalf of the agent by invoking a CX flow.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.FlowInvocationOrBuilder
      getFlowInvocationOrBuilder() {
    if (actionCase_ == 5) {
      return (com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) action_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (actionCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.dialogflow.cx.v3beta1.UserUtterance) action_);
    }
    if (actionCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance) action_);
    }
    if (actionCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dialogflow.cx.v3beta1.ToolUse) action_);
    }
    if (actionCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) action_);
    }
    if (actionCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (actionCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.dialogflow.cx.v3beta1.UserUtterance) action_);
    }
    if (actionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance) action_);
    }
    if (actionCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.cx.v3beta1.ToolUse) action_);
    }
    if (actionCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) action_);
    }
    if (actionCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Action)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Action other =
        (com.google.cloud.dialogflow.cx.v3beta1.Action) obj;

    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 1:
        if (!getUserUtterance().equals(other.getUserUtterance())) return false;
        break;
      case 2:
        if (!getAgentUtterance().equals(other.getAgentUtterance())) return false;
        break;
      case 3:
        if (!getToolUse().equals(other.getToolUse())) return false;
        break;
      case 4:
        if (!getPlaybookInvocation().equals(other.getPlaybookInvocation())) return false;
        break;
      case 5:
        if (!getFlowInvocation().equals(other.getFlowInvocation())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (actionCase_) {
      case 1:
        hash = (37 * hash) + USER_UTTERANCE_FIELD_NUMBER;
        hash = (53 * hash) + getUserUtterance().hashCode();
        break;
      case 2:
        hash = (37 * hash) + AGENT_UTTERANCE_FIELD_NUMBER;
        hash = (53 * hash) + getAgentUtterance().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TOOL_USE_FIELD_NUMBER;
        hash = (53 * hash) + getToolUse().hashCode();
        break;
      case 4:
        hash = (37 * hash) + PLAYBOOK_INVOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getPlaybookInvocation().hashCode();
        break;
      case 5:
        hash = (37 * hash) + FLOW_INVOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getFlowInvocation().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Action prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Action performed by end user or Dialogflow agent in the conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Action}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Action)
      com.google.cloud.dialogflow.cx.v3beta1.ActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Action_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Action.class,
              com.google.cloud.dialogflow.cx.v3beta1.Action.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Action.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (userUtteranceBuilder_ != null) {
        userUtteranceBuilder_.clear();
      }
      if (agentUtteranceBuilder_ != null) {
        agentUtteranceBuilder_.clear();
      }
      if (toolUseBuilder_ != null) {
        toolUseBuilder_.clear();
      }
      if (playbookInvocationBuilder_ != null) {
        playbookInvocationBuilder_.clear();
      }
      if (flowInvocationBuilder_ != null) {
        flowInvocationBuilder_.clear();
      }
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Action_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Action getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Action.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Action build() {
      com.google.cloud.dialogflow.cx.v3beta1.Action result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Action buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Action result =
          new com.google.cloud.dialogflow.cx.v3beta1.Action(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Action result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3beta1.Action result) {
      result.actionCase_ = actionCase_;
      result.action_ = this.action_;
      if (actionCase_ == 1 && userUtteranceBuilder_ != null) {
        result.action_ = userUtteranceBuilder_.build();
      }
      if (actionCase_ == 2 && agentUtteranceBuilder_ != null) {
        result.action_ = agentUtteranceBuilder_.build();
      }
      if (actionCase_ == 3 && toolUseBuilder_ != null) {
        result.action_ = toolUseBuilder_.build();
      }
      if (actionCase_ == 4 && playbookInvocationBuilder_ != null) {
        result.action_ = playbookInvocationBuilder_.build();
      }
      if (actionCase_ == 5 && flowInvocationBuilder_ != null) {
        result.action_ = flowInvocationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Action) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Action) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Action other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Action.getDefaultInstance()) return this;
      switch (other.getActionCase()) {
        case USER_UTTERANCE:
          {
            mergeUserUtterance(other.getUserUtterance());
            break;
          }
        case AGENT_UTTERANCE:
          {
            mergeAgentUtterance(other.getAgentUtterance());
            break;
          }
        case TOOL_USE:
          {
            mergeToolUse(other.getToolUse());
            break;
          }
        case PLAYBOOK_INVOCATION:
          {
            mergePlaybookInvocation(other.getPlaybookInvocation());
            break;
          }
        case FLOW_INVOCATION:
          {
            mergeFlowInvocation(other.getFlowInvocation());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getUserUtteranceFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getAgentUtteranceFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getToolUseFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getPlaybookInvocationFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getFlowInvocationFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.UserUtterance,
            com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.UserUtteranceOrBuilder>
        userUtteranceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Agent obtained a message from the customer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the userUtterance field is set.
     */
    @java.lang.Override
    public boolean hasUserUtterance() {
      return actionCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Optional. Agent obtained a message from the customer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The userUtterance.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.UserUtterance getUserUtterance() {
      if (userUtteranceBuilder_ == null) {
        if (actionCase_ == 1) {
          return (com.google.cloud.dialogflow.cx.v3beta1.UserUtterance) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.getDefaultInstance();
      } else {
        if (actionCase_ == 1) {
          return userUtteranceBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Agent obtained a message from the customer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUserUtterance(com.google.cloud.dialogflow.cx.v3beta1.UserUtterance value) {
      if (userUtteranceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        userUtteranceBuilder_.setMessage(value);
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Agent obtained a message from the customer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUserUtterance(
        com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.Builder builderForValue) {
      if (userUtteranceBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        userUtteranceBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Agent obtained a message from the customer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeUserUtterance(com.google.cloud.dialogflow.cx.v3beta1.UserUtterance value) {
      if (userUtteranceBuilder_ == null) {
        if (actionCase_ == 1
            && action_
                != com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.getDefaultInstance()) {
          action_ =
              com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.UserUtterance) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 1) {
          userUtteranceBuilder_.mergeFrom(value);
        } else {
          userUtteranceBuilder_.setMessage(value);
        }
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Agent obtained a message from the customer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearUserUtterance() {
      if (userUtteranceBuilder_ == null) {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
        }
        userUtteranceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Agent obtained a message from the customer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.Builder getUserUtteranceBuilder() {
      return getUserUtteranceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Agent obtained a message from the customer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.UserUtteranceOrBuilder
        getUserUtteranceOrBuilder() {
      if ((actionCase_ == 1) && (userUtteranceBuilder_ != null)) {
        return userUtteranceBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 1) {
          return (com.google.cloud.dialogflow.cx.v3beta1.UserUtterance) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Agent obtained a message from the customer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.UserUtterance user_utterance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.UserUtterance,
            com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.UserUtteranceOrBuilder>
        getUserUtteranceFieldBuilder() {
      if (userUtteranceBuilder_ == null) {
        if (!(actionCase_ == 1)) {
          action_ = com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.getDefaultInstance();
        }
        userUtteranceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.UserUtterance,
                com.google.cloud.dialogflow.cx.v3beta1.UserUtterance.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.UserUtteranceOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.UserUtterance) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 1;
      onChanged();
      return userUtteranceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance,
            com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AgentUtteranceOrBuilder>
        agentUtteranceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Action performed by the agent as a message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the agentUtterance field is set.
     */
    @java.lang.Override
    public boolean hasAgentUtterance() {
      return actionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed by the agent as a message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The agentUtterance.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance getAgentUtterance() {
      if (agentUtteranceBuilder_ == null) {
        if (actionCase_ == 2) {
          return (com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.getDefaultInstance();
      } else {
        if (actionCase_ == 2) {
          return agentUtteranceBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed by the agent as a message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAgentUtterance(com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance value) {
      if (agentUtteranceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        agentUtteranceBuilder_.setMessage(value);
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed by the agent as a message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAgentUtterance(
        com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.Builder builderForValue) {
      if (agentUtteranceBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        agentUtteranceBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed by the agent as a message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAgentUtterance(
        com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance value) {
      if (agentUtteranceBuilder_ == null) {
        if (actionCase_ == 2
            && action_
                != com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.getDefaultInstance()) {
          action_ =
              com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 2) {
          agentUtteranceBuilder_.mergeFrom(value);
        } else {
          agentUtteranceBuilder_.setMessage(value);
        }
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed by the agent as a message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAgentUtterance() {
      if (agentUtteranceBuilder_ == null) {
        if (actionCase_ == 2) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 2) {
          actionCase_ = 0;
          action_ = null;
        }
        agentUtteranceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed by the agent as a message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.Builder
        getAgentUtteranceBuilder() {
      return getAgentUtteranceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed by the agent as a message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AgentUtteranceOrBuilder
        getAgentUtteranceOrBuilder() {
      if ((actionCase_ == 2) && (agentUtteranceBuilder_ != null)) {
        return agentUtteranceBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 2) {
          return (com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed by the agent as a message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AgentUtterance agent_utterance = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance,
            com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AgentUtteranceOrBuilder>
        getAgentUtteranceFieldBuilder() {
      if (agentUtteranceBuilder_ == null) {
        if (!(actionCase_ == 2)) {
          action_ = com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.getDefaultInstance();
        }
        agentUtteranceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance,
                com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.AgentUtteranceOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.AgentUtterance) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 2;
      onChanged();
      return agentUtteranceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ToolUse,
            com.google.cloud.dialogflow.cx.v3beta1.ToolUse.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ToolUseOrBuilder>
        toolUseBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by calling a plugin
     * tool.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the toolUse field is set.
     */
    @java.lang.Override
    public boolean hasToolUse() {
      return actionCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by calling a plugin
     * tool.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The toolUse.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ToolUse getToolUse() {
      if (toolUseBuilder_ == null) {
        if (actionCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ToolUse) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ToolUse.getDefaultInstance();
      } else {
        if (actionCase_ == 3) {
          return toolUseBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ToolUse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by calling a plugin
     * tool.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setToolUse(com.google.cloud.dialogflow.cx.v3beta1.ToolUse value) {
      if (toolUseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        toolUseBuilder_.setMessage(value);
      }
      actionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by calling a plugin
     * tool.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setToolUse(
        com.google.cloud.dialogflow.cx.v3beta1.ToolUse.Builder builderForValue) {
      if (toolUseBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        toolUseBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by calling a plugin
     * tool.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeToolUse(com.google.cloud.dialogflow.cx.v3beta1.ToolUse value) {
      if (toolUseBuilder_ == null) {
        if (actionCase_ == 3
            && action_ != com.google.cloud.dialogflow.cx.v3beta1.ToolUse.getDefaultInstance()) {
          action_ =
              com.google.cloud.dialogflow.cx.v3beta1.ToolUse.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ToolUse) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 3) {
          toolUseBuilder_.mergeFrom(value);
        } else {
          toolUseBuilder_.setMessage(value);
        }
      }
      actionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by calling a plugin
     * tool.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearToolUse() {
      if (toolUseBuilder_ == null) {
        if (actionCase_ == 3) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 3) {
          actionCase_ = 0;
          action_ = null;
        }
        toolUseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by calling a plugin
     * tool.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ToolUse.Builder getToolUseBuilder() {
      return getToolUseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by calling a plugin
     * tool.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ToolUseOrBuilder getToolUseOrBuilder() {
      if ((actionCase_ == 3) && (toolUseBuilder_ != null)) {
        return toolUseBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ToolUse) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ToolUse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by calling a plugin
     * tool.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ToolUse tool_use = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ToolUse,
            com.google.cloud.dialogflow.cx.v3beta1.ToolUse.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ToolUseOrBuilder>
        getToolUseFieldBuilder() {
      if (toolUseBuilder_ == null) {
        if (!(actionCase_ == 3)) {
          action_ = com.google.cloud.dialogflow.cx.v3beta1.ToolUse.getDefaultInstance();
        }
        toolUseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ToolUse,
                com.google.cloud.dialogflow.cx.v3beta1.ToolUse.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ToolUseOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ToolUse) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 3;
      onChanged();
      return toolUseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocationOrBuilder>
        playbookInvocationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a child
     * playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the playbookInvocation field is set.
     */
    @java.lang.Override
    public boolean hasPlaybookInvocation() {
      return actionCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a child
     * playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The playbookInvocation.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation getPlaybookInvocation() {
      if (playbookInvocationBuilder_ == null) {
        if (actionCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.getDefaultInstance();
      } else {
        if (actionCase_ == 4) {
          return playbookInvocationBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a child
     * playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookInvocation(
        com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation value) {
      if (playbookInvocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        playbookInvocationBuilder_.setMessage(value);
      }
      actionCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a child
     * playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookInvocation(
        com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.Builder builderForValue) {
      if (playbookInvocationBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        playbookInvocationBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a child
     * playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePlaybookInvocation(
        com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation value) {
      if (playbookInvocationBuilder_ == null) {
        if (actionCase_ == 4
            && action_
                != com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.getDefaultInstance()) {
          action_ =
              com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 4) {
          playbookInvocationBuilder_.mergeFrom(value);
        } else {
          playbookInvocationBuilder_.setMessage(value);
        }
      }
      actionCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a child
     * playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPlaybookInvocation() {
      if (playbookInvocationBuilder_ == null) {
        if (actionCase_ == 4) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 4) {
          actionCase_ = 0;
          action_ = null;
        }
        playbookInvocationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a child
     * playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.Builder
        getPlaybookInvocationBuilder() {
      return getPlaybookInvocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a child
     * playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocationOrBuilder
        getPlaybookInvocationOrBuilder() {
      if ((actionCase_ == 4) && (playbookInvocationBuilder_ != null)) {
        return playbookInvocationBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a child
     * playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation playbook_invocation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocationOrBuilder>
        getPlaybookInvocationFieldBuilder() {
      if (playbookInvocationBuilder_ == null) {
        if (!(actionCase_ == 4)) {
          action_ = com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.getDefaultInstance();
        }
        playbookInvocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocationOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 4;
      onChanged();
      return playbookInvocationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation,
            com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.FlowInvocationOrBuilder>
        flowInvocationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a CX flow.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the flowInvocation field is set.
     */
    @java.lang.Override
    public boolean hasFlowInvocation() {
      return actionCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a CX flow.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The flowInvocation.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation getFlowInvocation() {
      if (flowInvocationBuilder_ == null) {
        if (actionCase_ == 5) {
          return (com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.getDefaultInstance();
      } else {
        if (actionCase_ == 5) {
          return flowInvocationBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a CX flow.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFlowInvocation(com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation value) {
      if (flowInvocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        flowInvocationBuilder_.setMessage(value);
      }
      actionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a CX flow.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFlowInvocation(
        com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.Builder builderForValue) {
      if (flowInvocationBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        flowInvocationBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a CX flow.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFlowInvocation(
        com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation value) {
      if (flowInvocationBuilder_ == null) {
        if (actionCase_ == 5
            && action_
                != com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.getDefaultInstance()) {
          action_ =
              com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 5) {
          flowInvocationBuilder_.mergeFrom(value);
        } else {
          flowInvocationBuilder_.setMessage(value);
        }
      }
      actionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a CX flow.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFlowInvocation() {
      if (flowInvocationBuilder_ == null) {
        if (actionCase_ == 5) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 5) {
          actionCase_ = 0;
          action_ = null;
        }
        flowInvocationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a CX flow.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.Builder
        getFlowInvocationBuilder() {
      return getFlowInvocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a CX flow.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.FlowInvocationOrBuilder
        getFlowInvocationOrBuilder() {
      if ((actionCase_ == 5) && (flowInvocationBuilder_ != null)) {
        return flowInvocationBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 5) {
          return (com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) action_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Action performed on behalf of the agent by invoking a CX flow.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.FlowInvocation flow_invocation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation,
            com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.FlowInvocationOrBuilder>
        getFlowInvocationFieldBuilder() {
      if (flowInvocationBuilder_ == null) {
        if (!(actionCase_ == 5)) {
          action_ = com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.getDefaultInstance();
        }
        flowInvocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation,
                com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.FlowInvocationOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 5;
      onChanged();
      return flowInvocationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Action)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Action)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Action DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Action();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Action getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Action> PARSER =
      new com.google.protobuf.AbstractParser<Action>() {
        @java.lang.Override
        public Action parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Action> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Action> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Action getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
