/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TestCaseName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_TEST_CASE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/testCases/{test_case}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String testCase;

    @Deprecated
    protected TestCaseName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.testCase = null;
    }

    private TestCaseName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.testCase = (String)Preconditions.checkNotNull((Object)builder.getTestCase());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getTestCase() {
        return this.testCase;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TestCaseName of(String project, String location, String agent, String testCase) {
        return TestCaseName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setTestCase(testCase).build();
    }

    public static String format(String project, String location, String agent, String testCase) {
        return TestCaseName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setTestCase(testCase).build().toString();
    }

    public static TestCaseName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_TEST_CASE.validatedMatch(formattedString, "TestCaseName.parse: formattedString not in valid format");
        return TestCaseName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("test_case"));
    }

    public static List<TestCaseName> parseList(List<String> formattedStrings) {
        ArrayList<TestCaseName> list = new ArrayList<TestCaseName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TestCaseName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TestCaseName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TestCaseName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_TEST_CASE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TestCaseName testCaseName = this;
            synchronized (testCaseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.testCase != null) {
                        fieldMapBuilder.put((Object)"test_case", (Object)this.testCase);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_TEST_CASE.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "test_case", this.testCase});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TestCaseName that = (TestCaseName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.testCase, that.testCase);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        return h ^= Objects.hashCode(this.testCase);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String testCase;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getTestCase() {
            return this.testCase;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setTestCase(String testCase) {
            this.testCase = testCase;
            return this;
        }

        private Builder(TestCaseName testCaseName) {
            this.project = testCaseName.project;
            this.location = testCaseName.location;
            this.agent = testCaseName.agent;
            this.testCase = testCaseName.testCase;
        }

        public TestCaseName build() {
            return new TestCaseName(this);
        }
    }
}

