/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AgentGenerativeSettingsName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/generativeSettings");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;

    @Deprecated
    protected AgentGenerativeSettingsName() {
        this.project = null;
        this.location = null;
        this.agent = null;
    }

    private AgentGenerativeSettingsName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AgentGenerativeSettingsName of(String project, String location, String agent) {
        return AgentGenerativeSettingsName.newBuilder().setProject(project).setLocation(location).setAgent(agent).build();
    }

    public static String format(String project, String location, String agent) {
        return AgentGenerativeSettingsName.newBuilder().setProject(project).setLocation(location).setAgent(agent).build().toString();
    }

    public static AgentGenerativeSettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT.validatedMatch(formattedString, "AgentGenerativeSettingsName.parse: formattedString not in valid format");
        return AgentGenerativeSettingsName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"));
    }

    public static List<AgentGenerativeSettingsName> parseList(List<String> formattedStrings) {
        ArrayList<AgentGenerativeSettingsName> list = new ArrayList<AgentGenerativeSettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AgentGenerativeSettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AgentGenerativeSettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AgentGenerativeSettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AgentGenerativeSettingsName agentGenerativeSettingsName = this;
            synchronized (agentGenerativeSettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AgentGenerativeSettingsName that = (AgentGenerativeSettingsName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.agent);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        private Builder(AgentGenerativeSettingsName agentGenerativeSettingsName) {
            this.project = agentGenerativeSettingsName.project;
            this.location = agentGenerativeSettingsName.location;
            this.agent = agentGenerativeSettingsName.agent;
        }

        public AgentGenerativeSettingsName build() {
            return new AgentGenerativeSettingsName(this);
        }
    }
}

